<?php

class PayuLatamSettingsController extends PaymentSettingsController
{
    private $keyName = "PayuLatam";

    public function index()
    {
        $paymentSettings = $this->getPaymentSettings($this->keyName);
        $frm = $this->getForm();
        $frm->fill($paymentSettings);
        $this->set('frm', $frm);
        $this->set('paymentMethod', $this->keyName);
        $this->_template->render(false, false);
    }

    public function setup()
    {
        $frm = $this->getForm();
        $this->setUpPaymentSettings($frm, $this->keyName);
    }

    private function getForm()
    {
        $frm = new Form('frmPaymentMethods');
        $frm->addRequiredField(Labels::getLabel('LBL_Merchant_ID', $this->adminLangId), 'merchant_id');
        $frm->addRequiredField(Labels::getLabel('LBL_API_Login', $this->adminLangId), 'api_login');
        $frm->addRequiredField(Labels::getLabel('LBL_API_Key', $this->adminLangId), 'api_key');
        $frm->addRequiredField(Labels::getLabel('LBL_Account_ID', $this->adminLangId), 'account_id');
        $frm->addSubmitButton('&nbsp;', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->adminLangId));
        return $frm;
    }
}
