<?php

class ProductCategoriesController extends AdminBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
        $this->objPrivilege->canViewProductCategories();
    }

    public function index()
    {
        //ProductCategory::markSubCategoryDeleted();
        $canEdit = $this->objPrivilege->canEditProductCategories(0, true);
        $this->set("canEdit", $canEdit);
        $this->_template->addJs(array('js/cropper.js', 'js/cropper-main.js', 'js/jquery-sortable-lists.js'));
        $this->_template->addCss('css/cropper.css');
        $this->set('includeEditor', true);
        $this->_template->render();
    }

    public function search()
    {
        $records = array();
        $prodCat = new ProductCategory();
        $records = $prodCat->getCategories();
        $canEdit = $this->objPrivilege->canEditProductCategories(0, true);
        $this->set("arr_listing", $records);
        $this->set("canEdit", $canEdit);
        $this->_template->render(false, false);
    }

    public function getTotalBlock()
    {
        $totProds = Product::getProductsCount();
        $activeCategories = ProductCategory::getActiveInactiveCategoriesCount(AppConstants::ACTIVE);
        $inactiveCategories = ProductCategory::getActiveInactiveCategoriesCount(AppConstants::INACTIVE);
        $this->set("totProds", $totProds);
        $this->set("activeCategories", $activeCategories);
        $this->set("inactiveCategories", $inactiveCategories);
        $this->_template->render(false, false);
    }

    public function getSubCategories()
    {
        $canEdit = $this->objPrivilege->canEditProductCategories(0, true);
        $prodCatId = FatApp::getPostedData('prodCatId', FatUtility::VAR_INT, 0);
        $level = FatApp::getPostedData('level', FatUtility::VAR_INT, 0);
        $prodCat = new ProductCategory($prodCatId);
        $childCategories = $prodCat->getCategories();
        $this->set("childCategories", $childCategories);
        $this->set("level", $level);
        $this->set("canEdit", $canEdit);
        $this->_template->render(false, false);
    }

    public function updateOrder()
    {
        $this->objPrivilege->canEditProductCategories();
        $prodCatId = FatApp::getPostedData('catId', FatUtility::VAR_INT, 0);
        $parentCatId = FatApp::getPostedData('parentCatId', FatUtility::VAR_INT, 0);
        $catOrderArr = json_decode(FatApp::getPostedData('catOrder'));
        if ($prodCatId < 1 || count($catOrderArr) < 1) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieJsonError(Message::getHtml());
        }

        $prodCat = new ProductCategory($prodCatId);
        $prodCat->updateCatParent($parentCatId);
        $prodCat->updateCatCode();
        if (!$prodCat->updateOrder($catOrderArr)) {
            Message::addErrorMessage($prodCat->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        ProductCategory::updateCatOrderCode();

        $this->set('msg', Labels::getLabel('LBL_Record_Updated_Successfully', $this->adminLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function form($prodCatId = 0)
    {
        $this->objPrivilege->canEditProductCategories();
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $prodCatId = FatUtility::int($prodCatId);
        $prodCatFrm = $this->getCategoryForm($prodCatId);
        if (0 < $prodCatId) {
            $data = ProductCategory::getAttributesById($prodCatId);
            if ($data === false) {
                FatUtility::dieWithError($this->str_invalid_request);
            }
            $langData = ProductCategory::getLangDataArr($prodCatId, array(ProductCategory::DB_TBL_LANG_PREFIX . 'lang_id', ProductCategory::DB_TBL_PREFIX . 'name', ProductCategory::DB_TBL_PREFIX . 'content_block'));
            $catNameArr = array();
            $contentArray = [];
            
            foreach ($langData as $value) {
                $catNameArr[ProductCategory::DB_TBL_PREFIX . 'name'][$value[ProductCategory::DB_TBL_LANG_PREFIX . 'lang_id']] = $value[ProductCategory::DB_TBL_PREFIX . 'name'];
                $data[ProductCategory::DB_TBL_PREFIX . 'content_block_' . $value['prodcatlang_lang_id']] = $value['prodcat_content_block'];
            }
            
            $data = array_merge($data, $catNameArr);
            $prodCatFrm->fill($data);
            
        }
        $mediaLanguages = AppConstants::bannerTypeArr();
        $screenArr = AppConstants::getDisplaysArr($this->adminLangId);
        $langData = Language::getAllNames();
        unset($langData[$siteDefaultLangId]);
        $this->set('prodCatFrm', $prodCatFrm);
        $this->set('mediaLanguages', $mediaLanguages);
        $this->set('screenArr', $screenArr);
        $this->set('otherLangData', $langData);
        $this->set('includeEditor', true);
        $this->_template->render(false, false);
    }

    private function getCategoryForm($prodCatId = 0)
    {
        $prodCatId = FatUtility::int($prodCatId);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $frm = new Form('frmProdCategory');
        $frm->addHiddenField('', 'prodcat_id', $prodCatId);
        $frm->addRequiredField(Labels::getLabel('LBL_Category_Name', $this->adminLangId), 'prodcat_name[' . $siteDefaultLangId . ']');

        $prodCat = new ProductCategory();
        $categoriesArr = $prodCat->getCategoriesForSelectBox($this->adminLangId, $prodCatId);
        $categories = array(0 => Labels::getLabel('LBL_Root_Category', $this->adminLangId)) + $prodCat->makeAssociativeArray($categoriesArr);
        $frm->addSelectBox(Labels::getLabel('LBL_Parent_Category', $this->adminLangId), 'prodcat_parent', $categories, '', array(), '');

        $yesNoArr = AppConstants::getYesNoArr($this->adminLangId);
        $frm->addRadioButtons(Labels::getLabel('LBL_Publish', $this->adminLangId), 'prodcat_active', $yesNoArr, '1', array());

        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        $langData = Language::getAllNames();
        unset($langData[$siteDefaultLangId]);
        if (!empty($translatorSubscriptionKey) && count($langData) > 0) {
            $frm->addCheckBox(Labels::getLabel('LBL_Translate_To_Other_Languages', $this->adminLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }
        foreach ($langData as $langId => $data) {
            $frm->addTextBox(Labels::getLabel('LBL_Category_Name', $this->adminLangId), 'prodcat_name[' . $langId . ']');
        }

        $mediaLanguages = AppConstants::bannerTypeArr();
        $frm->addSelectBox(Labels::getLabel('LBL_Language', $this->adminLangId), 'icon_lang_id', $mediaLanguages, '', array(), '');
        $frm->addHiddenField('', 'icon_file_type', AttachedFile::FILETYPE_CATEGORY_ICON);
        $frm->addHiddenField('', 'logo_min_width');
        $frm->addHiddenField('', 'logo_min_height');
        $frm->addFileUpload(Labels::getLabel('LBL_Upload', $this->adminLangId), 'cat_icon', array('accept' => 'image/*', 'data-frm' => 'frmCategoryIcon'));
        foreach ($mediaLanguages as $key => $data) {
            $frm->addHiddenField('', 'cat_icon_image_id[' . $key . ']');
        }

        $frm->addSelectBox(Labels::getLabel('LBL_Language', $this->adminLangId), 'banner_lang_id', $mediaLanguages, '', array(), '');
        $screenArr = AppConstants::getDisplaysArr($this->adminLangId);
        $frm->addSelectBox(Labels::getLabel("LBL_Device", $this->adminLangId), 'slide_screen', $screenArr, '', array(), '');
        $frm->addHiddenField('', 'banner_file_type', AttachedFile::FILETYPE_CATEGORY_BANNER);
        $frm->addHiddenField('', 'banner_min_width');
        $frm->addHiddenField('', 'banner_min_height');
        $frm->addFileUpload(Labels::getLabel('LBL_Upload', $this->adminLangId), 'cat_banner', array('accept' => 'image/*', 'data-frm' => 'frmCategoryBanner'));
        foreach ($mediaLanguages as $key => $data) {
            foreach ($screenArr as $key1 => $screen) {
                $frm->addHiddenField('', 'cat_banner_image_id[' . $key . '_' . $key1 . ']');
            }
        }

        $frm->addSelectBox(Labels::getLabel('LBL_Language', $this->adminLangId), 'image_lang_id', $mediaLanguages, '', array(), '');
        $frm->addHiddenField('', 'image_file_type', AttachedFile::FILETYPE_CATEGORY_IMAGE);
        $frm->addHiddenField('', 'image_min_width');
        $frm->addHiddenField('', 'image_min_height');
        $frm->addFileUpload(Labels::getLabel('LBL_Upload', $this->adminLangId), 'cat_image', array('accept' => 'image/*', 'data-frm' => 'frmCategoryImage'));
        foreach ($mediaLanguages as $key => $data) {
            $frm->addHiddenField('', 'cat_image_id[' . $key . ']');
        }

        $frm->addSelectBox(Labels::getLabel('LBL_Language', $this->adminLangId), 'collection_image_lang_id', $mediaLanguages, '', array(), '');
        $frm->addHiddenField('', 'collection_image_file_type', AttachedFile::FILETYPE_CATEGORY_COLLECTION_IMAGE);
        $frm->addHiddenField('', 'collection_image_min_width');
        $frm->addHiddenField('', 'collection_image_min_height');
        $frm->addFileUpload(Labels::getLabel('LBL_Upload', $this->adminLangId), 'cat_collection_image', array('accept' => 'image/*', 'data-frm' => 'frmCollectionCategoryImage'));
        foreach ($mediaLanguages as $key => $data) {
            $frm->addHiddenField('', 'cat_collection_image_id[' . $key . ']');
        }
        $frm->addHtmlEditor(Labels::getLabel('LBL_Category_Content_Block', $this->adminLangId), 'prodcat_content_block_' . $siteDefaultLangId);

        foreach ($langData as $langId => $data) {
            $frm->addHtmlEditor(Labels::getLabel('LBL_Category_Content_Block', $this->adminLangId), 'prodcat_content_block_' . $langId);
        }

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->adminLangId));
        $frm->addButton('', 'btn_discard', Labels::getLabel('LBL_Discard', $this->adminLangId));
        return $frm;
    }

    public function setup()
    {
        $this->objPrivilege->canEditProductCategories();
        $frm = $this->getCategoryForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $prodCatId = FatUtility::int($post['prodcat_id']);

        $productCategory = new ProductCategory($prodCatId);
        if (!$productCategory->saveCategoryData($post)) {
            Message::addErrorMessage($productCategory->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        $this->set('msg', Labels::getLabel('LBL_Category_Setup_Successful', $this->adminLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function translatedCategoryData()
    {
        $catName = FatApp::getPostedData('catName', FatUtility::VAR_STRING, '');
        $toLangId = FatApp::getPostedData('toLangId', FatUtility::VAR_INT, 0);
        $data['prodcat_name'] = $catName;
        $productCategory = new ProductCategory();
        $translatedData = $productCategory->getTranslatedCategoryData($data, $toLangId);
        if (!$translatedData) {
            Message::addErrorMessage($productCategory->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        $this->set('prodCatName', $translatedData[$toLangId]['prodcat_name']);
        $this->_template->render(false, false, 'json-success.php', false, false);
    }

    public function images($prodcat_id, $imageType = '', $lang_id = 0, $slide_screen = 0)
    {
        $canEdit = $this->objPrivilege->canEditProductCategories(0, true);
        $prodcat_id = FatUtility::int($prodcat_id);
        $lang_id = FatUtility::int($lang_id);
        $images = array();
        switch ($imageType) {
            case 'icon':
                $images = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_ICON, $prodcat_id, 0, $lang_id, false);
                break;
            case 'banner':
                $images = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_BANNER, $prodcat_id, 0, $lang_id, false, $slide_screen);
                break;
            case 'image':
                $images = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_IMAGE, $prodcat_id, 0, $lang_id, true, 0);
                break;
            case 'collectionimage':
                $images = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_COLLECTION_IMAGE, $prodcat_id, 0, $lang_id, true, 0);
                break;
                
            default:
                # code...
                break;
        }

        $this->set('images', $images);
        $this->set('imageFunction', $imageType);
        $this->set('imageType', $imageType);
        $this->set('languages', Language::getAllNames());
        $this->set('canEdit', $canEdit);
        $this->_template->render(false, false);
    }

    public function setUpCatImages()
    {
        $this->objPrivilege->canEditProductCategories();
        $file_type = FatApp::getPostedData('file_type', FatUtility::VAR_INT, 0);
        $prodcat_id = FatApp::getPostedData('prodcat_id', FatUtility::VAR_INT, 0);
        $lang_id = FatApp::getPostedData('lang_id', FatUtility::VAR_INT, 0);
        $slide_screen = FatApp::getPostedData('slide_screen', FatUtility::VAR_INT, 0);
        $afileId = FatApp::getPostedData('afile_id', FatUtility::VAR_INT, 0);
        if (!$file_type) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieJsonError(Message::getHtml());
        }

        $allowedFileTypeArr = array(AttachedFile::FILETYPE_CATEGORY_COLLECTION_IMAGE, AttachedFile::FILETYPE_CATEGORY_IMAGE, AttachedFile::FILETYPE_CATEGORY_ICON, AttachedFile::FILETYPE_CATEGORY_BANNER);

        if (!in_array($file_type, $allowedFileTypeArr)) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieJsonError(Message::getHtml());
        }

        if (!is_uploaded_file($_FILES['cropped_image']['tmp_name'])) {
            Message::addErrorMessage(Labels::getLabel('LBL_Please_Select_A_File', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        ProductCategory:: deleteImagesWithOutCategoryId($file_type);

        $fileHandlerObj = new AttachedFile($afileId);
        if (!$fileHandlerObj->saveImage($_FILES['cropped_image']['tmp_name'], $file_type, $prodcat_id, 0, $_FILES['cropped_image']['name'], -1, false, $lang_id, $_FILES['cropped_image']['type'], $slide_screen)) {
            Message::addErrorMessage($fileHandlerObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        ProductCategory::setImageUpdatedOn($prodcat_id);
        $this->set('file', $_FILES['cropped_image']['name']);
        $this->set('prodcat_id', $prodcat_id);
        $this->set('msg', $_FILES['cropped_image']['name'] . ' ' . Labels::getLabel('LBL_Uploaded_Successfully', $this->adminLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function removeImage($afileId, $prodCatId, $imageType = '', $langId = 0, $slide_screen = 0)
    {
        $this->objPrivilege->canEditProductCategories();
        $afileId = FatUtility::int($afileId);
        $prodCatId = FatUtility::int($prodCatId);
        $langId = FatUtility::int($langId);
        if (!$afileId) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        if ($imageType == 'icon') {
            $fileType = AttachedFile::FILETYPE_CATEGORY_ICON;
        } elseif ($imageType == 'banner') {
            $fileType = AttachedFile::FILETYPE_CATEGORY_BANNER;
        } elseif ($imageType == 'image') {
            $fileType = AttachedFile::FILETYPE_CATEGORY_IMAGE;
        } elseif ($imageType == 'collectionimage') {
            $fileType = AttachedFile::FILETYPE_CATEGORY_COLLECTION_IMAGE;
        }
        
        $fileHandlerObj = new AttachedFile();
        if (!$fileHandlerObj->deleteFile($fileType, $prodCatId, $afileId, 0, $langId, $slide_screen)) {
            Message::addErrorMessage($fileHandlerObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        ProductCategory::setImageUpdatedOn($prodCatId);
        $this->set('imageType', $imageType);
        $this->set('msg', Labels::getLabel('MSG_Image_deleted_successfully', $this->adminLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function changeStatus()
    {
        $this->objPrivilege->canEditProductCategories();
        $prodCatId = FatApp::getPostedData('prodCatId', FatUtility::VAR_INT, 0);
        if ($prodCatId < 1) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieJsonError(Message::getHtml());
        }
        $catData = ProductCategory::getAttributesById($prodCatId, array('prodcat_active'));
        if (!$catData) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieJsonError(Message::getHtml());
        }

        $status = ($catData['prodcat_active'] == AppConstants::ACTIVE) ? AppConstants::INACTIVE : AppConstants::ACTIVE;
        $prodCat = new ProductCategory($prodCatId);
        if (!$prodCat->changeStatus($status)) {
            Message::addErrorMessage($prodCat->getError());
            FatUtility::dieWithError(Message::getHtml());
        }

        Product::updateMinPrices();
        $this->set('msg', $this->str_update_record);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function deleteRecord()
    {
        $this->objPrivilege->canEditProductCategories();
        $prodcat_id = FatApp::getPostedData('id', FatUtility::VAR_INT, 0);
        if ($prodcat_id < 1) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieJsonError(Message::getHtml());
        }

        $prodCateObj = new ProductCategory($prodcat_id);
        $childCats = $prodCateObj->getChildrens();
        if (count($childCats) > 0) {
            FatUtility::dieJsonError(Labels::getLabel('LBL_PLEASE_REMOVE_CHILD_CATEGORIES_FIRST.', $this->adminLangId));
        }
        if (!$prodCateObj->canRecordMarkDelete($prodcat_id)) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieJsonError(Message::getHtml());
        }

        /* Sub-Categories have products[ */
        if (true === $prodCateObj->haveProducts()) {
            FatUtility::dieJsonError(Labels::getLabel('LBL_Products_are_associated_with_its_category/sub-categories_so_we_are_not_able_to_delete_this_category', $this->adminLangId));
        }
        /* ] */

        $prodCateObj->assignValues(array(ProductCategory::tblFld('deleted') => 1));
        if (!$prodCateObj->save()) {
            FatUtility::dieJsonError($prodCateObj->getError());
        }

        Product::updateMinPrices();
        $this->set("msg", $this->str_delete_record);
        $this->_template->render(false, false, 'json-success.php');
    }

   
    
    public function getBreadcrumbNodes($action)
    {
        $nodes = array();
        switch ($action) {
            case 'index':
            case 'form':
                $nodes[] = array('title' => Labels::getLabel('LBL_Categories', $this->adminLangId), 'href' => CommonHelper::generateUrl('ProductCategories'));
        }
        return $nodes;
    }

    public function autocomplete()
    {
        $search_keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        $search_keyword = urldecode($search_keyword);
        $prodCateObj = new ProductCategory();
        $categories = $prodCateObj->getProdCatAutoSuggest($search_keyword, 10, $this->adminLangId);
        $json = array();
        $matches = $categories;
        foreach ($matches as $key => $val) {
            $json[] = array(
                'prodcat_id' => $key,
                'prodcat_identifier' => strip_tags(html_entity_decode($val, ENT_QUOTES, 'UTF-8'))
            );
        }
        echo json_encode($json);
    }

    public function links_autocomplete()
    {
        $keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        $prodCatObj = new ProductCategory();
        $arr_options = $prodCatObj->getProdCatTreeStructureSearch(0, $this->adminLangId, $keyword);
        $json = array();
        foreach ($arr_options as $key => $product) {
            $json[] = array(
                'id' => $key,
                'name' => strip_tags(html_entity_decode($product, ENT_QUOTES, 'UTF-8'))
            );
        }
        die(json_encode($json));
    }

}
