<?php

class RfqCancelReasonsController extends AdminBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
        $this->admin_id = AdminAuthentication::getLoggedAdminId();
    }

    public function index()
    {
        $this->objPrivilege->canViewRfqCancelReasons();
        $this->set("canEdit", true);
        $this->_template->render();
    }

    public function search()
    {
        $this->objPrivilege->canViewRfqCancelReasons();
        $srch = RfqCancelReason::getSearchObject($this->adminLangId);
        $srch->addMultipleFields(array('rcr_id', 'IFNULL(rcr_title, rcr_identifier) as rcr_title', 'rcr_identifier', 'rcr_active'));
        $srch->addOrder('rcr_id', 'ASC');
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);
        $this->set("arr_listing", $records);
        $this->set("canEdit", $this->objPrivilege->canEditRfqCancelReasons());
        $this->_template->render(false, false);
    }

    public function form()
    {
        $this->objPrivilege->canEditRfqCancelReasons();

        $reasonId = FatApp::getPostedData('rcr_id', FatUtility::VAR_INT, 0);
        $frm = $this->getForm();
        $data = array('rcr_id' => $reasonId);
        if (0 < $reasonId) {
            $data = RfqCancelReason::getAttributesById($reasonId, array('rcr_id', 'rcr_identifier', 'rcr_for'));
            if ($data === false) {
                FatUtility::dieWithError($this->str_invalid_request);
            }
        }
        $frm->fill($data);
        $this->set('languages', Language::getAllNames());
        $this->set('rcr_id', $reasonId);
        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function setup()
    {
        $this->objPrivilege->canEditRfqCancelReasons();

        $frm = $this->getForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $reasonId = FatApp::getPostedData('rcr_id', FatUtility::VAR_INT, 0);
        unset($post['rcr_id']);
        if ($reasonId == 0) {
            $post['rcr_active'] = AppConstants::YES;
        }

        $record = new RfqCancelReason($reasonId);
        $record->assignValues($post);
        if (!$record->save()) {
            Message::addErrorMessage($record->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $newTabLangId = 0;
        if ($reasonId > 0) {
            $languages = Language::getAllNames();
            foreach ($languages as $langId => $langName) {
                if (!$row = RfqCancelReason::getAttributesByLangId($langId, $reasonId)) {
                    $newTabLangId = $langId;
                    break;
                }
            }
        } else {
            $reasonId = $record->getMainTableRecordId();
            $newTabLangId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG', FatUtility::VAR_INT, 1);
        }

        $this->set('msg', $this->str_setup_successful);
        $this->set('reasonId', $reasonId);
        $this->set('langId', $newTabLangId);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function langForm(int $reasonId, int $langId, int $autoFillLangData = 0)
    {
        $this->objPrivilege->canEditRfqCancelReasons();

        if ($reasonId == 0 || $langId == 0) {
            FatUtility::dieWithError($this->str_invalid_request);
        }

        $langFrm = $this->getLangForm($langId);
        $langData = RfqCancelReason::getAttributesByLangId($langId, $reasonId);
        if (0 < $autoFillLangData) {
            $updateLangDataobj = new TranslateLangData(RfqCancelReason::DB_TBL_LANG);
            $translatedData = $updateLangDataobj->getTranslatedData($reasonId, $langId);
            if (false === $translatedData) {
                Message::addErrorMessage($updateLangDataobj->getError());
                FatUtility::dieWithError(Message::getHtml());
            }
            $langData = current($translatedData);
        } else {
            $langData = RfqCancelReason::getAttributesByLangId($langId, $reasonId);
        }

        $langData['rcr_id'] = $reasonId;
        $langData['lang_id'] = $langId;

        $langFrm->fill($langData);
        $this->set('languages', Language::getAllNames());
        $this->set('reasonId', $reasonId);
        $this->set('lang_id', $langId);
        $this->set('langFrm', $langFrm);
        $this->set('formLayout', Language::getLayoutDirection($langId));
        $this->_template->render(false, false);
    }

    public function langSetup()
    {
        $this->objPrivilege->canEditRfqCancelReasons();

        $langId = FatApp::getPostedData('lang_id', FatUtility::VAR_INT, 0);
        $reasonId = FatApp::getPostedData('rcr_id', FatUtility::VAR_INT, 0);
        $autoCompleteLangData = FatApp::getPostedData('auto_update_other_langs_data', FatUtility::VAR_INT, 0);

        $frm = $this->getLangForm($langId);
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if ($post == false || $reasonId == 0 || $langId == 0) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieWithError(Message::getHtml());
        }

        unset($post['rcr_id']);
        unset($post['lang_id']);

        $data = array(
            'rcrlang_lang_id' => $langId,
            'rcrlang_rcr_id' => $reasonId,
            'rcr_title' => $post['rcr_title'],
        );

        $reasonObj = new RfqCancelReason($reasonId);
        if (!$reasonObj->updateLangData($langId, $data)) {
            Message::addErrorMessage($reasonObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        
        /* [ TRANSLATE AND SAVE OTHER LANGUAGES DATA */
        if ($autoCompleteLangData) {
            $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
            $languages = Language::getAllNames();
            unset($languages[$siteDefaultLangId]);
            foreach ($languages as $langToTranslate => $langName) {
                if (!$reasonObj->saveTranslatedLangData($langToTranslate)) {
                    Message::addErrorMessage($reasonObj->getError());
                    FatUtility::dieJsonError(Message::getHtml());
                }
            }
        }
        /* ]*/

        $newTabLangId = 0;
        $languages = Language::getAllNames();
        foreach ($languages as $langId => $langName) {
            if (!$row = RfqCancelReason::getAttributesByLangId($langId, $reasonId)) {
                $newTabLangId = $langId;
                break;
            }
        }

        $this->set('msg', $this->str_setup_successful);
        $this->set('reasonId', $reasonId);
        $this->set('langId', $newTabLangId);
        $this->_template->render(false, false, 'json-success.php');
    }

    private function getForm()
    {
        $this->objPrivilege->canEditRfqCancelReasons();
        $frm = new Form('frmRfqCancelReason');
        $frm->addHiddenField('', 'rcr_id');
        $frm->addRequiredField(Labels::getLabel('LBL_Reason_Identifier', $this->adminLangId), 'rcr_identifier');
        $usrTypeArr = array(
            User::USER_TYPE_BUYER => Labels::getLabel('LBL_Buyer', $this->adminLangId),
            User::USER_TYPE_SELLER => Labels::getLabel('LBL_Seller', $this->adminLangId)
        );
        $frm->addSelectBox(Labels::getLabel('LBL_Reason_For', $this->adminLangId), 'rcr_for', $usrTypeArr, User::USER_TYPE_BUYER, array(), '');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->adminLangId));
        return $frm;
    }

    private function getLangForm($langId = 0)
    {
        $this->objPrivilege->canEditRfqCancelReasons();
        $frm = new Form('frmRfqCancelReasonLang');
        $frm->addHiddenField('', 'rcr_id');
        $frm->addSelectBox(Labels::getLabel('LBL_LANGUAGE', $this->adminLangId), 'lang_id', Language::getAllNames(), $this->adminLangId, array(), '');
        $frm->addRequiredField(Labels::getLabel('LBL_Reason_Title', $this->adminLangId), 'rcr_title');

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $languages = Language::getAllNames();
        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        unset($languages[$siteDefaultLangId]);

        if (!empty($translatorSubscriptionKey) && count($languages) > 0 && $langId == $siteDefaultLangId) {
            $frm->addCheckBox(Labels::getLabel('LBL_Translate_To_Other_Languages', $this->adminLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->adminLangId));
        return $frm;
    }

    public function changeStatus()
    {
        $this->objPrivilege->canEditRfqCancelReasons();
        $reasonId = FatApp::getPostedData('reasonId', FatUtility::VAR_INT, 0);
        if (0 >= $reasonId) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieWithError(Message::getHtml());
        }

        $data = RfqCancelReason::getAttributesById($reasonId, array('rcr_id', 'rcr_active'));
        if ($data == false) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieWithError(Message::getHtml());
        }
        $status = ($data['rcr_active'] == AppConstants::ACTIVE) ? AppConstants::INACTIVE : AppConstants::ACTIVE;

        $obj = new RfqCancelReason($reasonId);
        if (!$obj->changeStatus($status)) {
            Message::addErrorMessage($obj->getError());
            FatUtility::dieWithError(Message::getHtml());
        }

        $this->set('msg', $this->str_update_record);
        $this->_template->render(false, false, 'json-success.php');
    }

}
