<?php

class SeoSettingsController extends AdminBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
        $this->objPrivilege->canViewSeoSettings();
    }

    public function index()
    {
        $this->_template->render();
    }

    public function form()
    {
        $frm = $this->getForm();
        $frm->fill(Configurations::getConfigurations());
        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    private function getForm()
    {
        $frm = new Form('frmConfiguration');
        $fld = $frm->addCheckBox(Labels::getLabel('LBL_ENABLE_LANGUAGE_CODE_TO_SITE_URLS_&_LANGUAGE_SPECIFIC_URL_REWRITING', $this->adminLangId), 'CONF_LANG_SPECIFIC_URL', 1, array(), false, 0);
        $fld->htmlAfterField = '<small>' . Labels::getLabel("LBL_LANGUAGE_CODE_TO_SITE_URLS_EXAMPLES", $this->adminLangId) . '</small>';

        $fld = $frm->addTextBox(Labels::getLabel('LBL_Twitter_Username', $this->adminLangId), 'CONF_TWITTER_USERNAME');
        $fld->htmlAfterField = '<small>' . Labels::getLabel("LBL_This_is_required_for_Twitter_Card_code_SEO_Update", $this->adminLangId) . '</small>';

        $fld = $frm->addTextarea(Labels::getLabel('LBL_Site_Tracker_Code', $this->adminLangId), 'CONF_SITE_TRACKER_CODE');
        $fld->htmlAfterField = '<small>' . Labels::getLabel("LBL_This_is_the_site_tracker_script,_used_to_track_and_analyze_data_about_how_people_are_getting_to_your_website._e.g.,_Google_Analytics.", $this->adminLangId) . ' http://www.google.com/analytics/</small>';

        $fld = $frm->addTextarea(Labels::getLabel('LBL_Robots_Txt', $this->adminLangId), 'CONF_SITE_ROBOTS_TXT');
        $fld->htmlAfterField = '<small>' . Labels::getLabel("LBL_This_will_update_your_Robots.txt_file._This_is_to_help_search_engines_index_your_site_more_appropriately.", $this->adminLangId) . '</small>';

        $frm->addHtml('', 'Analytics', '<h3>' . Labels::getLabel("LBL_Google_Tag_Manager", $this->adminLangId) . '</h3>');
        $fld = $frm->addTextarea(Labels::getLabel("LBL_Head_Script", $this->adminLangId), 'CONF_GOOGLE_TAG_MANAGER_HEAD_SCRIPT');
        $fld->htmlAfterField = "<small>" . Labels::getLabel("LBL_This_is_the_code_provided_by_google_tag_manager_for_integration.", $this->adminLangId) . "</small>";

        $fld = $frm->addTextarea(Labels::getLabel("LBL_Body_Script", $this->adminLangId), 'CONF_GOOGLE_TAG_MANAGER_BODY_SCRIPT');
        $fld->htmlAfterField = "<small>" . Labels::getLabel("LBL_This_is_the_code_provided_by_google_tag_manager_for_integration.", $this->adminLangId) . "</small>";

        $fld = $frm->addHtml('', 'schemacode', '<h3>' . Labels::getLabel("FRM_SCHEMA_CODES", $this->adminLangId) . '</h3>');
        $fld = $frm->addTextarea(Labels::getLabel("FRM_DEFAULT_SCHEMA", $this->adminLangId), 'CONF_DEFAULT_SCHEMA_CODES_SCRIPT');
        $fld->htmlAfterField = "<small>" . Labels::getLabel("LBL_DEFAULT_SCHEMA_MSG", $this->adminLangId) . "</small>";

        if ($this->objPrivilege->canEditSeoSettings(0, true)) {
            $frm->addSubmitButton('', 'btn_submit', Labels::getLabel("LBL_Save_Changes", $this->adminLangId));
        }
        return $frm;
    }

    public function setup()
    {
        $this->objPrivilege->canEditSeoSettings();
        $frm = $this->getForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            FatUtility::dieJsonError(current($frm->getValidationErrors()));
        }

        $record = new Configurations();
        if (!$record->update($post)) {
            FatUtility::dieJsonError($record->getError());
        }
        if (isset($post['CONF_SITE_ROBOTS_TXT'])) {
            $robotfile = fopen(CONF_INSTALLATION_PATH . 'public/robots.txt', "w");
            fwrite($robotfile, $post['CONF_SITE_ROBOTS_TXT']);
            fclose($robotfile);
        }

        $this->set('msg', Labels::getLabel('MSG_Setup_Successful', $this->adminLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

}
