<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$rfqId = $rfqData['rfq_id'];
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
?>
<div class="page">
    <div class="container container-fluid">
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page__title">
                    <div class="row">
                        <div class="col--first col-lg-6">
                            <span class="page__icon"><i class="ion-android-star"></i></span>
                            <h5><?php echo Labels::getLabel('LBL_RFQ_Detail', $adminLangId); ?></h5>
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        </div>
                    </div>
                </div>
                <section class="section">
                    <div class="sectionhead">
                        <h4><?php echo Labels::getLabel('LBL_Buyer_Detail', $adminLangId); ?></h4>

                        <?php
                        $data = [
                            'adminLangId' => $adminLangId,
                            'statusButtons' => false,
                            'deleteButton' => false,
                            'otherButtons' => [
                                [
                                    'attr' => [
                                        'href' => CommonHelper::generateUrl('requestForQuotes'),
                                        'title' => Labels::getLabel('LBL_BACK', $adminLangId)
                                    ],
                                    'label' => '<i class="fas fa-arrow-left"></i>'
                                ],
                            ]
                        ];
                        $extraButtons = array();
                        if (true === RequestForQuote::canAdminUpdateStatus($rfqData['rfq_status'])) {
                            $extraButtons = [
                                [
                                    'attr' => [
                                        'href' => 'javascript:void(0)',
                                        'title' => Labels::getLabel('LBL_Close_RFQ', $adminLangId),
                                        'onclick' => 'changeRfqStatus("' . $rfqId . '")',
                                    ],
                                    'label' => '<i class="fas fa fa-times"></i>'
                                ]
                            ];
                        }

                        $data['otherButtons'] = array_merge($data['otherButtons'], $extraButtons);
                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="sectionbody">
                        <table class="table table--two-cols no-border-row">
                            <tbody>
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>: </th>
                                    <td><?php echo $rfqData['buyer_name']; ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Delivery_Address', $adminLangId); ?>: </th>
                                    <td>
                                        <?php
                                        $deliveryAddress = '';
                                        $deliveryAddress .= $rfqData['rfq_shipping_address1'] . '<br>';
                                        $deliveryAddress .= $rfqData['rfq_shipping_address2'] . '<br>';
                                        $deliveryAddress .= $rfqData['rfq_shipping_city'] . ', ';
                                        $deliveryAddress .= $rfqData['rfq_shipping_state'] . '<br>';
                                        $deliveryAddress .= $rfqData['rfq_shipping_country'] . ', ' . $rfqData['rfq_shipping_zipcode'];
                                        echo $deliveryAddress;
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Contact_No.', $adminLangId); ?>: </th>
                                    <td><?php echo $rfqData['rfq_shipping_phone']; ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </section>

                <div class="row row--cols-group">
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <section class="section">
                            <div class="sectionhead">
                                <h4><?php echo Labels::getLabel('LBL_Buyer_Original_Offer', $adminLangId); ?></h4>
                            </div>
                            <div class="row space">
                                <div class="">
                                    <table class="table table--two-cols no-border-row">
                                        <tbody>
                                            <tr>
                                                <td class="child-first no-padding">
                                                    <div class="td__data-right">
                                                        <div class="cart-item">
                                                            <div class="date"><small><label><?php echo Labels::getLabel('LBL_Date', $adminLangId); ?> :</label><?php echo FatDate::Format($rfqData['rfq_added_on']); ?></small></div>
                                                            <div class="cart-item__pic">
                                                                <a href="<?php echo CommonHelper::generateUrl('Products', 'View', array($rfqData['selprod_id']), CONF_WEBROOT_FRONTEND); ?>">
                                                                    <?php $uploadedTime = AttachedFile::setTimeParam($rfqData['product_updated_on']); ?>
                                                                    <img data-ratio="1:1 (500x500)" src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($rfqData['selprod_product_id'], "CLAYOUT3", $rfqData['selprod_id'], 0, $adminLangId), CONF_WEBROOT_FRONTEND) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $rfqData['selprod_title']; ?>">
                                                                </a>
                                                            </div>
                                                            <div class="cart-item__details">
                                                                <span class="cart-item__title"><a href="<?php echo CommonHelper::generateUrl('Products', 'View', array($rfqData['selprod_id']), CONF_WEBROOT_FRONTEND); ?>"><?php echo $rfqData['selprod_title']; ?></a> </span>
                                                                <span class="text--normal text--normal-secondary">
                                                                    <?php
                                                                    if ($rfqData['in_stock']) {
                                                                        echo Labels::getLabel('LBL_In_Stock', $adminLangId);
                                                                    } else {
                                                                        echo Labels::getLabel('LBL_Out_Of_Stock', $adminLangId);
                                                                    }
                                                                    ?>
                                                                </span>
                                                                <h5><?php echo CommonHelper::displayMoneyFormat($rfqData['selprod_price']); ?></h5>
                                                                <?php if (!empty($selProdOptions)) { ?>
                                                                    <ul class="list--devider">
                                                                        <?php
                                                                        foreach ($selProdOptions as $option) {
                                                                            echo '<li><span>' . $option["option_name"] . ':</span> ' . $option["optionvalue_name"] . '</li>';
                                                                        }
                                                                        ?>
                                                                    </ul>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table--two-cols no-border-row">
                                        <tbody>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Product_Qty', $adminLangId); ?> </th>
                                                <td><?php echo $rfqData['rfq_quantity']; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Product_Capacity', $adminLangId); ?></th>
                                                <td><?php echo $rfqData['rfq_capacity']; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Delivery_Duration', $adminLangId); ?></th>
                                                <td><?php echo FatDate::Format($rfqData['rfq_delivery_time'], true); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Delivery_Address', $adminLangId); ?></th>
                                                <td><?php echo $deliveryAddress; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Comments_for_Seller', $adminLangId); ?></th>
                                                <td><?php echo $rfqData['rfq_comments']; ?></td>
                                            </tr>
                                            <?php if (!empty($attachments) && $rfqData['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) { ?>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Uploaded_documents', $adminLangId); ?></th>
                                                    <td class="uploaded--documents quoted--offer">
                                                        <?php
                                                        foreach ($attachments as $attachment) {
                                                            /* $icon = '<i class="fa fa-download"></i>';
                                                              $link = CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', array($attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER));
                                                              echo '<a target="_blank" href="' . $link . '"><span>' . $attachment["afile_name"] . $icon . '</span></a>'; */
                                                            $attachmentId = $attachment['afile_id'];
                                                            $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                            $documentUrl = CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 70, 70]);
                                                            echo "<span id='document-js-" . $attachmentId . "'>";
                                                            if (in_array($ext, $imageType)) {
                                                        ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                    <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                </a>
                                                            <?php } else { ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                    <i class="icn rfq-doc-file-icon">
                                                                        <svg class="svg">
                                                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                        <?php
                                                            }
                                                            echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>';
                                                            echo "</span>";
                                                        }
                                                        ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </section>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <section class="section">
                            <div class="sectionhead">
                                <h4><?php echo Labels::getLabel('LBL_Quoted_Offer_By_Seller', $adminLangId); ?></h4>
                            </div>
                            <div class="row space">
                                <div class="">
                                    <?php if (!empty($quotedOfferDetail)) { ?>
                                        <table class="table table--two-cols no-border-row">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Product_Total_Cost', $adminLangId); ?> </th>
                                                    <td><?php echo CommonHelper::displayMoneyFormat($quotedOfferDetail['counter_offer_total_cost']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Shipping_Cost', $adminLangId); ?></th>
                                                    <td><?php echo CommonHelper::displayMoneyFormat($quotedOfferDetail['counter_offer_shipping_cost']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Delivery_Duration', $adminLangId); ?></th>
                                                    <td><?php echo FatDate::Format($quotedOfferDetail['counter_offer_delivery_time'], true); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Comments_for_Buyer', $adminLangId); ?></th>
                                                    <td><?php echo $quotedOfferDetail['counter_offer_comment']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Uploaded_documents', $adminLangId); ?></th>
                                                    <td id="uploaded-documents-js" class="uploaded--documents quoted--offer">
                                                        <?php
                                                        if (!empty($quotedAttachments)) {
                                                            foreach ($quotedAttachments as $quotedAttachment) {
                                                                /* $icon = '<i class="fa fa-download"></i>';
                                                                  $link = CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', array($quotedAttachment["afile_record_id"], $quotedAttachment["afile_id"], AttachedFile::FILETYPE_QUOTED_DOCUMENT));
                                                                  echo '<a target="_blank" href="' . $link . '"><span>' . $quotedAttachment["afile_name"] . $icon . '</span></a>'; */

                                                                $attachmentId = $quotedAttachment['afile_id'];
                                                                $ext = pathinfo($quotedAttachment['afile_name'], PATHINFO_EXTENSION);
                                                                $documentUrl = CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$quotedAttachment["afile_record_id"], $quotedAttachment["afile_id"], AttachedFile::FILETYPE_QUOTED_DOCUMENT, true, 70, 70]);
                                                                echo "<span id='document-js-" . $attachmentId . "'>";
                                                                if (in_array($ext, $imageType)) {
                                                        ?>
                                                                    <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$quotedAttachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_QUOTED_DOCUMENT]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                        <img src="<?php echo $documentUrl; ?>" alt="<?php echo $quotedAttachment['afile_name']; ?>" title="<?php echo $quotedAttachment['afile_name']; ?>" />
                                                                    </a>
                                                                <?php } else { ?>
                                                                    <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$quotedAttachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_QUOTED_DOCUMENT]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                        <i class="icn rfq-doc-file-icon">
                                                                            <svg class="svg">
                                                                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                            </svg>
                                                                        </i>
                                                                    </a>
                                                        <?php
                                                                }
                                                                echo '<p class="doc-title"><span>' . $icon = $quotedAttachment["afile_name"] . '</span></p>';
                                                                echo "</span>";
                                                            }
                                                        }
                                                        ?>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <?php } else { ?>
                                        <div class="info--order">
                                            <p>
                                                <?php echo Labels::getLabel('LBL_Offer_not_quoted_yet_by_seller', $adminLangId); ?>
                                            </p>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
                <?php if (!empty($servicesList)) { ?>
                    <section class="section">
                        <div class="sectionhead">
                            <h4><?php echo Labels::getLabel('LBL_Attached_Services', $adminLangId); ?></h4>
                        </div>
                        <div class="sectionbody">
                            <table class="table table--two-cols ">
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Service_Name', $adminLangId); ?> </th>
                                    <th><?php echo Labels::getLabel('LBL_Service_Original_Price', $adminLangId); ?> </th>
                                    <th><?php echo Labels::getLabel('LBL_Service_Qty', $adminLangId); ?> </th>
                                    <th><?php echo Labels::getLabel('LBL_Service_Capacity', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Uploaded_documents', $adminLangId); ?></th>
                                </tr>

                                <tbody>
                                    <?php
                                    foreach ($servicesList as $service) {
                                        $attachedDocs = (isset($attachments[$service['rfqattser_selprod_id']])) ? $attachments[$service['rfqattser_selprod_id']] : [];
                                    ?>
                                        <tr>
                                            <td><?php echo $service['selprod_title']; ?></td>
                                            <td><?php
                                                echo CommonHelper::displayMoneyFormat($service['selprod_price'], true, true);;
                                                ?></td>
                                            <td><?php echo $service['rfqattser_quantity']; ?></td>
                                            <td><?php echo $service['rfqattser_required_capacity']; ?></td>
                                            <td class="uploaded--documents quoted--offer">
                                                <?php
                                                if (!empty($attachedDocs)) {
                                                    $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                    foreach ($attachedDocs as $attachment) {
                                                        $attachmentId = $attachment['afile_id'];
                                                        $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                        $documentUrl = CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 70, 70]);
                                                        echo "<span id='document-js-" . $attachmentId . "'>";
                                                        if (in_array($ext, $imageType)) {
                                                ?>
                                                            <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                            </a>
                                                        <?php } else { ?>
                                                            <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                <i class="icn rfq-doc-file-icon">
                                                                    <svg class="svg">
                                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                <?php
                                                        }
                                                        echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>';
                                                        echo "</span>";
                                                    }
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </section>
                <?php } ?>


                <section class="section">
                    <div class="sectionhead">
                        <h4><?php echo Labels::getLabel('LBL_Offers_listing', $adminLangId); ?></h4>
                    </div>
                    <div class="sectionbody">
                        <div id="listing"></div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>
<script>
    (function() {
        offersListing = function($rfqId) {
            var data = 'rfq_id=' + $rfqId;
            $('#listing').html(fcom.getLoader());
            fcom.ajax(fcom.makeUrl('RequestForQuotes', 'offersListing'), data, function(res) {
                $('#listing').html(res);
            });
        };

    })();

    var rfq_id = '<?php echo $rfqData['rfq_id']; ?>';
    offersListing(rfq_id);
</script>

<style>
    .no-border-row td,
    .no-border-row th {
        border: 0px;
    }

    .cart-item {
        width: 100%;
        display: inline-block;
    }

    .cart-item .cart-item__pic {
        float: left;
        width: 100px;
        margin: 0 0 0 0;
    }

    .cart-item .cart-item__details {
        text-align: left;
        width: calc(100% - 100px);
        padding-left: 15px;
        float: left;
    }

    .cart-item .cart-item__title {
        display: block;
        font-size: 1.2em;
        font-weight: 600;
    }

    .cart-item .text--normal {
        font-size: 0.9em;
    }

    .text--normal-secondary {
        color: #f15c5c !important;
    }

    .quoted--offer span {
        margin-top: 0;
    }

    .uploaded--documents span {
        padding: 2px 6px;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        margin: 0 6px 0 0;
        display: inline-block;
    }

    .uploaded--documents span i {
        margin-left: 10px;
        cursor: pointer;
    }
</style>