(function() {
    loadList = function() {
        var data = 'rfqcrule_type=1'
        fcom.ajax(fcom.makeUrl('RfqCancellationRules','search'), data, function(res){
            $('#listing').html(res);
        });
    }
    
    setupRuleForBuyer = function(frm) {
        
        var atLeastOneIsChecked = false;
        $('#cancel-reasons-js input:checkbox').each(function () {
            if ($(this).is(':checked') && atLeastOneIsChecked == false) {
                $('#cancel-reasons-js .custom--error').remove();
                atLeastOneIsChecked = true;
            }
        });
  
        if (atLeastOneIsChecked == false) {
            $('#cancel-reasons-js .custom--error').remove();
            errorHtml = '<ul class="custom--error"><li><a href="javascript:void(0);">Select atleast one reason</a></li></ul>';
            $('#cancel-reasons-js ul').after(errorHtml);
            return false;
        }

        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        data = data+'&rfqcrule_type=1';
        fcom.ajax(fcom.makeUrl('RfqCancellationRules', 'setupRule'), data, function(res) {
            var ans = $.parseJSON(res);
            if(ans.status == 1) {
                loadList();
                fcom.displaySuccessMessage(ans.msg);
            } else {
                fcom.displayErrorMessage(ans.msg);
            }
        });
    }
    
    rfqRuleForm = function(id) {
        $.facebox(function() {
            fcom.displayProcessing();
            data = 'rfqcrule_id='+id+'&rfqcrule_type=1';
            fcom.ajax(fcom.makeUrl('RfqCancellationRules', 'form'), data, function(t) {
                fcom.updateFaceboxContent(t);
            });
        });
    }
    
    toggleStatus = function( obj, ruleId, status) {
        if( !confirm(langLbl.confirmUpdateStatus) ){ return; }
        var ruleId = parseInt(ruleId);
        if (ruleId < 1) {
            fcom.displayErrorMessage(langLbl.invalidRequest);
            return false;
        }

        data = 'ruleId='+ruleId+'&status='+status;
        fcom.ajax(fcom.makeUrl('RfqCancellationRules', 'changeStatus'), data, function(res) {
            var ans = $.parseJSON(res);
            if(ans.status == 1) {
                loadList();
                fcom.displaySuccessMessage(ans.msg);
                $(obj).toggleClass("active");
            } else {
                fcom.displayErrorMessage(ans.msg);
            }
        });
    };

})();
loadList();