<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class='page'>
    <div class='container container-fluid'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page__title">
                    <div class="row">
                        <div class="col--first col-lg-6">
                            <span class="page__icon">
                                <i class="ion-android-star"></i></span>
                            <h5><?php echo Labels::getLabel('LBL_Manage_Users', $adminLangId); ?> </h5>
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        </div>
                    </div>
                </div>
                <section class="section searchform_filter">
                    <div class="sectionhead">
                        <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
                    </div>
                    <div class="sectionbody space togglewrap" style="display:none;">
                        <?php
                        $frmSearch->setFormTagAttribute('onsubmit', 'searchUsers(this,1); return(false);');
                        $frmSearch->setFormTagAttribute('class', 'web_form');
                        $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
                        $frmSearch->developerTags['fld_default_col'] = 6;

                        $sellerTypeFld = $frmSearch->getField('seller_type');
                        if (!empty($sellerTypeFld)) {
                            $sellerTypeFld->setWrapperAttribute('class', 'hide-seller-type-fld--js seller-type-fld--js');
                        }

                        $userParentFld = $frmSearch->getField('user_parent');
                        if (!empty($userParentFld)) {
                            $userParentFld->setWrapperAttribute('class', 'hide-seller-type-fld--js user-parent-fld--js');
                        }
                        
                        $countryFld = $frmSearch->getField('country');
                        if (!empty($countryFld)) {
                            $countryFld->setWrapperAttribute('class', 'hide-seller-type-fld--js seller-type-fld--js');
                        }

                        $fld = $frmSearch->getField('btn_clear');
                        $fld->addFieldTagAttribute('onclick', 'clearUserSearch()');
                        echo $frmSearch->getFormHtml();
                        ?>
                    </div>
                </section>
                <section class="section">
                    <div class="sectionhead">
                        <h4><?php echo Labels::getLabel('LBL_Users_List', $adminLangId); ?> </h4>
                        <?php
                        if ($canEdit) {
                            $data = [
                                'adminLangId' => $adminLangId,
                                'otherButtons' => [
                                    [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'deletedUser()',
                                            'title' => Labels::getLabel('LBL_Deleted_users', $adminLangId)
                                        ],
                                        'label' => '<i class="fas fa-user-times"></i>'
                                    ],
                                ]
                            ];

                            $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        }
                        ?>
                    </div>
                    <div class="sectionbody">
                        <div class="tablewrap">
                            <div id="userListing">
                                <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>

<style>
    .hide-seller-type-fld--js{
        display: none;
    }
</style>
<script>
    $(document).ready(function () {
        $('select[name="type"]').on('change', function () {
            var user_type = $(this).val();
            if (user_type == <?php echo User::USER_TYPE_SELLER; ?> || user_type == <?php echo User::USER_TYPE_BUYER_SELLER; ?>) {
                $('.seller-type-fld--js').show();
                $('.user-parent-fld--js').hide();
            } else if (user_type == <?php echo User::USER_TYPE_SUB_USER; ?>) {
                $('.user-parent-fld--js').show();
                $('.seller-type-fld--js').hide();
                $('input[name=\'user_parent_id\']').val('');
                $('input[name=\'user_parent\']').val('');
            } else {
                $('.seller-type-fld--js').hide();
                $('.user-parent-fld--js').hide();
            }
        });
    })
</script>
