<?php

class AttachServicesController extends SellerBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
    }

    public function index()
    {
        if (!ServicesController::isShopActive($this->userParentId, 0, true)) {
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'shop'));
        }
        if (!UserPrivilege::isUserHasValidSubsription($this->userParentId)) {
            Message::addInfo(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }
        $searchForm = $this->searchForm();
        $this->set('searchForm', $searchForm);
        $this->_template->addJs('js/yomultiselect.all.min.js');
        $this->_template->addCSS('css/yomultiselect.default-v2.min.css');
        $this->_template->render(true, true);
    }

    public function sellerProducts()
    {
        $db = FatApp::getDb();
        $post = FatApp::getPostedData();
        $userId = $this->userParentId;
        $srch = SellerProduct::getSearchObject($this->siteLangId);
        $srch->doNotCalculateRecords();
        $srch->joinTable(Product::DB_TBL, 'INNER JOIN', 'p.product_id = sp.selprod_product_id', 'p');
        $srch->joinTable(Product::DB_TBL_LANG, 'LEFT OUTER JOIN', 'p.product_id = p_l.productlang_product_id AND p_l.productlang_lang_id = ' . $this->siteLangId, 'p_l');
        $srch->addCondition('sp.selprod_type', '=', SellerProduct::PRODUCT_TYPE_PRODUCT);
        $srch->addCondition('sp.selprod_user_id', '=', $userId);
        $srch->addCondition('sp.selprod_active', '=', AppConstants::ACTIVE);
        $srch->addCondition('p.product_active', '=', AppConstants::ACTIVE);
        $srch->addCondition('p.product_approved', '=', Product::APPROVED);
        $srch->addOrder('product_name');
        $srch->addOrder('selprod_title');
        $srch->addOrder('selprod_id');
        $srch->addMultipleFields(array('selprod_id', 'IFNULL(selprod_title, IFNULL(product_name, product_identifier)) as selprod_title', 'IFNULL(product_name, product_identifier) as product_name', 'selprod_price', 'product_id'));

        if (!empty($post['keyword'])) {
            $cnd = $srch->addCondition('product_name', 'LIKE', '%' . $post['keyword'] . '%');
            $cnd->attachCondition('selprod_title', 'LIKE', '%' . $post['keyword'] . '%', 'OR');
        }

        $rs = $srch->getResultSet();
        $products = $db->fetchAll($rs, 'selprod_id');

        $productsGroupData = [];
        if ($products) {
            $selProductIds = array_unique(array_column($products, 'selprod_id'));
            $allSelproductOptions = SellerProduct::getSellerProductOptions($selProductIds, true, $this->siteLangId);
            $allSelproductOptions = $this->groupOptionsBySelProdId($allSelproductOptions);
            
            foreach ($products as $selprodId => $product) {
               $options = (isset($allSelproductOptions[$product['selprod_id']])) ? $allSelproductOptions[$product['selprod_id']] : [];
                $productId = (empty($options)) ? $selprodId : 0;
                $productName = (empty($options)) ? $product['selprod_title'] : $product['product_name'];
                $productsGroupData[$product['product_id']]['id'] = $productId;
                $productsGroupData[$product['product_id']]['text'] = strip_tags(htmlspecialchars($productName, ENT_QUOTES, 'UTF-8'));
                if (!empty($options)) {
                    $optionvalueNames = array_column($options, 'optionvalue_name');
                    $optionName = implode('|', $optionvalueNames);
                    $selprodTitle = $product['selprod_title'] . ' - ' . $optionName;
                    $productsGroupData[$product['product_id']]['items'][] = array(
                        "id" => $selprodId,
                        "text" => strip_tags(htmlspecialchars($selprodTitle, ENT_QUOTES, 'UTF-8'))
                    );
                }
            }
        }

        sort($productsGroupData);
        //return $productsGroupData;
        die(json_encode($productsGroupData));
    }

    public function search()
    {
        $searchForm = $this->searchForm();
        $post = $searchForm->getFormDataFromArray(FatApp::getPostedData());
        $userId = $this->userParentId;
        $page = (empty($post['page']) || $post['page'] <= 0) ? 1 : intval($post['page']);
        $pagesize = FatApp::getConfig('CONF_PAGE_SIZE', FatUtility::VAR_INT, 10);

        $srch = new searchBase(SellerProduct::DB_TBL_SELLER_PROD_SERVICE, 'sps');
        $srch->joinTable(SellerProduct::DB_TBL, 'INNER JOIN', 'sps.sps_service_product_id = sp.selprod_id', 'sp');
        $srch->joinTable(SellerProduct::DB_TBL_LANG, 'LEFT OUTER JOIN', 'sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'selprod_id = sp.' . SellerProduct::tblFld('id') . ' and sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'lang_id = ' . $this->siteLangId, 'sp_l');
        $keyword = FatApp::getPostedData('keyword', null, '');
        if (!empty($keyword)) {
            $cnd = $srch->addCondition('selprod_title', 'like', '%' . $keyword . '%');
        }
        $srch->addCondition('selprod_user_id', '=', $userId);

        $srch->addMultipleFields(array('selprod_id', 'selprod_title'));
        $srch->addGroupBy('sps_service_product_id');
        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $srchRs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($srchRs, 'selprod_id');
        $attachedProductsData = [];
        if (!empty($records)) {
            $servicesIds = array_column($records, 'selprod_id');
            $attachedProducts = $this->getAttachedSellerProducts($servicesIds);
            if (!empty($attachedProducts)) {
                $selProductIds = array_unique(array_column($attachedProducts, 'selprod_id'));
                $allSelproductOptions = SellerProduct::getSellerProductOptions($selProductIds, true, $this->siteLangId);
                $allSelproductOptions = $this->groupOptionsBySelProdId($allSelproductOptions);
                foreach ($attachedProducts as $product) {
                    $options = (isset($allSelproductOptions[$product['selprod_id']])) ? $allSelproductOptions[$product['selprod_id']] : [];
                    if (!empty($options)) {
                        $optionvalueNames = array_column($options, 'optionvalue_name');
                        $optionName = implode('|', $optionvalueNames);
                        $product['selprod_title'] = $product['selprod_title'] . ' - ' . $optionName;
                    }
                    $attachedProductsData[$product['sps_service_product_id']][] = $product;
                }
            }
        }

        $this->set('arrListing', $records);
        $this->set('attachedProductsData', $attachedProductsData);
        $this->set('siteLangId', $this->siteLangId);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('postedData', $post);
        $this->_template->render(false, false);
    }

    private function groupOptionsBySelProdId(array $optionsArr): array
    {
        if (empty($optionsArr)) {
            return [];
        }
        $optionsFormatedArr = [];
        foreach ($optionsArr as $option) {
            $optionsFormatedArr[$option['seller_product_id']][] = $option;
        }
        return $optionsFormatedArr;
    }

    public function updateServiceWithProducts()
    {
        $serviceId = FatApp::getPostedData('service_product_id', FatUtility::VAR_INT, 0);
        $selectedProducts = FatApp::getPostedData('products_data');
        $selectedProductsArr = explode(',', $selectedProducts);

        if ($serviceId <= 0 || empty($selectedProductsArr)) {
            Message::addErrorMessage(Labels::getLabel('LBL_Service_And_Minimum_One_Product_Is_Required', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $selProdObj = new SellerProduct();
        if (!$selProdObj->updateServiceToProduct($selectedProductsArr, $serviceId)) {
            Message::addErrorMessage($selProdObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('LBL_Updated_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function deleteAttachedProduct()
    {
        $userId = $this->userParentId;
        $serviceId = FatApp::getPostedData('service_product_id', FatUtility::VAR_INT, 0);
        $selProdId = FatApp::getPostedData('seller_product_id', FatUtility::VAR_INT, 0);

        if ($serviceId <= 0 || $selProdId <= 0) {
            Message::addErrorMessage(Labels::getLabel('Lbl_Invalid_Request', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $selProdUserId = SellerProduct::getAttributesById($selProdId, 'selprod_user_id');
        $serviceUserId = SellerProduct::getAttributesById($serviceId, 'selprod_user_id');

        if ($selProdUserId != $userId || $serviceUserId != $userId) {
            Message::addErrorMessage(Labels::getLabel('Lbl_Invalid_Request', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $selProdObj = new SellerProduct();
        if (!$selProdObj->deleteAttachedServiceProduct($serviceId, $selProdId)) {
            Message::addErrorMessage($selProdObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('LBL_Deleted_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    private function getAttachedSellerProducts(array $servicesIds): array
    {
        if (empty($servicesIds)) {
            return [];
        }
        $userId = $this->userParentId;
        $srch = new searchBase(SellerProduct::DB_TBL_SELLER_PROD_SERVICE, 'sps');
        $srch->joinTable(SellerProduct::DB_TBL, 'INNER JOIN', 'sps.sps_seller_prod_id = sp.selprod_id', 'sp');
        $srch->joinTable(SellerProduct::DB_TBL_LANG, 'LEFT OUTER JOIN', 'sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'selprod_id = sp.' . SellerProduct::tblFld('id') . ' and sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'lang_id = ' . $this->siteLangId, 'sp_l');
        $srch->addMultipleFields(array('selprod_id', 'selprod_title', 'sps_service_product_id'));
        $srch->addCondition('sps_service_product_id', 'IN', $servicesIds);
        $srch->addCondition('selprod_user_id', '=', $userId);
        $srchRs = $srch->getResultSet();
        return FatApp::getDb()->fetchAll($srchRs);
    }

    private function searchForm()
    {
        $frm = new Form('frmSearchServiceProduct');
        $frm->addTextBox(Labels::getLabel('LBL_Search_By', $this->siteLangId), 'keyword');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit', $this->siteLangId));
        $frm->addButton('', 'btn_clear', Labels::getLabel('LBL_Clear', $this->siteLangId));
        $frm->addHiddenField('', 'page');
        return $frm;
    }

}
