<?php

class HomeController extends MyAppController
{

    public function index()
    {
        $slides = $this->getSlides();
        $banners = $this->getBanners();
        $referalUrl =  CommonHelper::getCurrUrl();
        if (UserAuthentication::isUserLogged()) {
            $referalUrl = CommonHelper::referralTrackingUrl(UserAuthentication::getLoggedUserAttribute('user_referral_code'));
        }
        $socialShareContent = array(
            'type' => 'home',
            'title' => sprintf(FatApp::getConfig("CONF_SOCIAL_FEED_FACEBOOK_POST_TITLE_" . $this->siteLangId, FatUtility::VAR_STRING, ''), FatApp::getConfig("CONF_WEBSITE_NAME_" . $this->siteLangId)),
            'description' => sprintf(FatApp::getConfig("CONF_SOCIAL_FEED_FACEBOOK_POST_CAPTION_" . $this->siteLangId, FatUtility::VAR_STRING, ''), FatApp::getConfig("CONF_WEBSITE_NAME_" . $this->siteLangId)),
            'image' => CommonHelper::generateFullFileUrl('image', 'socialFeed', array($this->siteLangId)),
            'url' => $referalUrl
        );
        $this->set('homecollections', $this->loadCollections());
        $this->set('slides', $slides);
        $this->set('banners', $banners);
        $this->set('isWishlistEnable', FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1));
        $this->set('socialShareContent', $socialShareContent);
        $this->_template->addJs('js/slick.min.js');
        $this->_template->render();
    }

    public function loadCollections()
    {
        $collections = $this->getCollections();
        $loggedUserId = UserAuthentication::getLoggedUserId(true);
        $productSrchObj = $this->getProductSearchObj($loggedUserId);
        $cacheKey = $this->siteLangId . '-' . $this->siteCurrencyId;

        $homePageProdLayout1 = FatCache::get('homePageProdLayout1' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageProdLayout1) {
            $homePageProdLayout1 = '';
            if (isset($collections[Collections::TYPE_PRODUCT_LAYOUT1])) {
                $tpl = new FatTemplate('', '');
                $tpl->set('siteLangId', $this->siteLangId);
                $tpl->set('collections', $collections[Collections::TYPE_PRODUCT_LAYOUT1]);
                $homePageProdLayout1 = $tpl->render(false, false, '_partial/collection/product-layout-1.php', true, true);
                FatCache::set('homePageProdLayout1' . $cacheKey, $homePageProdLayout1, '.txt');
            }
        }
        $json['homePageProdLayout1'] =  $homePageProdLayout1;


        /* [ As all layout in sequence so added in one cache] */
        $homePageProdLayout2 = FatCache::get('homePageProdLayout2' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageProdLayout2) {
            $homePageProdLayout2 = '';
            if (isset($collections[Collections::TYPE_PRODUCT_LAYOUT2])) {
                $tpl = new FatTemplate('', '');
                $tpl->set('siteLangId', $this->siteLangId);
                $tpl->set('collections', $collections[Collections::TYPE_PRODUCT_LAYOUT2]);
                $homePageProdLayout2 = $tpl->render(false, false, '_partial/collection/product-layout-2.php', true, true);
                FatCache::set('homePageProdLayout2' . $cacheKey, $homePageProdLayout2, '.txt');
            }
        }
        $json['homePageProdLayout2'] =  $homePageProdLayout2;

        $homePageCatLayout1 = FatCache::get('homePageCatLayout1' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageCatLayout1) {
            $homePageCatLayout1 = '';
            if (isset($collections[Collections::TYPE_CATEGORY_LAYOUT1])) {
                $tpl = new FatTemplate('', '');
                $tpl->set('siteLangId', $this->siteLangId);
                $tpl->set('collections', $collections[Collections::TYPE_CATEGORY_LAYOUT1]);
                $homePageCatLayout1 = $tpl->render(false, false, '_partial/collection/category-layout-1.php', true, true);
                FatCache::set('homePageCatLayout1' . $cacheKey, $homePageCatLayout1, '.txt');
            }
        }

        $json['homePageCatLayout1'] =  $homePageCatLayout1;
        /* ] */

        /* Product Layout2[ */
        $homePageProdLayout3 = FatCache::get('homePageProdLayout3' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageProdLayout3 && (isset($collections[Collections::TYPE_PRODUCT_LAYOUT3]))) {
            $tpl = new FatTemplate('', '');
            $tpl->set('siteLangId', $this->siteLangId);
            $tpl->set('collections', $collections[Collections::TYPE_PRODUCT_LAYOUT3]);
            $homePageProdLayout3 = $tpl->render(false, false, '_partial/collection/product-layout-3.php', true, true);
            FatCache::set('homePageProdLayout3' . $cacheKey, $homePageProdLayout3, '.txt');
        }
        $json['homePageProdLayout3'] =  $homePageProdLayout3;
        /* ] */

        /* Shop Layout1[ */
        $homePageShopLayout1 = FatCache::get('homePageShopLayout1' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageShopLayout1 && (isset($collections[Collections::TYPE_SHOP_LAYOUT1]))) {
            $tpl = new FatTemplate('', '');
            $tpl->set('siteLangId', $this->siteLangId);
            $tpl->set('collections', $collections[Collections::TYPE_SHOP_LAYOUT1]);
            $homePageShopLayout1 = $tpl->render(false, false, '_partial/collection/shop-layout-1.php', true, true);
            FatCache::set('homePageShopLayout1' . $cacheKey, $homePageShopLayout1, '.txt');
        }
        $json['homePageShopLayout1'] =  $homePageShopLayout1;
        /* ] */

        /* [ As all layout in sequence so added in one cache] */

        $homePageCatLayout2 = FatCache::get('homePageCatLayout2' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageCatLayout2) {
            $homePageCatLayout2 = '';
            if (isset($collections[Collections::TYPE_CATEGORY_LAYOUT2])) {
                $tpl = new FatTemplate('', '');
                $tpl->set('siteLangId', $this->siteLangId);
                $tpl->set('collections', $collections[Collections::TYPE_CATEGORY_LAYOUT2]);
                $homePageCatLayout2 = $tpl->render(false, false, '_partial/collection/category-layout-2.php', true, true);
                FatCache::set('homePageCatLayout2' . $cacheKey, $homePageCatLayout2, '.txt');
            }
        }
        
        $json['homePageCatLayout2'] =  $homePageCatLayout2;

        $homePageProdLayout4 = FatCache::get('homePageProdLayout4' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageProdLayout4) {
            $homePageProdLayout4 = '';
            if (isset($collections[Collections::TYPE_PRODUCT_LAYOUT4])) {
                $tpl = new FatTemplate('', '');
                $tpl->set('siteLangId', $this->siteLangId);
                $tpl->set('collections', $collections[Collections::TYPE_PRODUCT_LAYOUT4]);
                $homePageProdLayout4 = $tpl->render(false, false, '_partial/collection/product-layout-4.php', true, true);
                FatCache::set('homePageProdLayout4' . $cacheKey, $homePageProdLayout4, '.txt');
            }
        }
        
        $json['homePageProdLayout4'] =  $homePageProdLayout4;

        $homePageBrandLayout1 = FatCache::get('homePageBrandLayout1' . $cacheKey, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if (!$homePageBrandLayout1) {
            $homePageBrandLayout1 = '';
            if (isset($collections[Collections::TYPE_BRAND_LAYOUT1])) {
                $tpl = new FatTemplate('', '');
                $tpl->set('siteLangId', $this->siteLangId);
                $tpl->set('collections', $collections[Collections::TYPE_BRAND_LAYOUT1]);
                $homePageBrandLayout1 = $tpl->render(false, false, '_partial/collection/brand-layout-1.php', true, true);
                FatCache::set('homePageBrandLayout1' . $cacheKey, $homePageBrandLayout1, '.txt');
            }
        }

        $json['homePageBrandLayout1'] =  $homePageBrandLayout1;
        $json['sponsoredProds'] = $this->getSponsoredProducts($productSrchObj);
        $json['sponsoredShops'] = $this->getSponsoredShops($productSrchObj);
        return $json;

        
    }

    private function getProductSearchObj($loggedUserId)
    {
        $loggedUserId = FatUtility::int($loggedUserId);
        $productSrchObj = new ProductSearch($this->siteLangId);
        $productSrchObj->setDefinedCriteria();
        $productSrchObj->joinProductToCategory();
        $productSrchObj->joinSellerSubscription($this->siteLangId, true);
        $productSrchObj->addSubscriptionValidCondition();
        $productSrchObj->doNotCalculateRecords();
        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }

        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $productSrchObj->joinFavouriteProducts($loggedUserId);
            $productSrchObj->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $productSrchObj->joinUserWishListProducts($loggedUserId);
            $productSrchObj->addFld('IFNULL(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }

        $productSrchObj->addCondition('selprod_deleted', '=', AppConstants::NO);

        $genFlds = array(
            'shop_is_buy_now', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers', 'product_id', 'selprod_id', 'IFNULL(product_name, product_identifier) as product_name',
            'IFNULL(selprod_title  ,IFNULL(product_name, product_identifier)) as selprod_title', 'selprod_updated_on', 'product_updated_on',
            'special_price_found', 'splprice_display_list_price', 'splprice_display_dis_val', 'splprice_display_dis_type',
            'theprice', 'selprod_price', 'selprod_stock', 'selprod_condition', 'prodcat_id',
            'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name', 'selprod_sold_count',
            'IF(selprod_stock > 0, 1, 0) AS in_stock', 'seller_user.user_name', 'seller_user.user_is_verified as seller_verified',
            'seller_user.user_is_founding_member as is_founding_member', 'shop_country.country_code as seller_country', 'selprod_user_id',
            'shop_id', 'IFNULL(shop_name, shop_identifier) as shop_name', 'selprod_type');

        $flds = array_merge($genFlds, $subFld);
        $productSrchObj->addMultipleFields($flds);
        return $productSrchObj;
    }

    public function languages()
    {
        $languages = Language::getAllNames(false);
        $languageArr = array();
        if (0 < count($languages)) {
            $siteDefaultLangId = FatApp::getConfig('CONF_DEFAULT_SITE_LANG', FatUtility::VAR_INT, 1);
            foreach ($languages as &$language) {
                $language['isSiteDefaultLang'] = ($language['language_id'] === $siteDefaultLangId) ? 1 : 0;
                $languageArr[] = $language;
            }
        }
        $this->set('languages', $languageArr);
        $this->_template->render();
    }


    public function setLanguage($langId = 0, $pathname = '')
    {
        if (!FatUtility::isAjaxCall()) {
            die('Invalid Action.');
        }

        $pathname = FatApp::getPostedData('pathname', FatUtility::VAR_STRING, '');
        $redirectUrl = '';
        if (empty($pathname)) {
            $redirectUrl = UrlHelper::generateFullUrl();
        }

        $isDefaultLangId = false;
        if ($langId == FatApp::getConfig('CONF_DEFAULT_SITE_LANG', FatUtility::VAR_INT, 1)) {
            $isDefaultLangId = true;
        }

        if (FatApp::getConfig('CONF_LANG_SPECIFIC_URL', FatUtility::VAR_INT, 0) && count(LANG_CODES_ARR) > 1) {
            $langCodeArr = LANG_CODES_ARR;
            if (count($langCodeArr) > 1) {
                $langIds = array_flip($langCodeArr);

                if (!empty($pathname)) {
                    //$existingUrlLangCode = strtoupper(substr(ltrim($pathname, '/'), 0, 2));
                    //$existingUrlLangCode = strtoupper(substr(ltrim($pathname, '/'), 0, 2));
                    $pathnameArr = explode('/', ltrim($pathname, '/'));
                    $existingUrlLangCode = strtoupper($pathnameArr[0]);
                } else {
                    $existingUrlLangCode = $langCodeArr[CommonHelper::getLangId()];
                }

                if (in_array($existingUrlLangCode, LANG_CODES_ARR)) {
                    // $existingUrlLangId = $langIds[$existingUrlLangCode];
                    //$pathname = ltrim(substr(ltrim($pathname, '/'), 2), '/');
                    $pathnameArr = explode('/', ltrim($pathname, '/'));
                    array_shift($pathnameArr);
                    $pathname = implode('/', $pathnameArr);
                } else {
                    // $existingUrlLangId = FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1);
                    $pathname = ltrim($pathname, '/');
                }

                $srch = UrlRewrite::getSearchObject();
                $srch->joinTable(UrlRewrite::DB_TBL, 'LEFT OUTER JOIN', 'temp.urlrewrite_original = ur.urlrewrite_original and temp.urlrewrite_lang_id = ' . $langId, 'temp');
                $srch->doNotCalculateRecords();
                $srch->setPageSize(1);
                $srch->addMultipleFields(array('ifnull(temp.urlrewrite_custom, ur.urlrewrite_custom) customurl'));
                $srch->addCondition('ur.' . UrlRewrite::DB_TBL_PREFIX . 'custom', '=', $pathname);
                // $srch->addCondition('ur.' . UrlRewrite::DB_TBL_PREFIX . 'lang_id', '=', $existingUrlLangId);

                $rs = $srch->getResultSet();
                $row = FatApp::getDb()->fetch($rs);

                if (!empty($row)) {
                    $redirectUrl = UrlHelper::generateFullUrl('', '', [], '', null, false, false, false);

                    if (false == $isDefaultLangId) {
                        $redirectUrl .=  strtolower($langCodeArr[$langId]) . '/';
                    }
                    $redirectUrl .=  $row['customurl'];
                }
            }

            if (empty($redirectUrl)) {
                $redirectUrl = UrlHelper::generateFullUrl('', '', [], '', null, false, false, false);
                if (false == $isDefaultLangId) {
                    $redirectUrl .=  strtolower($langCodeArr[$langId]) . '/';
                }
                $redirectUrl .=  ltrim($pathname, '/');
            }
        } else {
            if (empty($redirectUrl)) {
                $redirectUrl = UrlHelper::generateFullUrl('', '', [], '', null, false, false, false) . ltrim($pathname, '/');
            }
        }


        $langId = FatUtility::int($langId);
        if (0 < $langId) {
            $languages = Language::getAllNames();
            if (array_key_exists($langId, $languages)) {
                setcookie('defaultSiteLang', $langId, time() + 3600 * 24 * 10, CONF_WEBROOT_URL);
            }
        }
        $this->set('redirectUrl', $redirectUrl);
        $this->_template->render(false, false, 'json-success.php');
    }


    public function currencies()
    {
        $cObj = Currency::getSearchObject($this->siteLangId, true);
        $cObj->addMultipleFields(
                array(
                    'currency_id', 'currency_code', 'IFNULL(curr_l.currency_name,curr.currency_code) as currency_name'
                )
        );
        $rs = $cObj->getResultSet();
        $currencies = $this->db->fetchAll($rs);
        $this->set('currencies', $currencies);
        $this->_template->render();
    }

    public function setCurrency($currencyId = 0)
    {
        if (!FatUtility::isAjaxCall()) {
            die('Invalid Action.');
        }

        $currencyId = FatUtility::int($currencyId);
        $currencyObj = new Currency();
        if (0 < $currencyId) {
            $currencies = Currency::getCurrencyAssoc($this->siteLangId);
            if (array_key_exists($currencyId, $currencies)) {
                setcookie('defaultSiteCurrency', $currencyId, time() + 3600 * 24 * 10, CONF_WEBROOT_URL);
            }
        }
    }

    public function languageLabels($download = 0, $langId = 0)
    {
        $langId = FatUtility::int($langId) > 0 ? $langId : $this->siteLangId;
        $download = FatUtility::int($download);
        $langCode = Language::getAttributesById($langId, 'language_code', false);

        if (0 < $download) {
            if (!Labels::updateDataToFile($langId, $langCode, Labels::TYPE_APP)) {
                FatUtility::dieJsonError(Labels::getLabel('MSG_Unable_to_update_file', $langId));
            }
            $fileName = $langCode . '.json';
            $filePath = Labels::JSON_FILE_DIR_NAME . '/' . Labels::TYPE_APP . '/' . $fileName;

            AttachedFile::downloadAttachment($filePath, $fileName);
            exit;
        }

        $data = array(
            'languageCode' => $langCode,
            'downloadUrl' => CommonHelper::generateFullUrl('Home', 'languageLabels', array(1, $langId)),
            'langLabelUpdatedAt' => FatApp::getConfig('CONF_LANG_LABELS_UPDATED_AT', FatUtility::VAR_INT, time())
        );

        $this->set('data', $data);
        $this->_template->render();
    }

    public function setCurrentLocation()
    {
        $post = FatApp::getPostedData();

        $countryCode = $post['country'];
        $this->updateSettingByCurrentLocation($countryCode);

        if (!$_SESSION['geo_location']) {
            Message::addErrorMessage(Labels::getLabel('MSG_Current_Location', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $this->set('msg', Labels::getLabel('MSG_Settings_with_your_current_location_setup_successful', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function updateSettingByCurrentLocation($countryCode = '')
    {
        if (!$countryCode) {
            return;
        }

        $row = Countries::getCountryByCode($countryCode, array('country_code', 'country_id', 'country_currency_id', 'country_language_id'));
        if ($row == false) {
            return false;
        }
        $_SESSION['geo_location'] = true;
        $this->setCurrency($row['country_currency_id']);
        $this->setLanguage($row['country_language_id']);
    }

    public function affiliateReferral($referralCode)
    {
        $userSrchObj = User::getSearchObject();
        $userSrchObj->doNotCalculateRecords();
        $userSrchObj->doNotLimitRecords();
        $userSrchObj->addCondition('user_referral_code', '=', $referralCode);
        $userSrchObj->addMultipleFields(array('user_id', 'user_referral_code'));
        $rs = $userSrchObj->getResultSet();
        $row = FatApp::getDb()->fetch($rs);

        if ($row && $referralCode != '' && $row['user_referral_code'] == $referralCode) {
            $cookieExpiryDays = FatApp::getConfig("CONF_AFFILIATE_REFERRER_URL_VALIDITY", FatUtility::VAR_INT, 5);

            $cookieValue = array('data' => $row['user_referral_code'], 'creation_time' => time());
            $cookieValue = serialize($cookieValue);
            CommonHelper::setCookie('affiliate_referrer_code_signup', $cookieValue, time() + 3600 * 24 * $cookieExpiryDays);
        }
        FatApp::redirectUser(CommonHelper::generateUrl());
    }

    public function referral($userReferralCode)
    {
        $userSrchObj = User::getSearchObject();
        $userSrchObj->doNotCalculateRecords();
        $userSrchObj->doNotLimitRecords();
        $userSrchObj->addCondition('user_referral_code', '=', $userReferralCode);
        $userSrchObj->addMultipleFields(array('user_id', 'user_referral_code'));
        $rs = $userSrchObj->getResultSet();
        $row = FatApp::getDb()->fetch($rs);

        if ($row && $userReferralCode != '' && $row['user_referral_code'] == $userReferralCode) {
            $cookieExpiryDays = FatApp::getConfig("CONF_REFERRER_URL_VALIDITY", FatUtility::VAR_INT, 10);

            $cookieValue = array('data' => $row['user_referral_code'], 'creation_time' => time());
            $cookieValue = serialize($cookieValue);

            CommonHelper::setCookie('referrer_code_signup', $cookieValue, time() + 3600 * 24 * $cookieExpiryDays);
            CommonHelper::setCookie('referrer_code_checkout', $row['user_referral_code'], time() + 3600 * 24 * $cookieExpiryDays);
        }
        FatApp::redirectUser(CommonHelper::generateUrl());
    }

    private function getCollections()
    {
        $collectionCache = FatCache::get('collectionCache_' . $this->siteLangId . '_' . FatUtility::int(API_CALL), CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if ($collectionCache) {
            return unserialize($collectionCache);
        }

        $collections = array();
        $db = FatApp::getDb();
        $srch = new CollectionSearch($this->siteLangId);
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addOrder('collection_display_order', 'ASC');
        $srch->addMultipleFields(array('collection_id', 'IFNULL(collection_name,collection_identifier) as collection_name', 'IFNULL( collection_description, "" ) as collection_description', 'IFNULL(collection_link_caption, "") as collection_link_caption', 'collection_link_url', 'collection_layout_type', 'collection_type', 'collection_criteria', 'collection_child_records', 'collection_primary_records', 'collection_display_media_only', 'collection_for_app', 'collection_for_web'));
        $applicableForCol = (API_CALL) ? 'collection_for_app' : 'collection_for_web';
        $srch->addCondition($applicableForCol, '=', AppConstants::YES);
        $collectionsArr = $db->fetchAll($srch->getResultSet(), 'collection_id');
        
        if (empty($collectionsArr)) {
            return [];
        }

        $productCollections = [];
        foreach ($collectionsArr as $id => $collection) {
            if ($collection['collection_type'] == Collections::COLLECTION_TYPE_PRODUCT) {
                $productCollections[$id] = $collection;
                unset($collectionsArr[$id]);
            }
        }

        /** Optimized the query to fetch product collections */
        $collections = $this->fetchProductCollections($productCollections);

        $i = 0;
        foreach ($collectionsArr as $collection_id => $collection) {
            if (!$collection['collection_primary_records']) {
                continue;
            }

            if (API_CALL && 0 < $collection['collection_display_media_only'] && !in_array($collection['collection_type'], Collections::COLLECTION_WITHOUT_MEDIA)) {
                $imgUpdatedOn = Collections::getAttributesById($collection_id, 'collection_img_updated_on');
                $uploadedTime = AttachedFile::setTimeParam($imgUpdatedOn);

                $collection['collection_image'] = FatCache::getCachedUrl(CommonHelper::generateFullFileUrl('image', 'collectionReal', array($collection_id, $this->siteLangId, 'ORIGINAL', AttachedFile::FILETYPE_COLLECTION_IMAGE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                $collections[] = $collection;
                $i++;
                continue;
            }

            switch ($collection['collection_type']) {
                case Collections::COLLECTION_TYPE_CATEGORY:
                    
                    $tempObj = new CollectionSearch();
                    $tempObj->addCondition('collection_id', '=', $collection_id);
                    $tempObj->joinCollectionCategories($this->siteLangId);
                    $tempObj->addMultipleFields(array('ctpc_prodcat_id'));
                    $tempObj->addCondition('ctpc_prodcat_id', '!=', 'NULL');
                    $tempObj->setPageSize($collection['collection_primary_records']);
                    $rs = $tempObj->getResultSet();
                    if (!$categoryIds = $db->fetchAll($rs, 'ctpc_prodcat_id')) {
                        continue 2;
                    }

                    $productCatSrchObj = ProductCategory::getSearchObject(false, $this->siteLangId);
                    $productCatSrchObj->doNotCalculateRecords();
                    $productCatSrchObj->addMultipleFields(array('prodcat_id', 'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name', 'prodcat_description'));

                    /* fetch Categories data[ */
                    $productCatSrchTempObj = clone $productCatSrchObj;
                    $productCatSrchTempObj->addCondition('prodcat_id', 'IN', array_keys($categoryIds));
                    $productCatSrchTempObj->addCondition('prodcat_deleted', '=', AppConstants::NO);
                    $rs = $productCatSrchTempObj->getResultSet();
                    /* ] */
                    if (API_CALL) {
                        $collections[$i] = $collection;
                    } else {
                        $collections[$collection['collection_layout_type']][$collection['collection_id']] = $collection;
                    }
                    $counter = 0;
                    if ($collection['collection_layout_type'] == Collections::TYPE_CATEGORY_LAYOUT2) {
                        while ($catData = $db->fetch($rs)) {
                            /* fetch Sub-Categories[ */
                            $subCategorySrch = clone $productCatSrchObj;
                            $subCategorySrch->addCondition('prodcat_parent', '=', $catData['prodcat_id']);
                            $subCategorySrch->addCondition('prodcat_deleted', '=', AppConstants::NO);
                            $Catrs = $subCategorySrch->getResultSet();

                            if (API_CALL) {
                                $collections[$i]['categories'][$counter] = $catData;
                                // $collections[$i]['categories'][$counter]['subCategories'] = $db->fetchAll($Catrs);
                            } else {
                                $collections[$collection['collection_layout_type']][$collection['collection_id']]['categories'][$catData['prodcat_id']] = $catData;
                                $collections[$collection['collection_layout_type']][$collection['collection_id']]['categories'][$catData['prodcat_id']]['subCategories'] = $db->fetchAll($Catrs);
                            }
                            /* ] */
                            $counter++;
                        }
                    } else {
                        while ($catData = $db->fetch($rs)) {
                            if (API_CALL) {
                                $collections[$i]['categories'][$counter] = $catData;
                                // $collections[$i]['categories'][$counter]['products'] = $db->fetchAll($Prs);
                            } else {
                                $collections[$collection['collection_layout_type']][$collection['collection_id']]['categories'][$catData['prodcat_id']]['catData'] = $catData;
                            }
                            /* ] */
                            $counter++;
                        }
                    }
                    if (API_CALL) {
                        $collections[$i]['totCategories'] = $tempObj->recordCount();
                    } else {
                        $collections[$collection['collection_layout_type']][$collection['collection_id']]['totCategories'] = $tempObj->recordCount();
                    }
                    unset($tempObj);
                    break;
                case Collections::COLLECTION_TYPE_SHOP:
                    $tempObj = new CollectionSearch();
                    $tempObj->addCondition('collection_id', '=', $collection_id);
                    $tempObj->joinCollectionShops();
                    $tempObj->addMultipleFields(array('ctps_shop_id'));
                    $tempObj->addCondition('ctps_shop_id', '!=', 'NULL');
                    // $tempObj->setPageSize( $collection['collection_primary_records'] );
                    $rs = $tempObj->getResultSet();

                    if (!$shopIds = $db->fetchAll($rs, 'ctps_shop_id')) {
                        continue 2;
                    }

                    $shopObj = new ShopSearch($this->siteLangId);
                    $shopObj->setDefinedCriteria($this->siteLangId);
                    $shopObj->joinSellerSubscription();

                    $subFld = [];
                    if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
                        $subFld = array('spplan_spackage_id as subscription_package_id');
                    }

                    $shopObj->addCondition('shop_id', 'IN', array_keys($shopIds));
                    if (false === API_CALL) {
                        $shopObj->setPageSize($collection['collection_primary_records']);
                    }

                    $genFlds = array('shop_id', 'shop_user_id', 'IFNULL(shop_name, shop_identifier) as shop_name',
                        'IFNULL(country_name, country_code) as country_name',
                        'IFNULL(state_name, state_identifier) as state_name', 'user_is_verified as seller_verified',
                        'user_is_founding_member as is_founding_member');

                    $flds = array_merge($genFlds, $subFld);

                    $shopObj->addMultipleFields($flds);
                    //echo $shopObj->getQuery(); die();
                    $rs = $shopObj->getResultSet();

                    if (API_CALL) {
                        $collections[$i] = $collection;
                        $collections[$i]['totShops'] = $shopObj->recordCount();
                    } else {
                        $collections[$collection['collection_layout_type']][$collection['collection_id']] = $collection;
                        $collections[$collection['collection_layout_type']][$collection['collection_id']]['totShops'] = $shopObj->recordCount();
                    }

                    $counter = 0;
                    while ($shopsData = $db->fetch($rs)) {
                        $rating = 0;
                        if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
                            $rating = SelProdRating::getSellerRating($shopsData['shop_user_id']);
                        }

						$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shopsData['shop_user_id'], array('spackage_id'));
						/* $currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']); */
                        $currentActivePackageId = isset($currentPlanData['spackage_id'])?FatUtility::int($currentPlanData['spackage_id']):0;
						if ($currentActivePackageId > 0) {
							$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
						}


						$sellerProfileData = shopProfile::getSellerProfileData($shopsData['shop_user_id'], $this->siteLangId);
						$sellerType = (isset($sellerProfileData['sprofile_seller_type'])) ? $sellerProfileData['sprofile_seller_type'] : 0;


                        if (API_CALL) {
                            $collections[$i]['shops'][$counter] = $shopsData;

                            $collections[$i]['shops'][$counter]['rating'] = $rating;
							$collections[$i]['shops'][$counter]['shopData']['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
							$collections[$i]['shops'][$counter]['shopData']['subscription_package_id'] = $currentActivePackageId;
							$collections[$i]['shops'][$counter]['shopData']['seller_type'] = $sellerType;
														
                        } else {
                            $collections[$collection['collection_layout_type']][$collection['collection_id']]['shops'][$shopsData['shop_id']]['shopData'] = $shopsData;

                            $collections[$collection['collection_layout_type']][$collection['collection_id']]['rating'][$shopsData['shop_id']] = $rating;
							$collections[$collection['collection_layout_type']][$collection['collection_id']]['shops'][$shopsData['shop_id']]['shopData']['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
							$collections[$collection['collection_layout_type']][$collection['collection_id']]['shops'][$shopsData['shop_id']]['shopData']['subscription_package_id'] = $currentActivePackageId;
							$collections[$collection['collection_layout_type']][$collection['collection_id']]['shops'][$shopsData['shop_id']]['shopData']['seller_type'] = $sellerType;
                        }
                        $counter++;
                    }
                    unset($tempObj);
                    break;
                case Collections::COLLECTION_TYPE_BRAND:
                    $tempObj = new CollectionSearch();
                    $tempObj->addCondition('collection_id', '=', $collection_id);
                    $tempObj->joinCollectionBrands($this->siteLangId);
                    $tempObj->addMultipleFields(array('ctpb_brand_id'));
                    $tempObj->addCondition('ctpb_brand_id', '!=', 'NULL');
                    $rs = $tempObj->getResultSet();
                    $brandIds = $db->fetchAll($rs, 'ctpb_brand_id');

                    if (empty($brandIds)) {
                        continue 2;
                    }

                    /* fetch Brand data[ */
                    $brandSearchObj = Brand::getSearchObject($this->siteLangId, true, true);
                    $brandSearchTempObj = clone $brandSearchObj;
                    $brandSearchTempObj->addMultipleFields(array('brand_id', 'IFNULL(brand_name, brand_identifier) as brand_name'));
                    $brandSearchTempObj->addCondition('brand_id', 'IN', array_keys($brandIds));
                    if (false === API_CALL) {
                        $brandSearchTempObj->setPageSize($collection['collection_primary_records']);
                    }
                    $rs = $brandSearchTempObj->getResultSet();
                    /* ] */
                    if (API_CALL) {
                        $collections[$i] = $collection;
                        $collections[$i]['totBrands'] = $brandSearchTempObj->recordCount();
                        $collections[$i]['brands'] = $db->fetchAll($rs);
                    } else {
                        $collections[$collection['collection_layout_type']][$collection['collection_id']] = $collection;
                        $collections[$collection['collection_layout_type']][$collection['collection_id']]['totBrands'] = $brandSearchTempObj->recordCount();
                        $collections[$collection['collection_layout_type']][$collection['collection_id']]['brands'] = $db->fetchAll($rs);
                    }

                    unset($brandSearchTempObj);
                    unset($tempObj);
                    break;
            }
            $i++;
        }

        FatCache::set('collectionCache_' . $this->siteLangId . '_' . FatUtility::int(API_CALL), serialize($collections), '.txt');
        return $collections;
    }


    private function fetchProductCollections($collections)
    {
        $db = FatApp::getDb();
        $recordsCount = array_sum(array_column($collections, 'collection_primary_records'));
        $collectionIds = array_column($collections, 'collection_id');
        if (!$recordsCount) {
            return [];
        }

        $tempObj = new CollectionSearch();
        $tempObj->joinCollectionProducts();
        $tempObj->addDirectCondition('collection_id IN (' . implode(',', $collectionIds) . ')');
        $tempObj->addMultipleFields(array('ctsp_selprod_id', 'collection_id', 'collection_criteria', 'collection_layout_type'));
        $tempObj->addCondition('ctsp_selprod_id', '!=', 'NULL');
        $tempObj->doNotCalculateRecords();
        if (empty($collectionProducts = $db->fetchAll($tempObj->getResultSet()))) {
            return [];
        }

        $loggedUserId = UserAuthentication::getLoggedUserId(true);
        $productSrchTempObj = $this->getProductSearchObj($loggedUserId);
        $products = [];

        $productIds = array_unique(array_filter(array_column($collectionProducts, 'ctsp_selprod_id')));
        $recordsCount = (is_array($productIds) && !empty($productIds)) ? count($productIds) : 0;
        if ($recordsCount > 0) {
            $productSrchTempObj->addDirectCondition('selprod_id IN (' . implode(',', $productIds) . ')');
            $productSrchTempObj->addCondition('selprod_deleted', '=', AppConstants::NO);
            $productSrchTempObj->joinSellers();
            $productSrchTempObj->joinSellerSubscription($this->siteLangId);
            $productSrchTempObj->addGroupBy('selprod_id');
            $productSrchTempObj->setPageSize($recordsCount);
            $products = $db->fetchAll($productSrchTempObj->getResultSet(), 'selprod_id');
        }

        $collectionsarray = [];
        $groupProducts = [];
        foreach ($collectionProducts as $item) {
            $groupProducts[$item['collection_id']]['products'][] = $item['ctsp_selprod_id'];
            $groupProducts[$item['collection_id']]['collection_layout_type'] = $item['collection_layout_type'];
            $groupProducts[$item['collection_id']]['collection_criteria'] = $item['collection_criteria'];
        }

		if (0 < count($products)) {
			foreach($products as $prodKey=>$prods) {
				$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $prods['selprod_user_id'], array('spackage_id'));
				$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
				$products[$prodKey]['subscription_package_id'] =  $currentActivePackageId;
				if ($currentActivePackageId > 0) {
					$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
					$products[$prodKey]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
				}
				$sellerProfileData = shopProfile::getSellerProfileData($prods['selprod_user_id'], $this->siteLangId);
				$sellerType = (isset($sellerProfileData['sprofile_seller_type'])) ? $sellerProfileData['sprofile_seller_type'] : 0;
				$products[$prodKey]['seller_type'] = $sellerType;
				
			}
		}

        foreach ($groupProducts as $collectionId => $productData) {
            $collectionsarray[$productData['collection_layout_type']][$collectionId] = $collections[$collectionId];
            $collectionsarray[$productData['collection_layout_type']][$collectionId]['products'] = $this->formatCollectionProducts($productData['products'], $products, $productData['collection_criteria'], $collectionId);
            $collectionsarray[$productData['collection_layout_type']][$collectionId]['totProducts'] = count($collectionsarray[$productData['collection_layout_type']][$collectionId]['products']);
        }
        return $collectionsarray;
    }

    private function formatCollectionProducts($selprodIds, $products, $sortBy, $collectionId)
    {
        $data = [];
        foreach ($selprodIds as $id) {
            if (isset($products[$id])) {
                $data[] = $products[$id];
            }
        }
        //Either we do quries in loop or we can sort 10 or max 20 array items easily in php
        if ($sortBy == Collections::COLLECTION_CRITERIA_PRICE_HIGH_TO_LOW) {
            $price = array_column($data, 'theprice');
            array_multisort($price, SORT_DESC, $data);
        }

        if ($sortBy == Collections::COLLECTION_CRITERIA_PRICE_LOW_TO_HIGH) {
            $price = array_column($data, 'theprice');
            array_multisort($price, SORT_ASC, $data);
        }
        return $data;
    }
 
    private function getSlides()
    {
        $db = FatApp::getDb();
        $srchSlide = new SlideSearch($this->siteLangId);
        $srchSlide->doNotCalculateRecords();
        $srchSlide->joinPromotions($this->siteLangId, true, true, true);
        $srchSlide->addPromotionTypeCondition();
        $srchSlide->joinUserWallet();
        $srchSlide->joinActiveUser();
        $srchSlide->addSkipExpiredPromotionAndSlideCondition();
        $srchSlide->joinBudget();
        $srchSlide->joinAttachedFile();
        $srchSlide->addMultipleFields(array('slide_id', 'slide_record_id', 'slide_type', 'IFNULL(promotion_name, promotion_identifier) as promotion_name,IFNULL(slide_title, slide_identifier) as slide_title', 'slide_target', 'slide_url', 'promotion_id', 'daily_cost', 'weekly_cost', 'monthly_cost', 'total_cost', 'slide_img_updated_on'));
        $srchSlide->addOrder('slide_display_order', 'ASC');
        $totalSlidesPageSize = FatApp::getConfig('CONF_TOTAL_SLIDES_HOME_PAGE', FatUtility::VAR_INT, 4);
        $slidesSrch = new SearchBase('(' . $srchSlide->getQuery() . ') as t');
        $slidesSrch->addMultipleFields(array('slide_id', 'slide_type', 'slide_record_id', 'slide_url', 'slide_target', 'slide_title', 'promotion_id', 'userBalance', 'daily_cost', 'weekly_cost', 'monthly_cost', 'total_cost', 'promotion_budget', 'promotion_duration', 'slide_img_updated_on'));
        
        $slidesSrch->doNotCalculateRecords();
        
            $ppcSrch = clone $slidesSrch;
            $ppcSrch->addDirectCondition(
                    '((CASE
					WHEN promotion_duration=' . Promotion::DAILY . ' THEN promotion_budget > COALESCE(daily_cost,0)
					WHEN promotion_duration=' . Promotion::WEEKLY . ' THEN promotion_budget > COALESCE(weekly_cost,0)
					WHEN promotion_duration=' . Promotion::MONTHLY . ' THEN promotion_budget > COALESCE(monthly_cost,0)
					WHEN promotion_duration=' . Promotion::DURATION_NOT_AVAILABALE . ' THEN promotion_budget = -1
				  END ) )'
            );
        $ppcSrch->addCondition('slide_type', 'IN', [Slides::TYPE_PPC, Slides::TYPE_SLIDE]);
        $ppcSrch->setPageSize($totalSlidesPageSize);
            $ppcSrch->doNotCalculateRecords();
            $ppcRs = $ppcSrch->getResultSet();
        $slides = $db->fetchAll($ppcRs, 'slide_id');
      
        return $slides;
    }

    private function getBanners()
    {
        $pageSize = 0;
        $bannerLocationTypes = [BannerLocation::HOME_PAGE_TOP_BANNER, BannerLocation::HOME_PAGE_BOTTOM_BANNER];
        if (API_CALL) {
            $pageSize = BannerLocation::MOBILE_API_BANNER_PAGESIZE;
            $bannerLocationTypes = [BannerLocation::HOME_PAGE_TOP_BANNER, BannerLocation::HOME_PAGE_BOTTOM_BANNER, BannerLocation::HOME_PAGE_MIDDLE_BANNER];
        }
        $banners = BannerLocation::getPromotionalBanners($bannerLocationTypes, $this->siteLangId, $pageSize);
        return $banners;
    }

    private function getSponsoredShops($productSrchObj)
    {
        $shopPageSize = FatApp::getConfig('CONF_PPC_SHOPS_HOME_PAGE', FatUtility::VAR_INT, 2);
        if (1 > $shopPageSize) {
            return array();
        }

        $sponsoredShops = array();
        $db = FatApp::getDb();

        $shopObj = new PromotionSearch($this->siteLangId);
        $shopObj->setDefinedCriteria();
        $shopObj->joinActiveUser();
        $shopObj->joinShops($this->siteLangId, true, true);
        $shopObj->joinShopCountry();
        $shopObj->joinShopState();
        $shopObj->addPromotionTypeCondition(Promotion::TYPE_SHOP);
        $shopObj->addShopActiveExpiredCondition();
        $shopObj->joinUserWallet();
        $shopObj->joinBudget();
        $shopObj->addBudgetCondition();
        $shopObj->addOrder('', 'rand()');
        $shopObj->setPageSize($shopPageSize);
        $shopObj->doNotCalculateRecords();
        $rs = $shopObj->getResultSet();
        $i = 0;

        while ($shops = $db->fetch($rs)) {
            /* fetch Shop data[ */
            $shops['is_founding_member'] = $shops['user_is_founding_member'];
            $shops['seller_verified'] = $shops['user_is_verified'];
            $shops['subscription_package_id'] = isset($shops['spplan_spackage_id'])?$shops['spplan_spackage_id']:0;

            unset($shops['user_is_founding_member']);
            unset($shops['user_is_verified']);
            if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
                unset($shops['spplan_spackage_id']);
            }


            $productShopSrchTempObj = clone $productSrchObj;

            if (API_CALL) {
                $productShopSrchTempObj->joinProductRating();
                $productShopSrchTempObj->addFld('IFNULL(prod_rating, 0) as prod_rating');
            }

            $productShopSrchTempObj->addCondition('selprod_user_id', '=', $shops['shop_user_id']);
            $productShopSrchTempObj->addGroupBy('selprod_product_id');
            $productShopSrchTempObj->doNotCalculateRecords();
            $productShopSrchTempObj->setPageSize(Shop::SHOP_PRODUCTS_COUNT_AT_HOMEPAGE);
            $Prs = $productShopSrchTempObj->getResultSet();

            $rating = 0;
            if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
                $rating = SelProdRating::getSellerRating($shops['shop_user_id']);
            }

            if (API_CALL) {
                $sponsoredShops[$i]['shopData'] = $shops;
                $sponsoredShops[$i]['shopData']['promotion_id'] = $shops['promotion_id'];
                $sponsoredShops[$i]['shopData']['rating'] = $rating;
                $sponsoredShops[$i]['shopData']['shop_logo'] = CommonHelper::generateFullFileUrl('image', 'shopLogo', array($shops['shop_id'], $this->siteLangId));
                $sponsoredShops[$i]['shopData']['shop_banner'] = CommonHelper::generateFullFileUrl('image', 'shopBanner', array($shops['shop_id'], $this->siteLangId));
                $sponsoredShops[$i]['products'] = $db->fetchAll($Prs);
            } else {
                $sponsoredShops['shops'][$shops['shop_id']]['shopData'] = $shops;
                $sponsoredShops['shops'][$shops['shop_id']]['shopData']['promotion_id'] = $shops['promotion_id'];

                $sponsoredShops['rating'][$shops['shop_id']] = $rating;
                $sponsoredShops['shops'][$shops['shop_id']]['products'] = $db->fetchAll($Prs);
            }
            /* ] */
            $i++;
        }
        return $sponsoredShops;
    }

    private function getSponsoredProductsObj($productSrchObj)
    {
        $prodObj = new PromotionSearch($this->siteLangId);
        $prodObj->joinProducts();
        $prodObj->joinShops();
        $prodObj->addPromotionTypeCondition(Promotion::TYPE_PRODUCT);
        $prodObj->joinActiveUser();
        $prodObj->setDefinedCriteria();
        $prodObj->addShopActiveExpiredCondition();
        $prodObj->joinUserWallet();
        $prodObj->joinBudget();
        $prodObj->addBudgetCondition();
        $prodObj->doNotCalculateRecords();
        $prodObj->addMultipleFields(array('selprod_id as proSelProdId', 'promotion_id', 'promotion_record_id'));

        $productSrchSponObj = clone $productSrchObj;
        $productSrchSponObj->joinTable('(' . $prodObj->getQuery() . ') ', 'INNER JOIN', 'selprod_id = ppr.proSelProdId ', 'ppr');
        $productSrchSponObj->addFld(array('promotion_id', 'promotion_record_id')); 
        $productSrchSponObj->joinSellers();
        $productSrchSponObj->joinSellerSubscription($this->siteLangId);
        $productSrchSponObj->addGroupBy('selprod_id');
        $productSrchSponObj->addOrder('', 'rand()');
        return $productSrchSponObj;
    }

    // For Home Page
    private function getSponsoredProducts($productSrchObj)
    {
        $productPageSize = (API_CALL) ? 4 : FatApp::getConfig('CONF_PPC_PRODUCTS_HOME_PAGE', FatUtility::VAR_INT, 6);

        if (1 > $productPageSize) {
            return array();
        }

        $db = FatApp::getDb();
        $productSrchSponObj = $this->getSponsoredProductsObj($productSrchObj);
        if (API_CALL) {
            $productSrchSponObj->joinProductRating();
            $productSrchSponObj->addFld('IFNULL(prod_rating, 0) as prod_rating');
        }
        $productSrchSponObj->doNotCalculateRecords();
        $productSrchSponObj->setPageSize($productPageSize);
        $rs = $productSrchSponObj->getResultSet();
        return $db->fetchAll($rs);
    }

    // Used for APP
    public function getAllSponsoredProducts()
    {
        $loggedUserId = UserAuthentication::getLoggedUserId(true);

        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $page = ($page < 2) ? 1 : $page;

        $pagesize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);

        $productSrchObj = $this->getProductSearchObj($loggedUserId);

        $productSrchSponObj = $this->getSponsoredProductsObj($productSrchObj);
        $productSrchSponObj->joinProductRating();
        $productSrchSponObj->addFld('IFNULL(prod_rating, 0) as prod_rating');
        $productSrchSponObj->setPageNumber($page);
        $productSrchSponObj->setPageSize($pagesize);

        $rs = $productSrchSponObj->getResultSet();
        $sponsoredProds = FatApp::getDb()->fetchAll($rs);

        $this->set('sponsoredProds', $sponsoredProds);
        $this->set('page', $page);
        $this->set('pageCount', $productSrchSponObj->pages());
        $this->set('recordCount', $productSrchSponObj->recordCount());
        $this->set('postedData', FatApp::getPostedData());
        $this->_template->render();
    }

    public function getImage()
    {
        $post = FatApp::getPostedData();
        if (1 > count($post)) {
            $message = Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $type = FatApp::getPostedData('type', null, '');
        if (empty($type)) {
            $message = Labels::getLabel('MSG_Type_is_mandatory', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $image_url = "";
        switch (strtoupper($type)) {
            case 'PRODUCT_PRIMARY':
                $product_id = FatApp::getPostedData('product_id', null, 0);
                $seller_product_id = FatApp::getPostedData('seller_product_id', null, 0);
                if (1 > $product_id || 1 > $seller_product_id) {
                    $message = Labels::getLabel('MSG_Product_id_&_Seller_product_id_is_mandatory.', $this->siteLangId);
                    FatUtility::dieJsonError($message);
                }
                $image_url = CommonHelper::generateFullFileUrl('image', 'product', array($product_id, "MEDIUM", $seller_product_id, 0, $this->siteLangId));
                break;
            case 'SLIDE':
                $slide_id = FatApp::getPostedData('slide_id', null, 0);
                if (1 > $slide_id) {
                    $message = Labels::getLabel('MSG_Slide_id_is_mandatory.', $this->siteLangId);
                    FatUtility::dieJsonError($message);
                }
                $image_url = CommonHelper::generateFullFileUrl('image', 'slide', array($slide_id, 0, $this->siteLangId));
                break;
            case 'BANNER':
                $banner_id = FatApp::getPostedData('banner_id', null, 0);
                if (1 > $banner_id) {
                    $message = Labels::getLabel('MSG_Banner_id_is_mandatory.', $this->siteLangId);
                    FatUtility::dieJsonError($message);
                }
                $image_url = CommonHelper::generateFullFileUrl('Banner', 'HomePageAfterFirstLayout', array($banner_id, $this->siteLangId));
                break;
        }
        $this->set('image_url', $image_url);
        $this->_template->render();
    }

    public function countries()
    {
        $countryObj = new Countries();
        $countriesArr = $countryObj->getCountriesArr($this->siteLangId);
        $arr_country = array();
        foreach ($countriesArr as $key => $val) {
            $arr_country[] = array("id" => $key, 'name' => $val);
        }
        $this->set('countries', $arr_country);
        $this->_template->render();
    }

    public function states($countryId)
    {
        $countryId = FatUtility::int($countryId);
        if (1 > $countryId) {
            $message = Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $statesArr = $this->getStates($countryId, 0, true);
        $states = array();
        foreach ($statesArr as $key => $val) {
            $states[] = array("id" => $key, 'name' => $val);
        }
        $this->set('states', $states);
        $this->_template->render();
    }

    public function splashScreenData()
    {
        $langCode = Language::getAttributesById($this->siteLangId, 'language_code', false);

        $data['languageLabels'] = [
            'language_code' => $langCode,
            'language_layout_direction' => Language::getLayoutDirection($this->siteLangId),
            'downloadUrl' => CommonHelper::generateFullUrl('Home', 'languageLabels', array(1, $this->siteLangId)),
            'langLabelUpdatedAt' => FatApp::getConfig('CONF_LANG_LABELS_UPDATED_AT', FatUtility::VAR_INT, time())
        ];

        $data['appThemeSetting'] = [
            'primaryThemeColor' => FatApp::getConfig('CONF_PRIMARY_APP_THEME_COLOR', FatUtility::VAR_STRING, ''),
            'primaryInverseThemeColor' => FatApp::getConfig('CONF_PRIMARY_INVERSE_APP_THEME_COLOR', FatUtility::VAR_STRING, ''),
            'secondaryThemeColor' => FatApp::getConfig('CONF_SECONDARY_APP_THEME_COLOR', FatUtility::VAR_STRING, ''),
            'secondaryInverseThemeColor' => FatApp::getConfig('CONF_SECONDARY_INVERSE_APP_THEME_COLOR', FatUtility::VAR_STRING, ''),
        ];

        $data['isWishlistEnable'] = FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1);
        $data['canSendSms'] = SmsArchive::canSendSms() ? 1 : 0;
        $data['canAddReview'] = FatApp::getConfig('CONF_ALLOW_REVIEWS', FatUtility::VAR_INT, 1);
        $this->set('data', $data);
        $this->_template->render();
    }

    public function getUrlSegmentsDetail()
    {
        $url = FatApp::getPostedData('url', FatUtility::VAR_STRING, '');
        if (empty($url)) {
            LibHelper::dieJsonError(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
        }
        $detail = CommonHelper::getUrlTypeData($url);
        $this->set('data', ['urlSegmentsDetail' => $detail]);
        $this->_template->render();
    }

    public function pwaManifest()
    {
        $manifestFile = CONF_UPLOADS_PATH . '/manifest-' . $this->siteLangId . '.json';
        if (!file_exists($manifestFile)) {
            $iconsArr = [36, 48, 57, 60, 70, 72, 76, 96, 114, 120, 144, 192, 152, 180, 150, 310, 512];
            $arr = array(
                "display" => FatApp::getConfig('CONFIG_PWA_DISPLAY', FatUtility::VAR_STRING, "standalone"),
                "name" => FatApp::getConfig('CONFIG_PWA_NAME', FatUtility::VAR_STRING, ""),
                "short_name" => FatApp::getConfig('CONFIG_PWA_SHORT_NAME', FatUtility::VAR_STRING, ""),
                "description" => FatApp::getConfig('CONFIG_PWA_DESCRIPTION', FatUtility::VAR_STRING, ""),
                "lang" => $this->siteLangCode,
                "start_url" => FatApp::getConfig('CONFIG_PWA_START_URL', FatUtility::VAR_STRING, "/"),
                "scope" => '/',
                "background_color" => FatApp::getConfig('CONFIG_PWA_BACKGROUND_COLOR', FatUtility::VAR_STRING, "#ffffff"),
                "theme_color" => FatApp::getConfig('CONFIG_PWA_THME_COLOR', FatUtility::VAR_STRING, "#a91352"),
                "orientation"=>FatApp::getConfig('CONFIG_PWA_ORIENTATION', FatUtility::VAR_STRING, "portrait")
            );
            $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_PWA_APP_ICON,0);
            $uploadedTime = AttachedFile::setTimeParam($file_row['afile_updated_at']);
            foreach ($iconsArr as $key => $val) {
                $iconUrl = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('Image', 'appleTouchIcon', array($this->siteLangId, $val . '-' . $val)), CONF_IMG_CACHE_TIME, '.png').$uploadedTime;
                $icons = [
                    'src' => $iconUrl,
                    'sizes' => $val . 'x' . $val,
                    'type' => 'image/png'
                ];
                $arr['icons'][] = $icons;
            }
            file_put_contents($manifestFile, FatUtility::convertToJson($arr, JSON_UNESCAPED_UNICODE));
       }
        echo file_get_contents($manifestFile);
        exit;
    }

}
