<?php

require CONF_INSTALLATION_PATH . 'library/payment-plugins/PayuLatam/PayU.php';

class PayuLatamPayController extends PaymentController
{

    private $keyName = "PayuLatam";
    private $testEnvironmentUrl = 'https://sandbox.checkout.payulatam.com/ppp-web-gateway-payu/';
    private $liveEnvironmentUrl = 'https://checkout.payulatam.com/ppp-web-gateway-payu/';

    protected function allowedCurrenciesArr()
    {
        return [
            'ARS', 'BRL', 'CLP', 'COP', 'MXN', 'PEN', 'USD'
        ];
    }

    public function charge($orderId)
    {
        $pmObj = new PaymentSettings($this->keyName);
        if (!$paymentSettings = $pmObj->getPaymentSettings()) {
            Message::addErrorMessage($pmObj->getError());
            CommonHelper::redirectUserReferer();
        }

        $orderPaymentObj = new OrderPayment($orderId, $this->siteLangId);
        $paymentAmount = $orderPaymentObj->getOrderPaymentGatewayAmount();
        $orderInfo = $orderPaymentObj->getOrderPrimaryinfo();
        
        if ($orderInfo['order_type'] == Orders::ORDER_WALLET_RECHARGE) {
            $paymentGatewayChargeCop = number_format($orderInfo['order_net_amount_cop'], 2, '.', '');
        } else {
            $paymentGatewayChargeCop = number_format($paymentAmount * $orderInfo['order_default_currency_to_cop'], 2, '.', ''); 
        }
        
        if (substr($paymentGatewayChargeCop, '.00')) {
            $paymentGatewayChargeCop = number_format(rtrim($paymentGatewayChargeCop, '0'), 1, '.', '');
        } else {
            $paymentGatewayChargeCop = $this->cleanNumber($paymentGatewayChargeCop);
        }
        
        if (!$orderInfo['id']) {
            FatUtility::exitWIthErrorCode(404);
        } //elseif ($orderInfo["order_is_paid"] == Orders::ORDER_IS_PENDING) {
        elseif (in_array($orderInfo["order_is_paid"], Orders::getUnpaidStatus())) {
            $frm = $this->getPaymentForm($orderId);
            $this->set('frm', $frm);
            $this->set('paymentAmount', $paymentAmount);
            $this->set('paymentAmountCop', $paymentGatewayChargeCop);
            $this->set('orderCurrency', $orderInfo['order_currency_code']);
        } else {
            $this->set('error', Labels::getLabel('MSG_INVALID_ORDER_PAID_CANCELLED', $this->siteLangId));
        }

        $cancelBtnUrl = CommonHelper::getPaymentCancelPageUrl($orderId);
        if ($orderInfo['order_type'] == Orders::ORDER_WALLET_RECHARGE) {
            $cancelBtnUrl = CommonHelper::getPaymentFailurePageUrl();
        }

        $this->set('cancelBtnUrl', $cancelBtnUrl);
        $this->set('orderInfo', $orderInfo);
        $this->set('paymentAmount', $paymentAmount);
        $this->set('exculdeMainHeaderDiv', true);
        $this->_template->render(true, false);
    }

    public function checkCardType()
    {
        $post = FatApp::getPostedData();
        $res = ValidateElement::ccNumber($post['cc']);
        echo json_encode($res);
        exit;
    }

    private function getPaymentForm($orderId = '')
    {
        $pmObj = new PaymentSettings($this->keyName);
        $paymentSettings = $pmObj->getPaymentSettings();

        $orderPaymentObj = new OrderPayment($orderId, $this->siteLangId);
        $paymentGatewayCharge = $orderPaymentObj->getOrderPaymentGatewayAmount();
        $orderInfo = $orderPaymentObj->getOrderPrimaryinfo();
        //echo '<pre>'; print_r($orderInfo); echo '</pre>'; exit;

        /*if ($orderInfo['order_type'] == Orders::ORDER_WALLET_RECHARGE) {
            $paymentGatewayCharge = number_format($orderInfo['order_net_amount_cop'], 2, '.', '');
        } else {
            $paymentGatewayCharge = number_format($paymentGatewayCharge * $orderInfo['order_default_currency_to_cop'], 2, '.', '');
        }*/
        
        if (substr($paymentGatewayCharge, '.00')) {
            $paymentGatewayCharge = number_format(rtrim($paymentGatewayCharge, '0'), 1, '.', '');
        } else {
            $paymentGatewayCharge = $this->cleanNumber($paymentGatewayCharge);
        }
        //echo $paymentGatewayCharge; die();

        $billingAddress = $orderInfo['customer_billing_name'] . ', ' . $orderInfo['customer_billing_phone'] . ' ' . $orderInfo['customer_billing_address_1'] . ' ' . $orderInfo['customer_billing_address_2'] . ' ' . $orderInfo['customer_billing_city'] . ' ' . $orderInfo['customer_billing_postcode'] . ' ' . $orderInfo['customer_billing_state'] . ' ' . $orderInfo['customer_billing_country'];
        $shippingAddress = $orderInfo['customer_shipping_name'] . ', ' . $orderInfo['customer_shipping_phone'] . ' ' . $orderInfo['customer_shipping_address_1'] . ' ' . $orderInfo['customer_shipping_address_2'] . ' ' . $orderInfo['customer_shipping_city'] . ' ' . $orderInfo['customer_shipping_postcode'] . ' ' . $orderInfo['customer_shipping_state'] . ' ' . $orderInfo['customer_shipping_country'];

        $signature = md5($paymentSettings['api_key'] . '~' . $paymentSettings['merchant_id'] . '~' . $orderId . '~' . $paymentGatewayCharge . '~' . $orderInfo["order_currency_code"]);
        //$signature = md5($paymentSettings['api_key'] . '~' . $paymentSettings['merchant_id'] . '~' . $orderId . '~' . $paymentGatewayCharge . '~' . "COP");
        $actionUrl = (FatApp::getConfig('CONF_TRANSACTION_MODE', FatUtility::VAR_BOOLEAN, false) == true) ? $this->liveEnvironmentUrl : $this->testEnvironmentUrl;
        $frm = new Form('frmPayuLatamPay', array('id' => 'frmPayuLatamPay', 'action' => $actionUrl));
        $frm->addHiddenField('', 'merchantId', $paymentSettings['merchant_id']);
        $frm->addHiddenField('', 'accountId', $paymentSettings['account_id']);
        $frm->addHiddenField('', 'description', $orderInfo['invoice']);
        $frm->addHiddenField('', 'referenceCode', $orderId); /* Order Id */
        $frm->addHiddenField('', 'amount', $paymentGatewayCharge); /* Order Total Amount to Pay */
        $frm->addHiddenField('', 'tax', "0");
        $frm->addHiddenField('', 'taxReturnBase', "0");
        $frm->addHiddenField('', 'currency', $orderInfo["order_currency_code"]);
        /* $frm->addHiddenField('', 'currency', "COP"); */
        $frm->addHiddenField('', 'signature', $signature);
        $frm->addHiddenField('', 'test', "0");
        $frm->addHiddenField('', 'buyerEmail', $orderInfo['customer_email']);
        $frm->addHiddenField('', 'responseUrl', CommonHelper::generateNoAuthUrl('PayuLatamPay', 'response'));
        $frm->addHiddenField('', 'confirmationUrl', CommonHelper::generateNoAuthUrl('PayuLatamPay', 'callback'));
        /* [ ADDITIONAL FIELDS (REQUIRED FOR COLOMBIAN PAYMENT METHODS) */
        $frm->addHiddenField('', 'lng', 'en');
        $frm->addHiddenField('', 'extra1', '');
        $frm->addHiddenField('', 'extra2', '');
        $frm->addHiddenField('', 'payerFullName', $orderInfo['customer_name']);
        $frm->addHiddenField('', 'payerDocument', '');
        $frm->addHiddenField('', 'mobilePhone', (empty($orderInfo['customer_phone'])) ? $orderInfo['customer_phone'] : $orderInfo['customer_billing_phone'] );
        $frm->addHiddenField('', 'billingAddress', $billingAddress);
        $frm->addHiddenField('', 'shippingAddress', $shippingAddress);
        $frm->addHiddenField('', 'telephone', (empty($orderInfo['customer_phone'])) ? $orderInfo['customer_phone'] : $orderInfo['customer_billing_phone']);
        $frm->addHiddenField('', 'officeTelephone', (empty($orderInfo['customer_phone'])) ? $orderInfo['customer_phone'] : $orderInfo['customer_billing_phone']);
        $frm->addHiddenField('', 'algorithmSignature', "MD5");
        $frm->addHiddenField('', 'extra3', '');
        $frm->addHiddenField('', 'billingCity', $orderInfo['customer_billing_city']);
        $frm->addHiddenField('', 'shippingCity', $orderInfo['customer_shipping_city']);
        $frm->addHiddenField('', 'zipCode', $orderInfo['customer_billing_postcode']);
        $frm->addHiddenField('', 'billingCountry', $orderInfo['customer_billing_country_code']);
        $frm->addHiddenField('', 'shippingCountry', $orderInfo['customer_shipping_country_code']);
        $frm->addHiddenField('', 'buyerFullName', $orderInfo['customer_name']);
        $frm->addHiddenField('', 'payerEmail', $orderInfo['customer_email']);
        $frm->addHiddenField('', 'payerPhone', (empty($orderInfo['customer_phone'])) ? $orderInfo['customer_phone'] : $orderInfo['customer_billing_phone']);
        $frm->addHiddenField('', 'payerOfficePhone', (empty($orderInfo['customer_phone'])) ? $orderInfo['customer_phone'] : $orderInfo['customer_billing_phone']);
        $frm->addHiddenField('', 'payerMobilePhone', (empty($orderInfo['customer_phone'])) ? $orderInfo['customer_phone'] : $orderInfo['customer_billing_phone']);
        /* ] */
        return $frm;
    }

    public function response()
    {
        $pmObj = new PaymentSettings($this->keyName);
        $paymentSettings = $pmObj->getPaymentSettings();

        $ApiKey = $paymentSettings['api_key'];
        $merchant_id = $paymentSettings['merchant_id'];
        $referenceCode = $_REQUEST['referenceCode'];

        $TX_VALUE = $_REQUEST['TX_VALUE'];
        $New_value = number_format($TX_VALUE, 1, '.', '');
        $currency = $_REQUEST['currency'];
        $transactionState = $_REQUEST['transactionState'];
        $Originalsignature = md5("$ApiKey~$merchant_id~$referenceCode~$New_value~$currency~$transactionState");

        $signature = $_REQUEST['signature'];
        $reference_pol = $_REQUEST['reference_pol'];
        $orderPaymentObj = new OrderPayment($referenceCode, $this->siteLangId);

        switch ($_REQUEST['transactionState']) {
            case 4 : /* PAYMENT SUCCESSFULL */
                $msg = Labels::getLabel('MSG_Transaction_Approved', $this->siteLangId);
                $redirectUrl = CommonHelper::generateUrl('custom', 'paymentSuccess', [$referenceCode]);
                break;

            case 6 : /* TRANSACTION REJECTED */
                $msg = Labels::getLabel('MSG_Transaction_Rejected', $this->siteLangId);
                $redirectUrl = CommonHelper::generateUrl('custom', 'paymentFailed');
                break;

            case 104 : /* PAYMENT FAILED */
                $msg = Labels::getLabel('MSG_Something_went_wrong', $this->siteLangId);
                $redirectUrl = CommonHelper::generateUrl('custom', 'paymentFailed');
                break;

            case 7 : /* Payment Pending */
                $msg = Labels::getLabel('MSG_Payment_Pending', $this->siteLangId);
                $redirectUrl = CommonHelper::generateUrl('custom', 'paymentSuccess', [$referenceCode]);
                break;

            default : /* Payment Failed */
                $msg = Labels::getLabel('MSG_' . $_REQUEST['message'], $this->siteLangId);
                $redirectUrl = CommonHelper::generateUrl('custom', 'paymentFailed');
                break;
        }

        $file = fopen("response.txt", "a");
        fwrite($file, json_encode($_REQUEST));
        fclose($file);

        //Message::addErrorMessage($msg);
        FatApp::redirectUser($redirectUrl);
    }

    public function callback()
    {
        $file = fopen("callbackresponse.txt", "a");
        fwrite($file, json_encode($_POST));
        fclose($file);

        $pmObj = new PaymentSettings($this->keyName);
        $paymentSettings = $pmObj->getPaymentSettings();

        $post = $_POST;
        /* $post = [
          'payment_method_type' => '4',
          'date' => '2021.02.19 04:49:47',
          'pse_reference3' => '',
          'pse_reference2' => '',
          'commision_pol' => '0.00',
          'pse_reference1' => '',
          'shipping_city' => '',
          'bank_referenced_name' => '',
          'sign' => 'c3a8a8dd6379d365081f476cfa22d6e6',
          'extra2' => '',
          'extra3' => '',
          'operation_date' => '2021-02-19 04:49:47',
          'billing_address' => '',
          'payment_request_state' => 'A',
          'extra1' => '',
          'administrative_fee' => '0.00',
          'administrative_fee_tax' => '0.00',
          'bank_id' => '25',
          'nickname_buyer' => '',
          'payment_method' => '25',
          'attempts' => '1',
          'transaction_id' => '56cb6bc3-93bf-49bf-bcd5-b27b71ddccf4',
          'transaction_date' => '2021-02-19 04:49:47',
          'test' => '0',
          'exchange_rate' => '3547.33',
          'ip' => '10.0.0.2',
          'reference_pol' => '121234485',
          'tax' => '0.00',
          'antifraudMerchantId' => '',
          'pse_bank' => '',
          'state_pol' => '4',
          'billing_city' => '',
          'phone' => '',
          'error_message_bank' => '',
          'shipping_country' => 'CO',
          'error_code_bank' => 'SUCCESS',
          'cus' => '1998470',
          'customer_number' => '',
          'description' => 'O1613728090',
          'merchant_id' => '508029',
          'administrative_fee_base' => '0.00',
          'authorization_code' => '',
          'currency' => 'USD',
          'shipping_address' => '',
          'installments_number' => '',
          'nickname_seller' => '',
          'value' => '3.60',
          'transaction_bank_id' => '',
          'billing_country' => 'CO',
          'response_code_pol' => '1',
          'payment_method_name' => 'PSE',
          'office_phone' => '',
          'email_buyer' => 'rock@dummyid.com',
          'payment_method_id' => '4',
          'response_message_pol' => 'APPROVED',
          'account_id' => '512321',
          'airline_code' => '',
          'pseCycle' => '',
          'risk' => '',
          'reference_sale' => 'O1613728090',
          'additional_value' => '0.00',
          ]; */

        $orderId = (isset($post['reference_sale'])) ? $post['reference_sale'] : 0;
        $orderPaymentObj = new OrderPayment($orderId, $this->siteLangId);
        $paymentGatewayCharge = $orderPaymentObj->getOrderPaymentGatewayAmount();
        $orderInfo = $orderPaymentObj->getOrderPrimaryinfo();
        
        $ApiKey = $paymentSettings['api_key'];
        $merchant_id = $paymentSettings['merchant_id'];
        $referenceCode = $post['reference_sale'];

        $TX_VALUE = $post['value'];
        if (substr($TX_VALUE, '.00')) {
            $TX_VALUE = number_format(rtrim($TX_VALUE, '0'), 1, '.', '');
        } else {
            $TX_VALUE = $this->cleanNumber($post['value']);
        }
        //$New_value = number_format($TX_VALUE, 1, '.', '');
        $currency = $post['currency'];
        $transactionState = $post['state_pol'];
        $Originalsignature = md5("$ApiKey~$merchant_id~$referenceCode~$TX_VALUE~$currency~$transactionState");

        $signature = $post['sign'];
        $request = '';
        if ($paymentGatewayCharge > 0) {
            switch ($post['state_pol']) {
                case 4: /* Approved */
                    $orderPaymentStatus = Orders::ORDER_IS_PAID;
                    break;
                case 6: /* Declined */
                    $orderPaymentStatus = Orders::ORDER_IS_PENDING; /* NEED TO UPDATE LATER */
                    break;
                case 5: /* Expired */
                    $orderPaymentStatus = Orders::ORDER_IS_PENDING;
                    break;
                default:
                    $orderPaymentStatus = Orders::ORDER_IS_PENDING;
                    break;
            }

            $receiverMatch = (strtolower($Originalsignature) == strtolower($signature));
            
            if ($orderInfo['order_type'] == Orders::ORDER_WALLET_RECHARGE) {
                $paymentGatewayChargeCop = number_format($orderInfo['order_net_amount_cop'], 2, '.', '');
            } else {
                $paymentGatewayChargeCop = number_format($paymentGatewayCharge * $orderInfo['order_default_currency_to_cop'], 2, '.', '');
            }
            
            $totalPaidMatch = ((float) $post['value'] == (float) $paymentGatewayChargeCop);

            if (!$receiverMatch) {
                $request .= "\n\n PAY_U_LATAM :: RECEIVER SIGNATURE MISMATCH! " . strtolower($post['sign']) . "\n\n";
            }

            if (!$totalPaidMatch) {
                $request .= "\n\n PAY_U_LATAM :: TOTAL PAID MISMATCH! " . strtolower($post['value']) . "\n\n";
            }

            if ($orderPaymentStatus == Orders::ORDER_IS_PAID && $receiverMatch && $totalPaidMatch) {
                $orderPaymentObj->addOrderPayment($paymentSettings["pmethod_code"], $post["transaction_id"], $paymentGatewayCharge, Labels::getLabel('MSG_Payment_Received', $this->siteLangId), json_encode($post));
            } else {
                $orderPaymentObj->addOrderPaymentComments($request);
            }
        }
    }

    public function send($orderId)
    {
        $pmObj = new PaymentSettings($this->keyName);
        $paymentSettings = $pmObj->getPaymentSettings();

        $frm = $this->getPaymentForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            $message['error'] = Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError($message);
        }

        $invalidCardDetail = false;
        if (date('Y') == $post['cc_expire_date_year'] && date('m') > $post['cc_expire_date_month']) {
            $invalidCardDetail = true;
        } elseif (date('Y') > $post['cc_expire_date_year']) {
            $invalidCardDetail = true;
        }

        if (true === $invalidCardDetail) {
            $message['error'] = Labels::getLabel("MSG_Invalid_card_detail", $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $orderPaymentObj = new OrderPayment($orderId, $this->siteLangId);
        /* Retrieve Payment to charge corresponding to your order */
        $orderPaymentAmount = $orderPaymentObj->getOrderPaymentGatewayAmount();

        if ($orderPaymentAmount > 0) {
            $orderActualPaid = number_format(round($orderPaymentAmount, 2), 2, ".", "");

            $orderInfo = $orderPaymentObj->getOrderPrimaryinfo();
            PayU::$apiKey = $paymentSettings['api_key']; //Enter your own apiKey here.
            PayU::$apiLogin = $paymentSettings['api_login']; //Enter your own apiLogin here.
            PayU::$merchantId = $paymentSettings['merchant_id']; //Enter your commerce Id here.
            PayU::$language = SupportedLanguages::EN; //Select the langua

            if (FatApp::getConfig('CONF_TRANSACTION_MODE', FatUtility::VAR_BOOLEAN, false) == true) {
                PayU::$isTest = false;
                Environment::setPaymentsCustomUrl("https://api.payulatam.com/payments-api/4.0/service.cgi");
                Environment::setReportsCustomUrl("https://api.payulatam.com/reports-api/4.0/service.cgi");
                Environment::setSubscriptionsCustomUrl("https://api.payulatam.com/payments-api/rest/v4.9/");
            } else {
                PayU::$isTest = true;
                Environment::setPaymentsCustomUrl("https://sandbox.api.payulatam.com/payments-api/4.0/service.cgi");
                Environment::setReportsCustomUrl("https://sandbox.api.payulatam.com/reports-api/4.0/service.cgi");
                Environment::setSubscriptionsCustomUrl("https://sandbox.api.payulatam.com/payments-api/rest/v4.9/");
            }
            //echo '<pre>'; print_r($orderInfo);
            $rand = mt_rand(10, 1000);
            $orderIdO = $orderId;
            $orderId = $orderId . '-' . $rand;
            $parameters = array(
                //Enter the account’s identifier here
                PayUParameters::ACCOUNT_ID => $paymentSettings['account_id'],
                PayUParameters::REFERENCE_CODE => $orderId,
                //PayUParameters::REFERENCE_CODE => '2343242',
                PayUParameters::DESCRIPTION => "payment",
                PayUParameters::VALUE => $orderActualPaid,
                PayUParameters::CURRENCY => $orderInfo['order_currency_code'],
                // -- Buyer --
                //Enter the buyer's name here.
                PayUParameters::BUYER_NAME => $orderInfo['customer_name'],
                //Enter the buyer's email here.
                PayUParameters::BUYER_EMAIL => $orderInfo['customer_email'],
                //Enter the buyer's contact phone here.
                /* PayUParameters::BUYER_CONTACT_PHONE => $orderInfo['customer_phone'], */
                //Enter the buyer's contact document here.
                /* PayUParameters::BUYER_DNI => "5415668464654", */
                //Enter the buyer's address here.
                /* PayUParameters::BUYER_STREET => $orderInfo['customer_billing_address_1'],
                  PayUParameters::BUYER_STREET_2 => $orderInfo['customer_billing_address_2'],
                  PayUParameters::BUYER_CITY => $orderInfo['customer_billing_city'],
                  PayUParameters::BUYER_STATE => $orderInfo['customer_billing_state'],
                  PayUParameters::BUYER_COUNTRY => $orderInfo['customer_billing_country_code'],
                  PayUParameters::BUYER_POSTAL_CODE => $orderInfo['customer_shipping_postcode'],
                  PayUParameters::BUYER_PHONE => $orderInfo['customer_shipping_phone'],
                 */
                // -- Payer --
                ///Enter the payer's name here
                PayUParameters::PAYER_NAME => "APPROVED",
                //Enter the payer's email here
                PayUParameters::PAYER_EMAIL => $orderInfo['customer_email'],
                /* //Enter the payer's contact phone here.
                  PayUParameters::PAYER_CONTACT_PHONE => $orderInfo['customer_phone'],
                  //Enter the payer's contact document here.
                  PayUParameters::PAYER_DNI => "5415668464654",
                  //Enter the payer's address here.
                  PayUParameters::PAYER_STREET => $orderInfo['customer_billing_address_1'],
                  PayUParameters::PAYER_STREET_2 => $orderInfo['customer_billing_address_2'],
                  PayUParameters::PAYER_CITY => $orderInfo['customer_billing_city'],
                  PayUParameters::PAYER_STATE => $orderInfo['customer_billing_state'],
                  PayUParameters::PAYER_COUNTRY => $orderInfo['customer_billing_country_code'],
                  PayUParameters::PAYER_POSTAL_CODE => $orderInfo['customer_shipping_postcode'],
                  PayUParameters::PAYER_PHONE => $orderInfo['customer_shipping_phone'], */

                // -- Credit card data --
                // Enter the number of the credit card here
                PayUParameters::CREDIT_CARD_NUMBER => $post['cc_number'],
                // Enter expiration date of the credit card here
                PayUParameters::CREDIT_CARD_EXPIRATION_DATE => $post['cc_expire_date_year'] . '/' . $post['cc_expire_date_month'],
                //Enter the security code of the credit card here
                PayUParameters::CREDIT_CARD_SECURITY_CODE => $post['cc_cvv'],
                //Enter the name of the credit card here
                // "MASTERCARD" || "AMEX" || "ARGENCARD" || "CABAL" || "NARANJA" || "CENCOSUD" || "SHOPPING"
                PayUParameters::PAYMENT_METHOD => "VISA",
                // Enter the number of installments here.
                PayUParameters::INSTALLMENTS_NUMBER => "1",
                    // Enter the name of the country here.
                    /* PayUParameters::COUNTRY => $orderInfo['customer_billing_country_code'], */
            );
            try {
                $response = PayUPayments::doAuthorizationAndCapture($parameters);
                //echo '<pre>'; print_r($response); die('123');
                if ($response) {
                    if ($response->transactionResponse->responseCode == "APPROVED") {
                        if (!$orderPaymentObj->addOrderPayment($paymentSettings["pmethod_name"], $response->transactionResponse->orderId, $orderPaymentAmount, Labels::getLabel("MSG_Received_Payment", $this->siteLangId), $response->transactionResponse->responseCode)) {//die('123');
                            $json['error'] = Labels::getLabel('MSS_Transaction_Failed', $this->siteLangId);
                        } else {
                            //$json['msg'] = $message;
                            //$json['description'] = $decription;
                            $json['msg'] = Labels::getLabel('MSS_Transaction_Successful', $this->siteLangId);
                            $json['redirect'] = CommonHelper::generateUrl('custom', 'paymentSuccess', array($orderIdO));
                        }
                    } else {
                        // $json['error'] = $response->transactionResponse->responseMessage;
                        $json['error'] = $response->transactionResponse->responseCode;
                        //$json['errorCode'] = $response->transactionResponse->responseCode;
                    }
                } else {
                    $json['error'] = Labels::getLabel('MSG_No_response_returned', $this->siteLangId);
                }
            } catch (Exception $e) {
                $json['error'] = $e->getMessage();
            }
        } else {
            $json['error'] = Labels::getLabel('MSG_Invalid_Request', $this->siteLangId);
        }
        echo json_encode($json);
        exit;
    }

    private function cleanNumber($num)
    {
        $pos = strpos($num, '.');
        if ($pos === false) {
            return $num;
        } else { // it is decimal number
            return rtrim(rtrim($num, '0'), '.');
        }
    }

}
