<?php

class ProductsController extends MyAppController
{

    public function __construct($action)
    {
        parent::__construct($action);
    }

    public function index()
    {
        $this->featured();
    }

    public function search()
    {
        $this->productsData(__FUNCTION__);
    }

    public function featured()
    {
        $this->productsData(__FUNCTION__);
    }

    private function productsData($method)
    {
        $get = Product::convertArrToSrchFiltersAssocArr(FatApp::getParameters());
        $includeKeywordRelevancy = false;
        $keyword = '';
        if (array_key_exists('keyword', $get)) {
            $includeKeywordRelevancy = true;
            $keyword = $get['keyword'];
        }
        $frm = $this->getProductSearchForm($includeKeywordRelevancy);
        $get['join_price'] = 1;
        $arr = array();

        switch ($method) {
            case 'index':
                $arr = array(
                    'pageTitle' => Labels::getLabel('LBL_All_PRODUCTS', $this->siteLangId),
                    'canonicalUrl' => CommonHelper::generateFullUrl('Products', 'index'),
                    'productSearchPageType' => SavedSearchProduct::PAGE_PRODUCT_INDEX,
                    'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'allProducts'),
                );
                break;
            case 'search':
                $arr = array(
                    'pageTitle' => Labels::getLabel('LBL_Search_results_for', $this->siteLangId),
                    'canonicalUrl' => CommonHelper::generateFullUrl('Products', 'search'),
                    'productSearchPageType' => SavedSearchProduct::PAGE_PRODUCT,
                    'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'searchListing'),
                    'keyword' => $keyword,
                    'seller_type' => (isset($get['sellertype'])) ? $get['sellertype'] : 0,
                );
                break;
            case 'featured':
                $arr = array(
                    'pageTitle' => Labels::getLabel('LBL_FEATURED_PRODUCTS', $this->siteLangId),
                    'canonicalUrl' => CommonHelper::generateFullUrl('Products', 'featured'),
                    'productSearchPageType' => SavedSearchProduct::PAGE_FEATURED_PRODUCT,
                    'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'searchListing'),
                    'seller_type' => (isset($get['sellertype'])) ? $get['sellertype'] : 0,
                );
                $get['featured'] = 1;
                break;
        }

        $frm->fill($get);
        $data = $this->getListingData($get);
        $common = array(
            'frmProductSearch' => $frm,
            'recordId' => 0,
            'showBreadcrumb' => false
        );
        $data = array_merge($data, $common, $arr);
        if (FatUtility::isAjaxCall()) {
            $this->set('products', $data['products']);
            $this->set('page', $data['page']);
            $this->set('pageCount', $data['pageCount']);
            $this->set('postedData', $get);
            $this->set('recordCount', $data['recordCount']);
            $this->set('siteLangId', $this->siteLangId);
            echo $this->_template->render(false, false, 'products/products-list.php', true);
            exit;
        }
        $this->set('data', $data);
        $this->includeProductPageJsCss();
        $this->_template->addJs('js/slick.min.js');
        $this->_template->render(true, true, 'products/index.php');
    }

    private function getFilterSearchObj($langId, $headerFormParamsAssocArr)
    {
        return FilterHelper::getSearchObj($langId, $headerFormParamsAssocArr);
    }

    public function brandFilters()
    {
        $post = FilterHelper::getParamsAssocArr();
        $langIdForKeywordSeach = 0;
        if (array_key_exists('keyword', $post) && !empty($post['keyword'])) {
            $langIdForKeywordSeach = $this->siteLangId;
        }
        $post['doNotJoinSpecialPrice'] = true;
        $prodSrchObj = $this->getFilterSearchObj($langIdForKeywordSeach, $post);
        $prodSrchObj->doNotCalculateRecords();
        $brandsCheckedArr = FilterHelper::selectedBrands($post);
        $cacheKey = FilterHelper::getCacheKey($this->siteLangId, $post);
        $brandFilter = FatCache::get('brandFilter' . $cacheKey, CONF_FILTER_CACHE_TIME, '.txt');
        if (!$brandFilter) {
            $brandsArr = FilterHelper::brands($prodSrchObj, $this->siteLangId, $post, true);
            FatCache::set('brandFilter' . $cacheKey, serialize($brandsArr), '.txt');
        } else {
            $brandsArr = unserialize($brandFilter);
        }

        $this->set('brandsArr', $brandsArr);
        $this->set('brandsCheckedArr', $brandsCheckedArr);
        echo $this->_template->render(false, false, 'products/brand-filters.php', true);
        exit;
    }

    public function countryFilters()
    {
        $post = FilterHelper::getParamsAssocArr();
        $langIdForKeywordSeach = 0;
        if (array_key_exists('keyword', $post) && !empty($post['keyword'])) {
            $langIdForKeywordSeach = $this->siteLangId;
        }

        $post['doNotJoinSpecialPrice'] = true;
        $prodSrchObj = $this->getFilterSearchObj($langIdForKeywordSeach, $post);
        $prodSrchObj->doNotCalculateRecords();

        $countriesCheckedArr = FilterHelper::selectedCountries($post);
        $cacheKey = FilterHelper::getCacheKey($this->siteLangId, $post);
        $countryFilter = FatCache::get('countryFilter' . $cacheKey, CONF_FILTER_CACHE_TIME, '.txt');
        if (!$countryFilter) {
            $countriesArr = FilterHelper::countries($prodSrchObj, $this->siteLangId, $post, true);
            FatCache::set('countryFilter' . $cacheKey, serialize($countriesArr), '.txt');
        } else {
            $countriesArr = unserialize($countryFilter);
        }
        $this->set('countriesArr', $countriesArr);
        $this->set('countriesCheckedArr', $countriesCheckedArr);
        echo $this->_template->render(false, false, 'products/country-filters.php', true);
        exit;
    }

    public function filters()
    {
        $db = FatApp::getDb();
        $headerFormParamsAssocArr = FilterHelper::getParamsAssocArr();

        $categoryId = 0;
        if (array_key_exists('category', $headerFormParamsAssocArr)) {
            $categoryId = FatUtility::int($headerFormParamsAssocArr['category']);
        }
        if (array_key_exists('shop_id', $headerFormParamsAssocArr)) {
            $categoryId = FatUtility::int($headerFormParamsAssocArr['shop_id']);
        }
        $keyword = '';
        $langIdForKeywordSeach = 0;
        if (array_key_exists('keyword', $headerFormParamsAssocArr) && !empty($headerFormParamsAssocArr['keyword'])) {
            $keyword = $headerFormParamsAssocArr['keyword'];
            $langIdForKeywordSeach = $this->siteLangId;
        }

        $verified = 0;
        if (array_key_exists('verified', $headerFormParamsAssocArr)) {
            $verified = FatUtility::int($headerFormParamsAssocArr['verified']);
        }

        $foundingmember = 0;
        if (array_key_exists('foundingmember', $headerFormParamsAssocArr)) {
            $foundingmember = FatUtility::int($headerFormParamsAssocArr['foundingmember']);
        }

     

        $cacheKey = FilterHelper::getCacheKey($this->siteLangId, $headerFormParamsAssocArr);
        $headerFormParamsAssocArr['doNotJoinSpecialPrice'] = true;
        $prodSrchObj = $this->getFilterSearchObj($langIdForKeywordSeach, $headerFormParamsAssocArr);
        $prodSrchObj->doNotCalculateRecords();

        /* Categories Data[ */
        $categoriesArr = array();
        if (empty($keyword)) {
            $categoriesArr = FilterHelper::getCategories($this->siteLangId, $categoryId, $prodSrchObj, $cacheKey);
        }
        /* ] */

        /* Brand Filters Data[ */
        $brandsCheckedArr = FilterHelper::selectedBrands($headerFormParamsAssocArr);
        $brandsArr = FilterHelper::brands($prodSrchObj, $this->siteLangId, $headerFormParamsAssocArr, true, true);
        /* ] */

        /* {Can modify the logic fetch data directly from query . will implement later}
          Option Filters Data[ */
        $options = FilterHelper::getOptions($this->siteLangId, $categoryId, $prodSrchObj);
        /* $optionSrch->joinSellerProductOptionsWithSelProdCode();
          $optionSrch->addGroupBy('optionvalue_id'); */
        /* ] */


        /* Condition filters data[ */
        $conditionsArr = array();
        $conditions = FatCache::get('condition' . $cacheKey, CONF_FILTER_CACHE_TIME, '.txt');
        if (!$conditions) {
            $conditionArr = Product::getConditionArr($this->siteLangId);
            $conditions = array();
            foreach ($conditionArr as $key => $val) {
                $conditionSrch = clone $prodSrchObj;
                $conditionSrch->setPageSize(1);
                $conditionSrch->addMultipleFields(array('selprod_condition'));
                $conditionSrch->addCondition('selprod_condition', '=', $key);
                /* if needs to show product counts under any condition[ */
                //$conditionSrch->addFld('count(selprod_condition) as totalProducts');
                /* ] */
                $conditionRs = $conditionSrch->getResultSet();
                $conditionsArr[] = $db->fetch($conditionRs);
            }
            FatCache::set('condition' . $cacheKey, serialize($conditionsArr), '.txt');
        } else {
            $conditionsArr = unserialize($conditions);
        }
        /* ] */
        /* Price Filters[ */
        $userId =  UserAuthentication::getLoggedUserId(true);
        $priceArr = FilterHelper::getPrice($headerFormParamsAssocArr, $this->siteLangId, $userId);

        $priceInFilter = false;
        $filterDefaultMinValue = isset($priceArr['minPrice']) ? $priceArr['minPrice'] : 0;
        $filterDefaultMaxValue = isset($priceArr['maxPrice']) ? $priceArr['maxPrice'] : 0;

        if ($this->siteCurrencyId != FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1) || (array_key_exists('currency_id', $headerFormParamsAssocArr) && $headerFormParamsAssocArr['currency_id'] != $this->siteCurrencyId)) {
            $filterDefaultMinValue = CommonHelper::displayMoneyFormat($priceArr['minPrice'], false, false, false);
            $filterDefaultMaxValue = CommonHelper::displayMoneyFormat($priceArr['maxPrice'], false, false, false);
            $priceArr['minPrice'] = $filterDefaultMinValue;
            $priceArr['maxPrice'] = $filterDefaultMaxValue;
        }

        if (array_key_exists('price-min-range', $headerFormParamsAssocArr) && array_key_exists('price-max-range', $headerFormParamsAssocArr)) {
            $priceArr['minPrice'] = $headerFormParamsAssocArr['price-min-range'];
            $priceArr['maxPrice'] = $headerFormParamsAssocArr['price-max-range'];
            $priceInFilter = true;
        }

        if (array_key_exists('currency_id', $headerFormParamsAssocArr) && $headerFormParamsAssocArr['currency_id'] != $this->siteCurrencyId) {
            if (isset($headerFormParamsAssocArr['price-min-range']) && isset($headerFormParamsAssocArr['price-max-range'])) {
                $priceArr['minPrice'] = CommonHelper::convertExistingToOtherCurrency($headerFormParamsAssocArr['currency_id'], $headerFormParamsAssocArr['price-min-range'], $this->siteCurrencyId, false);
                $priceArr['maxPrice'] = CommonHelper::convertExistingToOtherCurrency($headerFormParamsAssocArr['currency_id'], $headerFormParamsAssocArr['price-max-range'], $this->siteCurrencyId, false);
            }
        }

        /* ] */

        /* Availability Filters[ */
        $availabilities = FatCache::get('availabilities' . $cacheKey, CONF_FILTER_CACHE_TIME, '.txt');
        if (!$availabilities) {
            $availabilitySrch = clone $prodSrchObj;
            $availabilitySrch->setPageSize(1);
            //$availabilitySrch->addGroupBy('in_stock');
            $availabilitySrch->addHaving('in_stock', '>', 0);
            $availabilitySrch->addMultipleFields(array('if(selprod_stock > 0,1,0) as in_stock'));
            $availabilityRs = $availabilitySrch->getResultSet();
            $availabilityArr = $db->fetchAll($availabilityRs, 'in_stock');
            FatCache::set('availabilities' . $cacheKey, serialize($availabilityArr), '.txt');
        } else {
            $availabilityArr = unserialize($availabilities);
        }
        /* ] */

        $optionValueCheckedArr = array();
        if (array_key_exists('optionvalue', $headerFormParamsAssocArr)) {
            $optionValueCheckedArr = $headerFormParamsAssocArr['optionvalue'];
        }

        $conditionsCheckedArr = array();
        if (array_key_exists('condition', $headerFormParamsAssocArr)) {
            $conditionsCheckedArr = $headerFormParamsAssocArr['condition'];
        }

        $availability = 0;
        if (array_key_exists('out_of_stock', $headerFormParamsAssocArr)) {
            $availability = $headerFormParamsAssocArr['out_of_stock'];
        }

        $productFiltersArr = array('count_for_view_more' => FatApp::getConfig('CONF_COUNT_FOR_VIEW_MORE', FatUtility::VAR_INT, 5));

        $prodcatArr = array();
        //$productCategories = array();
        if (array_key_exists('prodcat', $headerFormParamsAssocArr)) {
            $prodcatArr = $headerFormParamsAssocArr['prodcat'];
            // $productCatObj = new ProductCategory;
            // $productCategories =  $productCatObj->getCategoriesForSelectBox($this->siteLangId);
        }

        $shopCatFilters = false;
        if (array_key_exists('shop_id', $headerFormParamsAssocArr)) {
            $shop_id = FatUtility::int($headerFormParamsAssocArr['shop_id']);
            $searchFrm = Shop::getFilterSearchForm();
            $searchFrm->fill($headerFormParamsAssocArr);
            $this->set('searchFrm', $searchFrm);
            if (0 < $shop_id) {
                $shopCatFilters = true;
            }
        }

        $sellerTypeCheckedArr = array();
        if (array_key_exists('sellertypes', $headerFormParamsAssocArr)) {
            $sellerTypeCheckedArr = $headerFormParamsAssocArr['sellertypes'];
        }

        $this->set('sellerTypeCheckedArr', $sellerTypeCheckedArr);

        $countriesArr = FilterHelper::countries($prodSrchObj, $this->siteLangId, $headerFormParamsAssocArr, false, true);

        $checkedCountriesArr = array();
        if (array_key_exists('country', $headerFormParamsAssocArr)) {
            $checkedCountriesArr = $headerFormParamsAssocArr['country'];
        }

        $supplierTypeCheckedArr = array();
        if (array_key_exists('supplier', $headerFormParamsAssocArr)) {
            $supplierTypeCheckedArr = $headerFormParamsAssocArr['supplier'];
        }

        $this->set('supplierTypeCheckedArr', $supplierTypeCheckedArr);

        $this->set('verified', $verified);
        $this->set('foundingmember', $foundingmember);
        $this->set('countriesArr', $countriesArr);
        $this->set('checkedCountriesArr', $checkedCountriesArr);
        $this->set('productFiltersArr', $productFiltersArr);
        $this->set('headerFormParamsAssocArr', $headerFormParamsAssocArr);
        $this->set('categoriesArr', $categoriesArr);
        $this->set('shopCatFilters', $shopCatFilters);
        $this->set('prodcatArr', $prodcatArr);
        // $this->set('productCategories',$productCategories);
        $this->set('brandsArr', $brandsArr);
        $this->set('brandsCheckedArr', $brandsCheckedArr);
        $this->set('optionValueCheckedArr', $optionValueCheckedArr);
        $this->set('conditionsArr', $conditionsArr);
        $this->set('conditionsCheckedArr', $conditionsCheckedArr);
        $this->set('options', $options);
        $this->set('priceArr', $priceArr);
        $this->set('priceInFilter', $priceInFilter);
        $this->set('filterDefaultMinValue', $filterDefaultMinValue);
        $this->set('filterDefaultMaxValue', $filterDefaultMaxValue);
        $this->set('availability', $availability);
        $availabilityArr = (API_CALL) ? array_values($availabilityArr) : $availabilityArr;
        $this->set('availabilityArr', $availabilityArr);
        $this->set('layoutDirection', CommonHelper::getLayoutDirection());

        $this->set('shop_id', $shop_id);

        if (API_CALL) {
            $this->_template->render();
        }

        echo $this->_template->render(false, false, 'products/filters.php', true);
        exit;
    }

    public function view($selprod_id = 0)
    {
        $selprod_id = FatUtility::int($selprod_id);
        if (API_CALL && 1 > $selprod_id) {
            FatUtility::dieJsonError(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
        }
        $this->_template->addJs('js/slick.min.js');
        $selprodType = SellerProduct::getAttributesById($selprod_id, 'selprod_type');
        if ($selprodType == SellerProduct::PRODUCT_TYPE_SERVICE) { 
            $this->loadServiceDetails($selprod_id);
            exit;
        } else {
            $this->loadProductDetails($selprod_id);
            exit;
        }
    }

    private function loadProductDetails(int $selprod_id)
    {
        $prodSrchObj = new ProductSearch($this->siteLangId);
        /* fetch requested product[ */
        $prodSrch = clone $prodSrchObj;
        $prodSrch->setDefinedCriteria(0, 0, array(), false);
        $prodSrch->joinProductToCategory();
        $prodSrch->joinShopSpecifics();
        $prodSrch->joinProductSpecifics();
        $prodSrch->joinSellerProductSpecifics();
        $prodSrch->joinSellerSubscription();
        $prodSrch->addSubscriptionValidCondition();
        $prodSrch->joinSellerReturnAddress();
        $prodSrch->doNotCalculateRecords();
        $prodSrch->addCondition('selprod_id', '=',  'mysql_func_' . $selprod_id, 'AND', true);
        $prodSrch->addCondition('selprod_deleted', '=',  'mysql_func_' . AppConstants::NO, 'AND', true);
        $prodSrch->doNotLimitRecords();

        /* sub query to find out that logged user have marked current product as in wishlist or not[ */
        $loggedUserId = 0;
        if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }
        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $prodSrch->joinFavouriteProducts($loggedUserId);
            $prodSrch->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $prodSrch->joinUserWishListProducts($loggedUserId);
            $prodSrch->addFld('COALESCE(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }

        $selProdReviewObj = new SelProdReviewSearch();
        $selProdReviewObj->joinProducts($this->siteLangId);
        $selProdReviewObj->joinSellerProducts($this->siteLangId);
        $selProdReviewObj->joinSelProdRating();
        $selProdReviewObj->joinUser();
        $selProdReviewObj->joinSelProdReviewHelpful();
        $selProdReviewObj->addCondition('sprating_rating_type', '=', 'mysql_func_'.SelProdRating::TYPE_PRODUCT, 'AND', true);
        $selProdReviewObj->doNotCalculateRecords();
        $selProdReviewObj->doNotLimitRecords();
        $selProdReviewObj->addGroupBy('spr.spreview_product_id');
        $selProdReviewObj->addGroupBy('sprh_spreview_id');
        $selProdReviewObj->addCondition('spr.spreview_status', '=', 'mysql_func_'.SelProdReview::STATUS_APPROVED, 'AND', true);
        $selProdReviewObj->addMultipleFields(array('spr.spreview_selprod_id', 'spr.spreview_product_id', "ROUND(AVG(sprating_rating),2) as prod_rating", "count(spreview_id) as totReviews"));
        $selProdRviewSubQuery = $selProdReviewObj->getQuery();
        $prodSrch->joinTable('(' . $selProdRviewSubQuery . ')', 'LEFT OUTER JOIN', 'sq_sprating.spreview_product_id = product_id', 'sq_sprating');
        $prodSrch->addMultipleFields(
                array('shop_user_id','shop_is_buy_now', 'shop_hide_price_for_guests', 'selprod_updated_on', 'selprod_type', 'shop_hide_price_for_loginusers', 'product_id', 'product_identifier', 'COALESCE(product_name,product_identifier) as product_name', 'product_seller_id', 'product_model', 'product_type', 'prodcat_id', 'COALESCE(prodcat_name,prodcat_identifier) as prodcat_name', 'product_upc', 'product_isbn', 'product_short_description', 'product_description',
                    'selprod_id', 'selprod_user_id', 'selprod_code', 'selprod_condition', 'selprod_price', 'special_price_found', 'splprice_start_date', 'splprice_end_date', 'COALESCE(selprod_title, product_name, product_identifier) as selprod_title', 'selprod_warranty', 'selprod_return_policy', 'selprodComments',
                    'theprice', 'selprod_stock', 'selprod_threshold_stock_level', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'brand_id', 'COALESCE(brand_name, brand_identifier) as brand_name', 'brand_short_description', 'user_name',
                    'shop_id', 'COALESCE(shop_name, shop_identifier) as shop_name', 'COALESCE(sq_sprating.prod_rating,0) prod_rating ', 'COALESCE(sq_sprating.totReviews,0) totReviews',
                    'splprice_display_dis_type', 'splprice_display_dis_val', 'splprice_display_list_price', 'product_attrgrp_id', 'product_youtube_video', 'product_cod_enabled', 'selprod_cod_enabled', 'selprod_available_from', 'selprod_min_order_qty', 'product_updated_on', 'product_warranty', 'selprod_return_age', 'selprod_cancellation_age', 'shop_return_age', 'shop_cancellation_age',
                    'seller_user.user_is_verified as seller_verified', 'seller_user.user_is_founding_member as is_founding_member', 'rcountry.country_code as seller_country', 'seller_profile.sprofile_seller_type as seller_type'
                )
        );  

        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $prodSrch->addFld(array('spplan_spackage_id as subscription_package_id'));
        } else {
            $prodSrch->addFld(array('0 as subscription_package_id'));
        }

        $productRs = $prodSrch->getResultSet();
        $product = FatApp::getDb()->fetch($productRs);
        /* ] */

        if (!$product) {
            if (API_CALL) {
                FatUtility::dieJsonError(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            }
            FatUtility::exitWithErrorCode(404);
        }

        /* over all catalog product reviews */
        $selProdReviewObj->addCondition('spreview_product_id', '=', 'mysql_func_'.$product['product_id'], 'AND', true);
        $selProdReviewObj->addMultipleFields(array('count(spreview_postedby_user_id) totReviews', 'sum(if(sprating_rating=1,1,0)) rated_1', 'sum(if(sprating_rating=2,1,0)) rated_2', 'sum(if(sprating_rating=3,1,0)) rated_3', 'sum(if(sprating_rating=4,1,0)) rated_4', 'sum(if(sprating_rating=5,1,0)) rated_5'));

        $reviews = FatApp::getDb()->fetch($selProdReviewObj->getResultSet());
        /* CommonHelper::printArray($reviews); die; */
        $this->set('reviews', $reviews);
        $subscription = false;
        $allowed_images = -1;
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $product['selprod_user_id'], array('ossubs_images_allowed'));
            $allowed_images = $currentPlanData['ossubs_images_allowed'];
            $subscription = true;
        }

        Product::recordProductWeightage($product['selprod_code'], SmartWeightageSettings::PRODUCT_VIEW);
        Product::addUpdateProductBrowsingHistory($product['selprod_code'], SmartWeightageSettings::PRODUCT_VIEW); 

        /* Current Product option Values[ */
        $options = SellerProduct::getSellerProductOptions($selprod_id, false);
        $productSelectedOptionValues = array();
        $productGroupImages = array();
        $productImagesArr = array();

        if (count($options) > 0) {
            foreach ($options as $op) {
                /* Product UPC code [ */
                $product['product_upc'] = UpcCode::getUpcCode($product['product_id'], $op['selprodoption_optionvalue_id']);
                /* ] */
                $images = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_PRODUCT_IMAGE, $product['product_id'], $op['selprodoption_optionvalue_id'], $this->siteLangId, true, '', $allowed_images);
                if ($images) {
                    $productImagesArr += $images;
                }
                $productSelectedOptionValues[$op['selprodoption_option_id']] = $op['selprodoption_optionvalue_id'];
            }
        }

        if (count($productImagesArr) > 0) {
            foreach ($productImagesArr as $image) {
                $afileId = $image['afile_id'];
                if (!array_key_exists($afileId, $productGroupImages)) {
                    $productGroupImages[$afileId] = array();
                }
                $productGroupImages[$afileId] = $image;
            }
        }

        $product['selectedOptionValues'] = $productSelectedOptionValues;
        /* ] */

        if (isset($allowed_images) && $allowed_images > 0) {
            $universal_allowed_images_count = $allowed_images - count($productImagesArr);
        }

        $productUniversalImagesArr = array();
        if (empty($productGroupImages) || !$subscription || isset($universal_allowed_images_count)) {
            $universalImages = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_PRODUCT_IMAGE, $product['product_id'], -1, $this->siteLangId, true, '');
            /* CommonHelper::printArray($universalImages); die; */
            if ($universalImages) {
                if (isset($universal_allowed_images_count)) {
                    $images = array_slice($universalImages, 0, $universal_allowed_images_count);
                    $productUniversalImagesArr = $images;
                    $universal_allowed_images_count = $universal_allowed_images_count - count($productUniversalImagesArr);
                } elseif (!$subscription) {
                    $productUniversalImagesArr = $universalImages;
                }
            }
        }

        if ($productUniversalImagesArr) {
            foreach ($productUniversalImagesArr as $image) {
                $afileId = $image['afile_id'];
                if (!array_key_exists($afileId, $productGroupImages)) {
                    $productGroupImages[$afileId] = array();
                }
                $productGroupImages[$afileId] = $image;
            }
        }
        
        //abled and Get Shipping Rates [*/
        $codEnabled = false;
        if (Product::isProductShippedBySeller($product['product_id'], $product['product_seller_id'], $product['selprod_user_id'])) {
            $walletBalance = User::getUserBalance($product['selprod_user_id']);
            if ($product['selprod_cod_enabled'] == AppConstants::YES) {
                $codEnabled = true;
            }
            $codMinWalletBalance = -1;
            $shop_cod_min_wallet_balance = Shop::getAttributesByUserId($product['selprod_user_id'], 'shop_cod_min_wallet_balance');
            if ($shop_cod_min_wallet_balance > -1) {
                $codMinWalletBalance = $shop_cod_min_wallet_balance;
            } elseif (FatApp::getConfig('CONF_COD_MIN_WALLET_BALANCE', FatUtility::VAR_FLOAT, -1) > -1) {
                $codMinWalletBalance = FatApp::getConfig('CONF_COD_MIN_WALLET_BALANCE', FatUtility::VAR_FLOAT, -1);
            }
            if ($codMinWalletBalance > -1 && $codMinWalletBalance > $walletBalance) {
                $codEnabled = false;
            }
            $shippingRates = Product::getProductShippingRates($product['product_id'], $this->siteLangId, 0, $product['selprod_user_id']);
            $shippingDetails = Product::getProductShippingDetails($product['product_id'], $this->siteLangId, $product['selprod_user_id']);
        } else {
            if ($product['product_cod_enabled'] == AppConstants::YES) {
                $codEnabled = true;
            }
            $shippingRates = Product::getProductShippingRates($product['product_id'], $this->siteLangId, 0, 0);
            $shippingDetails = Product::getProductShippingDetails($product['product_id'], $this->siteLangId, 0);
        }
        if ($product['product_type'] == Product::PRODUCT_TYPE_DIGITAL) {
            $shippingRates = array();
            $shippingDetails = array();
        }
        
        $this->set('codEnabled', $codEnabled);
        $this->set('shippingRates', $shippingRates);
        $this->set('shippingDetails', $shippingDetails);
        /* ] */

        /* [ Product shipping cost */
        $shippingCost = 0;
        /* ] */

        $product['moreSellersArr'] = $this->getMoreSeller($product['selprod_code'], $this->siteLangId, $product['selprod_user_id']);
        $product['selprod_return_policies'] = SellerProduct::getSelprodPolicies($product['selprod_id'], PolicyPoint::PPOINT_TYPE_RETURN, $this->siteLangId);
        $product['selprod_warranty_policies'] = SellerProduct::getSelprodPolicies($product['selprod_id'], PolicyPoint::PPOINT_TYPE_WARRANTY, $this->siteLangId);
        /* Form buy product[ */
        $frm = $this->getCartForm($this->siteLangId);
        $frm->fill(array('selprod_id' => $selprod_id));
        $this->set('frmBuyProduct', $frm);
        /* ] */


		if(count($product['moreSellersArr']) > 0) {
			foreach($product['moreSellersArr'] as $keys=>$moreShop) {
				$moreshop_rating = 0;
				if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
					$moreshop_rating = SelProdRating::getSellerRating($moreShop['selprod_user_id']);
					$product['moreSellersArr'][$keys]['rating'] = $moreshop_rating;
				}
			}		
		}


        $optionSrchObj = clone $prodSrchObj;
        $optionSrchObj->setDefinedCriteria();
        $optionSrchObj->doNotCalculateRecords();
        $optionSrchObj->doNotLimitRecords();
        $optionSrchObj->joinTable(SellerProduct::DB_TBL_SELLER_PROD_OPTIONS, 'LEFT OUTER JOIN', 'selprod_id = tspo.selprodoption_selprod_id', 'tspo');
        $optionSrchObj->joinTable(OptionValue::DB_TBL, 'LEFT OUTER JOIN', 'tspo.selprodoption_optionvalue_id = opval.optionvalue_id', 'opval');
        $optionSrchObj->joinTable(Option::DB_TBL, 'LEFT OUTER JOIN', 'opval.optionvalue_option_id = op.option_id', 'op');
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)) {
            $validDateCondition = " and oss.ossubs_till_date >= '" . date('Y-m-d') . "'";
            $optionSrchObj->joinTable(Orders::DB_TBL, 'INNER JOIN', 'o.order_user_id=seller_user.user_id AND o.order_type=' . ORDERS::ORDER_SUBSCRIPTION . ' AND o.order_is_paid =1', 'o');
            $optionSrchObj->joinTable(OrderSubscription::DB_TBL, 'INNER JOIN', 'o.order_id = oss.ossubs_order_id and oss.ossubs_status_id=' . FatApp::getConfig('CONF_DEFAULT_SUBSCRIPTION_PAID_ORDER_STATUS') . $validDateCondition, 'oss');
        }
        $optionSrchObj->addCondition('product_id', '=', 'mysql_func_' . $product['product_id'], 'AND', true);

        $optionSrch = clone $optionSrchObj;
        $optionSrch->joinTable(Option::DB_TBL . '_lang', 'LEFT OUTER JOIN', 'op.option_id = op_l.optionlang_option_id AND op_l.optionlang_lang_id = ' . $this->siteLangId, 'op_l');
        $optionSrch->addMultipleFields(array('option_id', 'option_is_color', 'COALESCE(option_name,option_identifier) as option_name'));
        $optionSrch->addCondition('option_id', '!=', 'NULL');
        $optionSrch->addCondition('selprodoption_selprod_id', '=', 'mysql_func_' .$selprod_id, 'AND', true);
        $optionSrch->addGroupBy('option_id');

        $optionRs = $optionSrch->getResultSet();
        if (API_CALL) {
            $optionRows = FatApp::getDb()->fetchAll($optionRs);
        } else {
            $optionRows = FatApp::getDb()->fetchAll($optionRs, 'option_id');
        }

        if (count($optionRows) > 0) {
            foreach ($optionRows as &$option) {
                $optionValueSrch = clone $optionSrchObj;
                $optionValueSrch->joinTable(OptionValue::DB_TBL . '_lang', 'LEFT OUTER JOIN', 'opval.optionvalue_id = opval_l.optionvaluelang_optionvalue_id AND opval_l.optionvaluelang_lang_id = ' . $this->siteLangId, 'opval_l');
                $optionValueSrch->addCondition('product_id', '=', 'mysql_func_' .$product['product_id'], 'AND', true);
                $optionValueSrch->addCondition('option_id', '=', 'mysql_func_' .$option['option_id'], 'AND', true);
                $optionValueSrch->addMultipleFields(array('COALESCE(product_name, product_identifier) as product_name', 'selprod_id', 'selprod_user_id', 'selprod_code', 'option_id', 'COALESCE(optionvalue_name,optionvalue_identifier) as optionvalue_name ', 'theprice', 'optionvalue_id', 'optionvalue_color_code'));
                $optionValueSrch->addGroupBy('optionvalue_id');
                $optionValueRs = $optionValueSrch->getResultSet();
                if (API_CALL) {
                    $optionValueRows = FatApp::getDb()->fetchAll($optionValueRs);
                } else {
                    $optionValueRows = FatApp::getDb()->fetchAll($optionValueRs, 'optionvalue_id');
                }
                $option['values'] = $optionValueRows;
            }
        }
        $this->set('optionRows', $optionRows);
        $sellerProduct = new SellerProduct($selprod_id);
        $criteria = array('selprod_id');

        $upsellProducts = $sellerProduct->getUpsellProducts($product['selprod_id'], $this->siteLangId, $loggedUserId);
        $relatedProducts = $sellerProduct->getRelatedProducts($this->siteLangId, $product['selprod_id'], $criteria);
        
        /* To Do list */
        /* $relatedProducts = array(); */
        $relatedProductsRs = $this->relatedProductsById(array_keys($relatedProducts));


        $this->setProductViewCommonData($product['shop_id']);
        /* Get Product Specifications */
        $this->set('productSpecifications', $this->getProductSpecifications($product['product_id'], $this->siteLangId));
        /* End of Product Specifications */

        $canSubmitFeedback = true;
        if ($loggedUserId) {
            $orderProduct = SelProdReview::getProductOrderId($product['product_id'], $loggedUserId);
            if (empty($orderProduct) || (isset($orderProduct['op_order_id']) && !Orders::canSubmitFeedback($loggedUserId, $orderProduct['op_order_id'], $selprod_id))) {
                $canSubmitFeedback = false;
            }
        }

        $this->set('canSubmitFeedback', $canSubmitFeedback);
        $this->set('upsellProducts', !empty($upsellProducts) ? $upsellProducts : array());
        $this->set('relatedProductsRs', !empty($relatedProductsRs) ? $relatedProductsRs : array());

        $this->set('product', $product);
        $this->set('productImagesArr', $productGroupImages);
        $this->set('sellerStats', RequestForQuote::getSellerStates($product['shop_user_id']));
        //    $this->set( 'productGroups', $productGroups );
        $frmReviewSearch = $this->getReviewSearchForm(5);
        $frmReviewSearch->fill(array('selprod_id' => $selprod_id));
        $this->set('frmReviewSearch', $frmReviewSearch);
        $this->set('volumeDiscountRows', $sellerProduct->getVolumeDiscounts());
        /* ] */


		$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $product['shop_user_id'], array('spackage_id'));
		$currentActivePackageId = isset($currentPlanData['spackage_id'])? $currentPlanData['spackage_id'] : 0;
		$this->set('subscription_package_id' , $currentActivePackageId);
        if ($currentActivePackageId > 0) {
            $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
            $this->set('subscription_package' , (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '');
        }


        if (!empty($product)) {
            $afile_id = !empty($productGroupImages) ? array_keys($productGroupImages)[0] : 0;
            $this->set('socialShareContent', $this->getOgTags($product, $afile_id));
        }
        $this->setRecentlyViewedItem($selprod_id);
        if (false === API_CALL) {
            $this->_template->addJs(array('js/slick.js', 'js/modaal.js', 'js/product-detail.js', 'js/xzoom.js', 'js/magnific-popup.js'));
        } else {
            $recentlyViewed = FatApp::getPostedData('recentlyViewed');
            $recentlyViewed = is_array($recentlyViewed) && 0 < count($recentlyViewed) ? FatUtility::int($recentlyViewed) : array();
            if (in_array($selprod_id, $recentlyViewed)) {
                unset($recentlyViewed[$selprod_id]);
            }
            /* To Do list */
            /* $recentlyViewed = $this->getRecentlyViewedProductsDetail($recentlyViewed); */
            $recentlyViewed = array();
            $this->set('recentlyViewed', $recentlyViewed);
        }
		
        /* Recommnended Products [ */
        $recommendedProducts = (array) $this->getRecommendedProducts($selprod_id, $this->siteLangId, $loggedUserId);
        $recommendedProducts = (0 < count(array_filter($recommendedProducts)) ? array_filter($recommendedProducts) : []);
        $recSelProdIdsArr = array_column($recommendedProducts, 'selprod_id');
        $recommendedProducts = $this->relatedProductsById($recSelProdIdsArr);
        $this->set('recommendedProducts', $recommendedProducts);
        /* ]  */		
		/* [ SELLER PROFILE DATA */
        $serviceProducts = $sellerProduct->getServiceProducts($this->siteLangId);
        $this->set('serviceProducts', $serviceProducts);
        $this->_template->render();
    }

    private function getRecommendedProducts($selprod_id, $langId, $userId = 0)
    {
        $selprod_id = FatUtility::int($selprod_id);
        if (1 > $selprod_id) {
            return;
        }

        /* if (User::checkPersonalizedCookiesEnabled() == false) {
            return false;
        } */

        /*if($recommendedProducts =  FatCache::get('recommProds'.$selprod_id.'-'.$langId.'-'.$userId, CONF_HOME_PAGE_CACHE_TIME, '.txt')){
            return  unserialize($recommendedProducts);
        }*/

        $productId = SellerProduct::getAttributesById($selprod_id, 'selprod_product_id', false);

        $srch = new ProductSearch($langId);
        $join_price = 1;
        /* $srch->setGeoAddress(); */
        $srch->setDefinedCriteria($join_price);
        $srch->joinProductToCategory();
        $srch->joinSellerSubscription();
        $srch->addSubscriptionValidCondition();
       /*  $srch->validateAndJoinDeliveryLocation(); */
        $srch->addCondition('selprod_deleted', '=',  'mysql_func_' . AppConstants::NO, 'AND', true);
        $srch->addMultipleFields(
            array(
                'shop_is_buy_now', 'shop_hide_price_for_guests', 'selprod_user_id', 'shop_hide_price_for_loginusers', 'product_id', 'COALESCE(product_name, product_identifier) as product_name', 'prodcat_id', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'product_updated_on',
                'selprod_id', 'selprod_condition', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'theprice',
                'special_price_found', 'splprice_display_list_price', 'splprice_display_dis_val', 'selprod_updated_on', 'selprod_type',
                'splprice_display_dis_type', 'selprod_sold_count',
                'COALESCE(selprod_title, product_name, product_identifier) as selprod_title', 'selprod_price', 'seller_user.user_name',
                'seller_user.user_is_verified as seller_verified',
                'seller_user.user_is_founding_member as is_founding_member', 'shop_id', 'IFNULL(shop_name, shop_identifier) as shop_name', 'shop_user_id',
            )
        );

        $dateToEquate = date('Y-m-d');
        
        $subSrch1 = new SearchBase('tbl_product_product_recommendation', 'ppr');
        $subSrch1->addMultipleFields(array('ppr_recommended_product_id as rec_product_id', 'ppr_weightage as weightage'));
        $subSrch1->addCondition('ppr_viewing_product_id', '=', 'mysql_func_' . $productId, 'AND', true);
        $subSrch1->addOrder('weightage', 'desc');
        $subSrch1->doNotCalculateRecords();
        $subSrch1->setPageSize(10);

        $subSrch2 = new SearchBase(Product::DB_PRODUCT_TO_TAG, 'ptt');
        $subSrch2->joinTable('tbl_tag_product_recommendation', 'INNER JOIN', 'tpr.tpr_tag_id = ptt.ptt_tag_id', 'tpr');
        $subSrch2->addMultipleFields(array('tpr_product_id  as rec_product_id', 'if(tpr_custom_weightage_valid_till <= ' . $dateToEquate . ', tpr_custom_weightage+tpr_weightage , tpr_weightage) as weightage'));
        $subSrch2->addOrder('weightage', 'desc');
        $subSrch2->doNotCalculateRecords();
        $subSrch2->setPageSize(10);

        $recommendedProductsQuery = '(' . $subSrch1->getQuery() . ') union (' . $subSrch2->getQuery() . ')';
        if (0 < $userId) {
            $subSrch3 = new SearchBase('tbl_user_product_recommendation', 'upr');
            $subSrch3->addMultipleFields(array('upr_product_id as rec_product_id', 'upr_weightage as weightage'));
            $subSrch3->addOrder('weightage', 'desc');
            $subSrch3->addCondition('upr_user_id', '=', $userId);
            $subSrch3->doNotCalculateRecords();
            $subSrch3->setPageSize(10);
            $recommendedProductsQuery .= ' union (' . $subSrch3->getQuery() . ')';
        }
        $rs = FatApp::getDb()->query('select rec_product_id , weightage from (' . $recommendedProductsQuery . ') as temp order by weightage desc');
      
        $recommendedProds = FatApp::getDb()->fetchAllAssoc($rs);
        if (empty($recommendedProds)) {
            return array();
        }

        $srch->addGroupBy('product_id');

        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $srch->joinFavouriteProducts($userId);
            $srch->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $srch->joinUserWishListProducts($userId);
            $srch->addFld('COALESCE(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }

        $srch->addCondition('selprod_id', '!=', $selprod_id);
        $srch->addCondition('product_id', 'in', array_keys($recommendedProds));
        $srch->setPageSize(5);
        $srch->doNotCalculateRecords();
        

        return FatApp::getDb()->fetchAll($srch->getResultSet());
    }

    private function getProductSpecifications($product_id, $langId)
    {
        $product_id = FatUtility::int($product_id);
        $langId = FatUtility::int($langId);
        if (1 > $product_id) {
            return array();
        }
        $specSrchObj = new ProductSearch($langId);
        $specSrchObj->setDefinedCriteria();
        $specSrchObj->doNotCalculateRecords();
        $specSrchObj->doNotLimitRecords();
        $specSrchObj->joinTable(Product::DB_PRODUCT_SPECIFICATION, 'LEFT OUTER JOIN', 'product_id = tcps.prodspec_product_id', 'tcps');
        $specSrchObj->joinTable(Product::DB_PRODUCT_LANG_SPECIFICATION, 'INNER JOIN', 'tcps.prodspec_id = tcpsl.prodspeclang_prodspec_id and   prodspeclang_lang_id  = ' . $langId, 'tcpsl');
        $specSrchObj->addMultipleFields(array('prodspec_id', 'prodspec_name', 'prodspec_value'));
        $specSrchObj->addGroupBy('prodspec_id');
        $specSrchObj->addCondition('prodspec_product_id', '=', $product_id);
        $specSrchObjRs = $specSrchObj->getResultSet();
        return FatApp::getDb()->fetchAll($specSrchObjRs);
    }

    private function getMoreSeller($selprodCode, $langId, $userId = 0)
    {
        $userId = FatUtility::int($userId);
        $langId = FatUtility::int($langId);

        $moreSellerSrch = new ProductSearch($langId);
        $moreSellerSrch->addMoreSellerCriteria($selprodCode, $userId);

        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }

        /* $moreSellerSrch->addMultipleFields(array( 'selprod_id', 'selprod_user_id', 'selprod_price', 'special_price_found', 'theprice', 'shop_id', 'shop_name' ,'IF(selprod_stock > 0, 1, 0) AS in_stock')); */
        $genFlds = array('selprod_id', 'selprod_user_id', 'selprod_price', 'special_price_found', 'theprice',
            'shop_id', 'shop_name', 'product_seller_id', 'product_id',
            'shop_country_l.country_name as shop_country_name', 'shop_state_l.state_name as shop_state_name',
            'shop_city', 'selprod_cod_enabled', 'product_cod_enabled',
            'IF(selprod_stock > 0, 1, 0) AS in_stock', 'selprod_min_order_qty', 'selprod_available_from',
            'user_is_verified as seller_verified',
            'user_is_founding_member as is_founding_member', 'shop_is_buy_now as is_buy_now'
        );

        $flds = array_merge($genFlds, $subFld);

        $moreSellerSrch->addMultipleFields($flds);
        $moreSellerSrch->addHaving('in_stock', '>', 0);
        $moreSellerSrch->addOrder('theprice');
        $moreSellerSrch->addGroupBy('selprod_id');
        $moreSellerRs = $moreSellerSrch->getResultSet();
        return FatApp::getDb()->fetchAll($moreSellerRs);
    }

    private function setRecentlyViewedItem($selprod_id)
    {
        $selprod_id = FatUtility::int($selprod_id);
        if (1 > $selprod_id) {
            return;
        }
        $recentProductsArr = array();
        if (!isset($_COOKIE['recentViewedProducts'])) {
            setcookie('recentViewedProducts', $selprod_id . '_', time() + 60 * 60 * 72, CONF_WEBROOT_URL);
        } else {
            $recentProducts = $_COOKIE['recentViewedProducts'];
            $recentProductsArr = explode('_', $recentProducts);
        }
        $products = array();
        if (is_array($recentProductsArr) && !in_array($selprod_id, $recentProductsArr)) {
            if (count($recentProductsArr) >= 10) {
                $recentProductsArr = array_reverse($recentProductsArr);
                array_pop($recentProductsArr);
                $recentProductsArr = array_reverse($recentProductsArr);
            }

            foreach ($recentProductsArr as $val) {
                if ($val == '') {
                    continue;
                }
                array_push($products, $val);
            }
            array_push($products, $selprod_id);
            setcookie('recentViewedProducts', implode('_', $products), time() + 60 * 60 * 72, CONF_WEBROOT_URL);
        }
    }

    private function getOgTags($product = array(), $afile_id = 0)
    {
        if (empty($product)) {
            return array();
        }
        $afile_id = FatUtility::int($afile_id);
        $title = $product['selprod_title'] ? $product['selprod_title'] : $product['product_name'];
        $product_description = trim(CommonHelper::subStringByWords(strip_tags(CommonHelper::renderHtml($product["product_description"], true)), 500));
        $product_description .= ' - ' . Labels::getLabel('LBL_See_more_at', $this->siteLangId) . ": " . CommonHelper::getCurrUrl();

        $productImageUrl = '';
        /* $productImageUrl = CommonHelper::generateFullFileUrl('image','product', array($product['product_id'],'', $product['selprod_id'],0,$this->siteLangId )); */
        if (0 < $afile_id) {
            $productImageUrl = CommonHelper::generateFullFileUrl('image', 'product', array($product['product_id'], 'FB_RECOMMEND', 0, $afile_id));
        }
        $socialShareContent = array(
            'type' => 'Product',
            'title' => $title,
            'description' => $product_description,
            'image' => $productImageUrl,
        );
        return $socialShareContent;
    }

    private function getRecentlyViewedProductsDetail($cookiesProductsArr = array())
    {
        if (1 > count($cookiesProductsArr)) {
            return $cookiesProductsArr;
        }
        $loggedUserId = UserAuthentication::getLoggedUserId(true);
        $prodSrch = new ProductSearch($this->siteLangId);
        $prodSrch->setDefinedCriteria();
        $prodSrch->joinSellerSubscription();
        $prodSrch->addSubscriptionValidCondition();
        $prodSrch->joinSellerReturnAddress();
        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }
        $prodSrch->joinProductToCategory();
        $prodSrch->doNotCalculateRecords();
        $prodSrch->doNotLimitRecords();
        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $prodSrch->joinFavouriteProducts($loggedUserId);
            $prodSrch->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $prodSrch->joinUserWishListProducts($loggedUserId);
            $prodSrch->addFld('COALESCE(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }
        $prodSrch->addCondition('selprod_id', 'IN', $cookiesProductsArr);
        $genFlds = array(
            'shop_is_buy_now', 'shop_hide_price_for_guests', 'selprod_user_id', 'shop_hide_price_for_loginusers', 'product_id', 'COALESCE(product_name, product_identifier) as product_name', 'prodcat_id', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'product_updated_on',
            'selprod_id', 'selprod_condition', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'theprice',
            'special_price_found', 'splprice_display_list_price', 'splprice_display_dis_val', 'selprod_updated_on', 'selprod_type',
            'splprice_display_dis_type', 'selprod_sold_count',
            'COALESCE(selprod_title, product_name, product_identifier) as selprod_title', 'selprod_price', 'seller_user.user_name',
            'seller_user.user_is_verified as seller_verified',
            'seller_user.user_is_founding_member as is_founding_member',
            'rcountry.country_code as seller_country', 'shop_id', 'IFNULL(shop_name, shop_identifier) as shop_name','shop_user_id',
        );

        $flds = array_merge($genFlds, $subFld);
        $prodSrch->addMultipleFields($flds);
      
        $productRs = $prodSrch->getResultSet();
        $recentViewedProducts = FatApp::getDb()->fetchAll($productRs, 'selprod_id');
		if(0< count($recentViewedProducts)) {
			foreach($recentViewedProducts as $key=>$prod) {
				$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $prod['shop_user_id'], array('spackage_id'));
				$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
				$recentViewedProducts[$key]['subscription_package_id'] = $currentActivePackageId;
				if ($currentActivePackageId > 0) {
					$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
					$recentViewedProducts[$key]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
				}
				
				$sellerProfileData = shopProfile::getSellerProfileData($prod['shop_user_id'], $this->siteLangId);
				$sellerType = (isset($sellerProfileData['sprofile_seller_type'])) ? $sellerProfileData['sprofile_seller_type'] : 0;				
				$recentViewedProducts[$key]['seller_type'] = $sellerType;
			}			
		}
		
        uksort(
                $recentViewedProducts, function ($key1, $key2) use ($cookiesProductsArr) {
            return (array_search($key1, $cookiesProductsArr) > array_search($key2, $cookiesProductsArr));
        }
        );
        return $recentViewedProducts;
    }

    public function recentlyViewedProducts($productId = 0)
    {
        $productId = FatUtility::int($productId);
        $recentViewedProducts = array();
        $cookieProducts = isset($_COOKIE['recentViewedProducts']) ? $_COOKIE['recentViewedProducts'] : false;
        if ($cookieProducts != false) {
            $cookiesProductsArr = explode("_", $cookieProducts);
            if (!isset($cookiesProductsArr) || !is_array($cookiesProductsArr) || count($cookiesProductsArr) <= 0) {
                return '';
            }
            if ($productId && in_array($productId, $cookiesProductsArr)) {
                $pos = array_search($productId, $cookiesProductsArr);
                unset($cookiesProductsArr[$pos]);
            }

            if (isset($cookiesProductsArr) && is_array($cookiesProductsArr) && count($cookiesProductsArr)) {
                $cookiesProductsArr = array_map('intval', $cookiesProductsArr);
                $cookiesProductsArr = array_reverse($cookiesProductsArr);
                $recentViewedProducts = $this->getRecentlyViewedProductsDetail($cookiesProductsArr);
            }
        }
        $this->set('recentViewedProducts', $recentViewedProducts);
        $this->_template->render(false, false);
    }

    public function relatedProductsById($ids = array())
    {
        $loggedUserId = UserAuthentication::getLoggedUserId(true);
        if (isset($ids) && is_array($ids) && count($ids)) {
            
            $prodSrch = new ProductSearch($this->siteLangId);
            $prodSrch->setDefinedCriteria();
            $prodSrch->joinProductToCategory();
            $prodSrch->joinSellerReturnAddress();
            $prodSrch->joinSellers();
            $prodSrch->joinSellerSubscription(0, false, true);
            $prodSrch->doNotCalculateRecords();
            $subFld = [];
            if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
                $subFld = array('spplan_spackage_id as subscription_package_id');
            }
            if (API_CALL) {
                $prodSrch->joinTable(SelProdReview::DB_TBL, 'LEFT OUTER JOIN', 'spr.spreview_selprod_id = selprod_id AND spr.spreview_product_id = product_id', 'spr');
                $prodSrch->joinTable(SelProdRating::DB_TBL, 'LEFT OUTER JOIN', 'sprating.sprating_spreview_id = spr.spreview_id', 'sprating');
                $prodSrch->addFld(array('COALESCE(ROUND(AVG(sprating_rating),2),0) as prod_rating'));
                $prodSrch->addGroupBy('selprod_id');
            }
            $prodSrch->setPageSize(20);
            if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
                $prodSrch->joinFavouriteProducts($loggedUserId);
                $prodSrch->addFld('IFNULL(ufp_id, 0) as ufp_id');
            } else {
                $prodSrch->joinUserWishListProducts($loggedUserId);
                $prodSrch->addFld('COALESCE(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
            }
            $prodSrch->addCondition('selprod_id', 'IN', $ids);
            $genFlds = array(
                'shop_user_id','shop_is_buy_now', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers', 'selprod_updated_on', 'selprod_type',  'product_id', 'COALESCE(product_name, product_identifier) as product_name', 'prodcat_id', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'product_updated_on', 'COALESCE(selprod_title,product_name, product_identifier) as selprod_title',
                'selprod_id', 'selprod_condition', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'theprice',
                'special_price_found', 'splprice_display_list_price', 'splprice_display_dis_val', 'splprice_display_dis_type', 'selprod_sold_count', 'selprod_price','selprod_user_id',
                'seller_user.user_is_verified as seller_verified', 'seller_user.user_is_founding_member as is_founding_member', 'rcountry.country_code as seller_country', 'seller_user.user_name', 'shop_id', 'IFNULL(shop_name, shop_identifier) as shop_name'
            );
            $flds = array_merge($subFld, $genFlds);
            $prodSrch->addMultipleFields($flds);
            $productRs = $prodSrch->getResultSet();
            $products = FatApp::getDb()->fetchAll($productRs, 'selprod_id');

			if(count($products)>0) {
				foreach($products as $keys=>$prod) {
					$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $prod['shop_user_id'], array('spackage_id'));
					$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
					$products[$keys]['subscription_package_id'] = $currentActivePackageId;
					if ($currentActivePackageId > 0) {
						$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
						$products[$keys]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
					}
				}
			}


            uksort(
                    $products, function ($key1, $key2) use ($ids) {
                return (array_search($key1, $ids) > array_search($key2, $ids));
            }
            );
            return $products;
        }
    }

    public function searchProducttagsAutocomplete()
    {
        $keyword = FatApp::getPostedData("keyword");	
        $arr = explode(' ', $keyword);
        $arr_keywords = array();
        foreach ($arr as $value) {
            $value = trim($value);
            if (strlen($value) < 3) {
                continue;
            }
            $arr_keywords[] = $value;
        }
		$keywordLength = mb_strlen($keyword);
		
		$srch = new ProductSearch($this->siteLangId);
		$srch->joinSellerProducts(0, '', ['product_tag_autocomplete'=>true], true);
		$cnd = $srch->addCondition('product_isbn', 'LIKE', '%' . $keyword . '%');		
        if (count($arr_keywords) > 0) {
            if ($keywordLength <= 80) {
                foreach ($arr_keywords as $value) {
                    $cnd->attachCondition('product_tags_string', 'LIKE', '%' . $value . '%');
					$cnd->attachCondition('selprod_tags_string', 'LIKE', '%' . $value . '%');
                    $cnd->attachCondition('selprod_title', 'LIKE', '%' . $value . '%');
                    $cnd->attachCondition('product_name', 'LIKE', '%' . $value . '%');
                    $cnd->attachCondition('brand_name', 'LIKE', '%' . $value . '%');
                    $cnd->attachCondition('prodcat_name', 'LIKE', '%' . $value . '%');
					$cnd->attachCondition("product_identifier", "LIKE", '%' . $value . '%');
                }
            }
        }		
		
		$srch->addMultipleFields(array('COALESCE(selprod_title) as value'));
		$srch->joinProductToCategory($this->siteLangId);
		$srch->joinBrands($this->siteLangId);
        $srch->doNotCalculateRecords();
		$srch->setPageSize(10);		
		$rs = $srch->getResultSet(); 
        $tags = FatApp::getDb()->fetchAll($rs); 

        if (API_CALL) {
            $this->set('suggestions', $tags);
            $this->_template->render();
            die;
        }
        $json = array();
        foreach ($tags as $key => $tag) {
            $json[] = array(
                'value' => strip_tags(html_entity_decode($tag['value'], ENT_QUOTES, 'UTF-8'))
            );
        }
        die(json_encode($json));
    }

    public function getBreadcrumbNodes($action)
    {
        $nodes = array();
        $parameters = FatApp::getParameters();
        switch ($action) {
            case 'view':
                if (isset($parameters[0]) && FatUtility::int($parameters[0]) > 0) {
                    $selprod_id = FatUtility::int($parameters[0]);
                    if ($selprod_id) {
                        $productType = SellerProduct::getAttributesById($selprod_id, 'selprod_type');
                        $row = [];
                        if ($productType == SellerProduct::PRODUCT_TYPE_PRODUCT) {
                            $srch = new ProductSearch($this->siteLangId);
                            $srch->joinSellerProducts();
                            $srch->joinProductToCategory();
                            $srch->doNotCalculateRecords();
                            $srch->doNotLimitRecords();
                            $srch->addMultipleFields(array('COALESCE(selprod_title, product_name, product_identifier) as selprod_title', 'COALESCE(product_name, product_identifier)as product_name', 'prodcat_code'));
                            $srch->addCondition('selprod_id', '=', $selprod_id);
                            $rs = $srch->getResultSet();
                            $row = FatApp::getDb()->fetch($rs);
                        } else {
                            $srch = new ServiceSearch($this->siteLangId);
                            $srch->joinSellers();
                            $srch->joinSellerSubscription();
                            $srch->joinShops();
                            $srch->joinServiceCategory();
                            $srch->addCondition('selprod_id', '=', $selprod_id);
                            $srch->addMultipleFields(array('selprod_title', 'prodcat_code'));
                            $rs = $srch->getResultSet();
                            $row = FatApp::getDb()->fetch($rs);
                        }
                        if ($row) {
                            $productCatCode = $row['prodcat_code'];
                            $productCatCode = explode("_", $productCatCode);
                            $productCatCode = array_filter($productCatCode, 'strlen');
                            $productCatObj = new ProductCategory();
                            $prodCategories = $productCatObj->getCategoriesForSelectBox($this->siteLangId, '', $productCatCode);

                            foreach ($productCatCode as $code) {
                                $code = FatUtility::int($code);
                                if (isset($prodCategories[$code]['prodcat_name'])) {
                                    $prodCategories[$code]['prodcat_name'];
                                    $nodes[] = array('title' => $prodCategories[$code]['prodcat_name'], 'href' => CommonHelper::generateUrl('category', 'view', array($code)));
                                }
                            }
                            $nodes[] = array('title' => ($row['selprod_title']) ? $row['selprod_title'] : $row['product_name']);
                        }
                    }
                }
                break;
            default:
                $nodes[] = array('title' => Labels::getLabel('LBL_' . FatUtility::camel2dashed($action), $this->siteLangId));
                break;
        }
        return $nodes;
    }

    public function logWeightage()
    {
        $post = FatApp::getPostedData();
        if (!isset($post['selprod_code']) || empty($post['selprod_code'])) {
            return false;
        }
        $selprod_code = $post['selprod_code'];
        $weightageKey = SmartWeightageSettings::PRODUCT_VIEW;
        if (isset($post['timeSpend']) && $post['timeSpend'] == true) {
            $weightageKey = SmartWeightageSettings::PRODUCT_TIME_SPENT;
        }
        $weightageSettings = SmartWeightageSettings::getWeightageAssoc();
        Product::recordProductWeightage($selprod_code, $weightageKey, $weightageSettings[$weightageKey]);
    }

    private function getCartForm($formLangId)
    {
        $frm = new Form('frmBuyProduct', array('id' => 'frmBuyProduct'));
        $fld = $frm->addTextBox(Labels::getLabel('LBL_Quantity', $formLangId), 'quantity', 1, array('maxlength' => '3'));
        $fld->requirements()->setIntPositive();
        $frm->addHTML(null, 'btnProductBuy', '<button name="btnProductBuy" type="submit" id="btnProductBuy" class="btn btn--primary btn--block block-on-mobile w-inh add-to-cart--js btnBuyNow"> ' . Labels::getLabel('LBL_Buy_Now', $formLangId) . '</button>');
        $frm->addHTML(null, 'btnAddToCart', '<button name="btnAddToCart" type="submit" id="btnAddToCart" class="btn btn--bordered-primary btn--block block-on-mobile w-inh add-to-cart--js btn--primary-border"> <span class="site-icon site-icon--small mr-2">
        <svg xmlns="http://www.w3.org/2000/svg" width="15.504" height="15.703" viewBox="0 0 15.504 15.703">
            <path d="M3.448,12.135V3.448H2V2H4.172a.724.724,0,0,1,.724.724v8.687h9L15.348,5.62h-9V4.172h9.932a.724.724,0,0,1,.7.9l-1.81,7.239a.724.724,0,0,1-.7.548H4.172A.724.724,0,0,1,3.448,12.135ZM4.9,17.2a1.448,1.448,0,1,1,1.448-1.448A1.448,1.448,0,0,1,4.9,17.2Zm8.687,0a1.448,1.448,0,1,1,1.448-1.448A1.448,1.448,0,0,1,13.583,17.2Z" transform="translate(-1.75 -1.75)"></path>
        </svg>                                                      
        </span>' . Labels::getLabel('LBL_Add_to_Cart', $formLangId) . '</button>');
        $frm->addHiddenField('', 'selprod_id');
        return $frm;
    }

    private function getReviewSearchForm($pageSize = 10)
    {
        $frm = new Form('frmReviewSearch');
        $frm->addHiddenField('', 'selprod_id');
        $frm->addHiddenField('', 'page');
        $frm->addHiddenField('', 'pageSize', $pageSize);
        $frm->addHiddenField('', 'orderBy', 'most_helpful');
        return $frm;
    }

    public function fatActionCatchAll($action)
    {
        FatUtility::exitWithErrorCode(404);
    }

    public function track($productId = 0)
    {
        $productId = FatUtility::int($productId);
        if (1 > $productId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl(''));
        }
        $loggedUserId = UserAuthentication::getLoggedUserId(true);
        /* Track Click */
        $prodObj = new PromotionSearch($this->siteLangId, true);
        $prodObj->joinProducts();
        $prodObj->joinActiveUser();
        $prodObj->joinShops();
        $prodObj->addPromotionTypeCondition(Promotion::TYPE_PRODUCT);
        $prodObj->addShopActiveExpiredCondition();
        $prodObj->joinUserWallet();
        $prodObj->joinBudget();
        $prodObj->addBudgetCondition();
        $prodObj->doNotCalculateRecords();
        $prodObj->addMultipleFields(array('selprod_id as proSelProdId', 'promotion_id'));
        $prodObj->addCondition('promotion_record_id', '=', $productId);
        $prodObj->addCondition('promotion_deleted', '=', AppConstants::NO);
        
        $productSrchObj = new ProductSearch($this->siteLangId);
        $productSrchObj->joinProductToCategory($this->siteLangId, true, true, true, false);
        $productSrchObj->doNotCalculateRecords();
        $productSrchObj->setPageSize(10);
        $productSrchObj->setDefinedCriteria();

        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $productSrchObj->joinFavouriteProducts($loggedUserId);
            $productSrchObj->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $productSrchObj->joinUserWishListProducts($loggedUserId);
            $productSrchObj->addFld('COALESCE(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }
        $productSrchObj->joinProductRating();
        $productSrchObj->addMultipleFields(
                array('product_id', 'selprod_id', 'COALESCE(product_name, product_identifier) as product_name', 'COALESCE(selprod_title, product_name, product_identifier) as selprod_title',
                    'special_price_found', 'splprice_display_list_price', 'splprice_display_dis_val', 'splprice_display_dis_type',
                    'theprice', 'selprod_price', 'selprod_stock', 'selprod_condition', 'prodcat_id', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'COALESCE(sq_sprating.prod_rating,0) prod_rating ', 'selprod_sold_count')
        );

        $productCatSrchObj = ProductCategory::getSearchObject(false, $this->siteLangId);
        $productCatSrchObj->doNotCalculateRecords();
        $productCatSrchObj->addMultipleFields(array('prodcat_id', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'prodcat_description'));
        $productSrchObj->joinTable('(' . $prodObj->getQuery() . ') ', 'INNER JOIN', 'selprod_id = ppr.proSelProdId ', 'ppr');
        $productSrchObj->addFld(array('promotion_id'));
        $productSrchObj->joinSellerSubscription();
        $productSrchObj->addSubscriptionValidCondition();
        $productSrchObj->addGroupBy('selprod_id');
        $row = FatApp::getDb()->fetch($productSrchObj->getResultSet());
        $url = CommonHelper::generateFullUrl('products', 'view', array($productId));
        if ($row == false) {
            if (!filter_var($url, FILTER_VALIDATE_URL) === false) {
                FatApp::redirectUser($url);
            }
        }

        if (Promotion::isUserClickCountable($loggedUserId, $row['promotion_id'], $_SERVER['REMOTE_ADDR'], session_id())) {
            $promotionClickData = array(
                'pclick_promotion_id' => $row['promotion_id'],
                'pclick_user_id' => $loggedUserId,
                'pclick_datetime' => date('Y-m-d H:i:s'),
                'pclick_ip' => $_SERVER['REMOTE_ADDR'],
                'pclick_cost' => Promotion::getPromotionCostPerClick(Promotion::TYPE_PRODUCT),
                'pclick_session_id' => session_id(),
            );

            FatApp::getDb()->insertFromArray(Promotion::DB_TBL_CLICKS, $promotionClickData, false, [], $promotionClickData);
            $clickId = FatApp::getDb()->getInsertId();
            $promotionClickChargesData = array(
                'picharge_pclick_id' => $clickId,
                'picharge_datetime' => date('Y-m-d H:i:s'),
                'picharge_cost' => Promotion::getPromotionCostPerClick(Promotion::TYPE_PRODUCT),
            );
            FatApp::getDb()->insertFromArray(Promotion::DB_TBL_ITEM_CHARGES, $promotionClickChargesData, false);
            $promotionLogData = array(
                'plog_promotion_id' => $row['promotion_id'],
                'plog_date' => date('Y-m-d'),
                'plog_clicks' => 1,
            );
            $onDuplicatePromotionLogData = array_merge($promotionLogData, array('plog_clicks' => 'mysql_func_plog_clicks+1'));
            FatApp::getDb()->insertFromArray(Promotion::DB_TBL_LOGS, $promotionLogData, true, array(), $onDuplicatePromotionLogData);
        }

        if (!filter_var($url, FILTER_VALIDATE_URL) === false) {
            FatApp::redirectUser($url);
        }

        FatApp::redirectUser(CommonHelper::generateUrl(''));
    }

    public function setUrlString()
    {
        $urlString = FatApp::getPostedData('urlString', FatUtility::VAR_STRING, '');
        if ($urlString != '') {
            $_SESSION['referer_page_url'] = rtrim($urlString, '/') . '/';
        }
    }

    public function sellers($selprod_id)
    {
        $selprod_id = FatUtility::int($selprod_id);
        $prodSrchObj = new ProductSearch($this->siteLangId);

        /* fetch requested product[ */
        $prodSrch = clone $prodSrchObj;
        $prodSrch->setDefinedCriteria(0, 0, array(), false);
        $prodSrch->joinProductToCategory();
        $prodSrch->joinSellerSubscription();
        $prodSrch->addSubscriptionValidCondition();
        $prodSrch->doNotCalculateRecords();
        $prodSrch->addCondition('selprod_id', '=', $selprod_id);
        $prodSrch->doNotLimitRecords();

        /* sub query to find out that logged user have marked current product as in wishlist or not[ */
        $selProdReviewObj = new SelProdReviewSearch();
        $selProdReviewObj->joinSelProdRating();
        $selProdReviewObj->addCondition('sprating_rating_type', '=', SelProdRating::TYPE_PRODUCT);
        $selProdReviewObj->doNotCalculateRecords();
        $selProdReviewObj->doNotLimitRecords();
        $selProdReviewObj->addGroupBy('spr.spreview_product_id');
        $selProdReviewObj->addCondition('spr.spreview_status', '=', SelProdReview::STATUS_APPROVED);
        $selProdReviewObj->addMultipleFields(array('spr.spreview_selprod_id', 'spr.spreview_product_id', "ROUND(AVG(sprating_rating),2) as prod_rating", "count(spreview_id) as totReviews"));
        $selProdRviewSubQuery = $selProdReviewObj->getQuery();
        $prodSrch->joinTable('(' . $selProdRviewSubQuery . ')', 'LEFT OUTER JOIN', 'sq_sprating.spreview_product_id = product_id', 'sq_sprating');

        $genFlds = array(
            'product_id', 'COALESCE(product_name,product_identifier ) as product_name', 'product_seller_id',
            'product_model', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'product_upc',
            'product_isbn', 'product_short_description', 'product_description', 'selprod_id', 'selprod_user_id',
            'selprod_code', 'selprod_condition', 'selprod_price', 'special_price_found', 'splprice_start_date',
            'splprice_end_date', 'COALESCE(selprod_title,product_name,product_identifier) as selprod_title',
            'selprod_warranty', 'selprod_return_policy', 'selprodComments', 'theprice', 'selprod_stock',
            'selprod_threshold_stock_level', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'brand_id',
            'COALESCE(brand_name, brand_identifier) as brand_name', 'brand_short_description', 'user_name',
            'shop_id', 'shop_name', 'COALESCE(sq_sprating.prod_rating,0) prod_rating ',
            'COALESCE(sq_sprating.totReviews,0) totReviews', 'splprice_display_dis_type',
            'splprice_display_dis_val', 'splprice_display_list_price', 'product_attrgrp_id',
            'product_youtube_video', 'product_cod_enabled', 'selprod_cod_enabled');

        $prodSrch->addMultipleFields($genFlds);

        $productRs = $prodSrch->getResultSet();
        $product = FatApp::getDb()->fetch($productRs);
        /* ] */
        if (!$product) {
            FatUtility::exitWithErrorCode(404);
        }
        /* more sellers[ */
        $product['moreSellersArr'] = $this->getMoreSeller($product['selprod_code'], $this->siteLangId);

        foreach ($product['moreSellersArr'] as $key=>$seller) {
            if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
                $product['rating'][$seller['selprod_user_id']] = SelProdRating::getSellerRating($seller['selprod_user_id']);
            } else {
                $product['rating'][$seller['selprod_user_id']] = 0;
            }

            /* [ Check COD enabled */
            $codEnabled = false;
            if (Product::isProductShippedBySeller($seller['product_id'], $seller['product_seller_id'], $seller['selprod_user_id'])) {
                if ($product['selprod_cod_enabled']) {
                    $codEnabled = true;
                }
            } else {
                if ($product['product_cod_enabled']) {
                    $codEnabled = true;
                }
            }
            $product['cod'][$seller['selprod_user_id']] = $codEnabled;
			
			
			$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $seller['selprod_user_id'], array('spackage_id'));
			$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
			$product['moreSellersArr'][$key]['subscription_package_id'] = $currentActivePackageId;
			if ($currentActivePackageId > 0) {
				$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
				$product['moreSellersArr'][$key]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
			}			
			
			
            /* ] */
        }
        /* ] */
        $this->set('product', $product);
        $this->_template->render();
    }

    public function productQuickDetail($selprod_id = 0)
    {
        $productImagesArr = array();
        $selprod_id = FatUtility::int($selprod_id);
        $prodSrchObj = new ProductSearch($this->siteLangId);

        /* fetch requested product[ */
        $prodSrch = clone $prodSrchObj;
        $prodSrch->setDefinedCriteria(false, false, array(), false);
        $prodSrch->joinProductToCategory();
        $prodSrch->joinSellerSubscription();
        $prodSrch->addSubscriptionValidCondition();
        $prodSrch->doNotCalculateRecords();
        $prodSrch->addCondition('selprod_id', '=', $selprod_id);
        $prodSrch->doNotLimitRecords();
        $selProdReviewObj = new SelProdReviewSearch();
        $selProdReviewObj->joinProducts($this->siteLangId);
        $selProdReviewObj->joinSellerProducts($this->siteLangId);
        $selProdReviewObj->joinSelProdRating();
        $selProdReviewObj->joinUser();
        $selProdReviewObj->joinSelProdReviewHelpful();
        $selProdReviewObj->addCondition('sprating_rating_type', '=', SelProdRating::TYPE_PRODUCT);
        $selProdReviewObj->doNotCalculateRecords();
        $selProdReviewObj->doNotLimitRecords();
        $selProdReviewObj->addGroupBy('spr.spreview_product_id');
        $selProdReviewObj->addGroupBy('sprh_spreview_id');
        $selProdReviewObj->addCondition('spr.spreview_status', '=', SelProdReview::STATUS_APPROVED);
        $selProdReviewObj->addMultipleFields(array('spr.spreview_selprod_id', 'spr.spreview_product_id', "ROUND(AVG(sprating_rating),2) as prod_rating", "count(spreview_id) as totReviews"));
        $selProdRviewSubQuery = $selProdReviewObj->getQuery();
        $prodSrch->joinTable('(' . $selProdRviewSubQuery . ')', 'LEFT OUTER JOIN', 'sq_sprating.spreview_product_id = product_id', 'sq_sprating');
        /* sub query to find out that logged user have marked current product as in wishlist or not[ */
        $loggedUserId = UserAuthentication::getLoggedUserId(true);
        
        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $prodSrch->joinFavouriteProducts($loggedUserId);
            $prodSrch->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $prodSrch->joinUserWishListProducts($loggedUserId);
            $prodSrch->addFld('COALESCE(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }

        $prodSrch->addMultipleFields(
            array(
                'shop_is_buy_now', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers', 'product_id', 'product_identifier','selprod_is_shipping_required','selprod_document_required',
                    'COALESCE(product_name,product_identifier) as product_name', 'product_seller_id', 'product_model',
                    'product_type', 'prodcat_id', 'COALESCE(prodcat_name,prodcat_identifier) as prodcat_name',
                    'product_upc', 'product_isbn', 'product_short_description', 'product_description', 'selprod_id',
                    'selprod_user_id', 'selprod_code', 'selprod_condition', 'selprod_price', 'special_price_found',
                    'splprice_start_date', 'splprice_end_date',
                    'COALESCE(selprod_title,product_name, product_identifier) as selprod_title', 'selprod_warranty',
                    'selprod_return_policy', 'selprodComments', 'theprice', 'selprod_stock',
                    'selprod_threshold_stock_level', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'brand_id',
                    'COALESCE(brand_name, brand_identifier) as brand_name', 'brand_short_description', 'user_name',
                    'shop_id', 'shop_name', 'splprice_display_dis_type', 'splprice_display_dis_val',
                    'splprice_display_list_price', 'product_attrgrp_id', 'product_youtube_video', 'product_cod_enabled',
                'selprod_cod_enabled', 'selprod_available_from', 'selprod_min_order_qty', 'selprod_updated_on', 'shop_is_buy_now as is_buy_now', 'selprod_type','prod_rating','COALESCE(sq_sprating.totReviews,0) totReviews'
                )
        );

        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $prodSrch->addFld(array('spplan_spackage_id as subscription_package_id'));
        } else {
            $prodSrch->addFld(array('0 as subscription_package_id'));
        }
        /* echo $selprod_id; die; */
        $productRs = $prodSrch->getResultSet();
        $product = FatApp::getDb()->fetch($productRs);
        /* ] */

        if (!$product) {
            FatUtility::exitWithErrorCode(404);
        }

        /* over all catalog product reviews */
        $selProdReviewObj->addCondition('spreview_product_id', '=', $product['product_id']);
        $selProdReviewObj->addMultipleFields(array('count(spreview_postedby_user_id) totReviews', 'sum(if(sprating_rating=1,1,0)) rated_1', 'sum(if(sprating_rating=2,1,0)) rated_2', 'sum(if(sprating_rating=3,1,0)) rated_3', 'sum(if(sprating_rating=4,1,0)) rated_4', 'sum(if(sprating_rating=5,1,0)) rated_5'));

        $reviews = FatApp::getDb()->fetch($selProdReviewObj->getResultSet());
        /* CommonHelper::printArray($reviews); die; */
        $this->set('reviews', $reviews);


        $subscription = false;
        $allowed_images = -1;
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $product['selprod_user_id'], array('ossubs_images_allowed'));
            $allowed_images = $currentPlanData['ossubs_images_allowed'];
            $subscription = true;
        }

        /* Current Product option Values[ */
        $options = SellerProduct::getSellerProductOptions($selprod_id, false);
        /* CommonHelper::printArray($options);die(); */
        $productSelectedOptionValues = array();
        $productGroupImages = array();
        if ($options) {
            foreach ($options as $op) {
                /* Product UPC code [ */
                /* $product['product_upc'] = UpcCode::getUpcCode( $product['product_id'] , $op['selprodoption_optionvalue_id'] ); */
                /* ] */
                $images = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_PRODUCT_IMAGE, $product['product_id'], $op['selprodoption_optionvalue_id'], $this->siteLangId, true, '', $allowed_images);
                if ($images) {
                    $productImagesArr += $images;
                }
                $productSelectedOptionValues[$op['selprodoption_option_id']] = $op['selprodoption_optionvalue_id'];
            }
        }

        if ($productImagesArr) {
            foreach ($productImagesArr as $image) {
                $afileId = $image['afile_id'];
                if (!array_key_exists($afileId, $productGroupImages)) {
                    $productGroupImages[$afileId] = array();
                }
                $productGroupImages[$afileId] = $image;
            }
        }
        $product['selectedOptionValues'] = $productSelectedOptionValues;
        /* ] */

        if (isset($allowed_images) && $allowed_images > 0) {
            $universal_allowed_images_count = $allowed_images - count($productImagesArr);
        }

        $productUniversalImagesArr = array();
        if (empty($productGroupImages) || !$subscription || isset($universal_allowed_images_count)) {
            $universalImages = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_PRODUCT_IMAGE, $product['product_id'], -1, $this->siteLangId, true, '');
            /* CommonHelper::printArray($universalImages); die; */
            if ($universalImages) {
                if (isset($universal_allowed_images_count)) {
                    $images = array_slice($universalImages, 0, $universal_allowed_images_count);
                    $productUniversalImagesArr = $images;
                    $universal_allowed_images_count = $universal_allowed_images_count - count($productUniversalImagesArr);
                } elseif (!$subscription) {
                    $productUniversalImagesArr = $universalImages;
                }
            }
        }

        if ($productUniversalImagesArr) {
            foreach ($productUniversalImagesArr as $image) {
                $afileId = $image['afile_id'];
                if (!array_key_exists($afileId, $productGroupImages)) {
                    $productGroupImages[$afileId] = array();
                }
                $productGroupImages[$afileId] = $image;
            }
        }

        /* [ Product shipping cost */
        $shippingCost = 0;
        /* ] */

        /* more sellers[ */
        $product['moreSellersArr'] = $this->getMoreSeller($product['selprod_code'], $this->siteLangId, $product['selprod_user_id']);
        /* ] */

        $product['selprod_return_policies'] = SellerProduct::getSelprodPolicies($product['selprod_id'], PolicyPoint::PPOINT_TYPE_RETURN, $this->siteLangId);
        $product['selprod_warranty_policies'] = SellerProduct::getSelprodPolicies($product['selprod_id'], PolicyPoint::PPOINT_TYPE_WARRANTY, $this->siteLangId);

        /* Form buy product[ */
        $frm = $this->getCartForm($this->siteLangId);
        $frm->fill(array('selprod_id' => $selprod_id));
        $this->set('frmBuyProduct', $frm);
        /* ] */

        $optionSrchObj = clone $prodSrchObj;
        $optionSrchObj->setDefinedCriteria();
        $optionSrchObj->doNotCalculateRecords();
        $optionSrchObj->doNotLimitRecords();
        $optionSrchObj->joinTable(SellerProduct::DB_TBL_SELLER_PROD_OPTIONS, 'LEFT OUTER JOIN', 'selprod_id = tspo.selprodoption_selprod_id', 'tspo');
        $optionSrchObj->joinTable(OptionValue::DB_TBL, 'LEFT OUTER JOIN', 'tspo.selprodoption_optionvalue_id = opval.optionvalue_id', 'opval');
        $optionSrchObj->joinTable(Option::DB_TBL, 'LEFT OUTER JOIN', 'opval.optionvalue_option_id = op.option_id', 'op');
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)) {
            $validDateCondition = " and oss.ossubs_till_date >= '" . date('Y-m-d') . "'";
            $optionSrchObj->joinTable(Orders::DB_TBL, 'INNER JOIN', 'o.order_user_id=seller_user.user_id AND o.order_type=' . ORDERS::ORDER_SUBSCRIPTION . ' AND o.order_is_paid =1', 'o');
            $optionSrchObj->joinTable(OrderSubscription::DB_TBL, 'INNER JOIN', 'o.order_id = oss.ossubs_order_id and oss.ossubs_status_id=' . FatApp::getConfig('CONF_DEFAULT_SUBSCRIPTION_PAID_ORDER_STATUS') . $validDateCondition, 'oss');
        }
        $optionSrchObj->addCondition('product_id', '=', $product['product_id']);
        $optionSrch = clone $optionSrchObj;
        $optionSrch->joinTable(Option::DB_TBL . '_lang', 'LEFT OUTER JOIN', 'op.option_id = op_l.optionlang_option_id AND op_l.optionlang_lang_id = ' . $this->siteLangId, 'op_l');
        $optionSrch->addMultipleFields(array('option_id', 'option_is_color', 'COALESCE(option_name,option_identifier) as option_name'));
        $optionSrch->addCondition('option_id', '!=', 'NULL');
        $optionSrch->addCondition('selprodoption_selprod_id', '=', $selprod_id);
        $optionSrch->addGroupBy('option_id');
        $optionRs = $optionSrch->getResultSet();
        $optionRows = FatApp::getDb()->fetchAll($optionRs, 'option_id');
        if ($optionRows) {
            foreach ($optionRows as &$option) {
                $optionValueSrch = clone $optionSrchObj;
                $optionValueSrch->joinTable(OptionValue::DB_TBL . '_lang', 'LEFT OUTER JOIN', 'opval.optionvalue_id = opval_l.optionvaluelang_optionvalue_id AND opval_l.optionvaluelang_lang_id = ' . $this->siteLangId, 'opval_l');
                $optionValueSrch->addCondition('product_id', '=', $product['product_id']);
                $optionValueSrch->addCondition('option_id', '=', $option['option_id']);
                $optionValueSrch->addMultipleFields(array('COALESCE(product_name, product_identifier) as product_name', 'selprod_id', 'selprod_user_id', 'selprod_code', 'option_id', 'COALESCE(optionvalue_name,optionvalue_identifier) as optionvalue_name ', 'theprice', 'optionvalue_id', 'optionvalue_color_code'));
                $optionValueSrch->addGroupBy('optionvalue_id');
                $optionValueRs = $optionValueSrch->getResultSet();
                $optionValueRows = FatApp::getDb()->fetchAll($optionValueRs, 'optionvalue_id');
                $option['values'] = $optionValueRows;
            }
        }
		$this->setProductViewCommonData($product['shop_id']);
        $this->set('optionRows', $optionRows);
        $this->set('productSpecifications', $this->getProductSpecifications($product['product_id'], $this->siteLangId));
        $this->set('product', $product);
        $this->set('productImagesArr', $productGroupImages);
        $this->_template->render(false, false);
    }

    public function linksAutocomplete()
    {
        $prodCatObj = new ProductCategory();
        $post = FatApp::getPostedData();
        $arr_options = $prodCatObj->getProdCatTreeStructureSearch(0, $this->siteLangId, $post['keyword']);
        $json = array();
        foreach ($arr_options as $key => $product) {
            $json[] = array(
                'id' => $key,
                'name' => strip_tags(html_entity_decode($product, ENT_QUOTES, 'UTF-8'))
            );
        }
        die(json_encode($json));
    }

    private function getListingData($get)
    {
        $db = FatApp::getDb();
        $userId = UserAuthentication::getLoggedUserId(true);
        $page = 1;
        if (array_key_exists('page', $get)) {
            $page = max(FatUtility::int($get['page']), $page);
        }
        $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
        if (array_key_exists('pageSize', $get)) {
            $get['pageSize'] = FatUtility::int($get['pageSize']);
            $pageSize = $get['pageSize'] > 0 ? $get['pageSize'] : $pageSize;
        }

        $srch = Product::getListingObj($get, $this->siteLangId, $userId);
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
       
        $rs = $srch->getResultSet();
        $db = FatApp::getDb();
        $products = $db->fetchAll($rs);

        if($products) {
            foreach($products as $key=>$prod) {
                $products[$key]['shop_rating'] = SelProdRating::getSellerRating($prod['shop_user_id']);
                $currentActivePackageId = 0;
				
                $currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $prod['shop_user_id'], array('spackage_id'));
				if(!empty($currentPlanData)) {
					$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
				}
                $products[$key]['subscription_package_id'] = $currentActivePackageId;
                if ($currentActivePackageId > 0) {
                    $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
                    $products[$key]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
                }				
            }
        }        
        /* to show searched category data[ */
        $categoryId = null;
        $category = array();
        if (array_key_exists('category', $get)) {
            $categoryId = FatUtility::int($get['category']);
            if ($categoryId) {
                $productCategorySearch = new ProductCategorySearch($this->siteLangId);
                $productCategorySearch->addCondition('prodcat_id', '=', $categoryId);
                $productCategorySearch->addMultipleFields(array('prodcat_id', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name', 'prodcat_description', 'prodcat_code'));
                $productCategorySearchRs = $productCategorySearch->getResultSet();
                $category = $db->fetch($productCategorySearchRs);
                $category['banner'] = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_BANNER, $categoryId);
            }
        }
        /* ] */

        $data = array(
            'products' => $products,
            'category' => $category,
            'categoryId' => $categoryId,
            'postedData' => $get,
            'page' => $page,
            'pageCount' => $srch->pages(),
            'pageSize' => $pageSize,
            'recordCount' => $srch->recordCount(),
            'siteLangId' => $this->siteLangId
        );
        return $data;
    }

    public function getFilteredProducts()
    {
        $post = FatApp::getPostedData();
        $userId = UserAuthentication::getLoggedUserId(true);
        $post['join_price'] = 1;
        $page = 1;
        if (array_key_exists('page', $post)) {
            $page = max($page, FatUtility::int($post['page']));
        }
        $pageSize = !empty($post['pageSize']) ? FatUtility::int($post['pageSize']) : FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
        $srch = Product::getListingObj($post, $this->siteLangId, $userId);
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
        $rs = $srch->getResultSet();
        $db = FatApp::getDb();
        $products = $db->fetchAll($rs);

        $data = array(
            'products' => $products,
            'page' => $page,
            'pageCount' => $srch->pages(),
            'pageSize' => $pageSize,
            'recordCount' => $srch->recordCount()
        );
        $this->set('data', $data);
        $this->_template->render();
    }

    public function getOptions($selProdId)
    {
        $selProdId = FatUtility::int($selProdId);
        if (1 > $selProdId) {
            FatUtility::dieJsonError(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
        }
        $productId = SellerProduct::getAttributesById($selProdId, 'selprod_product_id', false);
        $options = SellerProduct::getSellerProductOptions($selProdId, false);
        $productSelectedOptionValues = array();
        if (is_array($options) && 0 < count($options)) {
            foreach ($options as $op) {
                $productSelectedOptionValues[$op['selprodoption_option_id']] = $op['selprodoption_optionvalue_id'];
            }
        }

        $prodSrchObj = new ProductSearch($this->siteLangId);
        $optionSrchObj = clone $prodSrchObj;
        $optionSrchObj->setDefinedCriteria();
        $optionSrchObj->joinTable(SellerProduct::DB_TBL_SELLER_PROD_OPTIONS, 'LEFT OUTER JOIN', 'selprod_id = tspo.selprodoption_selprod_id', 'tspo');
        $optionSrchObj->joinTable(OptionValue::DB_TBL, 'LEFT OUTER JOIN', 'tspo.selprodoption_optionvalue_id = opval.optionvalue_id', 'opval');
        $optionSrchObj->joinTable(Option::DB_TBL, 'LEFT OUTER JOIN', 'opval.optionvalue_option_id = op.option_id', 'op');

        $optionSrch = clone $optionSrchObj;
        $optionSrch->joinTable(Option::DB_TBL . '_lang', 'LEFT OUTER JOIN', 'op.option_id = op_l.optionlang_option_id AND op_l.optionlang_lang_id = ' . $this->siteLangId, 'op_l');
        $optionSrch->addMultipleFields(array('option_id', 'option_is_color', 'COALESCE(option_name,option_identifier) as option_name'));
        $optionSrch->addCondition('option_id', '!=', 'NULL');
        $optionSrch->addCondition('selprodoption_selprod_id', '=', $selProdId);
        $optionSrch->addGroupBy('option_id');

        $optionRs = $optionSrch->getResultSet();
        $optionRows = FatApp::getDb()->fetchAll($optionRs);

        if ($optionRows) {
            foreach ($optionRows as &$option) {
                $optionValueSrch = clone $optionSrchObj;
                $optionValueSrch->joinTable(OptionValue::DB_TBL . '_lang', 'LEFT OUTER JOIN', 'opval.optionvalue_id = opval_l.optionvaluelang_optionvalue_id AND opval_l.optionvaluelang_lang_id = ' . $this->siteLangId, 'opval_l');
                $optionValueSrch->addCondition('product_id', '=', $productId);
                $optionValueSrch->addCondition('option_id', '=', $option['option_id']);
                $optionValueSrch->addMultipleFields(array('COALESCE(product_name, product_identifier) as product_name', 'selprod_id', 'selprod_user_id', 'selprod_code', 'option_id', 'COALESCE(optionvalue_name,optionvalue_identifier) as optionvalue_name ', 'theprice', 'optionvalue_id', 'optionvalue_color_code'));
                $optionValueSrch->addGroupBy('optionvalue_id');
                $optionValueRs = $optionValueSrch->getResultSet();
                $optionValueRows = FatApp::getDb()->fetchAll($optionValueRs);

                foreach ($optionValueRows as $index => $opVal) {
                    $optionValueRows[$index]['isAvailable'] = 1;
                    if (is_array($productSelectedOptionValues) && !in_array($opVal['optionvalue_id'], $productSelectedOptionValues)) {
                        $optionUrl = Product::generateProductOptionsUrl($selProdId, $productSelectedOptionValues, $option['option_id'], $opVal['optionvalue_id'], $productId);
                        $optionUrlArr = explode("::", $optionUrl);
                        if (is_array($optionUrlArr) && count($optionUrlArr) == 2) {
                            $optionValueRows[$index]['isAvailable'] = 0;
                        }
                    }
                }

                $option['values'] = $optionValueRows;
            }
        }
        $this->set('options', $optionRows);
        $this->_template->render();
    }

    private function shopFaqs(int $shopId): array
    {
        $srch = Faq::getSearchObject($this->siteLangId);
        $srch->addCondition('faq_shop_id', '=', $shopId);
        $srch->doNotCalculateRecords();
        $rs = $srch->getResultSet();
        return FatApp::getDb()->fetchAll($rs);
    }

    public function serviceFilters()
    {
        $headerFormParamsAssocArr = FilterHelper::getParamsAssocArr();
        $categoryId = 0;
        if (array_key_exists('category', $headerFormParamsAssocArr)) {
            $categoryId = FatUtility::int($headerFormParamsAssocArr['category']);
        }

        $keyword = '';
        $langIdForKeywordSeach = 0;
        if (array_key_exists('keyword', $headerFormParamsAssocArr) && !empty($headerFormParamsAssocArr['keyword'])) {
            $keyword = $headerFormParamsAssocArr['keyword'];
            $langIdForKeywordSeach = $this->siteLangId;
        }

        $cacheKey = FilterHelper::getCacheKey($this->siteLangId, $headerFormParamsAssocArr);
        $headerFormParamsAssocArr['doNotJoinSpecialPrice'] = true;
        $prodSrchObj = $this->getFilterSearchObj($langIdForKeywordSeach, $headerFormParamsAssocArr);
        $prodSrchObj->doNotCalculateRecords();

        /* Categories Data[ */
        $categoriesArr = array();
        if (empty($keyword)) {
            $categoriesArr = FilterHelper::getServicesCategories($this->siteLangId, $categoryId, $cacheKey);
        }
        /* ] */
        $userId = UserAuthentication::getLoggedUserId(true);
        $priceArr = FilterHelper::getServicesPrice($headerFormParamsAssocArr, $this->siteLangId, $userId);
        $priceInFilter = false;
        $filterDefaultMinValue = $priceArr['minPrice'];
        $filterDefaultMaxValue = $priceArr['maxPrice'];

        if ($this->siteCurrencyId != FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1) || (array_key_exists('currency_id', $headerFormParamsAssocArr) && $headerFormParamsAssocArr['currency_id'] != $this->siteCurrencyId)) {
            $filterDefaultMinValue = CommonHelper::displayMoneyFormat($priceArr['minPrice'], false, false, false);
            $filterDefaultMaxValue = CommonHelper::displayMoneyFormat($priceArr['maxPrice'], false, false, false);
            $priceArr['minPrice'] = $filterDefaultMinValue;
            $priceArr['maxPrice'] = $filterDefaultMaxValue;
        }

        if (array_key_exists('price-min-range', $headerFormParamsAssocArr) && array_key_exists('price-max-range', $headerFormParamsAssocArr)) {
            $priceArr['minPrice'] = $headerFormParamsAssocArr['price-min-range'];
            $priceArr['maxPrice'] = $headerFormParamsAssocArr['price-max-range'];
            $priceInFilter = true;
        }

        if (array_key_exists('currency_id', $headerFormParamsAssocArr) && $headerFormParamsAssocArr['currency_id'] != $this->siteCurrencyId) {
            $priceArr['minPrice'] = CommonHelper::convertExistingToOtherCurrency($headerFormParamsAssocArr['currency_id'], $headerFormParamsAssocArr['price-min-range'], $this->siteCurrencyId, false);
            $priceArr['maxPrice'] = CommonHelper::convertExistingToOtherCurrency($headerFormParamsAssocArr['currency_id'], $headerFormParamsAssocArr['price-max-range'], $this->siteCurrencyId, false);
        }

        /* ] */
        $productFiltersArr = array('count_for_view_more' => FatApp::getConfig('CONF_COUNT_FOR_VIEW_MORE', FatUtility::VAR_INT, 5));
        $prodcatArr = array();
        if (array_key_exists('prodcat', $headerFormParamsAssocArr)) {
            $prodcatArr = $headerFormParamsAssocArr['prodcat'];
        }
        
        $countriesArr = FilterHelper::servicesCountries($this->siteLangId, $headerFormParamsAssocArr, false, true);
        $checkedCountriesArr = array();
        if (array_key_exists('country', $headerFormParamsAssocArr)) {
            $checkedCountriesArr = $headerFormParamsAssocArr['country'];
        }


        $this->set('shop_id', 0);
        $this->set('countriesArr', $countriesArr);
        $this->set('checkedCountriesArr', $checkedCountriesArr);
        $this->set('productFiltersArr', $productFiltersArr);
        $this->set('headerFormParamsAssocArr', $headerFormParamsAssocArr);
        $this->set('categoriesArr', $categoriesArr);
        $this->set('shopCatFilters', []);
        $this->set('prodcatArr', $prodcatArr);
        $this->set('priceArr', $priceArr);
        $this->set('priceInFilter', $priceInFilter);
        $this->set('filterDefaultMinValue', $filterDefaultMinValue);
        $this->set('filterDefaultMaxValue', $filterDefaultMaxValue);
        $this->set('layoutDirection', CommonHelper::getLayoutDirection());

        if (API_CALL) {
            $this->_template->render();
        }

        echo $this->_template->render(false, false, 'products/service-filters.php', true);
        exit;
    }

    private function loadServiceDetails(int $selprodId)
    {
        $srch = new ServiceSearch($this->siteLangId);
        $srch->joinSellers();
        $srch->joinSellerSubscription();
        $srch->joinShops();
        $srch->joinServiceCategory();
        $srch->addCondition('selprod_id', '=', $selprodId);
        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }
        $genFlds = array(
            'shop_is_buy_now', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers', 'prodcat_code', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name',
            'selprod_id', 'selprod_user_id', 'selprod_code', 'selprod_price', 'selprod_title',
            'user_name', 'seller_user.user_is_verified as seller_verified',
            'seller_user.user_is_founding_member as is_founding_member','shop_user_id',
            'rcountry.country_code as seller_country', 'shop_id', 'selprod_updated_on', 'selprod_features', 'selprod_type', 'seller_profile.sprofile_seller_type as seller_type', 'selprod_updated_on', 'selprod_is_shipping_required','selprod_document_required'
        ); 
        $flds = array_merge($subFld, $genFlds);
        $srch->addMultipleFields($flds);
        $productRs = $srch->getResultSet();
        $product = FatApp::getDb()->fetch($productRs);
        if (!$product) {
            if (API_CALL) {
                FatUtility::dieJsonError(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            }
            FatUtility::exitWithErrorCode(404);
        }
        $this->set('product', $product);
        $this->setProductViewCommonData($product['shop_id']);
        $shippingRates = [];
        if ($product['selprod_is_shipping_required']) {
            $shippingRates = Product::getProductShippingRates($product['selprod_id'], $this->siteLangId, 0, $product['selprod_user_id'], 0, 0, 0, $type = SellerProduct::PRODUCT_TYPE_SERVICE);
            
        }
        $this->set('shippingRates', $shippingRates);
        
		$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $product['shop_user_id'], array('spackage_id'));
		$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
		$this->set('subscription_package_id' , $currentActivePackageId);
        if ($currentActivePackageId > 0) {
            $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
            $this->set('subscription_package' , (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '');
        }		
		 $this->set('sellerStats', RequestForQuote::getSellerStates($product['shop_user_id']));
        $this->_template->addJs(array('js/slick.js', 'js/modaal.js', 'js/product-detail.js', 'js/xzoom.js', 'js/magnific-popup.js', 'products/page-js/view.js'));
        $this->_template->render(true, true, 'products/service-view.php');
    }

    private function setProductViewCommonData(int $shopId)
    {
        $srch = new ShopSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->doNotCalculateRecords();
        $srch->addMultipleFields(
                array('shop_id', 'shop_user_id', 'shop_ltemplate_id', 'shop_created_on',
                    'COALESCE(shop_name, shop_identifier) as shop_name', 'shop_description',
                    'shop_payment_policy', 'shop_delivery_policy', 'shop_refund_policy',
                    'COALESCE(shop_country_l.country_name,shop_country.country_code) as shop_country_name',
                    'COALESCE(shop_state_l.state_name,state_identifier) as shop_state_name', 'shop_city',
                    'shop_free_ship_upto', 'u.user_is_verified as seller_verified',
                    'u.user_is_founding_member as is_founding_member', 'shop_is_buy_now as is_buy_now', 'shop_seller_info')
        );
        $srch->addCondition('shop_id', '=', $shopId);
        $shopRs = $srch->getResultSet();
        $shop = FatApp::getDb()->fetch($shopRs);

        $shop_rating = 0;
        if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
            $shop_rating = SelProdRating::getSellerRating($shop['shop_user_id']);
        }

        $this->set('shop', $shop);
        $this->set('shop_rating', $shop_rating);
        $this->set('shopTotalReviews', SelProdReview::getSellerTotalReviews($shop['shop_user_id']));

        /* [ SELLER PROFILE DATA */
        $sellerProfileData = shopProfile::getSellerProfileData($shop['shop_user_id'], $this->siteLangId);
        $shop['shop_seller_info'] = empty($shop['shop_seller_info']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_COMPANY_INFO', $this->siteLangId),
            'description' => $shop['shop_seller_info'],
        );
        /* [ SHOP DOCUMENTS */
        $docObj = new ShopDocument($shopId);
        $docSrch = $docObj->getSearchObject($this->siteLangId);
        $docRs = $docSrch->getResultSet();
        $shopDocumentsArr = FatApp::getDb()->fetchAll($docRs);
        $shopDocuments = [];
        if (!empty($shopDocumentsArr)) {
            foreach ($shopDocumentsArr as $document) {
                $type = $document['shopdoc_type'];
                $shopDocuments[$type][] = $document;
            }
        }
        $this->set('shopDocuments', $shopDocuments);
        $this->set('sellerProfileData', $sellerProfileData);
        $this->set('faqs', $this->shopFaqs($shopId));
        $this->set('sellerTypeArr', ShopProfile::getSellerTypeArr($this->siteLangId));
        /* ] */
        /* ] */
        if (false === API_CALL) {
            $this->_template->addJs(array('js/slick.js', 'js/modaal.js', 'js/product-detail.js', 'js/xzoom.js', 'js/magnific-popup.js'));
        }
        $banners = BannerLocation::getPromotionalBanners(BannerLocation::PRODUCT_DETAIL_PAGE_BANNER, $this->siteLangId);
        $this->set('banners', $banners);
    }

    public function serviceCountriesFilters()
    {
        $post = FilterHelper::getParamsAssocArr();
        $post['doNotJoinSpecialPrice'] = true;
        $countriesCheckedArr = FilterHelper::selectedCountries($post);
        $cacheKey = FilterHelper::getCacheKey($this->siteLangId, $post);
        $countryFilter = FatCache::get('serviceCountryFilter' . $cacheKey, CONF_FILTER_CACHE_TIME, '.txt');
        if (!$countryFilter) {
            $countriesArr = FilterHelper::servicesCountries($this->siteLangId, $post, true);
            FatCache::set('serviceCountryFilter' . $cacheKey, serialize($countriesArr), '.txt');
        } else {
            $countriesArr = unserialize($countryFilter);
        }
        $this->set('countriesArr', $countriesArr);
        $this->set('countriesCheckedArr', $countriesCheckedArr);
        echo $this->_template->render(false, false, 'products/country-filters.php', true);
        exit;
    }

}
