<?php

class ShopProfileController extends SellerBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
    }

    /* NEW CUSTOMIZATIONS FOR SELLER PROFILE */

    public function profile()
    {
        $this->validUserShopCheck();
        $userId = $this->userParentId;
        $shopData = Shop::getAttributesByUserId($userId, ['shop_id', 'shop_country_id'], false);
        $shop_id = $shopData['shop_id'];
        $countryId = $shopData['shop_country_id'];
        $countryCode = Countries::getAttributesById($countryId, 'country_code');

        $sellerProfileData = ShopProfile::getSellerProfileData($userId, $this->siteLangId);
        $frm = $this->getProfileForm();
        $frm->fill($sellerProfileData);
        $this->set('shop_id', $shop_id);
        $this->set('frm', $frm);
        $this->set('language', Language::getAllNames());
        $this->set('countryCode', $countryCode);
        $this->_template->render(false, false);
    }

    public function setupProfile()
    {
        $this->validUserShopCheck();
        $this->userPrivilege->canEditShop(UserAuthentication::getLoggedUserId());
        $userId = $this->userParentId;

        $frm = $this->getProfileForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $shopObj = new ShopProfile();
        $dataToSave = [
            'sprofile_user_id' => $userId,
            'sprofile_seller_type' => $post['sprofile_seller_type'],
            /* 'sprofile_production_capacity' => $post['sprofile_production_capacity'],
              'sprofile_rnd_capacity' => $post['sprofile_rnd_capacity'],
              'sprofile_trade_capacity' => $post['sprofile_trade_capacity'], */
            'sprofile_company_video' => $post['sprofile_company_video'],
        ];

        if (!$shopObj->updateProfile($dataToSave)) {
            Message::addErrorMessage($shopObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('MSG_SET_UP_SUCCESSFULLY', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function profileLangForm(int $langId, int $autoFillLangData = 0)
    {
        $this->validUserShopCheck();
        $userId = FatUtility::int($this->userParentId);
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);
        $data = [];

        if (1 > $langId || 1 > $userId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $frm = $this->getProfileLangForm($langId);

        if (0 < $autoFillLangData) {
            $updateLangDataobj = new TranslateLangData(ShopProfile::DB_TBL_LANG);
            $translatedData = $updateLangDataobj->getTranslatedData($userId, $langId);
            if (empty($translatedData)) {
                Message::addErrorMessage($updateLangDataobj->getError());
                FatUtility::dieWithError(Message::getHtml());
            }
            $data = current($translatedData);
        } else {
            $data = ShopProfile::getSellerProfileData($userId, $langId);
        }

        $frm->fill($data);
        $this->set('shop_id', $shopId);
        $this->set('language', Language::getAllNames());
        $this->set('siteLangId', $this->siteLangId);
        $this->set('frm', $frm);
        $this->set('formLangId', $langId);
        $this->set('formLayout', Language::getLayoutDirection($langId));
        $this->_template->render(false, false);
    }

    public function setupProfileLang()
    {
        $this->userPrivilege->canEditShop(UserAuthentication::getLoggedUserId());
        $post = FatApp::getPostedData();
        $langId = $post['lang_id'];
        $userId = $this->userParentId;

        if ($userId == 0 || $langId == 0) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $frm = $this->getProfileLangForm($langId);
        $post = $frm->getFormDataFromArray($post);

        if (empty($post)) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $dataToSave = [
            'sprofilelang_sprofile_user_id' => $this->userParentId,
            'sprofilelang_lang_id' => $langId,
            'sprofile_production_process' => $post['sprofile_production_process'],
            'sprofile_advantages' => $post['sprofile_advantages'],
            'sprofile_quality_control' => $post['sprofile_quality_control'],
            'sprofile_shipping_package' => $post['sprofile_shipping_package'],
            'sprofile_production_capacity' => $post['sprofile_production_capacity'],
            'sprofile_rnd_capacity' => $post['sprofile_rnd_capacity'],
            'sprofile_trade_capacity' => $post['sprofile_trade_capacity'],
        ];

        $shopObj = new ShopProfile();
        if (!$shopObj->updateProfileLang($dataToSave)) {
            Message::addErrorMessage(Labels::getLabel($shopObj->getError(), $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $autoUpdateOtherLangsData = FatApp::getPostedData('auto_update_other_langs_data', FatUtility::VAR_INT, 0);
        if (0 < $autoUpdateOtherLangsData) {
            $updateLangDataobj = new TranslateLangData(ShopProfile::DB_TBL_LANG);
            if (false === $updateLangDataobj->updateTranslatedData($userId)) {
                Message::addErrorMessage($updateLangDataobj->getError());
                FatUtility::dieWithError(Message::getHtml());
            }
        }

        $newTabLangId = 0;
        $languages = Language::getAllNames();
        foreach ($languages as $langId => $langName) {
            $srch = new SearchBase(ShopProfile::DB_TBL_LANG);
            $srch->addCondition('sprofilelang_sprofile_user_id', '=', $userId);
            $srch->addCondition('sprofilelang_lang_id', '=', $langId);
            $srch->doNotCalculateRecords();
            $srch->doNotLimitRecords();
            $rs = $srch->getResultSet();
            $sellerProfileData = FatApp::getDb()->fetch($rs);
            if (!$sellerProfileData) {
                $newTabLangId = $langId;
                break;
            }
        }

        $this->set('langId', $newTabLangId);
        $this->set('msg', Labels::getLabel('MSG_Setup_successful', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function certificates(int $type = ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE)
    {
        $this->validUserShopCheck();
        $userId = $this->userParentId;
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);

        $this->set('type', $type);
        $this->set('shop_id', $shopId);
        $this->set('language', Language::getAllNames());
        $this->_template->render(false, false);
    }

    public function certificatesListing(int $type = ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE)
    {
        $this->validUserShopCheck();
        $userId = $this->userParentId;
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);
        $sdocObj = new ShopDocument($shopId);
        $srch = $sdocObj->getSearchObject($this->siteLangId);
        $srch->addCondition('shopdoc_type', '=', $type);
        $rs = $srch->getResultSet();
        $documents = FatApp::getDb()->fetchAll($rs);
        $this->set('shop_id', $shopId);
        $this->set('documents', $documents);
        $this->_template->render(false, false);
    }

    public function certificateForm(int $type = ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE, $shopDocId = 0)
    {
        $this->validUserShopCheck();
        $userId = $this->userParentId;
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);
        $data = ['shopdoc_id' => $shopDocId, 'shopdoc_type' => $type, 'shopdoc_shop_id' => $shopId];
        if ($shopDocId > 0) {
            $data = ShopDocument::getAttributesById($shopDocId);
            $allLanguagesData = ShopDocument::getAllLanguagesData($shopDocId);
            if (!empty($allLanguagesData)) {
                $data['shopdoc_name'] = $allLanguagesData;
            }
        }

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $languages = Language::getAllNames();
        $frm = $this->getCertificateForm();
        $frm->fill($data);

        unset($languages[$siteDefaultLangId]);
        $this->set('frm', $frm);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $this->set('otherLanguages', $languages);
        $this->_template->render(false, false);
    }

    public function setupCertificates()
    {
        $this->validUserShopCheck();
        $this->userPrivilege->canEditShop(UserAuthentication::getLoggedUserId());
        $frm = $this->getCertificateForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $shopDocId = FatUtility::int($post['shopdoc_id'], 0);
        $shopId = FatUtility::int($post['shopdoc_shop_id'], 0);
        $filesName = array_filter($_FILES['shopdoc_file']['name']);

        if (1 > $shopDocId && (!isset($_FILES['shopdoc_file']) || count($filesName) == 0)) {
            Message::addErrorMessage(Labels::getLabel('MSG_Document_File_is_required', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $db = FatApp::getDb();
        $db->startTransaction();

        unset($post['shopdoc_id']);
        $shopDocObj = new ShopDocument($shopId, $shopDocId);
        $shopDocObj->assignValues($post);
        if (!$shopDocObj->save()) {
            Message::addErrorMessage($shopDocObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $shopDocId = $shopDocObj->getMainTableRecordId();
        $shopdocNames = (isset($post['shopdoc_name'])) ? $post['shopdoc_name'] : [];
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $shopdocNames[$siteDefaultLangId] = $post['shopdoc_identifier'];
        if (!empty($shopdocNames)) {
            if (!$this->updateDocumentLangData($shopdocNames, $shopDocId, $shopId)) {
                $db->rollbackTransaction();
                FatUtility::dieJsonError(Message::getHtml());
            }
        }
        $allowedFileTypes = array('image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'application/pdf', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/msword');
        //echo'<pre>'; print_r($allowedFileTypes); echo'</pre>'; exit;

        if ($shopDocId > 0 && isset($_FILES['shopdoc_file']) && !empty($_FILES['shopdoc_file'])) {


            $files = $_FILES['shopdoc_file']['name'];
            $files = array_filter($files);
            /* [ VALIDATE FILES BEFORE UPLOADING */
            if (!empty($files)) {
                foreach ($files as $index => $file) {
                    $fileMimeType = mime_content_type($_FILES['shopdoc_file']['tmp_name'][$index]);
                    if (!in_array($fileMimeType, $allowedFileTypes)) {
                        $db->rollbackTransaction();
                        Message::addErrorMessage(Labels::getLabel('MSG_INVALID_FILE_TYPE', $this->siteLangId));
                        FatUtility::dieJsonError(Message::getHtml());
                    }
                }
                /* ] */
                foreach ($files as $index => $file) {
                    $fileHandlerObj = new AttachedFile();
                    if (!$res = $fileHandlerObj->saveAttachment($_FILES['shopdoc_file']['tmp_name'][$index], AttachedFile::FILETYPE_SHOP_DOCUMENT, $shopDocId, 0, $file, -1, false)) {
                        $db->rollbackTransaction();
                        Message::addErrorMessage($fileHandlerObj->getError());
                        FatUtility::dieJsonError(Message::getHtml());
                    }
                }
            }
        }
        $db->commitTransaction();
        $this->set('msg', Labels::getLabel('MSG_SET_UP_SUCCESSFULLY', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function deleteCertificate(int $shopDocId)
    {
        $userId = $this->userParentId;
        $data = ShopDocument::getAttributesById($shopDocId);
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);
        if (1 > $userId || (empty($data)) || (!empty($data) && $data['shopdoc_shop_id'] != $shopId)) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $shopDocObj = new ShopDocument($shopId, $shopDocId);
        if (!$shopDocObj->deleteRecord(true)) {
            Message::addErrorMessage($shopDocObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        $fileRow = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SHOP_DOCUMENT, $shopDocId);
        $filHandleObj = new AttachedFile();
        if (!$filHandleObj->deleteFile(AttachedFile::FILETYPE_SHOP_DOCUMENT, $shopDocId)) {
            Message::addErrorMessage($filHandleObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        if (!empty($fileRow)) {
            $fileFolder = AttachedFile::FILETYPE_SHOP_DOCUMENT_PATH;
            foreach ($fileRow as $file) {
                if (file_exists(CONF_UPLOADS_PATH . $fileFolder . $file['afile_physical_path'])) {
                    unlink(CONF_UPLOADS_PATH . $fileFolder . $file['afile_physical_path']);
                }
            }
        }

        $this->set('msg', Labels::getLabel('MSG_Document_Deleted_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function deleteCertificateFile(int $shopDocId, int $fileId)
    {
        $fileRow = AttachedFile::getAttributesById($fileId);
        $filHandleObj = new AttachedFile();
        if (!$filHandleObj->deleteFile(AttachedFile::FILETYPE_SHOP_DOCUMENT, $shopDocId, $fileId)) {
            Message::addErrorMessage($filHandleObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        if (!empty($fileRow)) {
            $fileFolder = AttachedFile::FILETYPE_SHOP_DOCUMENT_PATH;
            if (file_exists(CONF_UPLOADS_PATH . $fileFolder . $fileRow['afile_physical_path'])) {
                unlink(CONF_UPLOADS_PATH . $fileFolder . $fileRow['afile_physical_path']);
            }
        }

        $this->set('msg', Labels::getLabel('MSG_Document_File_Deleted_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function faqs()
    {
        $this->validUserShopCheck();
        $shopId = Shop::getAttributesByUserId($this->userParentId, 'shop_id', false);
        $this->set('shop_id', $shopId);
        $this->set('language', Language::getAllNames());
        $this->_template->render(false, false);
    }

    public function faqsListing()
    {
        $this->validUserShopCheck();
        $userId = $this->userParentId;
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);
        $pagesize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $srch = Faq::getSearchObject($this->siteLangId);
        $srch->addCondition('faq_shop_id', '=', $shopId);
        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);

        $this->set('faqs', $records);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->_template->render(false, false);
    }

    public function faqForm(int $faqId = 0)
    {
        $this->validUserShopCheck();
        $shopId = Shop::getAttributesByUserId($this->userParentId, 'shop_id', false);
        $data = array('faq_shop_id' => $shopId);
        if ($faqId > 0) {
            $data = Faq::getAttributesById($faqId);
        }

        $frm = $this->getFaqForm($shopId);
        $frm->fill($data);
        $this->set('shop_id', $shopId);
        $this->set('frm', $frm);
        $this->set('faqId', $faqId);
        $this->set('language', Language::getAllNames());
        $this->_template->render(false, false);
    }

    public function setupFaq()
    {
        $frm = $this->getFaqForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $faqId = FatUtility::int($post['faq_id']);
        unset($post['faq_id']);
        $faqObj = new Faq($faqId);
        $faqObj->assignValues($post);

        if (!$faqObj->save()) {
            Message::addErrorMessage($faqObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        $faqId = $faqObj->getMainTableRecordId();

        $newTabLangId = 0;
        if ($faqId > 0) {
            $languages = Language::getAllNames();
            foreach ($languages as $langId => $langName) {
                if (!$row = Faq::getAttributesByLangId($langId, $faqId)) {
                    $newTabLangId = $langId;
                    break;
                }
            }
        }

        $this->set('msg', Labels::getLabel('LBL_Faq_Setup_Successful', $this->siteLangId));
        $this->set('faqId', $faqId);
        $this->set('langId', $newTabLangId);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function faqLangForm(int $faqId = 0, int $langId = 0, int $autoFillLangData = 0)
    {
        $this->validUserShopCheck();
        if ($faqId == 0 || $langId == 0) {
            FatUtility::dieWithError(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
        }

        $faqLangFrm = $this->getFaqLangForm($langId);
        if (0 < $autoFillLangData) {
            $updateLangDataobj = new TranslateLangData(Faq::DB_TBL_LANG);
            $translatedData = $updateLangDataobj->getTranslatedData($faqId, $langId);
            if (false === $translatedData) {
                Message::addErrorMessage($updateLangDataobj->getError());
                FatUtility::dieWithError(Message::getHtml());
            }
            $langData = current($translatedData);
        } else {
            $langData = Faq::getAttributesByLangId($langId, $faqId);
        }

        $langData['faq_id'] = $faqId;
        $langData['lang_id'] = $langId;

        if ($langData) {
            $faqLangFrm->fill($langData);
        }

        $this->set('languages', Language::getAllNames());
        $this->set('faqId', $faqId);
        $this->set('langId', $langId);
        $this->set('frm', $faqLangFrm);
        $this->set('formLayout', Language::getLayoutDirection($langId));
        $this->_template->render(false, false);
    }

    public function setupFaqLang()
    {

        $post = FatApp::getPostedData();
        $faqId = FatUtility::int($post['faq_id']);
        $langId = FatUtility::int($post['lang_id']);

        if ($faqId == 0 || $langId == 0) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $frm = $this->getFaqLangForm($langId);
        $post = $frm->getFormDataFromArray($post);

        unset($post['faq_id']);
        unset($post['lang_id']);
        $data = array(
            'faqlang_lang_id' => $langId,
            'faqlang_faq_id' => $faqId,
            'faq_title' => $post['faq_title'],
            'faq_content' => $post['faq_content'],
        );

        $faqObj = new Faq($faqId);
        if (!$faqObj->updateLangData($langId, $data)) {
            Message::addErrorMessage($faqObj->getError());
            FatUtility::dieWithError(Message::getHtml());
        }

        $autoUpdateOtherLangsData = FatApp::getPostedData('auto_update_other_langs_data', FatUtility::VAR_INT, 0);
        if (0 < $autoUpdateOtherLangsData) {
            $updateLangDataobj = new TranslateLangData(Faq::DB_TBL_LANG);
            if (false === $updateLangDataobj->updateTranslatedData($faqId)) {
                Message::addErrorMessage($updateLangDataobj->getError());
                FatUtility::dieWithError(Message::getHtml());
            }
        }

        $newTabLangId = 0;
        $languages = Language::getAllNames();
        foreach ($languages as $langId => $langName) {
            if (!$row = Faq::getAttributesByLangId($langId, $faqId)) {
                $newTabLangId = $langId;
                break;
            }
        }

        $this->set('msg', Labels::getLabel('LBL_Faq_Setup_Successful', $this->siteLangId));
        $this->set('faqId', $faqId);
        $this->set('langId', $newTabLangId);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function deleteFaq(int $faqId)
    {
        $this->validUserShopCheck();
        if ($faqId < 1) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $userId = $this->userParentId;
        $shopId = Shop::getAttributesByUserId($userId, 'shop_id', false);

        $res = Faq::getAttributesById($faqId, array('faq_id', 'faq_shop_id'));
        if (empty($res) || ($res['faq_shop_id'] != $shopId)) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $faqObj = new Faq($faqId);
        $faqObj->assignValues(array(Faq::tblFld('deleted') => 1));
        if (!$faqObj->save()) {
            Message::addErrorMessage($faqObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('MSG_Record_Deleted_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function settings()
    {
        $this->validUserShopCheck();
        $shopId = Shop::getAttributesByUserId($this->userParentId, 'shop_id', false);
        $shopData = Shop::getAttributesById($shopId, array('shop_id', 'shop_is_buy_now', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers'));
        if (FatApp::getConfig('CONF_PRICE_HIDE_SETTING_ENABLED', FatUtility::VAR_INT, 0) == 1 && FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_GUEST_USERS', FatUtility::VAR_INT, 0) == AppConstants::YES && FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_LOGGED_IN_USERS', FatUtility::VAR_INT, 0) == AppConstants::YES) {
            $shopData['shop_is_buy_now'] = AppConstants::NO;
        }
        $frm = $this->getSettingsForm();
        $frm->fill($shopData);
        $this->set('shop_id', $shopId);
        $this->set('language', Language::getAllNames());
        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function setupSettings()
    {
        $this->userPrivilege->canEditShop(UserAuthentication::getLoggedUserId());
        $this->validUserShopCheck();
        $post = FatApp::getPostedData();
        $shopId = FatUtility::int($post['shop_id']);
        $frm = $this->getSettingsForm();
        $post = $frm->getFormDataFromArray($post);
        if (false === $post) {
            $this->renderJsonError(current($frm->getValidationErrors()));
        }
        unset($post['shop_id']);
        $post['shop_updated_on'] = date('Y-m-d H:i:s');


        if (FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_GUEST_USERS', FatUtility::VAR_INT, 0) == AppConstants::YES) {
            $post["shop_hide_price_for_guests"] = AppConstants::NO;
        }

        if (FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_LOGGED_IN_USERS', FatUtility::VAR_INT, 0) == AppConstants::YES) {
            $post["shop_hide_price_for_loginusers"] = AppConstants::NO;
        }

        if ($post["shop_is_buy_now"] == AppConstants::YES) {
            $post["shop_hide_price_for_guests"] = AppConstants::NO;
            $post["shop_hide_price_for_loginusers"] = AppConstants::NO;
        }

        $shopObj = new Shop($shopId);
        $shopObj->assignValues($post);
        if (!$shopObj->save()) {
            $this->renderJsonError($shopObj->getError());
        }
        CommonHelper::deleteCollectionCache();
        $this->renderJsonSuccess(Labels::getLabel('MSG_SHOP_SETTINGS_UPDATED_SUCCESSFULLY', $this->siteLangId));
    }

    private function validUserShopCheck()
    {
        $userId = $this->userParentId;
        $shop_id = 0;
        $shopDetails = Shop::getAttributesByUserId($userId, null, false);
        if (empty($shopDetails) || !false == $shopDetails && $shopDetails['shop_active'] != AppConstants::ACTIVE) {
            Message::addErrorMessage(Labels::getLabel('MSG_Your_shop_deactivated_contact_admin', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
    }

    private function getSettingsForm()
    {
        $optionArr = AppConstants::shopPermissionArray($this->siteLangId);
        $frm = new Form('frmStoreSettings');
        $frm->addHiddenField('', 'shop_id', 0);
        if (FatApp::getConfig('CONF_PRICE_HIDE_SETTING_ENABLED', FatUtility::VAR_INT, 0) == 1 && FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_GUEST_USERS', FatUtility::VAR_INT, 0) == 1 && FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_LOGGED_IN_USERS', FatUtility::VAR_INT, 0) == 1) {
            $msg = "<strong style='color:red;'>" . Labels::getLabel('LBL_Note:-_Store_Settings_are_disabled,_As_product_prices_are_hidden_by_Admin._Please_Contact_With_Administrator.', $this->siteLangId) . '</strong>';
            $frm->addHTML('', 'seller_message', $msg);
        }
        
        $frm->addRadioButtons(Labels::getLabel('LBL_Can_Buyer_place_an_order_directly?', $this->siteLangId), 'shop_is_buy_now', $optionArr, "", ["class" => "list-inline"], ["class" => "can_buy"]);
        if (FatApp::getConfig('CONF_PRICE_HIDE_SETTING_ENABLED', FatUtility::VAR_INT, 0) == 1) {
            if (FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_GUEST_USERS', FatUtility::VAR_INT, 0) == 0) {
                $frm->addCheckBox(Labels::getLabel("LBL_Yes", $this->siteLangId), 'shop_hide_price_for_guests', 1, [], false, 0);
            }
            if (FatApp::getConfig('CONF_PRODUCT_PRICE_DISABLED_FOR_LOGGED_IN_USERS', FatUtility::VAR_INT, 0) == 0) {
                $frm->addCheckBox(Labels::getLabel("LBL_Yes", $this->siteLangId), 'shop_hide_price_for_loginusers', 1, [], false, 0);
            }
        }
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->siteLangId));
        return $frm;
    }

    private function getFaqForm()
    {
        $frm = new Form('frmFaq');
        $frm->addHiddenField('', 'faq_faqcat_id', 0);
        $frm->addHiddenField('', 'faq_id', 0);
        $frm->addHiddenField('', 'faq_shop_id', 0);
        $frm->addRequiredField(Labels::getLabel('LBL_FAQ_Identifier', $this->siteLangId), 'faq_identifier');
        $activeInactiveArr = AppConstants::getActiveInactiveArr($this->siteLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Status', $this->siteLangId), 'faq_active', $activeInactiveArr, '', array(), '');
        $submitFld = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->siteLangId));
        $btnFld = $frm->addButton('', 'btn_cancel', Labels::getLabel('LBL_Cancel', $this->siteLangId), array());
        $submitFld->attachField($btnFld);
        return $frm;
    }

    private function getFaqLangForm($langId = 0)
    {
        $siteLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $langId = max($siteLangId, $langId);
        $frm = new Form('frmFaqLang');
        $frm->addHiddenField('', 'faqcat_id');
        $frm->addHiddenField('', 'faq_id');
        $frm->addSelectBox(Labels::getLabel('LBL_LANGUAGE', $this->siteLangId), 'lang_id', Language::getAllNames(), $langId, array(), '');
        $frm->addRequiredField(Labels::getLabel('LBL_Title', $this->siteLangId), 'faq_title');
        $frm->addTextArea(Labels::getLabel('LBL_Content', $this->siteLangId), 'faq_content');
        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        if (!empty($translatorSubscriptionKey) && $langId == $siteLangId) {
            $frm->addCheckBox(Labels::getLabel('LBL_UPDATE_OTHER_LANGUAGES_DATA', $this->siteLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Update', $this->siteLangId));
        return $frm;
    }

    private function updateDocumentLangData(array $shopdocNames, int $shopDocId, int $shopId): bool
    {
        if (empty($shopdocNames) || 1 > $shopDocId) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_LANGUAGE_DATA', $this->siteLangId));
            return false;
        }
        $shoDocObj = new ShopDocument($shopId, $shopDocId);
        foreach ($shopdocNames as $langId => $languageName) {
            if (trim($languageName) != '') {
                $dataToSave = [
                    'shopdoc_name' => $languageName
                ];
                if (!$shoDocObj->updateLangData($langId, $dataToSave)) {
                    Message::addErrorMessage($shoDocObj->getError());
                    return false;
                }
            }
        }
        return true;
    }

    private function getProfileForm()
    {
        $frm = new Form('frmSellerProfile');
        $langId = $this->siteLangId;
        $sellerTypeArr = ShopProfile::getSellerTypeArr($langId);
        $fld = $frm->addSelectBox(Labels::getLabel('LBL_Seller_Type', $langId), 'sprofile_seller_type', $sellerTypeArr, '', array(), Labels::getLabel('LBL_Seller_TYpe', $langId));
        $fld->requirements()->setRequired(true);
        /* $frm->addIntegerField(Labels::getLabel('LBL_Production_Capacity', $langId), 'sprofile_production_capacity', '', array());
          $frm->addIntegerField(Labels::getLabel('LBL_RND_Capacity', $langId), 'sprofile_rnd_capacity', '', array());
          $frm->addIntegerField(Labels::getLabel('LBL_Trade_Capacity', $langId), 'sprofile_trade_capacity', '', array());
         */
        $frm->addTextBox(Labels::getLabel('LBL_Company_Video_[_Youtube_URL_]', $langId), 'sprofile_company_video', '', array());
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->siteLangId));
        return $frm;
    }

    private function getProfileLangForm(int $formLangId)
    {
        $frm = new Form('frmSellerProfileLang');
        $frm->addSelectBox(Labels::getLabel('LBL_LANGUAGE', $this->siteLangId), 'lang_id', Language::getAllNames(), $formLangId, array(), '');

        $frm->addTextArea(Labels::getLabel('LBL_Production_Capacity', $this->siteLangId), 'sprofile_production_capacity', '', array());
        $frm->addTextArea(Labels::getLabel('LBL_RND_Capacity', $this->siteLangId), 'sprofile_rnd_capacity', '', array());
        $frm->addTextArea(Labels::getLabel('LBL_Trade_Capacity', $this->siteLangId), 'sprofile_trade_capacity', '', array());
        $frm->addTextArea(Labels::getLabel('LBL_Production_Process', $this->siteLangId), 'sprofile_production_process')->requirement->setRequired(true);
        $frm->addTextArea(Labels::getLabel('LBL_Advantages', $this->siteLangId), 'sprofile_advantages')->requirement->setRequired(true);
        $frm->addTextArea(Labels::getLabel('LBL_Shipping_Package', $this->siteLangId), 'sprofile_shipping_package', '', array())->requirement->setRequired(true);
        $frm->addTextArea(Labels::getLabel('LBL_Quality_Control_Process', $this->siteLangId), 'sprofile_quality_control', '', array())->requirement->setRequired(true);
        $siteLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');

        if (!empty($translatorSubscriptionKey) && $formLangId == $siteLangId) {
            $frm->addCheckBox(Labels::getLabel('LBL_UPDATE_OTHER_LANGUAGES_DATA', $this->siteLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_SAVE_CHANGES', $this->siteLangId));
        return $frm;
    }

    private function getCertificateForm()
    {
        $frm = new Form('frmSellerCertificate');
        $frm->addHiddenField('', 'shopdoc_id');
        $frm->addHiddenField('', 'shopdoc_type');
        $frm->addHiddenField('', 'shopdoc_shop_id');
        $frm->addRequiredField(Labels::getLabel('LBL_Document_Name', $this->siteLangId), 'shopdoc_identifier', '', array());
        $allowedFileTypes = 'image/png, image/jpeg, image/jpg, image/gif, application/pdf, application/vnd.openxmlformats-officedocument.wordprocessingml.document, application/msword, application/docx, application/doc';
        $frm->addFileUpload('', 'shopdoc_file[]', array('accept' => $allowedFileTypes, 'data-frm' => 'frmBannerMedia'));

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $languages = Language::getAllNames();
        unset($languages[$siteDefaultLangId]);
        foreach ($languages as $langId => $lang) {
            $fldCapString = sprintf(Labels::getLabel('LBL_Document_Name_[%s]', $this->siteLangId), $lang);
            $frm->addTextBox($fldCapString, 'shopdoc_name[' . $langId . ']', '');
        }

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_SAVE_CHANGES', $this->siteLangId));
        return $frm;
    }

}
