<?php

class ShopsController extends MyAppController
{

    //use CommonServices;

    public function __construct($action)
    {
        parent::__construct($action);
    }
	
    public function index()
    {
        $this->shopsData(__FUNCTION__);
    }

    public function search()
    {
        $this->shopsData(__FUNCTION__);
    }

    public function featured()
    {
        $this->shopsData(__FUNCTION__);
    }
	
    public function shopsData($method)
    {
		$get = Product::convertArrToSrchFiltersAssocArr(FatApp::getParameters());
		
        $db = FatApp::getDb();
        $data = $get;
        $page = 1;
        if (array_key_exists('page', $data)) {
            $page = max(FatUtility::int($data['page']), $page);
        }
        $pagesize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
        if (array_key_exists('pageSize', $data)) {
            $data['pageSize'] = FatUtility::int($data['pageSize']);
            $pagesize = $data['pageSize'] > 0 ? $data['pageSize'] : $pagesize;
        }

        $searchForm = $this->getShopSearchForm($this->siteLangId);
        $post = $searchForm->getFormDataFromArray($data);
		$searchForm->fill($get);
		
        /* SubQuery, Shop have products[ */
        $prodShopSrch = new ProductSearch($this->siteLangId);
        $prodShopSrch->setDefinedCriteria();
        $prodShopSrch->joinProductToCategory();
        $prodShopSrch->doNotCalculateRecords();
        $prodShopSrch->doNotLimitRecords();
        $prodShopSrch->joinSellerSubscription($this->siteLangId, true);
        $prodShopSrch->addSubscriptionValidCondition();

        if (isset($data['keyword']) && !empty($data['keyword'])) {
            $keyword = urldecode($data['keyword']);
			
			
			$arr = explode(' ', $keyword);
			$arr_keywords = array();
			foreach ($arr as $value) {
				$value = trim($value);
				if (strlen($value) < 3) {
					continue;
				}
				$arr_keywords[] = $value;
			}
			$keywordLength = mb_strlen($keyword);			
			$cnd = $prodShopSrch->addCondition('tag_name', 'LIKE', '%' . $keyword . '%');		
			if (count($arr_keywords) > 0) {
				if ($keywordLength <= 80) {
					foreach ($arr_keywords as $value) {
						$cnd->attachCondition('product_tags_string', 'LIKE', '%' . $value . '%');
						$cnd->attachCondition('selprod_tags_string', 'LIKE', '%' . $value . '%');
						$cnd->attachCondition('selprod_title', 'LIKE', '%' . $value . '%');
						$cnd->attachCondition('product_name', 'LIKE', '%' . $value . '%');
						$cnd->attachCondition("product_identifier", "LIKE", '%' . $value . '%'); 
						$cnd->attachCondition('shop_name', 'like', '%' . $value . '%');
						$cnd->attachCondition('shop_identifier', 'like', '%' . $value . '%');	
					}
				}
			}			
			
			
            $prodShopSrch->joinTable('tbl_product_to_tags', 'LEFT OUTER JOIN', 'ptt_product_id=product_id');
            $prodShopSrch->joinTable('tbl_tags', 'LEFT OUTER JOIN', 'tag_id=ptt_tag_id');
            $prodShopSrch->joinTable('tbl_tags_lang', 'LEFT OUTER JOIN', 'tag_id = taglang_tag_id AND taglang_lang_id = ' . $this->siteLangId);
            
        }

        $prodShopSrch->addMultipleFields(array('distinct(shop_id)'));
        $rskey = $prodShopSrch->getResultSet(); 
        $shopRows = FatApp::getDb()->fetchAll($rskey);

        $keywordshops = array_unique(array_column($shopRows, 'shop_id'));
        if (!empty($keywordshops)) {
            $prodShopSrch->addCondition('shop_id', 'in', $keywordshops);
        }

        $srch = new ShopSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->joinShopCountry();
        $srch->joinShopState();
        $srch->joinShopProfile();
        $srch->joinSellerSubscription();
        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }

		$featured=0;
        switch ($method) {
            case 'index':
                $arr = array(
                    'pageTitle' => Labels::getLabel('LBL_SUPPLIERS_Found', $this->siteLangId),
                    'canonicalUrl' => CommonHelper::generateFullUrl('Shops', 'index'),
                    'productSearchPageType' => SavedSearchProduct::PAGE_PRODUCT_INDEX,
                );
                break;
            case 'search':
                $arr = array(
                    'pageTitle' => Labels::getLabel('LBL_SUPPLIERS_Found_for', $this->siteLangId),
                    'canonicalUrl' => CommonHelper::generateFullUrl('Shops', 'search'),
                    'productSearchPageType' => SavedSearchProduct::PAGE_PRODUCT,
                    'keyword' => isset($post['keyword']) ? $post['keyword'] : '',
                    'seller_type' => (isset($get['sellertype'])) ? $get['sellertype'] : 0,
                );
                break;
            case 'featured':
                $arr = array(
                    'pageTitle' => Labels::getLabel('LBL_FEATURED_SUPPLIERS_Found', $this->siteLangId),
                    'canonicalUrl' => CommonHelper::generateFullUrl('Shops', 'featured'),
                    'productSearchPageType' => SavedSearchProduct::PAGE_FEATURED_PRODUCT,
                    'seller_type' => (isset($get['sellertype'])) ? $get['sellertype'] : 0,
                );
                $featured = 1;
                break;
        }


	
        /* [ SELLER TYPE CONDITION  */
        if (array_key_exists('sellertypes', $get) && $get['sellertypes'] > 0) {
            $srch->addCondition('sprofile.sprofile_seller_type', 'IN', $get['sellertypes']);
        }

        /* [ STORE LOCATION CONDITION  */
        if (array_key_exists('country', $get) && count($get['country']) > 0) {
            $srch->addCondition('shop_country.country_id', 'IN', $get['country']);
        }        

		/* [ SUPPLIER VERIFIED CONDITION  */
        if (array_key_exists('verified', $get) && $get['verified'] > 0) {
            $srch->addCondition('user_is_verified', '=', $get['verified']);
        }		
		
		/* [ SUPPLIER IS FOUNDING MEMBER CONDITION  */
        if (array_key_exists('foundingmember', $get) && $get['foundingmember'] > 0) {
            $srch->addCondition('user_is_founding_member', '=', $get['foundingmember']);
        }

		/* [ SUPPLIER IS GOLD MEMBER CONDITION  */
        if (array_key_exists('supplier', $get) && $get['supplier'] > 0) {
            if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
                $srch->addCondition('spplan_spackage_id', '=', 3);
            }
        }

		/* [ SUPPLIER RATING CONDITION  */
        if (array_key_exists('rating', $get) && count($get['rating']) > 0) {
			$ratingArr = $get['rating']; 
			$rateQry ='';
			foreach($ratingArr as $ratekey=> $rty) {
				$plusOne = $rty+1;
				if($ratekey>0) {
					$rateQry .= ' OR ';
				}
				$rateQry .= 'avg_rating BETWEEN '.$rty.' AND '.$plusOne.''; 	
			}
			
			$srch1 = new SelProdReviewSearch();
			$srch1->joinSeller();
			$srch1->joinSellerProducts();
			$srch1->joinSelProdRating();
			$srch1->addMultipleFields(array("ROUND(AVG(sprating_rating),1) as avg_rating, spreview_seller_user_id"));
			$srch1->addCondition('sprating_rating_type', 'in', array(SelProdRating::TYPE_SELLER_SHIPPING_QUALITY, SelProdRating::TYPE_SELLER_STOCK_AVAILABILITY, SelProdRating::TYPE_SELLER_PACKAGING_QUALITY));
			$srch1->doNotCalculateRecords();
			$srch1->doNotLimitRecords();
			$srch1->addCondition('spr.spreview_status', '=', SelProdReview::STATUS_APPROVED);
			$srch1->addGroupby('spreview_seller_user_id');		

			$sprateQuery = $srch1->getQuery();

			$srch->joinTable("($sprateQuery)", 'inner join', 'selRating.spreview_seller_user_id = shop_user_id and ('.$rateQry.') ', 'selRating');
        }
		//print_r($get); die;
        $srch->joinTable('(' . $prodShopSrch->getQuery() . ')', 'INNER JOIN', 'temp.shop_id = s.shop_id', 'temp');
//$srch->getQuery; die;
        $loggedUserId = 0;
        if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }

        /* sub query to find out that logged user have marked shops as favorite or not[ */
        $favSrchObj = new UserFavoriteShopSearch();
        $favSrchObj->doNotCalculateRecords();
        $favSrchObj->doNotLimitRecords();
        $favSrchObj->addMultipleFields(array('ufs_shop_id', 'ufs_id'));
        $favSrchObj->addCondition('ufs_user_id', '=', $loggedUserId);
        $srch->joinTable('(' . $favSrchObj->getQuery() . ')', 'LEFT OUTER JOIN', 'ufs_shop_id = s.shop_id', 'ufs');
        /* ] */

        $genFlds = array(
            's.shop_id', 'shop_user_id', 'shop_ltemplate_id', 'shop_created_on', 'IFNULL(shop_name, shop_identifier) as shop_name', 'shop_description',
            'shop_country_l.country_name as country_name', 'shop_state_l.state_name as state_name', 'shop_city',
            'IFNULL(ufs.ufs_id, 0) as is_favorite', 'sprofile_seller_type', 'user_is_verified as seller_verified',
            'user_is_founding_member as is_founding_member', 'shop_is_buy_now as is_buy_now', 'case when shop_founded_date!= "0000-00-00" then DATE_FORMAT(shop_founded_date, "%Y") else "" end as founded_year'
        );
 
        $flds = array_merge($genFlds, $subFld);
        $srch->addMultipleFields($flds); 
        if (0 < $featured) {
            $srch->addCondition('shop_featured', '=', $featured);
        }

        $page = (empty($page) || $page <= 0) ? 1 : $page;
        $page = FatUtility::int($page);
        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);

        $srch->addOrder('shop_created_on');
        $shopRs = $srch->getResultSet();
        $allShops = $db->fetchAll($shopRs, 'shop_id');

        $totalProdCountToDisplay = 3;

        $productSrchObj = new ProductSearch($this->siteLangId);
        $productSrchObj->setDefinedCriteria();
        $productSrchObj->joinProductToCategory($this->siteLangId);
        $productSrchObj->doNotCalculateRecords();

        $productSrchObj->joinSellerSubscription($this->siteLangId, true);
        $productSrchObj->addSubscriptionValidCondition();
        $productSrchObj->joinSellerReturnAddress();
        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }


        if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
            $productSrchObj->joinFavouriteProducts($loggedUserId);
            $productSrchObj->addFld('IFNULL(ufp_id, 0) as ufp_id');
        } else {
            $productSrchObj->joinUserWishListProducts($loggedUserId);
            $productSrchObj->addFld('IFNULL(uwlp.uwlp_selprod_id, 0) as is_in_any_wishlist');
        }

        $productSrchObj->addCondition('selprod_deleted', '=', AppConstants::NO);
        $genFlds = array(
            'product_id', 'selprod_id', 'IFNULL(product_name, product_identifier) as product_name', 'IFNULL(selprod_title  ,IFNULL(product_name, product_identifier)) as selprod_title', 'product_updated_on',
            'special_price_found', 'splprice_display_list_price', 'splprice_display_dis_val', 'splprice_display_dis_type',
            'theprice', 'selprod_price', 'selprod_stock', 'selprod_condition', 'prodcat_id', 'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name', 'selprod_sold_count', 'IF(selprod_stock > 0, 1, 0) AS in_stock',
            'seller_user.user_is_verified as seller_verified', 'seller_user.user_is_founding_member as is_founding_member', 'rcountry.country_code as seller_country', 'seller_user.user_name', 'selprod_user_id', 'shop_id',
            'IFNULL(shop_name, shop_identifier) as shop_name', 'selprod_type'
        );

        $flds = array_merge($genFlds, $subFld);
        $productSrchObj->addMultipleFields($flds);
        foreach ($allShops as $kem=>$val) {
            $productShopSrchTempObj = clone $productSrchObj;
            $productShopSrchTempObj->addCondition('selprod_user_id', '=', $val['shop_user_id']);
            $productShopSrchTempObj->addOrder('in_stock', 'DESC');
            $productShopSrchTempObj->addGroupBy('selprod_product_id');
            $productShopSrchTempObj->setPageSize(3);
            $Prs = $productShopSrchTempObj->getResultSet();
            $allShops[$val['shop_id']]['products'] = $db->fetchAll($Prs);
            $allShops[$val['shop_id']]['totalProducts'] = $productShopSrchTempObj->recordCount();
            $allShops[$val['shop_id']]['totalSales'] =  $this->getShopsSales($val['shop_user_id']);
			$allShops[$val['shop_id']]['reviews'] =  $this->shopReviewsRatings($val['shop_user_id']);
			
			$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $val['shop_user_id'], array('spackage_id'));
			$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
			$allShops[$val['shop_id']]['subscription_package_id'] = $currentActivePackageId;
			if ($currentActivePackageId > 0) {
				$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
				$allShops[$val['shop_id']]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
			}			
			
            $allShops[$val['shop_id']]['shop_logo'] = CommonHelper::generateFullFileUrl('image', 'shopLogo', [$val['shop_id'], $this->siteLangId, 'SMALL']);
        }

        $startRecord = ($page - 1) * $pagesize + 1;
        $endRecord = $pagesize;
        $totalRecords = $srch->recordCount();
        if ($totalRecords < $endRecord) {
            $endRecord = $totalRecords;
        }

        $data = array(
            'allShops' => $allShops,
            'keyword' => isset($post['keyword']) ? $post['keyword'] : '',
            'totalProdCountToDisplay' => $totalProdCountToDisplay,
            'pageCount' => $srch->pages(),
            'recordCount' => $srch->recordCount(),
            'page' => $page,
            'pageSize' => $pagesize,
            'postedData' => $get,
            'totalRecords' => $totalRecords,
            'siteLangId' => $this->siteLangId
        );
        
        $common = array(
            'frmProductSearch' => $searchForm,
            'recordId' => 0,
            'showBreadcrumb' => false
        );		
		
		$data = array_merge($data, $common, $arr); 
        if (FatUtility::isAjaxCall()) {
            $this->set('allShops', $data['allShops']);
            $this->set('page', $data['page']);
            $this->set('pageCount', $data['pageCount']);
            $this->set('postedData', $get);
            $this->set('recordCount', $srch->recordCount());
            $this->set('siteLangId', $this->siteLangId);
            echo $this->_template->render(false, false, 'shops/shops-list.php', true);
            exit;
        }		
		
		$obj = new Extrapage();
		$block1 = $obj->getContentByPageType(Extrapage::SHOPLISTINGPAGEBLOCK1, $this->siteLangId);
		$data['block1'] = $block1;
		
        $this->set('data', $data);
        $this->includeShopPageJsCss();
        $this->_template->addJs('js/slick.min.js');
        $this->_template->render(true, true, 'shops/index.php');		
    }	

    private function getSellersSubscriptionArray()
    {
        $subSrch = new ShopSearch($this->siteLangId);
        $subSrch->setDefinedCriteria($this->siteLangId);
        $subSrch->joinSellerSubscription($this->siteLangId);
        $subSrch->addSubscriptionValidCondition();
        $subSrch->joinSellerActiveSubscription($this->siteLangId);
        $subSrch->doNotCalculateRecords();
        $subSrch->doNotLimitRecords();
        $subRs = $subSrch->getResultSet();
        $subscriptionsArray = FatApp::getDb()->fetchAll($subRs);
        return $subscriptionsArray;
    }

    private function getSellersCountryArray()
    {
        $shopByProdTitleSrch = new ProductSearch($this->siteLangId);
        $shopByProdTitleSrch->setDefinedCriteria();
        $shopByProdTitleSrch->joinProductToCategory();
        $shopByProdTitleSrch->doNotCalculateRecords();
        $shopByProdTitleSrch->doNotLimitRecords();
        $shopByProdTitleSrch->joinSellerSubscription($this->siteLangId, true);
        $shopByProdTitleSrch->addSubscriptionValidCondition();
        $shopByProdTitleSrch->addMultipleFields(array('distinct(shop_id)'));
        $rskey = $shopByProdTitleSrch->getResultSet();
        $shopRows = FatApp::getDb()->fetchAll($rskey);
        $keywordshops = array_unique(array_column($shopRows, 'shop_id'));
        //echo $shopByProdTitleSrch->getQuery();
        /* ] */
        $ctrySrch = new ShopSearch($this->siteLangId);
        $ctrySrch->setDefinedCriteria($this->siteLangId);
        $ctrySrch->joinShopCountry();
        $ctrySrch->joinShopState();
        $ctrySrch->joinSellerSubscription();


        if (!empty($keywordshops)) {
            $ctrySrch->addDirectCondition('shop_id IN (' . implode(',', $keywordshops) . ')', 'AND');
        }
        $ctrySrch->doNotCalculateRecords();
        $ctrySrch->doNotLimitRecords();
        $ctrySrch->addGroupBy('shop_country.country_id');


        $ctryRs = $ctrySrch->getResultSet();
        $countriesArray = FatApp::getDb()->fetchAll($ctryRs);
        return $countriesArray;
    }


   /*  public function featured()
    {
        $searchForm = $this->getShopSearchForm($this->siteLangId);
        $params['featured'] = 1;
        $searchForm->fill($params);
        $this->set('searchForm', $searchForm);
        $this->_template->addJs('js/slick.js');
        $this->_template->render();
    } */
	
    private function getShopsSales($shopUserId)
    {
        $orderSrch = new OrderProductSearch($this->siteLangId, true, true);
        $orderSrch->doNotCalculateRecords();
        $orderSrch->doNotLimitRecords();
        $orderSrch->addSellerCompletedOrdersStats(false, false, 'totalSold');
        $orderSrch->addGroupBy('order_user_id');
        $orderSrch->addCondition('op_selprod_user_id', '=', $shopUserId);
        $orderSrch->addMultipleFields(array('totalSoldSales'));
        $rs = $orderSrch->getResultSet();
        return FatApp::getDb()->fetch($rs);
    }

    private function getShopSearchForm()
    {
        $sortByArr = array(
            'popularity_desc' => Labels::getLabel('LBL_Sort_by_Popularity', $this->siteLangId),
            'price_asc' => Labels::getLabel('LBL_Price_(Low_to_High)', $this->siteLangId),
            'price_desc' => Labels::getLabel('LBL_Price_(High_to_Low)', $this->siteLangId),
        );

        $itemsTxt = Labels::getLabel('LBL_Shops', $this->siteLangId);
        $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
        $pageSizeArr[12] = 12 . ' ' . $itemsTxt;
        $pageSizeArr[24] = 24 . ' ' . $itemsTxt;
        $pageSizeArr[48] = 48 . ' ' . $itemsTxt;

        $sortBy = 'popularity_desc';

        $frm = new Form('frmSearchShops');
        $frm->addTextBox('', 'keyword', '', array('id' => 'keyword'));
        $frm->addSelectBox('', 'sortBy', $sortByArr, $sortBy, array('id' => 'sortBy'), '');
        $frm->addSelectBox('', 'pageSize', $pageSizeArr, $pageSize, array('id' => 'pageSize'), '');
        $frm->addHiddenField('', 'page', 1);
        $frm->addHiddenField('', 'sortOrder', 'asc');
        $frm->addHiddenField('', 'category', 0);
        $frm->addHiddenField('', 'shop_id', 0);
        $frm->addHiddenField('', 'brand_id', 0);
        $frm->addHiddenField('', 'countries', 0);
        $frm->addHiddenField('', 'collection_id', 0);
        $frm->addHiddenField('', 'join_price', 0);
        $frm->addHiddenField('', 'featured', 0);
        $frm->addHiddenField('', 'top_products', 0);
        $frm->addHiddenField('', 'currency_id', $this->siteCurrencyId);
        $frm->addHiddenField('', 'sellertype', 0);
		$frm->addHiddenField('', 'ratings', 0);
        return $frm;
    }

    protected function getSearchForm()
    {
        return Shop::getFilterSearchForm();
    }

	public function shopReviewsRatings($shopUserId, $isfilterApplied=[])
	{
		$selProdRatingSrch = SelProdRating::getSearchObj();
        $selProdRatingSrch->doNotCalculateRecords();
        $selProdRatingSrch->addMultipleFields(array('sprating_spreview_id', 'round(avg(sprating_rating),2) seller_rating'));
        $selProdRatingSrch->addCondition('sprating_rating_type', 'in', array(SelProdRating::TYPE_SELLER_SHIPPING_QUALITY, SelProdRating::TYPE_SELLER_STOCK_AVAILABILITY, SelProdRating::TYPE_SELLER_PACKAGING_QUALITY));
        $selProdRatingSrch->addGroupBy('sprating_spreview_id');
        $spratingQuery = $selProdRatingSrch->getQuery();
		
        $selProdReviewObj = new SelProdReviewSearch();
        $selProdReviewObj->joinProducts($this->siteLangId);
        $selProdReviewObj->joinSellerProducts($this->siteLangId);
        $selProdReviewObj->joinTable("($spratingQuery)", 'left join', 'spr.spreview_id = selRating.sprating_spreview_id', 'selRating');
        $selProdReviewObj->addGroupBy('spr.spreview_seller_user_id');
        $selProdReviewObj->addCondition('spr.spreview_status', '=', SelProdReview::STATUS_APPROVED);
        $selProdReviewObj->addCondition('spreview_seller_user_id', '=', $shopUserId);
        $selProdReviewObj->addMultipleFields(array('spr.spreview_seller_user_id', 'count(*) as totReviews', "ROUND(AVG(seller_rating),2) as avg_seller_rating", 'sum(if(round(seller_rating)=1,1,0)) rated_1', 'sum(if(round(seller_rating)=2,1,0)) rated_2', 'sum(if(round(seller_rating)=3,1,0)) rated_3', 'sum(if(round(seller_rating)=4,1,0)) rated_4', 'sum(if(round(seller_rating)=5,1,0)) rated_5'));
        $reviews = FatApp::getDb()->fetch($selProdReviewObj->getResultSet());		
		return $reviews;
	}

    public function view($shop_id)
    {
        $db = FatApp::getDb();

        $this->shopDetail($shop_id);

        if (API_CALL) {
            $get = FatApp::getPostedData();
        } else {
            $get = FatApp::getParameters();
            $get = array_filter(Product::convertArrToSrchFiltersAssocArr($get));
        }
        // CommonHelper::printArray($get, true);
        if (array_key_exists('currency', $get)) {
            $get['currency_id'] = $get['currency'];
        }
        if (array_key_exists('sort', $get)) {
            $get['sortOrder'] = $get['sort'];
        }

        $includeShopData = true;
        if (array_key_exists('includeShopData', $get) && 1 > FatUtility::int($get['includeShopData'])) {
            $includeShopData = false;
        }
        //$get['join_price'] = 1;
        $get['shop_id'] = $shop_id;

        $data = $this->getListingData($get, $includeShopData);
        $shopUserId = Shop::getAttributesById($shop_id, 'shop_user_id');
        $sellerProfileData = ShopProfile::getSellerProfileData($shopUserId, $this->siteLangId);
        $sellerType = (isset($sellerProfileData['sprofile_seller_type'])) ? $sellerProfileData['sprofile_seller_type'] : 0;
        $this->set('seller_type', $sellerType);
        $this->set('reviews', $this->shopReviewsRatings($shopUserId));

		$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shopUserId, array('spackage_id'));
		$currentActivePackageId = isset($currentPlanData['spackage_id'])?$currentPlanData['spackage_id']:0;
		$this->set('subscription_package_id' , $currentActivePackageId);
        if ($currentActivePackageId > 0) {
            $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
            $this->set('subscription_package' , (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '');
        }
		
		$searchFrm = $this->getSearchForm();
		$searchFrm->fill(['shop_id'=>$shop_id]);
		$this->set('searchFrm', $searchFrm);
		
        if (false === API_CALL) {
            $displayPrice = true;
            if ($shop_id > 0) {
                $shopData = Shop::getAttributesById($shop_id, ['shop_is_buy_now', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers']);
                $displayPrice = CommonHelper::isDisplayPrice($shopData);
            }
            $frm = $this->getProductSearchForm(false, true, true, $displayPrice);

            $frm->fill($get);

            $arr = array(
                'frmProductSearch' => $frm,
                'canonicalUrl' => CommonHelper::generateFullUrl('Shops', 'view', array($shop_id)),
                'productSearchPageType' => SavedSearchProduct::PAGE_SHOP,
                'recordId' => $shop_id,
                'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'categories'),
            );
            $data = array_merge($data, $arr);

            if (UserAuthentication::isUserLogged()) {
                $userData = User::getAttributesById(UserAuthentication::getLoggedUserId());
                $userParentId = (0 < $userData['user_parent']) ? $userData['user_parent'] : UserAuthentication::getLoggedUserId();
                $this->set('userParentId', $userParentId);
            }
            $this->set('shopDetail', $data['shop']);
            if (FatUtility::isAjaxCall()) {
                $this->set('products', $data['products']);
                $this->set('page', $data['page']);
                $this->set('pageCount', $data['pageCount']);
                $this->set('postedData', $get);
                $this->set('recordCount', $data['recordCount']);
                $this->set('siteLangId', $this->siteLangId);


                echo $this->_template->render(false, false, 'products/products-list.php', true);
                exit;
            }

            $this->includeProductPageJsCss();
            $this->_template->addJs('js/slick.min.js');
            $this->_template->addJs('js/shop-nav.js');
            $this->_template->addJs('js/jquery.colourbrightness.min.js');
        }
        if (API_CALL && true === $includeShopData) {
            $shopInfo = $this->shopPoliciesData($this->getShopInfo($shop_id));
			$data['shop'] = array_merge($data['shop'], $shopInfo);
            $data['shop']['rating'] = 0;
            if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
                $data['shop']['rating'] = SelProdRating::getSellerRating($data['shop']['shop_user_id']);
            }
            $data['shop']['shop_logo'] = CommonHelper::generateFullFileUrl('image', 'shopLogo', array($data['shop']['shop_id'], $this->siteLangId));
            $data['shop']['shop_banner'] = FatCache::getCachedUrl(CommonHelper::generateFullFileUrl('image', 'shopBanner', array($data['shop']['shop_id'], $this->siteLangId, 'MOBILE', 0, AppConstants::SCREEN_MOBILE)), CONF_IMG_CACHE_TIME, '.jpg');
        }

        $this->set('data', $data);

        if (false === API_CALL) {
            $this->includeProductPageJsCss();
            $this->_template->addJs(array('js/slick.min.js', 'js/shop-nav.js', 'js/jquery.colourbrightness.min.js'));
        }

        $this->_template->render();
    }

    public function showBackgroundImage($shop_id = 0, $lang_id = 0, $templateId = '')
    {
        $recordId = FatUtility::int($shop_id);
        $lang_id = FatUtility::int($lang_id);
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_BACKGROUND_IMAGE, $recordId, 0, $lang_id);
        if (!$file_row && !$this->getAllowedShowBg($templateId)) {
            return false;
        }

        return true;
    }

    public function shopDetail($shop_id, $policy = false)
    {
        $db = FatApp::getDb();

        $shop_id = FatUtility::int($shop_id);

        if ($shop_id <= 0) {
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Shop'));
        }

        $shopDetails = Shop::getAttributesByid($shop_id);
        if (UserAuthentication::isUserLogged() && UserAuthentication::getLoggedUserId() == $shopDetails['shop_user_id'] && !UserPrivilege::isUserHasValidSubsription(UserAuthentication::getLoggedUserId())) {
            Message::addInfo(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }

        $srch = new ShopSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->joinSellerSubscription();
        $srch->doNotCalculateRecords();
        $srch->joinTable('tbl_users', 'LEFT OUTER JOIN', 'tu.user_id = shop_user_id', 'tu');
        $loggedUserId = 0;
        if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }

        //echo $srch->getQuery(); die();

        /* sub query to find out that logged user have marked current shop as favorite or not[ */
        $favSrchObj = new UserFavoriteShopSearch();
        $favSrchObj->doNotCalculateRecords();
        $favSrchObj->doNotLimitRecords();
        $favSrchObj->addMultipleFields(array('ufs_shop_id', 'ufs_id'));
        $favSrchObj->addCondition('ufs_user_id', '=', $loggedUserId);
        $favSrchObj->addCondition('ufs_shop_id', '=', $shop_id);
        $srch->joinTable('(' . $favSrchObj->getQuery() . ')', 'LEFT OUTER JOIN', 'ufs_shop_id = shop_id', 'ufs');
        /* ] */

        $srch->addMultipleFields(
            array(
                'shop_id', 'tu.user_name', 'tu.user_regdate', 'shop_user_id', 'shop_ltemplate_id', 'shop_created_on', 'shop_name', 'shop_description',
                'shop_country_l.country_name as shop_country_name', 'shop_state_l.state_name as shop_state_name', 'shop_city',
                'IFNULL(ufs.ufs_id, 0) as is_favorite', 'tu.user_is_founding_member as is_founding_member', 'u.user_is_verified as seller_verified', 'country_code as countryCode'
            )
        );
        $srch->addCondition('shop_id', '=', $shop_id);
        if ($policy) {
            $srch->addMultipleFields(array('shop_payment_policy', 'shop_delivery_policy', 'shop_refund_policy', 'shop_additional_info', 'shop_seller_info'));
        }
        $shopRs = $srch->getResultSet();
        $shop = $db->fetch($shopRs);

        if (!$shop) {
            FatApp::redirectUser(FatUtility::exitWithErrorCode('404'));
        }
        $shopOwnerId = $shop['shop_user_id'];

        $currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shopOwnerId, array('spackage_id'));
        $currentActivePackageId = isset($currentPlanData['spackage_id'])?$currentPlanData['spackage_id']:0;
        $shop['subscription_package_id'] = $currentActivePackageId;
        if ($currentActivePackageId > 0) {
            $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
            $shop['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
        }

        $shopCategories = array();
        /* Switch($shop['shop_ltemplate_id']){
          case Shop::TEMPLATE_ONE:
          case Shop::TEMPLATE_THREE:
          case Shop::TEMPLATE_FOUR:
          case Shop::TEMPLATE_FIVE:
          $this->_template->addCss('shops/templates/page-css/'.$shop['shop_ltemplate_id'].'.css');
          break;
          case Shop::TEMPLATE_TWO:
          $this->_template->addJs('js/slick.min.js');
          $this->_template->addCss('shops/templates/page-css/'.$shop['shop_ltemplate_id'].'.css');
          break;
          default:
          $this->_template->addCss('shops/templates/page-css/'.SHOP::TEMPLATE_ONE.'.css');
          break;
          } */
        /* $this->_template->addCss('shops/templates/page-css/' . SHOP::TEMPLATE_ONE . '.css'); */
        $this->set('shop', $this->shopPoliciesData($shop));
        $this->set('shopRating', SelProdRating::getSellerRating($shop['shop_user_id']));
        $this->set('shopTotalReviews', SelProdReview::getSellerTotalReviews($shop['shop_user_id']));

        $description = trim(CommonHelper::subStringByWords(strip_tags(CommonHelper::renderHtml($shop['shop_description'], true)), 500));
        $description .= ' - ' . Labels::getLabel('LBL_See_more_at', $this->siteLangId) . ": " . CommonHelper::getCurrUrl();

        if ($shop) {
            $socialShareContent = array(
                'title' => $shop['shop_name'],
                'description' => $description,
                'image' => CommonHelper::generateFileUrl('Image', 'shopBanner', array($shop['shop_id'], $this->siteLangId, 'wide')),
            );
            $this->set('socialShareContent', $socialShareContent);
        }

        $shopUserId = FatUtility::int($shop['shop_user_id']);
        if ($shopUserId !== 0) {
            $srchSplat = SocialPlatform::getSearchObject($this->siteLangId);
            $srchSplat->doNotCalculateRecords();
            $srchSplat->doNotLimitRecords();
            $srchSplat->addCondition('splatform_user_id', '=', $shopUserId);
            $db = FatApp::getDb();

            $rs = $srchSplat->getResultSet();

            $socialPlatforms = $db->fetchAll($rs);
            $this->set('socialPlatforms', $socialPlatforms);
        }

        $this->set('countryCode', $shop['countryCode']);
        $collection_data = ShopCollection::getShopCollectionsDetail($shop_id, $this->siteLangId);
        $this->set('collectionData', $collection_data);
        $this->set('layoutTemplate', 'shop');
        // $this->set('template_id', ($shop['shop_ltemplate_id']==0)?SHOP::TEMPLATE_ONE:$shop['shop_ltemplate_id']);
        $this->set('template_id', SHOP::TEMPLATE_ONE);
        $this->set('layoutRecordId', $shop['shop_id']);
        $showBgImage = $this->showBackgroundImage($shop_id, $this->siteLangId, SHOP::TEMPLATE_ONE);
        $this->set('showBgImage', $showBgImage);
    }

    public function getShopCollectionListing($shop_id)
    {
        $shop_id = FatUtility::int($shop_id);
        if (1 > $shop_id) {
            LibHelper::dieJsonError(Labels::getLabel('LBL_INVALID_SHOP', $this->siteLangId));
        }
        $collectionData = ShopCollection::getShopCollectionsDetail($shop_id, $this->siteLangId);
        if (!empty($collectionData)) {
            foreach ($collectionData as $key => $collection) {
                $collectionData[$key]['shopCollectionImage'] = CommonHelper::generateFullFileUrl('image', 'shopCollectionImage', array($collection['scollection_id'], $this->siteLangId, 'SHOP'));
            }
        }

        $this->set('data', ['shopCollectionDetail' => $collectionData]);
        $this->_template->render();
    }

    public function getAllowedShowBg($templateId = '')
    {
        switch ($templateId) {
            case Shop::TEMPLATE_ONE:
            case Shop::TEMPLATE_TWO:
            case Shop::TEMPLATE_THREE:
                return false;
                break;
            case Shop::TEMPLATE_FOUR:
            case Shop::TEMPLATE_FIVE:
                return true;
                break;
            default:
                return false;
                break;
        }
    }

    public function topProducts($shop_id)
    {
        $db = FatApp::getDb();

        $this->shopDetail($shop_id);

        $frm = $this->getProductSearchForm();

        $get = FatApp::getParameters();
        $get = Product::convertArrToSrchFiltersAssocArr($get);

        if (array_key_exists('currency', $get)) {
            $get['currency_id'] = $get['currency'];
        }
        if (array_key_exists('sort', $get)) {
            $get['sortOrder'] = $get['sort'];
        }

        $get['top_products'] = 1;
        $get['shop_id'] = $shop_id;

        $frm->fill($get);

        $shopUserId = Shop::getAttributesById($shop_id, 'shop_user_id');
        $sellerProfileData = ShopProfile::getSellerProfileData($shopUserId, $this->siteLangId);
        $sellerType = (isset($sellerProfileData['sprofile_seller_type'])) ? $sellerProfileData['sprofile_seller_type'] : 0;
        $this->set('seller_type', $sellerType);

        $data = $this->getListingData($get);

        $arr = array(
            'frmProductSearch' => $frm,
            'canonicalUrl' => CommonHelper::generateFullUrl('Shops', 'topProducts', array($shop_id)),
            'productSearchPageType' => SavedSearchProduct::PAGE_SHOP,
            'recordId' => $shop_id,
            'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'categories'),
        );

        $data = array_merge($data, $arr);
        $this->set('data', $data);
		$this->set('reviews', $this->shopReviewsRatings($shopUserId));		
		$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shopUserId, array('spackage_id'));
		$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
		$this->set('subscription_package_id' , $currentActivePackageId);
        if ($currentActivePackageId > 0) {
            $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
            $this->set('subscription_package' , (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '');
        }		

		$searchFrm = $this->getSearchForm();
		$searchFrm->fill(['shop_id'=>$shop_id]);
		$this->set('searchFrm', $searchFrm);
		
        if (FatUtility::isAjaxCall()) {
            $this->set('products', $data['products']);
            $this->set('page', $data['page']);
            $this->set('pageCount', $data['pageCount']);
            $this->set('postedData', $get);
            $this->set('recordCount', $data['recordCount']);
            $this->set('siteLangId', $this->siteLangId);
            echo $this->_template->render(false, false, 'products/products-list.php', true);
            exit;
        }

        $this->includeProductPageJsCss();
        $this->_template->addJs('js/slick.min.js');

        $this->_template->addJs('js/shop-nav.js');
        $this->_template->addJs('js/jquery.colourbrightness.min.js');
        $this->_template->render(true, true, 'shops/view.php');
    }

    public function policy($shop_id)
    {
        $this->shopDetail($shop_id, true);

        $frm = $this->getProductSearchForm();
        $searchFrm = $this->getSearchForm();
        $frmData = array('shop_id' => $shop_id);
        $frm->fill($frmData);
        $searchFrm->fill($frmData);
        $this->set('frmProductSearch', $frm);
        $this->set('searchFrm', $searchFrm);
        $this->set('shopId', $shop_id);
		$shopUserId = Shop::getAttributesById($shop_id, 'shop_user_id');
		$this->set('reviews', $this->shopReviewsRatings($shopUserId));
        $this->_template->addJs('js/slick.js');
        $this->_template->addJs('js/shop-nav.js');
        $this->_template->addJs('js/jquery.colourbrightness.min.js');

        $this->_template->render();
    }

    public function collection($shop_id, $scollectionId)
    {
        $db = FatApp::getDb();
        $shop_id = FatUtility::int($shop_id);
        $scollectionId = FatUtility::int($scollectionId);
        if (1 > $scollectionId) {
            if (API_CALL) {
                LibHelper::dieJsonError(Labels::getLabel('LBL_INVALID_REQUEST', $this->siteLangId));
            }
            FatApp::redirectUser(CommonHelper::generateUrl(''));
        }

        $searchFrm = $this->getSearchForm();
		$searchFrm->fill(['shop_id'=>$shop_id]);
		$this->set('searchFrm', $searchFrm);
        
        $this->shopDetail($shop_id);

        $shopcolDetails = ShopCollection::getCollectionGeneralDetail($shop_id, $scollectionId, $this->siteLangId);

        $frm = $this->getProductSearchForm();

        $get = FatApp::getParameters();
        $get = Product::convertArrToSrchFiltersAssocArr($get);

        if (array_key_exists('currency', $get)) {
            $get['currency_id'] = $get['currency'];
        }
        if (array_key_exists('sort', $get)) {
            $get['sortOrder'] = $get['sort'];
        }
        //$get['join_price'] = 1;
        $get['shop_id'] = $shop_id;
        $get['collection_id'] = $scollectionId;

        $shopUserId = Shop::getAttributesById($shop_id, 'shop_user_id');
        $sellerProfileData = ShopProfile::getSellerProfileData($shopUserId, $this->siteLangId);
        $sellerType = (isset($sellerProfileData['sprofile_seller_type'])) ? $sellerProfileData['sprofile_seller_type'] : 0;
        $this->set('seller_type', $sellerType);

        $fld = $frm->getField('sortBy');
        $fld->value = 'popularity_desc';
        $fld->fldType = 'hidden';
        $frm->fill($get);

        $data = $this->getListingData($get);

        $arr = array(
            'scollection_name' => $shopcolDetails['scollection_name'],
            'canonicalUrl' => CommonHelper::generateFullUrl('Shops', 'collection', array($shop_id, $scollectionId)),
            'productSearchPageType' => SavedSearchProduct::PAGE_SHOP,
            'recordId' => $shop_id,
            'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'categories'),
        );

        if (false === API_CALL) {
            $arr['frmProductSearch'] = $frm;
        }

        $data = array_merge($data, $arr);
        $this->set('data', $data);

        $shopUserId = Shop::getAttributesById($shop_id, 'shop_user_id');
        $this->set('reviews', $this->shopReviewsRatings($shopUserId));

        $currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shopUserId, array('spackage_id'));
		$currentActivePackageId = isset($currentPlanData['spackage_id'])?$currentPlanData['spackage_id']:0;
		$this->set('subscription_package_id' , $currentActivePackageId);

        if (FatUtility::isAjaxCall()) {
            $this->set('products', $data['products']);
            $this->set('page', $data['page']);
            $this->set('pageCount', $data['pageCount']);
            $this->set('postedData', $get);
            $this->set('recordCount', $data['recordCount']);
            $this->set('siteLangId', $this->siteLangId);
            echo $this->_template->render(false, false, 'products/products-list.php', true);
            exit;
        }

        if (false === API_CALL) {
            $this->includeProductPageJsCss();
            $this->_template->addJs('js/slick.min.js');
            $this->_template->addJs('js/shop-nav.js');
            $this->_template->addJs('js/jquery.colourbrightness.min.js');
        }
        $this->_template->render(true, true, 'shops/view.php');
    }

    public function sendMessage($shop_id, $selprod_id = 0)
    {
        UserAuthentication::checkLogin();
        $shop_id = FatUtility::int($shop_id);
        $selprod_id = FatUtility::int($selprod_id);
		$shopUserId = Shop::getAttributesById($shop_id, 'shop_user_id');
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $db = FatApp::getDb();

        $shop = $this->getShopInfo($shop_id);
        if (!$shop) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Home'));
        }

        $frm = $this->getSendMessageForm($this->siteLangId);
        $userObj = new User($loggedUserId);
        $loggedUserData = $userObj->getUserInfo(array('user_id', 'user_name', 'credential_username'));
        $frmData = array('shop_id' => $shop_id);
        $product = [];
        if ($selprod_id > 0) {
            $frmData['product_id'] = $selprod_id;
            /* fetch requested product[ */
			$prodSrch = new ProductSearch($this->siteLangId);
			$prodSrch->setDefinedCriteria(0, 0, array(), false);
			$prodSrch->joinProductToCategory();
			$prodSrch->joinShopSpecifics();
			$prodSrch->joinProductSpecifics();
			$prodSrch->joinSellerProductSpecifics();
			$prodSrch->joinSellerSubscription();
			$prodSrch->addSubscriptionValidCondition();
			$prodSrch->doNotCalculateRecords();
			$prodSrch->addCondition('selprod_id', '=', $selprod_id);
			$prodSrch->addCondition('selprod_deleted', '=', AppConstants::NO);
			$prodSrch->doNotLimitRecords();
			$prodSrch->addMultipleFields(
					array('prodcat_name','prodcat_id','selprod_id','shop_user_id','selprod_price', 'special_price_found', 'theprice','shop_country_l.country_name as shop_country_name', 'shop_state_l.state_name as shop_state_name','user_is_verified as seller_verified','user_is_founding_member as is_founding_member', 'shop_is_buy_now as is_buy_now','selprod_user_id','shop_id', 'shop_name','product_id', 'selprod_type','selprod_document_required', 'product_identifier', 'COALESCE(product_name,product_identifier) as product_name', 'product_seller_id', 'COALESCE(selprod_title, product_name, product_identifier) as selprod_title')
			);

			$productRs = $prodSrch->getResultSet();
            $product = FatApp::getDb()->fetch($productRs);
        }
        $this->set('product', $product);
        $this->set('reviews', $this->shopReviewsRatings($shopUserId));
        $this->set('shopRating', SelProdRating::getSellerRating($shop['shop_user_id']));
        $this->set('shopTotalReviews', SelProdReview::getSellerTotalReviews($shop['shop_user_id']));
        $collection_data = ShopCollection::getShopCollectionsDetail($shop_id, $this->siteLangId);
        $this->set('collectionData', $collection_data);
        $this->set('template_id', SHOP::TEMPLATE_ONE);
        $frm->fill($frmData);
        $this->set('frm', $frm);
        $this->set('loggedUserData', $loggedUserData);
        $this->set('shop', $shop);
        if (FatUtility::isAjaxCall()) {
			$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shop['shop_user_id'], array('spackage_id'));
            $currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
            $this->set('subscription_package_id',  $currentActivePackageId);
            if ($currentActivePackageId > 0) {
                $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
                $this->set('subscription_package' , (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '');
            }			
			
            $this->set('siteLangId', $this->siteLangId);
            echo $this->_template->render(false, false, 'shops/contact-form.php', true);
            exit;
        }		
		$this->_template->render();
    }

    public function setUpSendMessage()
    {
        UserAuthentication::checkLogin();
        $frm = $this->getSendMessageForm($this->siteLangId);
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        $loggedUserId = UserAuthentication::getLoggedUserId();
        if (false == $post) {
            LibHelper::dieJsonError(current($frm->getValidationErrors()));
        }

        $shop_id = FatUtility::int($post['shop_id']);
        $shopData = $this->getShopInfo($shop_id);
        if (!$shopData) {
            $message = Labels::getLabel('LBL_Invalid_Shop', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if ($shopData['shop_user_id'] == $loggedUserId) {
            $message = Labels::getLabel('LBL_You_are_not_allowed_to_send_message', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $threadObj = new Thread();
        $threadDataToSave = array(
            'thread_subject' => $post['thread_subject'],
            'thread_started_by' => $loggedUserId,
            'thread_start_date' => date('Y-m-d H:i:s')
        );

        if (isset($post['product_id']) && $post['product_id'] > 0) {
            $product_id = FatUtility::int($post['product_id']);
            $threadDataToSave['thread_type'] = Thread::THREAD_TYPE_PRODUCT;
            $threadDataToSave['thread_record_id'] = $product_id;
        } else {
            $threadDataToSave['thread_type'] = Thread::THREAD_TYPE_SHOP;
            $threadDataToSave['thread_record_id'] = $shop_id;
        }

        $threadObj->assignValues($threadDataToSave);

        if (!$threadObj->save()) {
            $message = Labels::getLabel($threadObj->getError(), $this->siteLangId);
            if (API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }
        $thread_id = $threadObj->getMainTableRecordId();

        $threadMsgDataToSave = array(
            'message_thread_id' => $thread_id,
            'message_from' => $loggedUserId,
            'message_to' => $shopData['shop_user_id'],
            'message_text' => $post['message_text'],
            'message_date' => date('Y-m-d H:i:s'),
            'message_is_unread' => 1,
            'message_deleted' => 0
        );
        if (!$message_id = $threadObj->addThreadMessages($threadMsgDataToSave)) {
            $message = Labels::getLabel($threadObj->getError(), $this->siteLangId);
            if (API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        if ($message_id) {
            $emailObj = new EmailHandler();
            if (!$emailObj->SendMessageNotification($message_id, $this->siteLangId)) {
                LibHelper::dieJsonError($emailObj->getError());
            }
        }
        $this->set('msg', Labels::getLabel('MSG_Message_Submitted_Successfully!', $this->siteLangId));
        if (API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function reportSpam($shop_id)
    {
        UserAuthentication::checkLogin();
        $db = FatApp::getDb();
        $shop_id = FatUtility::int($shop_id);

        $shop = $this->getShopInfo($shop_id);
        if (!$shop) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Home'));
        }

        $shopRepData = ShopReport::getReportDetail($shop['shop_id'], UserAuthentication::getLoggedUserId(), 'sreport_id');
        if (!empty($shopRepData)) {
            Message::addErrorMessage(Labels::getLabel('LBL_YOU_ALREADY_REPORTED_FOR_THIS_SHOP', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Shops', 'View', array($shop_id)));
        }

        $frm = $this->getReportSpamForm($this->siteLangId);
        $frm->fill(array('shop_id' => $shop_id));
        $this->set('frm', $frm);
        $this->set('shop', $shop);
        $this->_template->render();
    }

    public function setUpShopSpam()
    {
        UserAuthentication::checkLogin();
        $frm = $this->getReportSpamForm($this->siteLangId);
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        $loggedUserId = UserAuthentication::getLoggedUserId();

        if (false == $post) {
            LibHelper::dieJsonError(current($frm->getValidationErrors()));
        }

        $shop_id = FatUtility::int($post['shop_id']);
        if (1 > $shop_id) {
            LibHelper::dieJsonError(Labels::getLabel('LBL_Invalid_Shop', $this->siteLangId));
        }

        $shopRepData = ShopReport::getReportDetail($shop_id, $loggedUserId, 'sreport_id');
        if (!empty($shopRepData) && 0 < count($shopRepData)) {
            LibHelper::dieJsonError(Labels::getLabel('LBL_YOU_ALREADY_REPORTED_FOR_THIS_SHOP', $this->siteLangId));
        }

        $srch = new ShopSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->joinSellerSubscription();
        $srch->doNotCalculateRecords();
        $srch->addMultipleFields(array('shop_id', 'shop_user_id'));
        $srch->addCondition('shop_id', '=', $shop_id);
        $shopRs = $srch->getResultSet();
        $shopData = FatApp::getDb()->fetch($shopRs);

        if (!$shopData) {
            LibHelper::dieJsonError(Labels::getLabel('LBL_Invalid_Shop', $this->siteLangId));
        }

        $sReportObj = new ShopReport();
        $dataToSave = array(
            'sreport_shop_id' => $shop_id,
            'sreport_reportreason_id' => $post['sreport_reportreason_id'],
            'sreport_message' => $post['sreport_message'],
            'sreport_user_id' => $loggedUserId,
            'sreport_added_on' => date('Y-m-d H:i:s'),
        );

        $sReportObj->assignValues($dataToSave);
        if (!$sReportObj->save()) {
            FatUtility::dieJsonError(strip_tags(Labels::getLabel($sReportObj->getError(), $this->siteLangId)));
        }

        $sreport_id = $sReportObj->getMainTableRecordId();

        if (!$sreport_id) {
            FatUtility::dieJsonError(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
        }

        /* email notification[ */
        if ($sreport_id) {
            $emailObj = new EmailHandler();
            $emailObj->sendShopReportNotification($sreport_id, $this->siteLangId);

            //send notification to admin
            $notificationData = array(
                'notification_record_type' => Notification::TYPE_SHOP,
                'notification_record_id' => $shop_id,
                'notification_user_id' => $loggedUserId,
                'notification_label_key' => Notification::REPORT_SHOP_NOTIFICATION,
                'notification_added_on' => date('Y-m-d H:i:s'),
            );

            if (!Notification::saveNotifications($notificationData)) {
                FatUtility::dieJsonError(Labels::getLabel("MSG_NOTIFICATION_COULD_NOT_BE_SENT", $this->siteLangId));
            }
        }
        /* ] */

        $sucessMsg = Labels::getLabel('MSG_Reported_Successfully!', $this->siteLangId);
        Message::addMessage($sucessMsg);
        $this->set('msg', $sucessMsg);
        if (API_CALL) {
            $this->_template->render();
        }
        $this->set('redirectUri', CommonHelper::generateUrl('Shops', 'View', [$shop_id]));
        $this->_template->render(false, false, 'json-success.php');
    }

    /* public function searchWhoFavouriteShop(){
      $db = FatApp::getDb();
      $data = FatApp::getPostedData();
      $page = (empty($data['page']) || $data['page'] <= 0) ? 1 : FatUtility::int($data['page']);
      $pagesize = FatApp::getConfig('CONF_PAGE_SIZE',FatUtility::VAR_INT, 10);

      $searchForm = $this->getWhoFavouriteSearchForm($this->siteLangId);
      $post = $searchForm->getFormDataFromArray($data);


      $shop_id = FatUtility::int($post['shop_id']);
      if(1 > $shop_id){
      FatUtility::dieWithError( Labels::getLabel('LBL_Invalid_Access_ID',$this->siteLangId));
      }

      $srch = new UserFavoriteShopSearch($this->siteLangId);
      $srch->joinWhosFavouriteUser();
      $srch->joinFavouriteUserShopsCount();
      $srch->addMultipleFields(array( 'ufs_shop_id as shop_id','ufs_user_id','user_name','userFavShopcount'));
      $srch->addCondition('ufs_shop_id','=',$shop_id);

      $page = (empty($page) || $page <= 0)?1:$page;
      $page = FatUtility::int($page);
      $srch->setPageNumber($page);
      $srch->setPageSize($pagesize);

      $rs = $srch->getResultSet();
      $userFavorite = $db->fetchAll( $rs );

      $totalShopToShow = 4;
      $prodSrchObj = new ProductSearch( $this->siteLangId );
      $prodSrchObj->setDefinedCriteria();
      $prodSrchObj->setPageSize(1);
      $shops = array();
      foreach($userFavorite as $val){
      $fsrch = new UserFavoriteShopSearch($this->siteLangId);
      $fsrch->joinWhosFavouriteUser();
      $fsrch->addCondition('ufs_user_id','=',$val['ufs_user_id']);
      $fsrch->addMultipleFields(array( 'ufs_shop_id as shop_id'));
      $fsrch->setPageSize($totalShopToShow);
      $frs = $fsrch->getResultSet();
      $shops[$val['ufs_user_id']]['shop'] = $db->fetchAll( $frs,'shop_id');
      if( $shops[$val['ufs_user_id']]['shop'] ){
      foreach( $shops[$val['ufs_user_id']]['shop'] as $res ){
      $prodSrch = clone $prodSrchObj;
      $prodSrch->addShopIdCondition( $res['shop_id'] );
      $prodSrch->addMultipleFields( array( 'selprod_id', 'product_id', 'shop_id','IFNULL(shop_name, shop_identifier) as shop_name',
      'IFNULL(product_name, product_identifier) as product_name',
      'IF(selprod_stock > 0, 1, 0) AS in_stock') );
      $prodRs = $prodSrch->getResultSet();
      $shops[$val['ufs_user_id']]['products'][] = $db->fetch( $prodRs);
      $shops[$val['ufs_user_id']]['totalProducts'] =     $prodSrch->recordCount();
      }
      }
      }

      $this->set( 'shops', $shops );
      $this->set( 'totalShopToShow', $totalShopToShow );
      $this->set( 'userFavorite', $userFavorite );
      $this->set('pageCount',$srch->pages());
      $this->set('recordCount',$srch->recordCount());
      $this->set('page', $page);
      $this->set('pageSize', $pagesize);
      $this->set('postedData', $post);

      $startRecord = ($page-1)* $pagesize + 1 ;
      $endRecord = $pagesize;
      $totalRecords = $srch->recordCount();
      if ($totalRecords < $endRecord) { $endRecord = $totalRecords; }
      $json['totalRecords'] = $totalRecords;
      $json['startRecord'] = $startRecord;
      $json['endRecord'] = $endRecord;
      $json['html'] = $this->_template->render( false, false, '', true, false);
      $json['loadMoreBtnHtml'] = $this->_template->render( false, false, '_partial/load-more-btn.php', true, false);
      FatUtility::dieJsonSuccess($json);
      }

      public function whoFavoritesShop($shop_id){
      $db = FatApp::getDb();
      $shop_id = FatUtility::int($shop_id);

      $searchForm = $this->getWhoFavouriteSearchForm($this->siteLangId);
      $searchForm->fill(array('shop_id'=>$shop_id));

      $shopData = $this->getShopInfo($shop_id);
      if( !$shopData ){
      Message::addErrorMessage( Labels::getLabel('LBL_Invalid_Request', $this->siteLangId) );
      FatApp::redirectUser(CommonHelper::generateUrl('Home'));
      }

      $srch = new UserFavoriteShopSearch($this->siteLangId);
      $srch->joinWhosFavouriteUser();
      $srch->joinFavouriteUserShopsCount();
      $srch->addMultipleFields(array( 'ufs_shop_id as shop_id','ufs_user_id','user_name','userFavShopcount'));
      $srch->addCondition('ufs_shop_id','=',$shop_id);

      $rs = $srch->getResultSet();
      $userFavorite = $db->fetchAll( $rs );

      $this->set( 'shopData', $shopData );
      $this->set( 'searchForm', $searchForm );
      $this->set( 'userFavoriteCount', $srch->recordCount() );
      $this->_template->render( );
      } */

    public function policies($shop_id)
    {
        $shop = $this->getShopInfo($shop_id);
        if (!$shop) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Home'));
        }

        $this->set('shop', $shop);
        $this->_template->render();
    }

    private function shopPoliciesData($shop)
    {
        $shop['description'] = empty($shop['shop_description']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_Shop_Description', $this->siteLangId),
            'description' => $shop['shop_description'],
        );
        $shop['shop_payment_policy'] = empty($shop['shop_payment_policy']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_PAYMENT_POLICY', $this->siteLangId),
            'description' => $shop['shop_payment_policy'],
        );
        $shop['shop_delivery_policy'] = empty($shop['shop_delivery_policy']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_DELIVERY_POLICY', $this->siteLangId),
            'description' => $shop['shop_delivery_policy'],
        );
        $shop['shop_refund_policy'] = empty($shop['shop_refund_policy']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_REFUND_POLICY', $this->siteLangId),
            'description' => $shop['shop_refund_policy'],
        );
        $shop['shop_additional_info'] = empty($shop['shop_additional_info']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_ADDITIONAL_INFO', $this->siteLangId),
            'description' => $shop['shop_additional_info'],
        );
        $shop['shop_seller_info'] = empty($shop['shop_seller_info']) ? (object) array() : array(
            'title' => Labels::getLabel('LBL_COMPANY_INFO', $this->siteLangId),
            'description' => $shop['shop_seller_info'],
        );
        return $shop;
    }

    public function banner($shopId, $sizeType = '', $prodCatId = 0, $lang_id = 0)
    {
        $shopId = FatUtility::int($shopId);
        $prodCatId = FatUtility::int($prodCatId);
        $file_row = false;

        if ($prodCatId > 0) {
            $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_BANNER_SELLER, $shopId, $prodCatId, $lang_id);
            /* if(false == $file_row){
              $file_row = AttachedFile::getAttachment( AttachedFile::FILETYPE_SHOP_BANNER, $shopId );
              } */
        }

        if (false == $file_row) {
            $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_BANNER, $shopId, 0, $lang_id);
        }

        $image_name = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';

        switch (strtoupper($sizeType)) {
            case 'THUMB':
                $w = 250;
                $h = 100;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'WIDE':
                $w = 1320;
                $h = 320;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            default:
                AttachedFile::displayOriginalImage($image_name);
                break;
        }
    }

    private function getShopInfo($shop_id)
    {
        $db = FatApp::getDb();
        $shop_id = FatUtility::int($shop_id);
        $srch = new ShopSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->doNotCalculateRecords();
        $srch->joinSellerSubscription();
		
		
        $loggedUserId = 0;
		if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }		
		/* sub query to find out that logged user have marked current shop as favorite or not[ */
		$favSrchObj = new UserFavoriteShopSearch();
		$favSrchObj->doNotCalculateRecords();
		$favSrchObj->doNotLimitRecords();
		$favSrchObj->addMultipleFields(array('ufs_shop_id', 'ufs_id'));
		$favSrchObj->addCondition('ufs_user_id', '=', $loggedUserId);
		$favSrchObj->addCondition('ufs_shop_id', '=', $shop_id);
		$srch->joinTable('(' . $favSrchObj->getQuery() . ')', 'LEFT OUTER JOIN', 'ufs_shop_id = shop_id', 'ufs');
		/* ] */		
		
        $srch->addMultipleFields(
            array(
                'shop_id', 'shop_user_id', 'shop_ltemplate_id', 'shop_created_on', 'shop_name', 'shop_description','user_is_verified as seller_verified', 'user_is_founding_member as is_founding_member',
                'shop_payment_policy', 'shop_delivery_policy', 'shop_refund_policy', 'shop_additional_info', 'shop_seller_info',
                'shop_country_l.country_name as shop_country_name', 'shop_state_l.state_name as shop_state_name', 'shop_city', 'u.user_name as shop_owner_name', 'u.user_regdate', 'u_cred.credential_username as shop_owner_username'
            )
        );

        $srch->addCondition('shop_id', '=', $shop_id);
        $shopRs = $srch->getResultSet();
        return $shop = $db->fetch($shopRs);
    }

    private function getReportSpamForm($langId)
    {
        $frm = new Form('frmShopReportSpam');
        $frm->addHiddenField('', 'shop_id');
        $frm->addSelectBox(Labels::getLabel('LBL_Select_Reason', $langId), 'sreport_reportreason_id', ShopReportReason::getReportReasonArr($langId), '', array(), Labels::getLabel('LBL_Select', $langId))->requirements()->setRequired();
        $frm->addTextArea(Labels::getLabel('LBL_Message', $langId), 'sreport_message')->requirements()->setRequired();
        $fldSubmit = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit_Report', $langId));
        return $frm;
    }

    private function getSendMessageForm($langId)
    {
        $frm = new Form('frmSendMessage');
        //$frm->addHiddenField('', 'user_id');
        $frm->addHiddenField('', 'shop_id');

        $fld = $frm->addHtml(Labels::getLabel('LBL_From', $langId), 'send_message_from', '');
        $frm->addHtml(Labels::getLabel('LBL_To', $langId), 'send_message_to', '');
        $frm->addHtml(Labels::getLabel('LBL_About_Product', $langId), 'about_product', '');
        $frm->addRequiredField(Labels::getLabel('LBL_Subject', $langId), 'thread_subject');
        $fld = $frm->addTextArea(Labels::getLabel('LBL_Your_Message', $langId), 'message_text');
        $fld->requirements()->setRequired();
        $frm->addHiddenField('', 'product_id');
        $fldSubmit = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Send', $langId));
        return $frm;
    }

    private function getWhoFavouriteSearchForm($langId)
    {
        $frm = new Form('frmsearchWhoFavouriteShop');
        $frm->addHiddenField('', 'shop_id');
        return $frm;
    }

    public function track($shopId = 0, $redirectType, $recordId)
    {
        $shopId = FatUtility::int($shopId);
        if (1 > $shopId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl(''));
        }

        /* Track Click */
        $srch = new PromotionSearch($this->siteLangId, true);
        $srch->joinActiveUser();
        $srch->joinShops();
        $srch->joinShopCountry();
        $srch->joinShopState();
        $srch->addPromotionTypeCondition(Promotion::TYPE_SHOP);
        $srch->addShopActiveExpiredCondition();
        $srch->joinUserWallet();
        $srch->joinBudget();
        $srch->addBudgetCondition();
        $srch->addCondition('shop_id', '=', $shopId);
        $srch->addMultipleFields(array('shop_id', 'shop_user_id', 'shop_name', 'country_name', 'state_name', 'promotion_id', 'promotion_cpc'));
        $srch->addOrder('', 'rand()');
        $srch->setPageSize(1);
        $srch->doNotCalculateRecords();
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);

        if ($row == false) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl(''));
        }

        if ($redirectType == PROMOTION::REDIRECT_PRODUCT) {
            $url = CommonHelper::generateFullUrl('products', 'view', array($recordId));
        } elseif ($redirectType == PROMOTION::REDIRECT_CATEGORY) {
            $url = CommonHelper::generateFullUrl('category', 'view', array($recordId));
        } else {
            $url = CommonHelper::generateFullUrl('shops', 'view', array($recordId));
        }

        $userId = 0;

        if (UserAuthentication::isUserLogged()) {
            $userId = UserAuthentication::getLoggedUserId();
        }

        if (Promotion::isUserClickCountable($userId, $row['promotion_id'], $_SERVER['REMOTE_ADDR'], session_id())) {
            $promotionClickData = array(
                'pclick_promotion_id' => $row['promotion_id'],
                'pclick_user_id' => $userId,
                'pclick_datetime' => date('Y-m-d H:i:s'),
                'pclick_ip' => $_SERVER['REMOTE_ADDR'],
                'pclick_cost' => $row['promotion_cpc'],
                'pclick_session_id' => session_id(),
            );
            FatApp::getDb()->insertFromArray(Promotion::DB_TBL_CLICKS, $promotionClickData, false, '', $promotionClickData);
            $clickId = FatApp::getDb()->getInsertId();

            $promotionClickChargesData = array(
                'picharge_pclick_id' => $clickId,
                'picharge_datetime' => date('Y-m-d H:i:s'),
                'picharge_cost' => $row['promotion_cpc'],
            );

            FatApp::getDb()->insertFromArray(Promotion::DB_TBL_ITEM_CHARGES, $promotionClickChargesData, false);

            $promotionLogData = array(
                'plog_promotion_id' => $row['promotion_id'],
                'plog_date' => date('Y-m-d'),
                'plog_clicks' => 1,
            );


            $onDuplicatePromotionLogData = array_merge($promotionLogData, array('plog_clicks' => 'mysql_func_plog_clicks+1'));
            FatApp::getDb()->insertFromArray(Promotion::DB_TBL_LOGS, $promotionLogData, true, array(), $onDuplicatePromotionLogData);
        }

        if (!filter_var($url, FILTER_VALIDATE_URL) === false) {
            FatApp::redirectUser(CommonHelper::processURLString($url));
        }

        FatApp::redirectUser(CommonHelper::generateUrl(''));
    }

    /* private function getProductSearchForm(){
      $sortByArr = array( 'price_asc' => Labels::getLabel('LBL_Price_(Low_to_High)', $this->siteLangId), 'price_desc' => Labels::getLabel('LBL_Price_(High_to_Low)', $this->siteLangId) );

      $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
      $itemsTxt = Labels::getLabel('LBL_Items', $this->siteLangId);
      $pageSizeArr[$pageSize] = $pageSize.' '.$itemsTxt;
      $pageSizeArr[25] = 25 . ' '.$itemsTxt;
      $pageSizeArr[50] = 50 . ' '.$itemsTxt;
      $frm = new Form('frmProductSearch');
      $frm->addTextBox('','keyword');
      $frm->addSelectBox( '', 'sortBy', $sortByArr, 'price_asc', array(), '');
      $frm->addSelectBox( '', 'pageSize', $pageSizeArr, $pageSize, array(), '' );
      $frm->addHiddenField('', 'page', 1);
      $frm->addHiddenField('', 'sortOrder', 'asc');
      $frm->addHiddenField('', 'category', 0);
      $frm->addHiddenField('', 'shop_id', 0);
      $frm->addSubmitButton('','btnProductSrchSubmit','');
      return $frm;
      } */

    private function getListingData($get, $includeShopData = true)
    {
        $db = FatApp::getDb();

        $shop_id = 0;
        if (array_key_exists('shop_id', $get)) {
            $shop_id = FatUtility::int($get['shop_id']);
        }

        $userId = 0;
        if (UserAuthentication::isUserLogged()) {
            $userId = UserAuthentication::getLoggedUserId();
        }
        $shop = array();

        if (true == $includeShopData) {
            $srch = new ShopSearch($this->siteLangId);
            $srch->setDefinedCriteria($this->siteLangId);
            $srch->joinSellerSubscription();
            $srch->doNotCalculateRecords();
            $srch->joinTable('tbl_users', 'LEFT OUTER JOIN', 'tu.user_id = shop_user_id', 'tu');

            /* sub query to find out that logged user have marked current shop as favorite or not[ */
            $favSrchObj = new UserFavoriteShopSearch();
            $favSrchObj->doNotCalculateRecords();
            $favSrchObj->doNotLimitRecords();
            $favSrchObj->addMultipleFields(array('ufs_shop_id', 'ufs_id'));
            $favSrchObj->addCondition('ufs_user_id', '=', $userId);
            $favSrchObj->addCondition('ufs_shop_id', '=', $shop_id);
            $srch->joinTable('(' . $favSrchObj->getQuery() . ')', 'LEFT OUTER JOIN', 'ufs_shop_id = shop_id', 'ufs');
            /* ] */

            $srch->addMultipleFields(
                array(
                    'shop_id', 'tu.user_name', 'tu.user_regdate', 'shop_user_id', 'shop_ltemplate_id', 'shop_created_on', 'IFNULL(shop_name, shop_identifier) as shop_name', 'shop_description',
                    'shop_country_l.country_name as shop_country_name', 'shop_state_l.state_name as shop_state_name', 'shop_city', 'shop_content_block',
                    'IFNULL(ufs.ufs_id, 0) as is_favorite', 'tu.user_is_founding_member as is_founding_member', 'u.user_is_verified as seller_verified', 'shop_country_id as return_country_id', 'country_code as return_country_code'
                )
            );
            $srch->addCondition('shop_id', '=', $shop_id);
            /* if($policy) {
              $srch->addMultipleFields(array('shop_payment_policy', 'shop_delivery_policy','shop_refund_policy','shop_additional_info','shop_seller_info'));
              } */
            //echo $srch->getQuery();
            $shopRs = $srch->getResultSet();
            $shop = $db->fetch($shopRs);
            $shopOwnerId = $shop['shop_user_id'];
            $currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $shopOwnerId, array('spackage_id'));
            $currentActivePackageId = isset($currentPlanData['spackage_id'])?$currentPlanData['spackage_id']:0;
            $shop['subscription_package_id'] = $currentActivePackageId;
            if ($currentActivePackageId > 0) {
                $packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
                $shop['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
            }

            /* $userObj = new User($shopOwnerId);
              $returnAddress = $userObj->getUserReturnAddress($this->siteLangId);
              if (!empty($returnAddress)) {
              $countryId = $returnAddress['ura_country_id'];
              $countryCode = Countries::getAttributesById($countryId, 'country_code');
              $shop['return_country_code'] = $countryCode;
              $shop['return_country_id'] = $countryId;
              } */
        }

        $page = 1;
        if (array_key_exists('page', $get)) {
            $page = FatUtility::int($get['page']);
            if ($page < 2) {
                $page = 1;
            }
        }

        $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
        if (array_key_exists('pageSize', $get)) {
            $pageSize = FatUtility::int($get['pageSize']);
            if (0 >= $pageSize) {
                $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
            }
        }

        $srch = Product::getListingObj($get, $this->siteLangId, $userId);

        $srch->setPageNumber($page);
        if ($pageSize) {
            $srch->setPageSize($pageSize);
        }

        $rs = $srch->getResultSet();
        $db = FatApp::getDb();
        $products = $db->fetchAll($rs);

        $data = array(
            'products' => $products,
            'shop' => $shop,
            'page' => $page,
            'pageSize' => $pageSize,
            'shopId' => $shop_id,
            'pageCount' => $srch->pages(),
            'postedData' => $get,
            'recordCount' => $srch->recordCount(),
            'siteLangId' => $this->siteLangId
        );
        return $data;
    }

    public function shopReportReasons()
    {
        $srch = ShopReportReason::getReportReasonArr($this->siteLangId, true);
        $rs = $srch->getResultSet();
        $data = FatApp::getDb()->fetchAll($rs);
        $this->set('data', array('reportReasons' => $data));
        $this->_template->render();
    }

    public function sellerProfile(int $shopId)
    {
        $this->shopDetail($shopId, true);
        $shopUserId = shop::getAttributesById($shopId, 'shop_user_id');
        $sellerProfileData = ShopProfile::getSellerProfileData($shopUserId, $this->siteLangId);
        $frm = $this->getProductSearchForm();
        $searchFrm = $this->getSearchForm();
        $frmData = array('shop_id' => $shopId);
        $frm->fill($frmData);
        $searchFrm->fill($frmData);

        /* [ SHOP DOCUMENTS */
        $docObj = new ShopDocument($shopId);
        $docSrch = $docObj->getSearchObject($this->siteLangId);
        $docRs = $docSrch->getResultSet();
        $shopDocumentsArr = FatApp::getDb()->fetchAll($docRs);
        $shopDocuments = [];
        if (!empty($shopDocumentsArr)) {
            foreach ($shopDocumentsArr as $document) {
                $type = $document['shopdoc_type'];
                $shopDocuments[$type][] = $document;
            }
        }
        /* ] */
        $this->set('isProductDetail', false);
        $this->set('faqs', $this->shopFaqs($shopId));
        $this->set('frmProductSearch', $frm);
        $this->set('searchFrm', $searchFrm);
        $this->set('shopId', $shopId);
        $this->set('sellerProfileData', $sellerProfileData);
        $this->set('sellerTypeArr', ShopProfile::getSellerTypeArr($this->siteLangId));
        $this->set('shopDocuments', $shopDocuments);
		$shopUserId = Shop::getAttributesById($shopId, 'shop_user_id');
		$this->set('reviews', $this->shopReviewsRatings($shopUserId));		
        $this->_template->addJs(array('js/magnific-popup.js'));
        $this->_template->render();
    }

    private function shopFaqs(int $shopId): array
    {
        $srch = Faq::getSearchObject($this->siteLangId);
        $srch->addCondition('faq_shop_id', '=', $shopId);
        $srch->doNotCalculateRecords();
        $rs = $srch->getResultSet();
        return FatApp::getDb()->fetchAll($rs);
    }

    private function getFilterSearchObj($langId, $headerFormParamsAssocArr)
    {
        return FilterHelper::getShopSearchObj($langId, $headerFormParamsAssocArr);
    }
	
    public function filters()
    {
        $db = FatApp::getDb();
        $headerFormParamsAssocArr = FilterHelper::getParamsAssocArr();

        $categoryId = 0;
        if (array_key_exists('category', $headerFormParamsAssocArr)) {
            $categoryId = FatUtility::int($headerFormParamsAssocArr['category']);
        }
        if (array_key_exists('shop_id', $headerFormParamsAssocArr)) {
            $categoryId = FatUtility::int($headerFormParamsAssocArr['shop_id']);
        }
        $keyword = '';
        $langIdForKeywordSeach = $this->siteLangId;
        if (array_key_exists('keyword', $headerFormParamsAssocArr) && !empty($headerFormParamsAssocArr['keyword'])) {
            $keyword = $headerFormParamsAssocArr['keyword'];
            $langIdForKeywordSeach = $this->siteLangId;
        }

        $verified = 0;
        if (array_key_exists('verified', $headerFormParamsAssocArr)) {
            $verified = FatUtility::int($headerFormParamsAssocArr['verified']);
        }      // echo '<pre>'; print_r($headerFormParamsAssocArr); die;
		
		$foundingmember = 0;
        if (array_key_exists('foundingmember', $headerFormParamsAssocArr)) {
            $foundingmember = FatUtility::int($headerFormParamsAssocArr['foundingmember']);
        }

        $cacheKey = FilterHelper::getCacheKey($this->siteLangId, $headerFormParamsAssocArr);
        $headerFormParamsAssocArr['doNotJoinSpecialPrice'] = true;
        $prodSrchObj = $this->getFilterSearchObj($langIdForKeywordSeach, $headerFormParamsAssocArr);
        $prodSrchObj->doNotCalculateRecords();

        $shopCatFilters = false;
		$shop_id = 0;
        if (array_key_exists('shop_id', $headerFormParamsAssocArr)) {
            $shop_id = FatUtility::int($headerFormParamsAssocArr['shop_id']);
            $searchFrm = Shop::getFilterSearchForm();
            $searchFrm->fill($headerFormParamsAssocArr);
            $this->set('searchFrm', $searchFrm);
            if (0 < $shop_id) {
                $shopCatFilters = true;
            }
        }

        $sellerTypeCheckedArr = array();
        if (array_key_exists('sellertypes', $headerFormParamsAssocArr)) {
            $sellerTypeCheckedArr = $headerFormParamsAssocArr['sellertypes'];
        }
		$this->set('sellerTypeCheckedArr', $sellerTypeCheckedArr);        
		
		$supplierTypeCheckedArr = array();
        if (array_key_exists('supplier', $headerFormParamsAssocArr)) {
            $supplierTypeCheckedArr = $headerFormParamsAssocArr['supplier'];
        }
		$this->set('supplierTypeCheckedArr', $supplierTypeCheckedArr);


		$ratingCheckedArr  = [];
        if (array_key_exists('rating', $headerFormParamsAssocArr)) {
            $ratingCheckedArr = $headerFormParamsAssocArr['rating'];
        } 
		$this->set('ratingCheckedArr', $ratingCheckedArr);

        /* Contry Filters Data[ */
        $checkedCountriesArr = FilterHelper::selectedCountries($headerFormParamsAssocArr); //echo '<pre>';print_r($checkedCountriesArr); die;
        $countriesArr = FilterHelper::getShopCountries($prodSrchObj, $this->siteLangId, $headerFormParamsAssocArr, false, true);
        /* ] */

        $this->set('verified', $verified);
        $this->set('foundingmember', $foundingmember);
        $this->set('countriesArr', $countriesArr);
        $this->set('checkedCountriesArr', $checkedCountriesArr);
        $this->set('headerFormParamsAssocArr', $headerFormParamsAssocArr);
		$this->set('layoutDirection', CommonHelper::getLayoutDirection());
		$this->set('shop_id', $shop_id);

        echo $this->_template->render(false, false, 'shops/filters.php', true);
        exit;			
    }

    public function relatedProducts()
    {
		$keyword = FatApp::getPostedData('keyword');
		$this->set('products', []);
		if(!empty($keyword)) {
			$get = ['keyword'=>$keyword];
			$db = FatApp::getDb();
			$srch = Product::getListingObj($get, $this->siteLangId);
			$srch->setPageSize(8);
			$rs = $srch->getResultSet();
			$products = $db->fetchAll($rs);
			$this->set('products', $products);
			$this->set('recordCount' , $srch->recordCount());
		}
        echo $this->_template->render(false, false, 'shops/related-products.php', true);
        exit;
    }
	
	
}
