<?php

class PaymentMethods extends MyAppModel
{
    public const DB_TBL = 'tbl_payment_methods';
    public const DB_TBL_LANG = 'tbl_payment_methods_lang';
    public const DB_TBL_PREFIX = 'pmethod_';

    public const PAYMENT_METHOD_PAYULATAM = 18;
    public const PAYMENT_METHOD_PAYPAL = 2;
    public const PAYMENT_METHOD_STRIPE = 5;
    public const PAYMENT_METHOD_BANK_TRANSFER = 9;
    
    public const PAYMENT_METHOD_TYPE_LOCAL = 1;
    public const PAYMENT_METHOD_TYPE_GLOBAL = 2;
    public const PAYMENT_METHOD_TYPE_ALL = -1;

    private $db;

    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
        $this->db = FatApp::getDb();
        $this->objMainTableRecord->setSensitiveFields(
                array(
                    'pmethod_code'
                )
        );
    }

    public static function getSearchObject($langId = 0, $isActive = true)
    {
        $langId = FatUtility::int($langId);

        $srch = new SearchBase(static::DB_TBL, 'pm');
        if ($isActive == true) {
            $srch->addCondition('pm.' . static::DB_TBL_PREFIX . 'active', '=', AppConstants::ACTIVE);
        }

        if ($langId > 0) {
            $srch->joinTable(
                    static::DB_TBL_LANG, 'LEFT OUTER JOIN', 'pm_l.pmethodlang_' . static::DB_TBL_PREFIX . 'id = pm.' . static::DB_TBL_PREFIX . 'id and pm_l.pmethodlang_lang_id = ' . $langId, 'pm_l'
            );
        }

        $srch->addOrder('pm.' . static::DB_TBL_PREFIX . 'active', 'DESC');
        $srch->addOrder('pm.' . static::DB_TBL_PREFIX . 'display_order', 'ASC');
        return $srch;
    }

    public function cashOnDeliveryIsActive()
    {
        $paymentMethod = PaymentMethods::getSearchObject();
        $paymentMethod->addMultipleFields(array('pmethod_id', 'pmethod_code', 'pmethod_active'));
        $paymentMethod->addCondition('pmethod_code', '=', 'cashondelivery');
        $paymentMethod->addCondition('pmethod_active', '=', AppConstants::YES);
        $rs = $paymentMethod->getResultSet();
        if (FatApp::getDb()->fetch($rs)) {
            return true;
        } else {
            return false;
        }
    }

    public static function getLocalPaymentGateways(): array
    {
        $srch = static::getSearchObject(0, AppConstants::YES);
        $srch->addCondition('pmethod_type', '=', static::PAYMENT_METHOD_TYPE_LOCAL);
        $srch->addFld('pmethod_id');
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);
        //return [static::PAYMENT_METHOD_PAYULATAM, static::PAYMENT_METHOD_PAYPAL];
        return (empty($records)) ? [] : array_column($records, 'pmethod_id');
    }

    public static function getGlobalPaymentGateways(): array
    {
        $srch = static::getSearchObject(0, AppConstants::YES);
        $srch->addCondition('pmethod_type', '=', static::PAYMENT_METHOD_TYPE_GLOBAL);
        $srch->addFld('pmethod_id');
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);
        //return [static::PAYMENT_METHOD_STRIPE, static::PAYMENT_METHOD_PAYPAL];
        return (empty($records)) ? [] : array_column($records, 'pmethod_id');
    }

    public static function getPaymentMethodTypes(int $langId, bool $includeBoth = false): array
    {
        if (0 >= $langId) {
            $langId = CommonHelper::getLangId();
        }
        $types = [
            static::PAYMENT_METHOD_TYPE_LOCAL => Labels::getLabel('LBL_Colombia_Payment_Gateways', $langId),
            static::PAYMENT_METHOD_TYPE_GLOBAL => Labels::getLabel('LBL_US_Payment_Gateways', $langId)
        ];
        if ($includeBoth) {
            $types[static::PAYMENT_METHOD_TYPE_ALL] = Labels::getLabel('LBL_Both', $langId);
        }
        return $types;
    }

}
