<?php

class RfqCancelReason extends MyAppModel
{

    public const DB_TBL = 'tbl_rfq_cancel_reasons';
    public const DB_TBL_PREFIX = 'rcr_';
    public const DB_TBL_LANG = 'tbl_rfq_cancel_reasons_lang';
    
    public const REASON_FOR_BUYER = 1;
    public const REASON_FOR_SELLER = 2;
    
    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
    }

    public static function getSearchObject(int $langId = 0)
    {
        $srch = new SearchBase(static::DB_TBL);
        if ($langId > 0) {
            $srch->joinTable(static::DB_TBL_LANG, 'LEFT OUTER JOIN', 'rcrlang_rcr_id = rcr_id AND rcrlang_lang_id = ' . $langId);
        }
        return $srch;
    }

    public static function reasonsArr(int $reasonFor = 0, int $langId = 0)
    {
        $srch = static::getSearchObject($langId);
        $srch->addMultipleFields(array('rcr_id', 'IFNULL(rcr_title, rcr_identifier) as rcr_title'));
        if ($reasonFor > 0) {
            $srch->addCondition('rcr_for', '=', $reasonFor);
        }
        $srch->addCondition('rcr_active', '=', AppConstants::YES);
        $rs = $srch->getResultSet();
        return FatApp::getDb()->fetchAllAssoc($rs);
    }

    public function saveTranslatedLangData($langId)
    {
        $langId = FatUtility::int($langId);
        if ($this->mainTableRecordId < 1 || $langId < 1) {
            $this->error = Labels::getLabel('ERR_Invalid_Request', $this->commonLangId);
            return false;
        }

        $translateLangobj = new TranslateLangData(static::DB_TBL_LANG);
        if (false === $translateLangobj->updateTranslatedData($this->mainTableRecordId, 0, $langId)) {
            $this->error = $translateLangobj->getError();
            return false;
        }
        return true;
    }

    public function getTranslatedData($data, $toLangId)
    {
        $toLangId = FatUtility::int($toLangId);
        if (empty($data) || $toLangId < 1) {
            $this->error = Labels::getLabel('ERR_Invalid_Request', $this->commonLangId);
            return false;
        }

        $translateLangobj = new TranslateLangData(static::DB_TBL_LANG);
        $translatedData = $translateLangobj->directTranslate($data, $toLangId);
        if (false === $translatedData) {
            $this->error = $translateLangobj->getError();
            return false;
        }
        return $translatedData;
    }

}
