<?php

class ShopDocument extends MyAppModel
{
    public const DB_TBL = 'tbl_shop_documents';
    public const DB_TBL_PREFIX = 'shopdoc_';
    
    public const DB_TBL_LANG = 'tbl_shop_documents_lang';
    public const DB_TBL_LANG_PREFIX = 'shopdoclang_';
    
    public const SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE = 1;
    public const SHOP_DOCUMENT_TYPE_TRADE_SHOW = 2;
    public const SHOP_DOCUMENT_TYPE_INSPECTION_REPORT = 3;
    
    private $shopId;
    
    public function __construct(int $shopId, int $shopDocId = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $shopDocId);
        $this->shopId = $shopId;
    }
    
    public function getSearchObject(int $langId = 0) {
        $srch = new SearchBase(static::DB_TBL, 'sdoc');
        $srch->addCondition('shopdoc_shop_id', '=', $this->shopId);
        if ($langId > 0) {
            $srch->joinTable(static::DB_TBL_LANG, 'LEFT OUTER JOIN', 'sdoclang.shopdoclang_shopdoc_id = sdoc.shopdoc_id AND sdoclang.shopdoclang_lang_id='. $langId, 'sdoclang');
        }
        return $srch;
    }
    
    public static function getAllLanguagesData(int $docId)
    {
        $srch = new SearchBase(static::DB_TBL_LANG, 'sdoc');
        $srch->addCondition('shopdoclang_shopdoc_id', '=', $docId);
        $srch->addMultipleFields(array('shopdoclang_lang_id', 'shopdoc_name'));
        $rs = $srch->getResultSet();
        return FatApp::getDb()->fetchAllAssoc($rs);
    }
}
