<?php

class ShopProfile extends MyAppModel
{
    public const DB_TBL = 'tbl_seller_profiles';
    public const DB_TBL_PREFIX = 'sprofile_';
    
    public const DB_TBL_LANG = 'tbl_seller_profiles_lang';
    public const DB_TBL_LANG_PREFIX = 'sprofilelang_';

    public const SELLER_TYPE_DISTRIBUTOR = 1;
    public const SELLER_TYPE_MANUFACTURER = 2;
    public const SELLER_SERVICE_PROVIDER = 3;
    public const USER_TYPE_BUYER = 4;
    
    private $shopId = 0;
    
    public function __construct(int $shopId = 0)
    {
        //parent::__construct();
        $this->$shopId = $shopId;
        
    }
   
    public static function getSellerTypeArr(int $langId, bool $includeBuyer = false) : array
    {
        $prefix = "";
        $userType = [];
        if ($includeBuyer) {
            $userType[static::USER_TYPE_BUYER] = Labels::getLabel('LBL_Buyer', $langId);
            $prefix = "_Seller_>>_";
        }
        
        $sellerTypes = [
            static::SELLER_TYPE_DISTRIBUTOR => Labels::getLabel('LBL_'. $prefix .'Distributor/Retailer', $langId),
            static::SELLER_TYPE_MANUFACTURER => Labels::getLabel('LBL_'. $prefix .'Manufacturer', $langId),
            static::SELLER_SERVICE_PROVIDER => Labels::getLabel('LBL_'. $prefix .'Service_Provider', $langId),
        ];
        $sellerTypes = $userType + $sellerTypes;
        
        return $sellerTypes;
    }
    
    /* public static function getReportUserTypeArr(int $langId)  : array
    {
        return [
            static::USER_TYPE_BUYER => Labels::getLabel('LBL_Buyer', $langId),
            static::SELLER_TYPE_DISTRIBUTOR => Labels::getLabel('LBL_Seller_>>_Distributor/Retailer', $langId),
            static::SELLER_TYPE_MANUFACTURER => Labels::getLabel('LBL_Seller_>>_Manufacturer', $langId),
            static::SELLER_SERVICE_PROVIDER => Labels::getLabel('LBL_Seller_>>_Service_Provider', $langId),
        ];
        
    } */

    public function updateProfile(array $data) : bool
    {
        if (empty($data) || ($data['sprofile_user_id'] <= 0)) {
            $this->error = Labels::getLabel('MSG_Invalid_Request');
            return false;
        }
        if (!FatApp::getDb()->insertFromArray(static::DB_TBL, $data, false, array(), $data)) {
            $this->error = FatApp::getDb()->getError();
            return false;
        }
        return true;
    }
    
    public static function getSellerProfileData(int $userId, int $langId) : array
    {
        $srch = new SearchBase(static::DB_TBL, 'sprofile');
        //$flds = array('sprofile.*');
        if ($langId > 0) {
            $srch->joinTable(static::DB_TBL_LANG, 'LEFT OUTER JOIN', 'splang.sprofilelang_sprofile_user_id = sprofile.sprofile_user_id AND splang.sprofilelang_lang_id ='. $langId, 'splang');
            //$flds += array('splang.sprofile_production_process', 'splang.sprofile_advantages');
        }
        $srch->addCondition(static::DB_TBL_PREFIX.'user_id', '=', $userId);
        //$srch->addMultipleFields($flds);
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if (empty($row)) {
            return [];
        }
        return $row;
    }
    
    public function updateProfileLang(array $data) : bool
    {
        if (empty($data)) {
            $this->error = Labels::getLabel('MSG_Invalid_Request');
            return false;
        }
        
        if (!FatApp::getDb()->insertFromArray(static::DB_TBL_LANG, $data, false, array(), $data)) {
            $this->error = FatApp::getDb()->getError();
            return false;
        }
        
        return true;    
    }
    
}
