<?php

class Transactions extends MyAppModel
{
    public const DB_TBL = 'tbl_user_transactions';
    public const DB_TBL_PREFIX = 'utxn_';

    public const STATUS_PENDING = 0;
    public const STATUS_COMPLETED = 1;
    public const STATUS_DECLINED = 2;

    public const WITHDRAWL_STATUS_PENDING = 0;
    public const WITHDRAWL_STATUS_COMPLETED = 1;
    public const WITHDRAWL_STATUS_APPROVED = 2;
    public const WITHDRAWL_STATUS_DECLINED = 3;
    public const WITHDRAWL_STATUS_PROCESSED = 4;
    public const WITHDRAWL_STATUS_PAYOUT_FAILED = 5;
    public const WITHDRAWL_STATUS_PAYOUT_UNCLAIMED = 6;

    public const TYPE_AFFILIATE_REFERRAL_SIGN_UP = 1;
    public const TYPE_AFFILIATE_REFERRAL_ORDER = 2;
    public const TYPE_LOADED_MONEY_TO_WALLET = 3;
    public const TYPE_ORDER_PAYMENT = 4;
    public const TYPE_ORDER_REFUND = 5;
    public const TYPE_PRODUCT_SALE = 6;
    public const TYPE_PRODUCT_SALE_ADMIN_COMMISSION = 7;
    public const TYPE_MONEY_WITHDRAWN = 8;
    public const TYPE_PPC = 9;
    public const TYPE_MONEY_WITHDRAWL_REFUND = 10;
    public const TYPE_ORDER_SHIPPING = 11;

    public const CREDIT_TYPE = 1;
    public const DEBIT_TYPE = 2;

    public function __construct($utxnId = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $utxnId);
    }

    public static function getSearchObject()
    {
        $srch = new SearchBase(static::DB_TBL, 'utxn');
        return $srch;
    }

    public static function getStatusArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId == 0) {
            trigger_error(Labels::getLabel('MSG_Language_Id_not_specified.', CommonHelper::getLangId()), E_USER_ERROR);
        }
        $arr = array(
            static::STATUS_PENDING => Labels::getLabel('LBL_TRANSACTION_PENDING', $langId),
            static::STATUS_COMPLETED => Labels::getLabel('LBL_TRANSACTION_COMPLETED', $langId),
            static::STATUS_DECLINED => Labels::getLabel('LBL_TRANSACTION_DECLINED', $langId)
        );
        return $arr;
    }

    public static function getWithdrawlStatusArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId == 0) {
            trigger_error(Labels::getLabel('MSG_Language_Id_not_specified.', $langId), E_USER_ERROR);
        }
        $arr = array(
            static::WITHDRAWL_STATUS_PENDING => Labels::getLabel('LBL_Withdrawal_Request_Pending', $langId),
            static::WITHDRAWL_STATUS_COMPLETED => Labels::getLabel('LBL_Withdrawal_Request_Completed', $langId),
            static::WITHDRAWL_STATUS_APPROVED => Labels::getLabel('LBL_Withdrawal_Request_Approved', $langId),
            static::WITHDRAWL_STATUS_DECLINED => Labels::getLabel('LBL_Withdrawal_Request_Declined', $langId),
            static::WITHDRAWL_STATUS_PROCESSED => Labels::getLabel('LBL_WITHDRAWAL_REQUEST_PROCESSED', $langId),
            static::WITHDRAWL_STATUS_PAYOUT_FAILED => Labels::getLabel('LBL_WITHDRAWAL_REQUEST_PAYOUT_FAILED', $langId),
            static::WITHDRAWL_STATUS_PAYOUT_UNCLAIMED => Labels::getLabel('LBL_WITHDRAWAL_REQUEST_PAYOUT_UNCLAMED', $langId),
        );
        return $arr;
    }

    public static function getCreditDebitTypeArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId == 0) {
            trigger_error(Labels::getLabel('MSG_Language_Id_not_specified.', $langId), E_USER_ERROR);
        }

        $arr = array(
            static::CREDIT_TYPE => Labels::getLabel('LBL_Credit', $langId),
            static::DEBIT_TYPE => Labels::getLabel('LBL_Debit', $langId)
        );
        return $arr;
    }

    public function getAttributesBywithdrawlId($withdrawalId, $attr = null)
    {
        $withdrawalId = FatUtility::int($withdrawalId);
        if (1 > $withdrawalId) {
            trigger_error(Labels::getLabel('MSG_INVALID_REQUEST', $this->commonLangId), E_USER_ERROR);
            return false;
        }

        $srch = static::getSearchObject();
        if (null != $attr) {
            if (is_array($attr)) {
                $srch->addMultipleFields($attr);
            } elseif (is_string($attr)) {
                $srch->addFld($attr);
            }
        }

        $srch->addCondition('utxn.utxn_withdrawal_id', '=', $withdrawalId);

        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);

        if (!empty($row)) {
            return $row;
        }

        return false;
    }

    public function getAttributesWithUserInfo($userId = 0, $attr = null)
    {
        $userId = FatUtility::int($userId);
        $srch = static::getSearchObject();
        $srch->joinTable(User::DB_TBL, 'LEFT OUTER JOIN', 'u.user_id = utxn.utxn_user_id', 'u');
        $srch->joinTable(User::DB_TBL_CRED, 'LEFT OUTER JOIN', 'c.credential_user_id = u.user_id', 'c');

        if (null != $attr) {
            if (is_array($attr)) {
                $srch->addMultipleFields($attr);
            } elseif (is_string($attr)) {
                $srch->addFld($attr);
            }
        }

        if ($this->mainTableRecordId > 0) {
            $srch->addCondition('utxn.utxn_id', '=', $this->mainTableRecordId);
        }

        if ($userId > 0) {
            $srch->addCondition('utxn.utxn_user_id', '=', $userId);
        }

        $rs = $srch->getResultSet();

        if ($this->mainTableRecordId > 0) {
            $row = FatApp::getDb()->fetch($rs);
        } else {
            $row = FatApp::getDb()->fetchAll($rs, 'utxn_id');
        }

        if (!empty($row)) {
            return $row;
        }

        return array();
    }

    public function addTransaction($data)
    {
        $userId = FatUtility::int($data['utxn_user_id']);
        if ($userId < 1) {
            trigger_error(Labels::getLabel('MSG_INVALID_REQUEST', $this->commonLangId), E_USER_ERROR);
            return false;
        }
        $data['utxn_date'] = date('Y-m-d H:i:s');
        $data['utxn_default_currency_to_cop'] = isset($data['utxn_default_currency_to_cop']) ? $data['utxn_default_currency_to_cop'] : 0;
        
        /*BOC to show colombian seller wallet in colombian peso*/
        /*if (!isset($data['utxn_debit_cop']) && isset($data['utxn_debit'])) {
             $data['utxn_debit_cop'] = $data['utxn_debit'];
        }
        
        if (!isset($data['utxn_credit_cop']) && isset($data['utxn_credit'])) {
             $data['utxn_credit_cop'] = $data['utxn_credit'];
        }*/
        
        $shopDetail = Shop::getUserShopDetail($userId);
        if (!empty($shopDetail) && strtolower($shopDetail['country_code']) == strtolower(Countries::COLOMBIAN_COUNTRY_CODE)) {
            if(isset($data['utxn_order_id'])) {
                $orderObj = new Orders();
                $orderDetail = $orderObj->getOrderById($data['utxn_order_id']);
            } else if (isset($data['utxn_op_id'])) {
                $orderProd = new OrderProduct($data['utxn_op_id']);
                $orderDetail = $orderProd->getOrderProdDetail();
            } 

            if (!empty($orderDetail) && $orderDetail['order_default_currency_to_cop'] > 0) {
                $data['utxn_default_currency_to_cop'] = $orderDetail['order_default_currency_to_cop'];
                if (!isset($data['utxn_debit_cop']) && isset($data['utxn_debit'])) {
                    $data['utxn_debit_cop'] = number_format($data['utxn_debit'] * $orderDetail['order_default_currency_to_cop'], 2, '.', '');
                }
                
                if (!isset($data['utxn_credit_cop']) && isset($data['utxn_credit'])) {
                    $data['utxn_credit_cop'] = number_format($data['utxn_credit'] * $orderDetail['order_default_currency_to_cop'], 2, '.', '');
                }
            }
        }
         
        /***********************EOC***************************/
    
        $this->assignValues($data);
        if (!$this->save()) {
            return false;
        }
        return $this->getMainTableRecordId();
    }

    public function getTransactionSummary(int $userId = 0, $date = '')
    {
        $srch = static::getSearchObject();
        if ($userId > 0) {
            $srch->addCondition('utxn.utxn_user_id', '=', $userId);
        }

        if (!empty($date)) {
            $srch->addCondition('mysql_func_DATE(utxn.utxn_date)', '=', $date, 'AND', true);
        }

        $srch->addMultipleFields(array('IFNULL(SUM(utxn.utxn_credit),0) AS total_earned', 'IFNULL(SUM(utxn.utxn_debit),0) AS total_used'));
        $srch->doNotCalculateRecords();
        $srch->doNotlimitRecords();
        $srch->addCondition('utxn_status', '=', AppConstants::ACTIVE);
        $rs = $srch->getResultSet();

        if ($row = FatApp::getDb()->fetch($rs)) {
            return $row;
        }

        return array('total_earned' => 0, 'total_used' => 0);
    }

    public static function formatTransactionNumber($txnId)
    {
        $newValue = str_pad($txnId, 7, '0', STR_PAD_LEFT);
        $newValue = "TN" . "-" . $newValue;
        return $newValue;
    }

    public static function formatTransactionComments($txnComments)
    {
        $strComments = $txnComments;
        $strComments = preg_replace('/<\/?a[^>]*>/', '', $strComments);
        return $strComments;
    }

    public static function getUserTransactionsObj(int $userId, bool $converAmtInColombianCurr = false)
    {
        $balSrch = static::getSearchObject();
        $balSrch->doNotCalculateRecords();
        $balSrch->doNotLimitRecords();
        if ($converAmtInColombianCurr) {
            $balSrch->addMultipleFields(array('utxn.*', "utxn_credit_cop - utxn_debit_cop as bal"));
        } else {
            $balSrch->addMultipleFields(array('utxn.*', "utxn_credit - utxn_debit as bal"));
        }
        $balSrch->addCondition('utxn_user_id', '=', $userId);
        $balSrch->addCondition('utxn_status', '=', AppConstants::ACTIVE);
        $qryUserPointsBalance = $balSrch->getQuery();

        $srch = static::getSearchObject();
        $srch->joinTable('(' . $qryUserPointsBalance . ')', 'JOIN', 'tqupb.utxn_id <= utxn.utxn_id', 'tqupb');

        if ($converAmtInColombianCurr) {
            $srch->addMultipleFields(array('utxn.*', "utxn.utxn_credit_cop as utxn_credit", "utxn.utxn_debit_cop as utxn_debit", "SUM(tqupb.bal) balance", "IF(utxn.utxn_credit > 0, " . static::CREDIT_TYPE . ", " . static::DEBIT_TYPE . ") as txnPaymentType"));
        } else {
            $srch->addMultipleFields(array('utxn.*', "SUM(tqupb.bal) balance", "IF(utxn.utxn_credit > 0, " . static::CREDIT_TYPE . ", " . static::DEBIT_TYPE . ") as txnPaymentType"));
        }

        $srch->addCondition('utxn.utxn_user_id', '=', $userId);
        $srch->addGroupBy('utxn.utxn_id');
        $srch->addOrder('utxn_id', 'DESC');
        return $srch;
    }
}
