<?php

class FilterHelper extends FatUtility
{

    public static function getSearchObj($langId, $headerFormParamsAssocArr)
    {
        $langId = FatUtility::int($langId);
        $post = FatApp::getPostedData();
        $prodSrchObj = new ProductSearch($langId);
        $prodSrchObj->joinSellerProducts(0, '', $headerFormParamsAssocArr, true);
        $prodSrchObj->unsetDefaultLangForJoins();
        $prodSrchObj->joinSellers();
        $prodSrchObj->joinShops($langId);
        $prodSrchObj->joinShopCountry();
        $prodSrchObj->joinShopState();
        $prodSrchObj->joinBrands($langId);
        $prodSrchObj->joinProductToCategory($langId,false);
        $prodSrchObj->joinSellerSubscription(0, false, true);
        $prodSrchObj->addSubscriptionValidCondition();
        $prodSrchObj->joinSellerReturnAddress();
        $categoryId = 0;
        $categoriesArr = array();
        if (array_key_exists('category', $post)) {
            $prodSrchObj->addCategoryCondition($post['category']);
            $categoryId = FatUtility::int($post['category']);
        }

        $shopId = FatApp::getPostedData('shop_id', FatUtility::VAR_INT, 0);
        if (0 < $shopId) {
            $prodSrchObj->addShopIdCondition($shopId);
        }

        $topProducts = FatApp::getPostedData('top_products', FatUtility::VAR_INT, 0);
        if (0 < $topProducts) {
            $prodSrchObj->joinProductRating();
            $prodSrchObj->addCondition('prod_rating', '>=', 3);
        }

        $brandId = FatApp::getPostedData('brand_id', FatUtility::VAR_INT, 0);
        if (0 < $brandId) {
            $prodSrchObj->addBrandCondition($brandId);
        }

        $featured = FatApp::getPostedData('featured', FatUtility::VAR_INT, 0);
        if (0 < $featured) {
            $prodSrchObj->addCondition('product_featured', '=', AppConstants::YES);
        }

        $keyword = '';
        if (array_key_exists('keyword', $headerFormParamsAssocArr) && !empty($headerFormParamsAssocArr['keyword'])) {
            $keyword = $headerFormParamsAssocArr['keyword'];
            $prodSrchObj->addKeywordSearch($keyword, false, false);
        }
        return $prodSrchObj;
    }


    public static function getShopSearchObj($langId, $headerFormParamsAssocArr)
    {
        $langId = FatUtility::int($langId);
        $post = FatApp::getPostedData();
        $shopSrchObj = new ShopSearch($langId);
        $shopSrchObj->joinShopCountry($langId);

        $shopId = FatApp::getPostedData('shop_id', FatUtility::VAR_INT, 0);
        if (0 < $shopId) {
            $shopSrchObj->addShopIdCondition($shopId);
        }
        $keyword = '';
        if (array_key_exists('keyword', $headerFormParamsAssocArr) && !empty($headerFormParamsAssocArr['keyword'])) {
            $keyword = $headerFormParamsAssocArr['keyword'];
            $shopSrchObj->addKeywordSearch($keyword, false, false);
        }
        return $shopSrchObj;
    }

    public static function getParamsAssocArr()
    {
        $post = FatApp::getPostedData();

        $get = FatApp::getParameters();
        $headerFormParamsAssocArr = Product::convertArrToSrchFiltersAssocArr($get);
        return array_merge($headerFormParamsAssocArr, $post);
    }

    public static function getCacheKey($langId, $post)
    {
        $cacheKey = $langId;

        if (array_key_exists('category', $post)) {
            $cacheKey .= '-' . FatUtility::int($post['category']);
        }

        if (array_key_exists('shop_id', $post)) {
            $cacheKey .= '-' . $post['shop_id'];
        }

        if (array_key_exists('top_products', $post)) {
            $cacheKey .= '-tp';
        }

        if (array_key_exists('brand_id', $post)) {
            $cacheKey .= '-' . $post['brand_id'];
        }

        if (array_key_exists('featured', $post)) {
            $cacheKey .= '-f';
        }

        if (array_key_exists('keyword', $post) && !empty($post['keyword'])) {
            $cacheKey .= '-' . urlencode($post['keyword']);
        }

        return $cacheKey;
    }

    public static function selectedBrands($post)
    {
        if (array_key_exists('brand', $post)) {
            if (API_CALL) {
                $post['brand'] = json_decode($post['brand'], true);
            }

            if (is_array($post['brand'])) {
                return $post['brand'];
            }

            return explode(',', $post['brand']);
        }
        return array();
    }

    public static function selectedCountries($post)
    {
        if (array_key_exists('country', $post)) {
            if (API_CALL) {
                $post['country'] = json_decode($post['country'], true);
            }

            if (is_array($post['country'])) {
                return $post['country'];
            }

            return explode(',', $post['country']);
        }
        return array();
    }

    public static function brands($prodSrchObj, $langId, $post, $doNotLimitRecord = false, $includePriority = false)
    {
        $brandId = 0;
        if (array_key_exists('brand_id', $post)) {
            $brandId = FatUtility::int($post['brand_id']);
        }

        $brandsCheckedArr = array();
        if (true == $includePriority) {
            $brandsCheckedArr = static::selectedBrands($post);
        }

        $brandSrch = clone $prodSrchObj;
        if (true == $doNotLimitRecord) {
            $brandSrch->doNotLimitRecords();
        } else {
            $pageSize = max(count($brandsCheckedArr), 10);
            $brandSrch->setPageSize($pageSize);
        }

        $brandSrch->joinBrandsLang($langId);
        $brandSrch->addGroupBy('brand.brand_id');
        $brandSrch->addMultipleFields(array('brand.brand_id', 'COALESCE(tb_l.brand_name,brand.brand_identifier) as brand_name'));
        if ($brandId) {
            $brandSrch->addCondition('brand_id', '=', $brandId);
            $brandsCheckedArr = array($brandId);
        }

        if (!empty($brandsCheckedArr) && true == $includePriority) {
            $brandSrch->addFld('IF(FIND_IN_SET(brand.brand_id, "' . implode(',', $brandsCheckedArr) . '"), 1, 0) as priority');
            $brandSrch->addOrder('priority', 'desc');
        } else {
            $brandSrch->addFld('0 as priority');
        }
        $brandSrch->addOrder('tb_l.brand_name');
        /* if needs to show product counts under brands[ */
        //$brandSrch->addFld('count(selprod_id) as totalProducts');
        /* ] */
        $brandRs = $brandSrch->getResultSet();
        $brands = FatApp::getDb()->fetchAll($brandRs);

        if (count($brands) > 0 && !FatApp::getConfig('CONF_PRODUCT_BRAND_MANDATORY', FatUtility::VAR_INT, 1) && in_array(null, array_column($brands, 'brand_id'))) {
            array_push($brands, array(
                'brand_id' => '-1',
                'brand_name' => Labels::getLabel('LBL_Unbranded', CommonHelper::getLangId()),
                'priority' => 9999
            ));
            $brands = array_map('array_filter', $brands);
            $brands = array_values(array_filter($brands));
        }
        return $brands;
    }

    public static function countries($prodSrchObj, $langId, $post, $doNotLimitRecord = false, $includePriority = false)
    {

        $countriesCheckedArr = array();
        if (true == $includePriority) {
            $countriesCheckedArr = static::selectedCountries($post);
        }

        $countrySrch = clone $prodSrchObj;
        if (true == $doNotLimitRecord) {
            $countrySrch->doNotLimitRecords();
        } else {
            $pageSize = max(count($countriesCheckedArr), 10);
            $countrySrch->setPageSize($pageSize);
        }

        $countrySrch->joinReturnCountryLang($langId);
        $countrySrch->addGroupBy('rcountry.country_id');
        $countrySrch->addMultipleFields(array('rcountry.country_id', 'COALESCE(rcountrylang.country_name,rcountry.country_code) as country_name'));
        if (!empty($countriesCheckedArr) && true == $includePriority) {
            $countrySrch->addFld('IF(FIND_IN_SET(rcountry.country_id, "' . implode(',', $countriesCheckedArr) . '"), 1, 0) as priority');
            $countrySrch->addOrder('priority', 'desc');
        } else {
            $countrySrch->addFld('0 as priority');
        }
        $countrySrch->addOrder('rcountrylang.country_name');

        $countryRs = $countrySrch->getResultSet(); 
        $countries = FatApp::getDb()->fetchAll($countryRs);

        if (count($countries) > 0 && in_array(null, array_column($countries, 'country_id'))) {
            array_push($brands, array(
                'countty_id' => '-1',
                'country_name' => Labels::getLabel('LBL_All', CommonHelper::getLangId()),
                'priority' => 9999
            ));
            $countries = array_map('array_filter', $countries);
            $countries = array_values(array_filter($countries));
        }
        return $countries;
    }


    public static function getShopCountries($prodSrchObj, $langId, $post, $doNotLimitRecord = false, $includePriority = false)
    {

        $countriesCheckedArr = array();
        if (true == $includePriority) {
            $countriesCheckedArr = static::selectedCountries($post);
        }

        $countrySrch = clone $prodSrchObj;
        if (true == $doNotLimitRecord) {
            $countrySrch->doNotLimitRecords();
        } else {
            $pageSize = max(count($countriesCheckedArr), 10);
            $countrySrch->setPageSize($pageSize);
        }

        $countrySrch->addGroupBy('country_id');
        $countrySrch->addMultipleFields(array('country_id', 'COALESCE(country_name,country_code) as country_name'));


        if (!empty($countriesCheckedArr) && true == $includePriority) {
            $countrySrch->addFld('IF(FIND_IN_SET(country_id, "' . implode(',', $countriesCheckedArr) . '"), 1, 0) as priority');
            $countrySrch->addOrder('priority', 'desc');
        } else {
            $countrySrch->addFld('0 as priority');
        }
        $countrySrch->addOrder('country_name');

        $countryRs = $countrySrch->getResultSet(); 
        $countries = FatApp::getDb()->fetchAll($countryRs);

        if (count($countries) > 0 && in_array(null, array_column($countries, 'country_id'))) {
            array_push($brands, array(
                'countty_id' => '-1',
                'country_name' => Labels::getLabel('LBL_All', CommonHelper::getLangId()),
                'priority' => 9999
            ));
            $countries = array_map('array_filter', $countries);
            $countries = array_values(array_filter($countries));
        }
        return $countries;
    }
	
    public static function getPrice($post, $langId, $userId = 0)
    {
        $langIdForKeywordSeach = 0;
        if (array_key_exists('keyword', $post) && !empty($post['keyword'])) {
            $langIdForKeywordSeach = $langId;
        }
        unset($post['doNotJoinSpecialPrice']);
        $priceSrch = static::getSearchObj($langIdForKeywordSeach, $post);
        $priceSrch->doNotLimitRecords();
        if ($userId == 0) {
            $priceSrch->addCondition('shop_hide_price_for_guests', '=', AppConstants::NO);
        } else {
            $priceSrch->addCondition('shop_hide_price_for_loginusers', '=', AppConstants::NO);
        }

        $priceSrch->doNotCalculateRecords();
        $priceSrch->addMultipleFields(array('MIN(theprice) as minPrice', 'MAX(theprice) as maxPrice'));
        $qry = $priceSrch->getQuery();
        $qry .= ' having minPrice IS NOT NULL AND maxPrice IS NOT NULL';
        
        $priceRs = FatApp::getDb()->query($qry);
        return FatApp::getDb()->fetch($priceRs);
    }

    public static function getCategories($langId, $categoryId, $prodSrchObj, $cacheKey)
    {
        $cacheKey .= (API_CALL) ? $cacheKey . '-m' : $cacheKey;
        $catSrch = clone $prodSrchObj;
        $catSrch->doNotLimitRecords();
        $catSrch->joinProductToCategoryLang($langId);
        $catSrch->addGroupBy('c.prodcat_id');
        $excludeCatHavingNoProducts = true;
        if (!empty($keyword)) {
            $excludeCatHavingNoProducts = false;
        }
        $categoriesArr = ProductCategory::getTreeArr($langId, $categoryId, false, $catSrch, $excludeCatHavingNoProducts);
        $categoriesArr = (API_CALL) ? array_values($categoriesArr) : $categoriesArr;
        FatCache::set('catFilter' . $cacheKey, serialize($categoriesArr), '.txt');
        return $categoriesArr;
    }

    public static function getOptions($langId, $categoryId, $prodSrchObj)
    {
        $options = FatCache::get('options' . $categoryId . '-' . $langId, CONF_FILTER_CACHE_TIME, '.txt');
        if (!$options) {
            $options = array();
            if ($categoryId && ProductCategory::isLastChildCategory($categoryId)) {
                $selProdCodeSrch = clone $prodSrchObj;
                $selProdCodeSrch->doNotLimitRecords();
                /* Removed Group by as taking time for huge data. handled in fetch all second param */
                $selProdCodeSrch->addMultipleFields(array('product_id', 'selprod_code'));
                $selProdCodeRs = $selProdCodeSrch->getResultSet();
                $selProdCodeArr = FatApp::getDb()->fetchAll($selProdCodeRs, 'selprod_code');

                if (!empty($selProdCodeArr)) {
                    foreach ($selProdCodeArr as $val) {
                        $optionsVal = SellerProduct::getSellerProductOptionsBySelProdCode($val['selprod_code'], $langId, true);
                        $options = $options + $optionsVal;
                    }
                }
            }

            usort(
                    $options, function ($a, $b) {
                if ($a['optionvalue_id'] == $b['optionvalue_id']) {
                    return 0;
                }
                return ($a['optionvalue_id'] < $b['optionvalue_id']) ? -1 : 1;
            }
            );
            FatCache::set('options ' . $categoryId . '-' . $langId, serialize($options), '.txt');
            return $options;
        }
        return unserialize($options);
    }

    public static function getServicesPrice($post, $langId, $userId = 0)
    {
        $priceSrch = new ServiceSearch($langId);
        $priceSrch->joinSellers();
        $priceSrch->joinSellerSubscription();
        $priceSrch->joinShops();
        $priceSrch->joinServiceCategory();
        $priceSrch->doNotLimitRecords();
        $priceSrch->doNotCalculateRecords();
        $priceSrch->addMultipleFields(array('MIN(selprod_price) as minPrice', 'MAX(selprod_price) as maxPrice'));
        if (isset($post['category']) && $post['category'] > 0) {
            $productCatCode = ProductCategory::getAttributesById($post['category'], 'prodcat_code');
            $priceSrch->addCondition('c.prodcat_code', 'LIKE', $productCatCode . '%', 'AND', true);
        }
        if ($userId == 0) {
            $priceSrch->addCondition('shop_hide_price_for_guests', '=', AppConstants::NO);
        } else {
            $priceSrch->addCondition('shop_hide_price_for_loginusers', '=', AppConstants::NO);
        }

        $priceRs = $priceSrch->getResultSet();
        return FatApp::getDb()->fetch($priceRs);
    }

    public static function getServicesCategories($langId, $categoryId, $cacheKey)
    {
        $cacheKey .= (API_CALL) ? $cacheKey . '-m' : $cacheKey;
        $categoriesArr = ProductCategory::getTreeArr($langId, $categoryId, false, false, false);
        $categoriesArr = (API_CALL) ? array_values($categoriesArr) : $categoriesArr;
        FatCache::set('serviceCatFilter' . $cacheKey, serialize($categoriesArr), '.txt');
        return $categoriesArr;
    }

    public static function servicesCountries($langId, $post, $doNotLimitRecord = false, $includePriority = false)
    {
        $countriesCheckedArr = array();
        if (true == $includePriority) {
            $countriesCheckedArr = static::selectedCountries($post);
        }
        $countrySrch = new ServiceSearch($langId);
        $countrySrch->joinSellers();
        $countrySrch->joinSellerSubscription();
        $countrySrch->joinShops();
        $countrySrch->joinServiceCategory();

        if (true == $doNotLimitRecord) {
            $countrySrch->doNotLimitRecords();
        } else {
            $pageSize = max(count($countriesCheckedArr), 10);
            $countrySrch->setPageSize($pageSize);
        }
        $countrySrch->addGroupBy('rcountry.country_id');
        $countrySrch->addMultipleFields(array('rcountry.country_id', 'COALESCE(rcountrylang.country_name,rcountry.country_code) as country_name'));
        if (!empty($countriesCheckedArr) && true == $includePriority) {
            $countrySrch->addFld('IF(FIND_IN_SET(rcountry.country_id, "' . implode(',', $countriesCheckedArr) . '"), 1, 0) as priority');
            $countrySrch->addOrder('priority', 'desc');
        } else {
            $countrySrch->addFld('0 as priority');
        }
        $countrySrch->addOrder('rcountrylang.country_name');
        if (isset($post['category']) && $post['category'] > 0) {
            $countrySrch->addCondition('prodcat_id', '=', $post['category']);
        }
        $countries = FatApp::getDb()->fetchAll($countrySrch->getResultSet());
        if (count($countries) > 0 && in_array(null, array_column($countries, 'country_id'))) {
            array_push($brands, array(
                'countty_id' => '-1',
                'country_name' => Labels::getLabel('LBL_All', CommonHelper::getLangId()),
                'priority' => 9999
            ));
            $countries = array_map('array_filter', $countries);
            $countries = array_values(array_filter($countries));
        }
        return $countries;
    }

}
