<div class="product-seller seller">
    <a href="<?php echo CommonHelper::generateUrl('shops', 'sellerProfile', array($product['shop_id'])); ?>" class="seller__name"><?php echo $product['shop_name']; ?> </a>
    <div class="seller__tags">
        <?php if ((isset($product['subscription_package_id']) && ($product['subscription_package_id'] == SellerPackages::GOLD_PACKAGE)) && $product['seller_verified'] == AppConstants::YES) { ?>
            <div class="tag-verified site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Verified', $siteLangId); ?>">
                <span class="tag-verified__icon"></span>
                <span class="tag-verified__text"><?php echo Labels::getLabel("LBL_Verified", $siteLangId); ?></span>
            </div>
        <?php } ?>
		<?php if (isset($product['seller_type']) && !empty($product['seller_type'])) { 
				$sellerType = ShopProfile::getSellerTypeArr($siteLangId); ?>
			<span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo isset($sellerType[$product['seller_type']]) ? $sellerType[$product['seller_type']]  : ''; ?>" >
				<img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="">
				<span class="site-tooltip__content"><?php echo isset($sellerType[$product['seller_type']]) ? $sellerType[$product['seller_type']]  : ''; ?></span>							
			</span>
		<?php } ?>
        <?php
        if (isset($product['subscription_package_id']) && ($product['subscription_package_id'] > 0) && FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)) { ?>
            <?php if ($product['subscription_package_id'] == SellerPackages::SILVER_PACKAGE) { ?>
                <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?>">
                    <img class="gray-scale" width="22" height="22" class="gray-scale" loading="lazy" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png">
                </span>
            <?php } elseif ($product['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) { ?>
                <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?>">
                    <img width="18" height="18" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dollar.png">
                </span>
        <?php
            }
        }
        ?>
        <?php if ($product['is_founding_member'] == AppConstants::YES) { ?>
            <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Founding_Memeber', $siteLangId); ?>">
                <img idth="22" height="22" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/crown.png">
            </span>
        <?php } ?>

    </div>
</div>