<?php $shop = isset($shop) ? $shop : ''; ?>

<div class="product-card__head">
	<div class="product-media ratio ratio--1by1">
		<?php
		$product['vsmallui'] = isset($smallThumb) && $smallThumb == true ? true : false;
		$product['smallui'] = true;
	$thumbSize = isset($smallThumb) && $smallThumb == true ? 'EXTRA-SMALL' : 'THUMB';
		$size = isset($smallThumb) &&  $smallThumb == true ? 80 : 180;
		$uploadedTime = AttachedFile::setTimeParam($product['selprod_updated_on']);
		$imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($product['product_id'], $thumbSize, $product['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
		if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
			if (isset($product['selprod_id']) && !empty($product['selprod_id'])) {
				$serviceImage = AttachedFile::getAttachment(AttachedFile::FILETYPE_SERVICE_PRODUCT_IMAGE, $product['selprod_id'], 0, -1, false, 0, 0, true);
				if (isset($serviceImage) && !empty($serviceImage)) {
					$imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array(FatUtility::int($serviceImage['afile_record_id']), "THUMB", $serviceImage['afile_id'])) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
				}
			}
		}
		?>
		<a title="<?php echo $product['selprod_title']; ?>" href="<?php echo !isset($product['promotion_id']) ? CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : CommonHelper::generateUrl('Products', 'track', array($product['promotion_record_id'])); ?>">
			<img loading="lazy" src="<?php echo $imgUrl; ?>" alt="<?php echo $product['prodcat_name']; ?>">
		</a>
	</div>
	<?php
	include(CONF_THEME_PATH . '_partial/collection-ui.php'); ?>

	<div class="product-actions">
		<a onClick='quickDetail(<?php echo $product['selprod_id']; ?>)' href="javascript:void(0)" class="btn btn--primary" title="<?php echo Labels::getLabel("LBL_Quick_view", $siteLangId); ?>">
			<span class="action-icon">
				<svg xmlns="http://www.w3.org/2000/svg" width="16" height="13.31" viewBox="0 0 16 13.31">
					<path d="M1.181,9.655a8.136,8.136,0,0,1,16,0,8.136,8.136,0,0,1-16,0Zm8,3.7a3.7,3.7,0,1,0-3.7-3.7A3.7,3.7,0,0,0,9.181,13.352Zm0-1.479A2.218,2.218,0,1,1,11.4,9.655,2.218,2.218,0,0,1,9.181,11.873Z" transform="translate(-1.181 -3)" fill="#fff" />
				</svg>
			</span>
			<?php echo Labels::getLabel("LBL_Quick_view", $siteLangId); ?>
		</a>
		<?php if ($product['in_stock'] > 0) { ?>

			<?php if (!UserAuthentication::isUserLogged() || (UserAuthentication::isUserLogged() && ((User::isBuyer()) || (User::isSeller())) && (UserAuthentication::getLoggedUserId() != $product['selprod_user_id']))) { ?>
				<?php if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {  ?>
					<a onclick="rfqForService(<?php echo $product['selprod_id']; ?> )" href="javascript:void(0)" class="btn btn--secondary" title="<?php echo Labels::getLabel("LBL_Enquire_Now", $siteLangId); ?>">
					<?php } else { ?>

						<a onclick="RequestForQuote(<?php echo $product['selprod_id']; ?> )" href="javascript:void(0)" class="btn btn--secondary" title="<?php echo Labels::getLabel("LBL_Enquire_Now", $siteLangId); ?>">
						<?php }
						?>
						<span class="action-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="18" height="15.802" viewBox="0 0 18 15.802">
								<g>
									<path d="M0,1.773a2.429,2.429,0,0,1,.441-1A2,2,0,0,1,1.925.007C2,0,2.075,0,2.152,0Q7.238,0,12.325.006a.755.755,0,0,1,.452.132.594.594,0,0,1,.188.409c.011,2.254.016,4.508,0,6.762a2.025,2.025,0,0,1-2.053,1.965c-1.775.005-3.549,0-5.324,0-.334,0-.668,0-1,0a1.452,1.452,0,0,0-.886.285q-1.373.983-2.746,1.962c-.425.3-.7.246-.959-.2Zm6.838,2.16H8.05c.6,0,1.206,0,1.809,0a.523.523,0,0,0,.548-.586.544.544,0,0,0-.6-.47H3.853a.543.543,0,0,0-.524.287.518.518,0,0,0,.489.764c1.007,0,2.014,0,3.021,0ZM6.822,6.4H8.209c.556,0,1.112,0,1.668,0a.52.52,0,0,0,.528-.587.546.546,0,0,0-.6-.47H3.834a.53.53,0,0,0-.506.288.521.521,0,0,0,.492.766c1,0,2,0,3,0Z" fill="#fff" />
									<path d="M107.026,93.448h.224q2.822,0,5.642,0a3.057,3.057,0,0,0,2.93-2.019,3.515,3.515,0,0,0,.194-1.065c.026-.98.009-1.96.009-2.941v-.208c.248,0,.481,0,.713,0a14.183,14.183,0,0,1,1.543.039A1.99,1.99,0,0,1,120,89.244c.005,1.714,0,3.428,0,5.143q0,1.955,0,3.911a.561.561,0,0,1-.284.561.572.572,0,0,1-.637-.094c-.908-.655-1.822-1.3-2.729-1.957a1.7,1.7,0,0,0-1.033-.329q-3.076.007-6.151,0a2.037,2.037,0,0,1-2.139-2.145C107.023,94.053,107.026,93.765,107.026,93.448Z" transform="translate(-101.999 -83.118)" fill="#fff" />
								</g>
							</svg>
						</span>
						<?php echo Labels::getLabel("LBL_Enquire_Now", $siteLangId); ?>
						</a>
					<?php } ?>
				<?php } ?>
	</div>


</div>

<div class="product-card__body">

	<div class="product-detail">
		<a href="<?php echo CommonHelper::generateUrl('Category', 'View', array($product['prodcat_id'])) ?>" class="product-category"><?php echo $product['prodcat_name']; ?></a>
		<a href="<?php echo !isset($product['promotion_id']) ? CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : CommonHelper::generateUrl('Products', 'track', array($product['promotion_record_id'])); ?>" class="product-title"><?php echo $product['selprod_title']; ?></a>

		<?php
		include(CONF_THEME_PATH . '_partial/collection/product-price.php');
		if (!isset($smallThumb)) {
			//  include(CONF_THEME_PATH . '_partial/collection/product-badges.php');
		}
		?>

		<?php if (!$shop && (isset($product['from_listing']) && $product['from_listing'] == true)) { 
					$yesOrNo = AppConstants::getYesNoArr($siteLangId); ?>
			<div class="product-sepcs">
				<ul>
					<?php if (!empty($product['is_service_listing'])) {  ?>
							<li><strong><?php echo Labels::getLabel("LBL_Shipping_Required", $siteLangId); ?></strong> <?php echo $yesOrNo[$product['selprod_is_shipping_required']]; ?></li>
					<?php } ?>						
					<?php if (!empty($product['is_service_listing'])) { ?>
							<li><strong><?php echo Labels::getLabel("LBL_Document_Required", $siteLangId); ?></strong> <?php echo $yesOrNo[$product['selprod_document_required']]; ?></li>
					<?php } ?>				
				
					<?php if (!empty($product['selprod_min_order_qty'])) { ?>
							<li><strong><?php echo Labels::getLabel("LBL_Min_Qty.", $siteLangId); ?></strong> <?php echo $product['selprod_min_order_qty']; ?></li>
					<?php }
					if (!empty($product['selprod_condition'])) {
						$conditions = Product::getConditionArr($siteLangId);
					?>
						<li><strong><?php echo Labels::getLabel("LBL_Condition", $siteLangId); ?></strong> <?php echo $conditions[$product['selprod_condition']]; ?></li>

					<?php }

					if (!empty($product['brand_name'])) { ?>
						<li><strong><?php echo Labels::getLabel("LBL_Brand", $siteLangId); ?></strong> <?php echo $product['brand_name']; ?></li>
					<?php } ?>
					<?php if (isset($product['productSpecifications']) && is_array($product['productSpecifications']) && !empty($product['productSpecifications'])) {
						foreach ($product['productSpecifications'] as $prodSpec) { ?>
							<li><strong><?php echo $prodSpec['prodspec_name']; ?></strong> <?php echo $prodSpec['prodspec_value']; ?></li>
					<?php   }
					} ?>

				</ul>
			</div>
		<?php } ?>

	</div>


	<?php if (!$shop) { ?>
		<div class="product-seller seller">
			<div class="product-seller__content">

				<?php if (!isset($smallThumb) || $smallThumb == false) { ?>
					<a href="<?php echo CommonHelper::generateUrl('shops', 'View', array($product['shop_id'])) ?>" class="seller__name"><?php echo $product['shop_name']; ?></a>
				<?php } ?>

				<?php if ((isset($product['from_listing']) && $product['from_listing'] == true)) { ?>
					<div class="shop-details">
						<?php if (isset($product['shop_state_name'])) { ?>
							<span class="shop-location"><?php echo $product['shop_state_name']; ?>, <?php echo $product['shop_country_name']; ?></span>
						<?php } ?>
						<?php if (isset($product['shop_rating']) && $product['shop_rating'] > 0) { ?>
							<div class="shop-ratings">
								<div class="ratings">
									<span class="ratings__star site-icon site-icon--small">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
											<path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
										</svg>
									</span>
									<span class="ratings__value"><?php echo round($product['shop_rating'], 1); ?></span>
								</div>
							</div>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if (!isset($smallThumb) || $smallThumb == false) { ?>

					<div class="seller__tags">

						<?php if (isset($product['subscription_package_id']) > 0) { ?>

							<?php if ((isset($product['subscription_package_id']) && $product['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) && $product['seller_verified'] == 1) { ?>
								<div class="tag-verified site-tooltip" title="<?php echo Labels::getLabel('LBL_Verified', $siteLangId); ?>">
									<span class="tag-verified__icon"></span>
									<span class="tag-verified__text"><?php echo Labels::getLabel("LBL_Verified", $siteLangId); ?></span>
								</div>
							<?php } ?>
							<?php if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)) { ?>
							<?php if (isset($product['seller_type']) && !empty($product['seller_type'])) {
								$sellerType = ShopProfile::getSellerTypeArr($siteLangId); ?>
								<span class="seller__tags-icon site-tooltip">
									<img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="">
									<span class="site-tooltip__content"><?php echo isset($sellerType[$product['seller_type']]) ? $sellerType[$product['seller_type']]  : ''; ?></span>
								</span>
							<?php } ?>

							<?php if ($product['subscription_package_id'] == SellerPackages::SILVER_PACKAGE) { ?>
								<span class="seller__tags-icon site-tooltip">
									<img class="gray-scale" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" alt="">
									<span class="site-tooltip__content"><?php echo $product['subscription_package']; ?></span>
								</span>
							<?php } elseif ($product['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) { ?>
								<span class="seller__tags-icon site-tooltip">
									<img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png">
									<span class="site-tooltip__content"><?php echo $product['subscription_package']; ?></span>
								</span>
							<?php } else { ?>
								<span class="seller__tags-icon site-tooltip">
									<span class="site-tooltip__content"><?php echo $product['subscription_package']; ?></span>
								</span>
								<?php } ?>
							<?php }
							
							if ($product['is_founding_member'] == 1) { ?>
								<span class="seller__tags-icon site-tooltip">
									<img src="<?php echo CONF_WEBROOT_URL; ?>images/crown.png">
									<span class="site-tooltip__content"><?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?></span>
								</span>
							<?php } ?>

						<?php } ?>
					</div>
				<?php } ?>

			</div>
			<?php if ((isset($product['from_listing']) && $product['from_listing'] == true)) { ?>
				<div class="product-seller__actions">
					<a onClick="contactWithSeller(<?php echo $product['shop_id']; ?>, <?php echo $product['selprod_id']; ?>);" href="javascript:void(0);" class="btn btn--bordered btn--block color-primary bold-600"><?php echo Labels::getLabel("LBL_Contact_Seller", $siteLangId); ?></a>
					<a onclick="RequestForQuote(<?php echo $product['selprod_id']; ?>)" href="javascript:void(0)" class="btn btn--primary btn--block bold-600"><?php echo Labels::getLabel("LBL_Request_for_Quote", $siteLangId); ?></a>
				</div>
			<?php } ?>

		</div>
	<?php } ?>


</div>