<!--product tile-->


<div class="product-card__head <?php echo (isset($layoutClass)) ? $layoutClass : ''; ?> <?php if ($product['selprod_stock'] <= 0) { ?> item--sold  <?php } ?>">

    <div class="product-media ratio ratio--1by1">
        <?php
        $thumbSize = isset($smallThumb) && $smallThumb == true ? 'EXTRA-SMALL' : 'COLLECTION';
        $product['smallui'] = true;
        $uploadedTime = AttachedFile::setTimeParam($product['product_updated_on']);
        $imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($product['product_id'], $thumbSize, $product['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
        if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
            $serviceImage = AttachedFile::getAttachment(AttachedFile::FILETYPE_SERVICE_PRODUCT_IMAGE, $product['selprod_id'], 0, -1, false, 0, 0, true);
            $imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array(FatUtility::int($serviceImage['afile_record_id']), "THUMB", $serviceImage['afile_id'])) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
        }
        ?>
        <a title="<?php echo $product['selprod_title']; ?>" href="<?php echo !isset($product['promotion_id']) ? CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : CommonHelper::generateUrl('Products', 'track', array($product['promotion_record_id'])); ?>">
            <img loading="lazy" data-ratio="1:1 (180x180)" src="<?php echo $imgUrl; ?>" alt="<?php echo $product['prodcat_name']; ?>">
        </a>
    </div>
    <?php
    include(CONF_THEME_PATH . '_partial/collection-ui.php'); ?>
    <div class="product-actions">
        <a onClick='quickDetail(<?php echo $product['selprod_id']; ?>)' href="javascript:void(0)" class="btn btn--primary" title="<?php echo Labels::getLabel("LBL_Quick_view", $siteLangId); ?>">
            <span class="action-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="13.31" viewBox="0 0 16 13.31">
                    <path d="M1.181,9.655a8.136,8.136,0,0,1,16,0,8.136,8.136,0,0,1-16,0Zm8,3.7a3.7,3.7,0,1,0-3.7-3.7A3.7,3.7,0,0,0,9.181,13.352Zm0-1.479A2.218,2.218,0,1,1,11.4,9.655,2.218,2.218,0,0,1,9.181,11.873Z" transform="translate(-1.181 -3)" fill="#fff" />
                </svg>
            </span>
            <?php echo Labels::getLabel("LBL_Quick_view", $siteLangId); ?>
        </a>
        <?php if (!UserAuthentication::isUserLogged() || (UserAuthentication::isUserLogged() && ((User::isBuyer()) || (User::isSeller())) && (UserAuthentication::getLoggedUserId() != $product['selprod_user_id']))) { ?>
            <?php if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE &&  $product['in_stock'] > 0) {  ?>
                <a onclick="rfqForService(<?php echo $product['selprod_id']; ?> )" href="javascript:void(0)" class="btn btn--secondary" title="<?php echo Labels::getLabel("LBL_Enquire_Now", $siteLangId); ?>">
                    <?php } else {
                    if ($product['in_stock'] > 0) { ?>
                        <a onclick="RequestForQuote(<?php echo $product['selprod_id']; ?> )" href="javascript:void(0)" class="btn btn--secondary" title="<?php echo Labels::getLabel("LBL_Enquire_Now", $siteLangId); ?>">
                    <?php }
                } ?>
                    <?php if ($product['in_stock'] > 0) { ?>
                        <span class="action-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="15.802" viewBox="0 0 18 15.802">
                                <g>
                                    <path d="M0,1.773a2.429,2.429,0,0,1,.441-1A2,2,0,0,1,1.925.007C2,0,2.075,0,2.152,0Q7.238,0,12.325.006a.755.755,0,0,1,.452.132.594.594,0,0,1,.188.409c.011,2.254.016,4.508,0,6.762a2.025,2.025,0,0,1-2.053,1.965c-1.775.005-3.549,0-5.324,0-.334,0-.668,0-1,0a1.452,1.452,0,0,0-.886.285q-1.373.983-2.746,1.962c-.425.3-.7.246-.959-.2Zm6.838,2.16H8.05c.6,0,1.206,0,1.809,0a.523.523,0,0,0,.548-.586.544.544,0,0,0-.6-.47H3.853a.543.543,0,0,0-.524.287.518.518,0,0,0,.489.764c1.007,0,2.014,0,3.021,0ZM6.822,6.4H8.209c.556,0,1.112,0,1.668,0a.52.52,0,0,0,.528-.587.546.546,0,0,0-.6-.47H3.834a.53.53,0,0,0-.506.288.521.521,0,0,0,.492.766c1,0,2,0,3,0Z" fill="#fff" />
                                    <path d="M107.026,93.448h.224q2.822,0,5.642,0a3.057,3.057,0,0,0,2.93-2.019,3.515,3.515,0,0,0,.194-1.065c.026-.98.009-1.96.009-2.941v-.208c.248,0,.481,0,.713,0a14.183,14.183,0,0,1,1.543.039A1.99,1.99,0,0,1,120,89.244c.005,1.714,0,3.428,0,5.143q0,1.955,0,3.911a.561.561,0,0,1-.284.561.572.572,0,0,1-.637-.094c-.908-.655-1.822-1.3-2.729-1.957a1.7,1.7,0,0,0-1.033-.329q-3.076.007-6.151,0a2.037,2.037,0,0,1-2.139-2.145C107.023,94.053,107.026,93.765,107.026,93.448Z" transform="translate(-101.999 -83.118)" fill="#fff" />
                                </g>
                            </svg>
                        </span>
                        <?php echo Labels::getLabel("LBL_Enquire_Now", $siteLangId); ?>
                        </a>
                <?php }
                } ?>
    </div>
</div>

<div class="product-card__body">

    <div class="product-detail">
        <a href="<?php echo CommonHelper::generateUrl('Category', 'View', array($product['prodcat_id'])) ?>" class="product-category"><?php echo $product['product_name']; ?></a>
        <a href="<?php echo !isset($product['promotion_id']) ? CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : CommonHelper::generateUrl('Products', 'track', array($product['promotion_record_id'])); ?>" class="product-title"><?php echo $product['selprod_title']; ?></a>

        <?php include(CONF_THEME_PATH . '_partial/collection/product-price.php'); ?>
        <?php include(CONF_THEME_PATH . '_partial/collection/product-badges.php'); ?>

    </div>
</div>