<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
if (isset($collections) && count($collections)) {
    $counter = 1;
    foreach ($collections as $collection_id => $row) { ?>
        <?php if (isset($row['products']) && count($row['products']) > 0) { ?>
            <section class="section">
                <div class="container">
                    <div class="section-card">
                        <div class="section-head">
                            <div class="section-head__title">
                                <h2><?php echo ($row['collection_name'] != '') ? $row['collection_name'] : ''; ?></h2>
                            </div>
                            <?php if ($row['totProducts'] > $row['collection_primary_records']) { ?>
                                <div class="section__action"><a href="<?php echo CommonHelper::generateUrl('Collections', 'View', array($row['collection_id'])); ?>" class="link"><?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?></a> </div>
                            <?php } ?>
                        </div>
                        <div class="section-body">
                            <div class="site-caraousel site-caraousel--6 site-caraousel-js" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
                                <?php foreach ($row['products'] as $product) { ?>
                                    <div>
                                        <div class="site-caraousel__item">
                                            <div class="product-card product-card--hovered">
                                                <?php include(CONF_THEME_PATH . '_partial/collection/product-card.php'); ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
<?php }
        $counter++;
    }
} ?>