<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
if (isset($collections) && count($collections)) {

?>
    <section class="section">
        <div class="container">
            <div class="row row-responsive-scroller">
                <?php
                $counter = 1;
                foreach ($collections as $collection_id => $row) { ?>
                    <?php if (isset($row['products']) && count($row['products'])) { ?>
                        <div class="col-4">
                            <div class="section-card section-card--bordered">
                                <div class="section-head">
                                    <div class="section-head__title">
                                        <h2><?php echo ($row['collection_name'] != '') ?  $row['collection_name'] : ''; ?></h2>
                                    </div>
                                    <div class="section__action">
                                        <?php if ($row['totProducts'] > $row['collection_primary_records']) { ?>
                                            <div class="section__action"><a href="<?php echo CommonHelper::generateUrl('Collections', 'View', array($row['collection_id'])); ?>" class="link"><?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?></a> </div>
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="section-body">
                                    <div class="collection-vertical">
                                        <?php $productCount = 1;
                                        foreach ($row['products'] as $product) { ?>
                                            <div class="collection-vertical__item">
                                                <div class="product-card product-card--horizontal product-card--hovered">
                                                    <?php include(CONF_THEME_PATH . '_partial/collection/product-layout-1-list.php'); ?>
                                                </div>
                                            </div>
                                        <?php $productCount++;
                                            if ($productCount >= 4) break;
                                        } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                <?php }
                    $counter++;
                } ?>




            </div>
        </div>
    </section>
<?php

} ?>