<div class="site-caraousel site-caraousel--3 site-caraousel-3-js">
    <?php
    $i = 0;
    foreach ($row['shops'] as $shop) {
    ?>
        <div>
            <div class="site-caraousel__item">
                <div class="shop-card">
                    <div class="shop-card__head">
                        <div class="shop-media ratio ratio--4by1">
                            <a title="<?php echo $shop['shopData']['shop_name']; ?>" href="<?php echo (!isset($shop['shopData']['promotion_id']) ? CommonHelper::generateUrl('shops', 'view', array($shop['shopData']['shop_id'])) : CommonHelper::generateUrl('shops', 'track', array($shop['shopData']['promotion_record_id'], Promotion::REDIRECT_SHOP, $shop['shopData']['promotion_record_id']))); ?>">
                                <img loading="lazy" src=" <?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'shopBanner', array($shop['shopData']['shop_id'], $siteLangId, "COLLECTION", 0, true), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $shop['shopData']['shop_name']; ?>" alt="<?php echo $shop['shopData']['shop_name']; ?>">
                            </a>
                        </div>
                    </div>
                    <div class="shop-card__body">
                        <div class="shop-meta">
                            <div class="shop-meta__small">
                                <div class="shop-logo ratio ratio--1by1">
                                    <a href="<?php echo (!isset($shop['shopData']['promotion_id']) ? CommonHelper::generateUrl('shops', 'view', array($shop['shopData']['shop_id'])) : CommonHelper::generateUrl('shops', 'track', array($shop['shopData']['promotion_record_id'], Promotion::REDIRECT_SHOP, $shop['shopData']['promotion_record_id']))); ?>"> <img src=" <?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shopData']['shop_id'], $siteLangId, "THUMB", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $shop['shopData']['shop_name']; ?>"></a>
                                </div>
                            </div>
                            <div class="shop-meta__large">
                                <span class="shop-title"><a href="<?php echo (!isset($shop['shopData']['promotion_id']) ? CommonHelper::generateUrl('shops', 'view', array($shop['shopData']['shop_id'])) : CommonHelper::generateUrl('shops', 'track', array($shop['shopData']['promotion_record_id'], Promotion::REDIRECT_SHOP, $shop['shopData']['promotion_record_id']))); ?>"><?php echo $shop['shopData']['shop_name']; ?></a></span>
                                <div class=" shop-details">
                                    <span class="shop-location"><?php echo $shop['shopData']['state_name']; ?><?php echo ($shop['shopData']['country_name'] && $shop['shopData']['state_name']) ? ', ' : ''; ?><?php echo $shop['shopData']['country_name']; ?></span>
                                    <div class="shop-ratings">
                                        <div class="ratings">
                                            <?php if (round($row['rating'][$shop['shopData']['shop_id']]) > 0) { ?>
                                                <span class="ratings__star site-icon site-icon--small">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                                        <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f" />
                                                    </svg>
                                                </span>
                                                <span class="ratings__value"><?php echo round($row['rating'][$shop['shopData']['shop_id']], 1); ?></span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="shop-details justify-content-between mt-3">
                                    <div>
                                        <div class="seller">
                                            <div class="seller__tags">
                                                <?php
                                                if ($shop['shopData']['seller_verified'] == AppConstants::YES && (isset($shop['shopData']['subscription_package_id']) && $shop['shopData']['subscription_package_id'] == SellerPackages::GOLD_PACKAGE)) { ?>
                                                    <div class="tag-verified site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Verified', $siteLangId); ?>">
                                                        <span class="tag-verified__icon"></span>
                                                        <span class="tag-verified__text"><?php echo Labels::getLabel("LBL_Verified", $siteLangId); ?></span>
                                                    </div>
                                                <?php } ?>

                                                <?php if (isset($shop['shopData']['seller_type']) && !empty($shop['shopData']['seller_type'])) {
                                                    $sellerTypeArr = ShopProfile::getSellerTypeArr($siteLangId);
                                                ?>
                                                    <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo isset($sellerTypeArr[$shop['shopData']['seller_type']]) ? $sellerTypeArr[$shop['shopData']['seller_type']]  : ''; ?>">
                                                        <img loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/manufacturer.svg">
                                                        <span class="site-tooltip__content"><?php echo isset($sellerTypeArr[$shop['shopData']['seller_type']]) ? $sellerTypeArr[$shop['shopData']['seller_type']]  : ''; ?></span>
                                                    </span>
                                                <?php } ?>

                                                <?php if (isset($shop['shopData']['subscription_package_id']) && ($shop['shopData']['subscription_package_id'] > 0) && FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)) { ?>
                                                    <?php if ($shop['shopData']['subscription_package_id'] == SellerPackages::SILVER_PACKAGE) { ?>
                                                        <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?>">
                                                            <img loading="lazy" class="gray-scale" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png">
                                                            <span class="site-tooltip__content"><?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?></span>
                                                        </span>
                                                    <?php } elseif ($shop['shopData']['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) { ?>
                                                        <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?>">
                                                            <img loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dollar.png">
                                                            <span class="site-tooltip__content"><?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?></span>
                                                        </span>
                                                    <?php
                                                    }
                                                }
                                                if ($shop['shopData']['is_founding_member'] == AppConstants::YES) { ?>
                                                    <span class="seller__tags-icon site-tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo Labels::getLabel('LBL_Founding_Memeber', $siteLangId); ?>">
                                                        <img loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/crown.png">
                                                        <span class="site-tooltip__content"><?php echo Labels::getLabel("LBL_Founding_Memeber", $siteLangId); ?></span>
                                                    </span>
                                                <?php } ?>

                                            </div>
                                        </div>

                                    </div>
                                    <div>
                                        <a href="<?php echo CommonHelper::generateUrl('shops', 'sellerProfile', array($shop['shopData']['shop_id'])); ?>" class="link">Contact Seller</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- ] -->
                </div>
            </div>
        </div>
    <?php
        $i++;
        isset($shop['shopData']['promotion_id']) ? Promotion::updateImpressionData($shop['shopData']['promotion_id']) : '';
        if ($i == Collections::LIMIT_SHOP_LAYOUT1)
            break;
    }
    ?>
</div>