<?php

defined('SYSTEM_INIT') or die('Invalid Usage.');
$str = '<table cellspacing="0" cellpadding="0" border="0" width="100%" style="border:1px solid #ddd; border-collapse:collapse;">
    <tr>
    <td width="40%" style="padding:10px;background:#eee;font-size:13px;border:1px solid #ddd; color:#333; font-weight:bold;">' . Labels::getLabel('LBL_Product', $siteLangId) . '</td>
    <td width="10%" style="padding:10px;background:#eee;font-size:13px; border:1px solid #ddd;color:#333; font-weight:bold;">' . Labels::getLabel('L_Qty', $siteLangId) . '</td>
    <td width="15%" style="padding:10px;background:#eee;font-size:13px; border:1px solid #ddd;color:#333; font-weight:bold;" align="right">' . Labels::getLabel('LBL_Price', $siteLangId) . '</td>
    <td width="15%" style="padding:10px;background:#eee;font-size:13px; border:1px solid #ddd;color:#333; font-weight:bold;" align="right">' . Labels::getLabel('LBL_Shipping', $siteLangId) . '</td>
    <td width="15%" style="padding:10px;background:#eee;font-size:13px; border:1px solid #ddd;color:#333; font-weight:bold;" align="right">' . Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId) . '</td>
    <td width="15%" style="padding:10px;background:#eee;font-size:13px; border:1px solid #ddd;color:#333; font-weight:bold;" align="right">' . Labels::getLabel('LBL_Tax_Charges', $siteLangId) . '</td>
    <td width="20%" style="padding:10px;background:#eee;font-size:13px; border:1px solid #ddd;color:#333; font-weight:bold;" align="right">' . Labels::getLabel('LBL_Total', $siteLangId) . '</td>
    </tr>';

$totalShippingPrice = 0;
$totalTaxCharged = 0;
$totalVolumeDiscount = 0;
$totalNetAmount = 0;
$totalOpCustomerBuyingPrice = 0;
$totalTaxOptions = [];

foreach ($orderProductsData as $orderProducts) {
    $shippingHanldedBySeller = CommonHelper::canAvailShippingChargesBySeller($orderProducts['op_selprod_user_id'], $orderProducts['opshipping_by_seller_user_id']);
    $taxOptions = json_decode(FatUtility::decodeHtmlEntities($orderProducts['op_product_tax_options']), true);

    $shippingHanldedBySeller = isset($shippingHanldedBySeller) ? $shippingHanldedBySeller : 0;
    $opCustomerBuyingPrice = CommonHelper::orderProductAmount($orderProducts, 'CART_TOTAL');
    $totalOpCustomerBuyingPrice += $opCustomerBuyingPrice;

    $shippingPrice = CommonHelper::orderProductAmount($orderProducts, 'SHIPPING');
    if ($shippingHanldedBySeller) {
        $totalShippingPrice += $shippingPrice;
    }

    $volumeDiscount = CommonHelper::orderProductAmount($orderProducts, 'VOLUME_DISCOUNT');
    $totalVolumeDiscount += $volumeDiscount;

    $taxCharged = CommonHelper::orderProductAmount($orderProducts, 'TAX');
    $totalTaxCharged += $taxCharged;

    $netAmount = CommonHelper::orderProductAmount($orderProducts, 'NETAMOUNT', false, $userType);
    $totalNetAmount += $netAmount;

    $skuCodes = $orderProducts["op_selprod_sku"];
    $options = $orderProducts['op_selprod_options'];

    $total = ($opCustomerBuyingPrice + $shippingPrice + $taxCharged - abs($volumeDiscount));

    $prodOrBatchUrl = 'javascript:void(0)';
    $productName = ($orderProducts["op_product_name"] != '') ? $orderProducts["op_product_name"] : $orderProducts["op_selprod_title"];

    $str .= '<tr>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
            <a href="' . $prodOrBatchUrl . '" style="font-size:13px; color:#333;">' . $productName . '</a>';

    if (!empty($orderProducts["op_brand_name"])) {
        $str .= '<br/>' . Labels::getLabel('Lbl_Brand', $siteLangId) . ':' . $orderProducts["op_brand_name"];
    }

    $str .= '<br/>' . Labels::getLabel('Lbl_Sold_By', $siteLangId) . ':' . $orderProducts["op_shop_name"] . '<br/>' . $options . '
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">' . $orderProducts['op_qty'] . '</td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($orderProducts["op_unit_price"]) . '</td>';

    $shopNote = '';
    if (!$shippingHanldedBySeller) {
        $shopNote = '<br /> <small>' . Labels::getLabel('Lbl_Shipping_Handled_By_Admin', $siteLangId) . '</small>';
    }

    $str .= '<td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($shippingPrice) . ' ' . $shopNote . '</td>';
    $str .= '<td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($volumeDiscount) . '</td>';


    if (empty($taxOptions)) {
        $str .= '<td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($taxCharged) . '</td>';
    } else {
        $taxChargedTxt = '';
        foreach ($taxOptions as $key => $val) {
            if (isset($totalTaxOptions[$key])) {
                $totalTaxOptions[$key] += $val;
            } else {
                $totalTaxOptions[$key] = $val;
            }

            $taxChargedTxt .= '<p style="color:#333"><strong>' . CommonHelper::displayTaxPercantage($val, true) . ': </strong>' . CommonHelper::displayMoneyFormat($val['value']) . '</p>';
        }
        $str .= '<td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . $taxChargedTxt . '</td>';
    }

    $str .= '<td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($total) . '</td>
        </tr>';
}
/* [ ORDER TOTAL DETAILS SECTION GOES HERE !!!! */
$colCount = 6;
$str .= '<tr><td colspan="' . $colCount . '" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . Labels::getLabel('L_CART_TOTAL_(_QTY_*_Product_price_)', $siteLangId) . '</td><td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($totalOpCustomerBuyingPrice) . '</td></tr>';

$str .= '<tr>
    <td colspan="' . $colCount . '" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . Labels::getLabel('LBL_SHIPPING', $siteLangId) . '</td>
    <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($totalShippingPrice) . '</td>
    </tr>';


if (empty($totalTaxOptions)) { //Need To Update
    $str .= '<tr>
        <td colspan="' . $colCount . '" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . Labels::getLabel('LBL_Tax', $siteLangId) . '</td>
        <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($totalTaxCharged) . '</td>
    </tr>';
} else {
    foreach ($totalTaxOptions as $key => $val) {
        $str .= '<tr>
            <td colspan="' . $colCount . '" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayTaxPercantage($val) . '</td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($val['value']) . '</td>
        </tr>';
    }
}

if ($totalVolumeDiscount) {
    $str .= '<tr>
        <td colspan="' . $colCount . '" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId) . '</td>
        <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($totalVolumeDiscount) . '</td>
    </tr>';
}
$str .= '<tr>
        <td colspan="' . $colCount . '" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . Labels::getLabel('LBL_NET_AMOUNT', $siteLangId) . '</td>
        <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">' . CommonHelper::displayMoneyFormat($totalNetAmount) . '</td>
    </tr>';


/* ] */
$str .= '</table>';
echo $str;
