<?php defined('SYSTEM_INIT') or die('Invalid Usage'); ?>
<?php if (FatApp::getConfig('CONF_ENABLE_NEWSLETTER_SUBSCRIPTION', FatUtility::VAR_INT, 0)) {
?>
    <div class="footer-row">

        <div class="container">
            <div class="site-subscribe">
                <p><?php echo Labels::getLabel('LBL_Be_the_first_to_here_about_the_latest_trends,_new_arrivals_&_exclusive_offers', $siteLangId); ?></p>
                <div class="site-subscribe__form">
                    <?php
                    if (FatApp::getConfig('CONF_NEWSLETTER_SYSTEM') == AppConstants::NEWS_LETTER_SYSTEM_MAILCHIMP) {
                        $class = (isset($blogPage)) ? 'form form-subscribe' : 'form';
                        $frm->setFormTagAttribute('class', $class);
                        $frm->setFormTagAttribute('onSubmit', 'setUpNewsLetter(this); return false;');
                        $emailFld = $frm->getField('email');
                        $emailFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Enter_Your_Email_Address', $siteLangId));
                        $emailFld->setFieldTagAttribute('class', "no--focus input-field");

                        $btnSubmitFld = $frm->getField('btnSubmit');
                        $btnSubmitFld->setFieldTagAttribute('class', "input-submit");


                    ?>
                        <?php echo $frm->getFormTag(); ?>
                        <span class="site-icon site-icon--small">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.4">
                                <path d="M2.8,3H17.2a.8.8,0,0,1,.8.8V16.6a.8.8,0,0,1-.8.8H2.8a.8.8,0,0,1-.8-.8V3.8A.8.8,0,0,1,2.8,3ZM16.4,6.39l-6.342,5.68L3.6,6.373V15.8H16.4ZM4.009,4.6l6.04,5.33L16,4.6Z" transform="translate(-2 -3)"></path>
                            </svg>
                        </span>
                        <?php echo $frm->getFieldHtml('email');
                        /* echo $frm->getFieldHtml('btnSubmit'); */ ?>
                        </form>
                        <?php echo $frm->getExternalJS(); ?>
                    <?php } elseif (FatApp::getConfig('CONF_NEWSLETTER_SYSTEM') == AppConstants::NEWS_LETTER_SYSTEM_AWEBER) { ?>
                        <?php echo FatApp::getConfig('CONF_AWEBER_SIGNUP_CODE'); ?>

                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

<?php
} else { ?>
    <div class="gap"></div>
<?php } ?>
<script type="text/javascript">
    (function() {
        setUpNewsLetter = function(frm) {
            if (!$(frm).validate()) return;
            events.newsLetterSubscription();
            var data = fcom.frmData(frm);
            fcom.updateWithAjax(fcom.makeUrl('MyApp', 'setUpNewsLetter'), data, function(t) {
                if (t.status) {
                    frm.reset();
                }
            });
        };
    })();
</script>