<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class="hero-layout__large">
	<div class="slideshow js-hero-slider hero-slider" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
		<?php foreach ($slides as $slide) {
			$desktop_url = '';
			$tablet_url = '';
			$mobile_url = '';
			$haveUrl = ($slide['slide_url'] != '') ? true : false;
			$defaultUrl = '';
			$slideArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_HOME_PAGE_BANNER, $slide['slide_id'], 0, $siteLangId);
			if (!$slideArr) {
				continue;
			} else {
				foreach ($slideArr as $slideScreen) {
					$uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
					$mobile_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'slide', array($slide['slide_id'], AppConstants::SCREEN_MOBILE, $siteLangId, 'MOBILE')) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
					$tablet_url = FatCache::getCachedUrl(
						CommonHelper::generateFileUrl('Image', 'slide', array($slide['slide_id'], AppConstants::SCREEN_IPAD, $siteLangId, 'TABLET')) . $uploadedTime,
						CONF_IMG_CACHE_TIME,
						'.jpg'
					) . ",";

					$defaultUrl =  FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'slide', array($slide['slide_id'], AppConstants::SCREEN_DESKTOP, $siteLangId, 'DESKTOP')) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
					$desktop_url = $defaultUrl . ",";
				}
			}

			if ($defaultUrl == '') {
				$defaultUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'slide', array($slide['slide_id'], AppConstants::SCREEN_DESKTOP, $siteLangId, 'DESKTOP')), CONF_IMG_CACHE_TIME, '.jpg');
			}

			$out = '<div class="hero-item">';
			if ($haveUrl) {
				if ($slide['promotion_id'] > 0) {
					$slideUrl =  CommonHelper::generateFileUrl('slides', 'track', array($slide['slide_id']));
				} else {
					$slideUrl = CommonHelper::processUrlString($slide['slide_url']);
				}
			}
			if ($haveUrl) {
				$out .= '<a target="' . $slide['slide_target'] . '" href="' . $slideUrl . '">';
			}
			$out .= '<div class="slideshow__item">
				<picture>
					<source data-aspect-ratio="4:3" srcset="' . $mobile_url . '" media="(max-width: 767px)">
					<source data-aspect-ratio="4:3" srcset="' . $tablet_url . '" media="(max-width: 1024px)">
					<source data-aspect-ratio="10:3" srcset="' . $desktop_url . '">
					<img loading="lazy" data-aspect-ratio="10:3" srcset="' . $desktop_url . '" alt="">
				</picture>
			</div>';
			if ($haveUrl) {
				$out .= '</a>';
			}
			$out .= '</div>';
			echo $out;
			if (isset($slide['promotion_id']) && $slide['promotion_id'] > 0) {
				Promotion::updateImpressionData($slide['promotion_id']);
			}
		} ?>
	</div>
</div>