<?php defined('SYSTEM_INIT') or die('Invalid usage');
/* reviews processing */
$totReviews = isset($reviews['totReviews']) ? FatUtility::int($reviews['totReviews']) : '';
$avgRating = isset($reviews['avg_seller_rating']) ? FatUtility::convertToType($reviews['avg_seller_rating'], FatUtility::VAR_FLOAT) : 0;
$rated_1 = isset($reviews['rated_1']) ? FatUtility::int($reviews['rated_1']) : '';
$rated_2 = isset($reviews['rated_2']) ? FatUtility::int($reviews['rated_2']) : '';
$rated_3 = isset($reviews['rated_3']) ? FatUtility::int($reviews['rated_3']) : '';
$rated_4 = isset($reviews['rated_4']) ? FatUtility::int($reviews['rated_4']) : '';
$rated_5 = isset($reviews['rated_5']) ? FatUtility::int($reviews['rated_5']) : '';

$pixelToFillRight = $avgRating / 5 * 160;
$pixelToFillRight = FatUtility::convertToType($pixelToFillRight, FatUtility::VAR_FLOAT);

$rate_5_width = $rate_4_width = $rate_3_width = $rate_2_width = $rate_1_width = 0;

if ($totReviews) {
    $rate_5_width = round(FatUtility::convertToType($rated_5 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_4_width = round(FatUtility::convertToType($rated_4 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_3_width = round(FatUtility::convertToType($rated_3 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_2_width = round(FatUtility::convertToType($rated_2 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_1_width = round(FatUtility::convertToType($rated_1 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
}
?>

<div class="cms">
    <h3><?php echo Labels::getLabel('LBl_Rating_&_Reviews', $siteLangId); ?></h3>
</div>
<div class="review-panel">
    <div class="review-panel__head p-xl-4 p-3 m-0 pb-0">
        <div class="row justify-content-between">
            <div class="col-sm-2 column">
                <div class="shop-reviews-wrapper">
                    <div class="shop-reviews">
                        <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="103" height="98" viewBox="0 0 103 98">
                            <path d="M890.5,2341l16.973,30.8,34.52,6.63-24.03,25.67,4.362,34.9L890.5,2424.06,858.675,2439l4.361-34.9-24.029-25.67,34.52-6.63L890.5,2341" transform="translate(-839 -2341)"></path>
                        </svg>


                        <div class="shop-reviews-points"><?php echo round($avgRating, 1); ?></div>
                    </div>
                    <div class="total-reviews"><?php echo $totReviews, ' ', Labels::getLabel('Lbl_ratings', $siteLangId); ?></div>
                </div>
            </div>
            <?php $this->includeTemplate('_partial/product-overall-ratings.php', array('reviews' => $reviews, 'siteLangId' => $siteLangId, 'product_id' => $product_id), false); ?>

            <?php if ($canSubmitFeedback) { ?>
                <div class="col-sm-4 column">
                    <div class="text-center mt-3">
                        <h6><?php echo Labels::getLabel('Lbl_Have_you_used_this_product?', $siteLangId); ?> </h6>
                        <a onClick="rateAndReviewProduct(<?php echo $product_id; ?>)" href="javascript:void(0)" class="btn btn-outline-primary btn--wide"><?php echo Labels::getLabel('Lbl_Rate_it_Now?', $siteLangId); ?></a>
                    </div>
                </div>
            <?php } ?>
        </div>

    </div>


    <?php if ($totReviews > 0) { ?>
        <div class="review-panel__sort">
            <div class="row align-items-center justify-content-between">
                <div class="col-sm-6">
                    <p><?php echo Labels::getLabel('Lbl_Displaying_Reviews', $siteLangId); ?> <span id='reviewStartIndex'></span> <?php echo Labels::getLabel('Lbl_of', $siteLangId); ?> <span id='reviewEndIndex'></p>
                </div>
                <div class="col-sm-auto">

                    <ul class="links-inline text-right">

                        <li class="nav__item selected"><a class="dropdown-item nav__link" href="javascript:void(0);" data-sort='most_recent' onclick="getSortedReviews(this);return false;"><?php echo Labels::getLabel('Lbl_Most_Recent', $siteLangId); ?></a></li>
                        <li class="nav__item selected"><a class="dropdown-item nav__link" href="javascript:void(0);" data-sort='most_helpful' onclick="getSortedReviews(this);return false;"><?php echo Labels::getLabel('Lbl_Most_Helpful', $siteLangId); ?></a></li>

                    </ul>

                </div>
            </div>
        </div>

        <div class="review-panel__body">
            <div class="review-panel__all">
                <div class="listing__all"></div>
                <div id="loadMoreReviewsBtnDiv" class="align--center"></div>
            </div>
        </div>


    <?php } ?>



</div>

<script>
    var $linkMoreText = '<?php echo Labels::getLabel('Lbl_SHOW_MORE', $siteLangId); ?>';
    var $linkLessText = '<?php echo Labels::getLabel('Lbl_SHOW_LESS', $siteLangId); ?>';
    $('#itemRatings div.progress__fill').css({
        'clip': 'rect(0px, <?php echo $pixelToFillRight; ?>px, 160px, 0px)'
    });

    $(document).ready(function() {
        function DropDown(el) {
            this.dd = el;
            this.placeholder = this.dd.children('span');
            this.opts = this.dd.find('ul.drop li');
            this.val = '';
            this.index = -1;
            this.initEvents();
        }

        DropDown.prototype = {
            initEvents: function() {
                var obj = this;
                obj.dd.on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    $(this).toggleClass('active');
                });
                obj.opts.on('click', function() {
                    var opt = $(this);
                    obj.val = opt.text();
                    obj.index = opt.index();
                    obj.placeholder.text(obj.val);
                    opt.siblings().removeClass('selected');
                    opt.filter(':contains("' + obj.val + '")').addClass('selected');
                }).change();
            },
            getValue: function() {
                return this.val;
            },
            getIndex: function() {
                return this.index;
            }
        };

        $(function() {
            // create new variable for each menu
            var dd1 = new DropDown($('.js-wrap-drop-reviews'));
            $(document).click(function() {
                // close menu on document click
                $('.wrap-drop').removeClass('active');
            });
        });
    });
</script>
</div>