<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
if (isset($includeEditor) && $includeEditor == true) {
    $extendEditorJs    = 'true';
} else {
    $extendEditorJs    = 'false';
}
if (CommonHelper::isThemePreview() && isset($_SESSION['preview_theme'])) {
    $themeActive = 'true';
} else {
    $themeActive = 'false';
}
$commonHeadData = array(
    'siteLangId' => $siteLangId,
    'siteLangCode' => $siteLangCode,
    'controllerName' => $controllerName,
    'action' => $action,
    'jsVariables' => $jsVariables,
    'extendEditorJs' => $extendEditorJs,
    'themeDetail' => $themeDetail,
    'themeActive' => $themeActive,
    'currencySymbolLeft' => $currencySymbolLeft,
    'currencySymbolRight' => $currencySymbolRight,
    'isUserDashboard' => $isUserDashboard,
    'canonicalUrl' => isset($canonicalUrl) ? $canonicalUrl: '',
);
if (isset($layoutTemplate) && $layoutTemplate != '') {
    $commonHeadData['layoutTemplate'] = $layoutTemplate;
    $commonHeadData['layoutRecordId'] = $layoutRecordId;
}
if (isset($socialShareContent) && $socialShareContent != '') {
    $commonHeadData['socialShareContent'] = $socialShareContent;
}
if (isset($includeEditor) && $includeEditor == true) {
    $commonHeadData['includeEditor'] = $includeEditor;
}
$this->includeTemplate('_partial/header/commonHeadTop.php', $commonHeadData, false);
/* This is not included in common head, because, commonhead file not able to access the $this->Controller and $this->action[ */
echo $this->writeMetaTags();
/* ] */
if (CommonHelper::demoUrl() && $controllerName == 'Blog') {
    echo '<meta name="robots" content="noindex">';
}
$this->includeTemplate('_partial/header/commonHeadMiddle.php', $commonHeadData, false);

/* This is not included in common head, because, if we are adding any css/js from any controller then that file is not included[ */
echo $this->getJsCssIncludeHtml(!CONF_DEVELOPMENT_MODE);
/* ] */
$this->includeTemplate('_partial/header/commonHeadBottom.php', $commonHeadData, false); ?>

<header class="header header-blog" role="Blog-header">
	<div class="header__secondary">
            <div class="container">
                <div id="secondary-menu-js" class="header-row header-offset">
                    <div class="header-row__cell header-row__cell-2">
                        <div class="menu-secondary">
                            <ul>
                                <?php
                                $isSeller = false;
                                if (UserAuthentication::isUserLogged() && User::canViewSupplierTab()) {
									$orderUrl = CommonHelper::generateUrl('seller', 'sales');
                                    $isSeller = true;
                                }
                                $isAffiliate = false;
                                if (UserAuthentication::isUserLogged() && User::canViewAffiliateTab()) {
                                    $isAffiliate = true;
                                }
                                $isAdvertiser = false;
                                if (UserAuthentication::isUserLogged() && User::canViewAdvertiserTab()) {
                                    $isAdvertiser = true;
                                }
                                ?>
                                <?php if (!$isSeller) { ?>
                                    <li class="menu-secondary__item"><a href="<?php echo CommonHelper::generateUrl("Supplier"); ?>">
                                            <span class="site-icon site-icon--small">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 15 17.53">
                                                    <path d="M10.523,11.6V13.23a4.892,4.892,0,0,0-4.892,4.892H4A6.523,6.523,0,0,1,10.523,11.6Zm0-.815a4.892,4.892,0,1,1,4.892-4.892A4.891,4.891,0,0,1,10.523,10.784Zm0-1.631A3.261,3.261,0,1,0,7.261,5.892,3.261,3.261,0,0,0,10.523,9.154Zm2.116,6.37a2.862,2.862,0,0,1,0-1.323l-.809-.467.815-1.412.809.467a2.85,2.85,0,0,1,1.146-.662v-.934H16.23v.934a2.847,2.847,0,0,1,1.146.662l.809-.467L19,13.733l-.809.467a2.862,2.862,0,0,1,0,1.322l.809.467L18.185,17.4l-.809-.467a2.85,2.85,0,0,1-1.146.662v.934H14.6V17.6a2.85,2.85,0,0,1-1.146-.662l-.809.467-.815-1.412.809-.466Zm2.776.561a1.223,1.223,0,1,0-1.223-1.223A1.223,1.223,0,0,0,15.415,16.084Z" transform="translate(-4 -1)"></path>
                                                </svg>
                                            </span>
                                            <?php echo Labels::getLabel("LBL_Become_a_Seller", $siteLangId); ?></a></li>
                                <?php } ?>
                                <li class="menu-secondary__item">

                                    <a href="<?php echo CommonHelper::generateUrl('Account', 'Messages'); ?>">


                                        <span class="site-icon site-icon--small">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.619">
                                                <path d="M4.394,11.9,1,14.571V2.762A.762.762,0,0,1,1.762,2H13.19a.762.762,0,0,1,.762.762V11.9Zm-.527-1.524h8.562V3.524h-9.9v7.912Zm2.466,3.048h7.8l1.343,1.055V6.571h.762A.762.762,0,0,1,17,7.333V17.619l-3.394-2.667H7.1a.762.762,0,0,1-.762-.762Z" transform="translate(-1 -2)"></path>
                                            </svg>
                                        </span>

                                        <?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?>
                                        <?php if (UserAuthentication::isUserLogged()) { ?>
                                            <span class="header-control__trigger-count top-0"><?php echo CommonHelper::displayBadgeCount($todayUnreadMessageCount, 9); ?></span>
                                        <?php } ?>
                                    </a>
                                </li>
                                <li class="menu-secondary__item"><a href="<?php echo $orderUrl; ?>">
                                        <span class="site-icon site-icon--small">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14 15.556">
                                                <path d="M16.222,17.556H3.778A.778.778,0,0,1,3,16.778v-14A.778.778,0,0,1,3.778,2H16.222A.778.778,0,0,1,17,2.778v14A.778.778,0,0,1,16.222,17.556ZM15.444,16V3.556H4.556V16ZM6.889,5.889h6.222V7.444H6.889ZM6.889,9h6.222v1.556H6.889Zm0,3.111h6.222v1.556H6.889Z" transform="translate(-3 -2)"></path>
                                            </svg>
                                        </span>
                                        <?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?></a></li>

                                <?php $this->includeTemplate('_partial/headerLanguageArea.php'); ?>

                            </ul>

                        </div>

                    </div>

                    <div class="header-row__cell header-row__cell-1">
                        <?php $title = !$isSeller ? Labels::getLabel("LBL_Seller", $siteLangId) : Labels::getLabel("LBL_FAQ", $siteLangId); ?>
                        <div class="menu-secondary">

                            <?php $this->includeTemplate('_partial/headerTopNavigation.php');
                            ?>
                        </div>


                    </div>


                </div>

            </div>
        </div>
	<?php if (FatApp::getConfig('CONF_AUTO_RESTORE_ON', FatUtility::VAR_INT, 1) && CommonHelper::demoUrl()) { 
		$this->includeTemplate('restore-system/top-header.php');    
	} ?>
    <?php $this->includeTemplate('_partial/blogNavigation.php'); ?>
</header>
<div class="clear"></div>
