<?php
defined('SYSTEM_INIT') or die('Invalid Usage . ');
$canCancelOrder = true;
$canReturnRefund = true;
$canReviewOrders = false;
$canSubmitFeedback = false;
if (true == $primaryOrder) {
    if ($childOrderDetail['op_product_type'] == Product::PRODUCT_TYPE_DIGITAL) {
        $canCancelOrder = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses(true)));
        $canReturnRefund = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses(true)));
    } else {
        $canCancelOrder = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses()));
        $canReturnRefund = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses()));
    }

    if (in_array($childOrderDetail["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses())) {
        $canReviewOrders = true;
    }

    $canSubmitFeedback = Orders::canSubmitFeedback($childOrderDetail['order_user_id'], $childOrderDetail['order_id'], $childOrderDetail['op_selprod_id']);
}
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');

if (!$print) {
    $this->includeTemplate('_partial/dashboardNavigation.php');
}
?>

<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <?php if (!$print) { ?>
            <div class="content-header row">
                <div class="col"> <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                    <h2 class="content-header-title no-print"><?php echo Labels::getLabel('LBL_Order_Details', $siteLangId); ?></h2>
                </div>
                <?php if (true == $primaryOrder) { ?>
                    <div class="col-auto">
                        <div class="btn-group">
                            <?php if (!$print) { ?>
                                <ul class="actions no-print">
                                    <?php if ($canCancelOrder) { ?>
                                        <li>
                                            <a href="<?php echo CommonHelper::generateUrl('Buyer', 'orderCancellationRequest', array($childOrderDetail['op_id'])); ?>" class="icn-highlighted" title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>"><i class="fas fa-times"></i></a>
                                        </li>
                                    <?php
                                    }
                                    if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0) && $canReviewOrders && $canSubmitFeedback) {
                                    ?> <li>
                                            <a href="<?php echo CommonHelper::generateUrl('Buyer', 'orderFeedback', array($childOrderDetail['op_id'])); ?>" class="icn-highlighted" title="<?php echo Labels::getLabel('LBL_Feedback', $siteLangId); ?>"><i class="fa fa-star"></i></a>
                                        </li> <?php
                                            }
                                            if ($canReturnRefund) {
                                                ?>
                                        <li>
                                            <a href="<?php echo CommonHelper::generateUrl('Buyer', 'orderReturnRequest', array($childOrderDetail['op_id'])); ?>" class="icn-highlighted" title="<?php echo Labels::getLabel('LBL_Refund', $siteLangId); ?>"><i class="fas fa-dollar-sign"></i></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
        <div class="content-body">
            <div class="cards">
                <div class="cards-header">
                    <h5 class="cards-title"> <?php echo Labels::getLabel('LBL_Order_Details', $siteLangId); ?> </h5>
                    <?php if (!$print) { ?>
                        <div class="action">
                            <div class="">
                                <?php if ($orderDetail['order_is_paid'] == Orders::ORDER_IS_PAID) { ?>
                                    <iframe src="<?php echo Fatutility::generateUrl('buyer', 'viewOrder', $urlParts) . '/print'; ?>" name="frame" style="display:none"></iframe>
                                    <a href="javascript:void(0)" onclick="frames['frame'].print()" class="btn btn--primary btn--sm no-print"><?php echo Labels::getLabel('LBL_Print', $siteLangId); ?></a>
                                <?php } else if ($orderDetail['order_is_paid'] == Orders::ORDER_IS_PARTIAL_PAID) { ?>
                                    <a href="<?php echo CommonHelper::generateUrl('Invoices', 'paidInvoice', [$orderDetail['order_id']]); ?>" class="btn btn--primary btn--sm no-print">
                                        <?php echo Labels::getLabel('LBL_Previous_Invoice', $siteLangId); ?>
                                    </a>
                                <?php } ?>
                                <a href="<?php echo CommonHelper::generateUrl('Buyer', 'orders'); ?>" class="btn btn-outline-primary btn--sm no-print"><?php echo Labels::getLabel('LBL_Back_to_order', $siteLangId); ?></a>
                            </div>
                        </div> <?php }
                                ?>
                </div>
                <div class="cards-content ">
                    <?php if ($primaryOrder) { ?>
                        <div class="row">
                            <div class="col-lg-6 col-md-6 mb-4">
                                <div class="info--order">
                                    <p><strong><?php echo Labels::getLabel('LBL_Customer_Name', $siteLangId); ?>: </strong><?php echo $childOrderDetail['user_name']; ?></p> <?php
                                                                                                                                                                                $paymentMethodName = !empty($childOrderDetail['pmethod_name']) ? $childOrderDetail['pmethod_identifier'] : '';
                                                                                                                                                                                if ($childOrderDetail['order_pmethod_id'] > 0 && $childOrderDetail['order_is_wallet_selected'] > 0) {
                                                                                                                                                                                    $paymentMethodName .= ' + ';
                                                                                                                                                                                }
                                                                                                                                                                                if ($childOrderDetail['order_is_wallet_selected'] > 0) {
                                                                                                                                                                                    $paymentMethodName .= Labels::getLabel("LBL_Wallet", $siteLangId);
                                                                                                                                                                                }
                                                                                                                                                                                ?> <p><strong><?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?>: </strong><?php echo $paymentMethodName; ?></p>
                                    <p><strong><?php echo Labels::getLabel('LBL_Payment_Status', $siteLangId); ?>: </strong>
                                        <?php
                                        echo Orders::getOrderPaymentStatusArr($siteLangId)[$childOrderDetail['order_is_paid']];
                                        if ('' != $childOrderDetail['pmethod_name'] && 'CashOnDelivery' == $childOrderDetail['pmethod_code']) {
                                            echo ' (' . $childOrderDetail['pmethod_name'] . ' )';
                                        }
                                        ?>
                                        <?php /* echo $orderStatuses[$childOrderDetail['op_status_id']]; */ ?></p>
                                    <p><strong><?php echo Labels::getLabel('LBL_Cart_Total', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrderDetail, 'CART_TOTAL'), true, false, true, false, true); ?></p>
                                    <p><strong><?php echo Labels::getLabel('LBL_Delivery', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrderDetail, 'SHIPPING'), true, false, true, false, true); ?></p>
                                    <?php if (empty($childOrderDetail['taxOptions'])) { ?>
                                        <p><strong><?php echo Labels::getLabel('LBL_Tax', $siteLangId); ?>:</strong> <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrderDetail, 'TAX'), true, false, true, false, true); ?></p>
                                    <?php } else { ?>
                                        <?php foreach ($childOrderDetail['taxOptions'] as $key => $val) { ?>
                                            <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></p>
                                    <?php
                                        }
                                    }
                                    ?>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <p><strong><?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?>:</strong> <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrderDetail, 'DISCOUNT'), true, false, true, false, true); ?></p> <?php
                                                                                                                                                                                                                                                                                $volumeDiscount = CommonHelper::orderProductAmount($childOrderDetail, 'VOLUME_DISCOUNT');
                                                                                                                                                                                                                                                                                if ($volumeDiscount) {
                                                                                                                                                                                                                                                                                ?>
                                            <p><strong><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId); ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($volumeDiscount, true, false, true, false, true); ?></p>
                                        <?php } ?>
                                        <?php
                                        $rewardPointDiscount = CommonHelper::orderProductAmount($childOrderDetail, 'REWARDPOINT');
                                        if ($rewardPointDiscount != 0) {
                                        ?>
                                            <p><strong><?php echo Labels::getLabel('LBL_Reward_Point_Discount', $siteLangId); ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($rewardPointDiscount, true, false, true, false, true); ?></p>
                                        <?php } ?>
                                    <?php } ?>
                                    <p><strong><?php echo Labels::getLabel('LBL_Order_Total', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrderDetail), true, false, true, false, true); ?></p>
                                    <?php
                                    if (count($servicesOrders) > 0) {
                                        $servicesTotalTax = array_sum(array_column($servicesOrders, 'tax_total'));
                                        $servicesTotalShipping = array_sum(array_column($servicesOrders, 'shipping_total'));
                                        $servicesTotalAmount = array_sum(array_column($servicesOrders, 'service_total'));
                                    ?>
                                        <br />
                                        <h5><small><?php echo Labels::getLabel('LBL_Services', $siteLangId); ?></small></h5>
                                        <p>
                                            <strong><?php echo Labels::getLabel('LBL_Delivery', $siteLangId); ?>: </strong>
                                            <?php echo CommonHelper::displayMoneyFormat($servicesTotalShipping, true, false, true, false, true); ?>
                                        </p>
                                        <p>
                                            <strong><?php echo Labels::getLabel('LBL_Tax', $siteLangId); ?>: </strong>
                                            <?php echo CommonHelper::displayMoneyFormat($servicesTotalTax, true, false, true, false, true); ?>
                                        </p>
                                        <p>
                                            <strong><?php echo Labels::getLabel('LBL_Cart_Total', $siteLangId); ?>: </strong>
                                            <?php echo CommonHelper::displayMoneyFormat($servicesTotalAmount, true, false, true, false, true); ?>
                                        </p>

                                    <?php } ?>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 mb-4">
                                <div class="info--order">
                                    <p><strong><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> #: </strong><?php echo $childOrderDetail['op_invoice_number']; ?></p>
                                    <p><strong><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>: </strong><?php echo FatDate::format($childOrderDetail['order_date_added']); ?></p>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::YES) { ?>
                                        <p><strong><?php echo Labels::getLabel('LBL_Total_Paid', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                                        <p><strong><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'] - $orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                                    <?php } ?>
                                </div>
                            </div>
                        </div> <?php
                            } else {
                                ?> <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-6">
                                <p><strong><?php echo Labels::getLabel('LBL_Order', $siteLangId); ?>: </strong><?php echo $orderDetail['order_id']; ?></p>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::YES) { ?>
                                    <p><strong><?php echo Labels::getLabel('LBL_Total_Paid', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                                    <p><strong><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'] - $orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                                <?php } ?>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6">
                                <div class="info--order">
                                    <p><strong><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>: </strong><?php echo FatDate::format($orderDetail['order_date_added']); ?></p>
                                </div>
                            </div>
                        </div> <?php }
                                ?>

                    <!-- [ QUALITY CERTIFICATE LISTING SECTION -->
                    <?php if (!empty($quality_certificates && !$print)) { ?>
                        <span class="gap"></span>
                        <div class="uploaded--documents">
                            <h6><?php echo Labels::getLabel('LBL_Quality_Certificates', $siteLangId); ?></h6>
                            <?php
                            foreach ($quality_certificates as $certificate) {
                                $attachmentId = $certificate['afile_id'];
                                $ext = pathinfo($certificate['afile_name'], PATHINFO_EXTENSION);
                                $documentUrl = CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type'], true, 70, 70]);
                            ?>
                                <span id="document-js-<?php echo $certificate['afile_id'] ?>">
                                    <?php if (in_array($ext, $imageType)) {
                                    ?>
                                        <a href="<?php echo CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <img src="<?php echo $documentUrl; ?>" alt="<?php echo $certificate['afile_name']; ?>" title="<?php echo $certificate['afile_name']; ?>" />
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <i class="icn rfq-doc-file-icon">
                                                <svg class="svg">
                                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                </svg>
                                            </i>
                                        </a>
                                    <?php
                                    }
                                    echo '<p class="doc-title"><a href="' . CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type']]) . '"><span>' . $certificate["afile_name"] . '</a></span></p>';
                                    ?>
                                </span>
                            <?php } ?>
                        </div>
                        <span class="gap"></span>
                        <span class="gap"></span>
                    <?php } ?>
                    <!-- ] -->

                    <!-- [ SERVICE DOCUMENTS LISTING SECTION -->
                    <?php if (!empty($service_documents && !$print)) { ?>
                        <span class="gap"></span>
                        <div class="uploaded--documents">
                            <h6><?php echo Labels::getLabel('LBL_Service_Documents', $siteLangId); ?></h6>
                            <?php
                            foreach ($service_documents as $document) {
                                $attachmentId = $document['afile_id'];
                                $ext = pathinfo($document['afile_name'], PATHINFO_EXTENSION);
                                $documentUrl = CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type'], true, 70, 70]);
                            ?>
                                <span id="document-js-<?php echo $document['afile_id'] ?>">
                                    <?php if (in_array($ext, $imageType)) {
                                    ?>
                                        <a href="<?php echo CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <img src="<?php echo $documentUrl; ?>" alt="<?php echo $document['afile_name']; ?>" title="<?php echo $document['afile_name']; ?>" />
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <i class="icn rfq-doc-file-icon">
                                                <svg class="svg">
                                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                </svg>
                                            </i>
                                        </a>
                                    <?php
                                    }
                                    echo '<p class="doc-title"><a href="' . CommonHelper::generateUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']]) . '"><span>' . $document["afile_name"] . '</a></span></p>';
                                    ?>
                                </span>
                            <?php } ?>
                        </div>
                        <span class="gap"></span>
                        <span class="gap"></span>
                    <?php } ?>
                    <!-- ] -->


                    <table class="table  table--orders  table-responsive">
                        <tbody>
                            <?php
                            $colCount = 8;
                            $colspan = 8;
                            if ($orderDetail['order_is_rfq'] == AppConstants::YES) {
                                $colspan = 5;
                            }
                            ?>
                            <tr>
                                <th><?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?></th>
                                <?php
                                if (!$print) {
                                    $colCount++;
                                ?>
                                    <th class="no-print" style="width:200px;"></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Qty', $siteLangId); ?></th>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th><?php echo Labels::getLabel('LBL_Price', $siteLangId); ?></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId); ?></th>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId); ?></th>
                                <?php } ?>
                                <th> <?php echo Labels::getLabel('LBL_Tax_Charges', $siteLangId); ?></th>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th> <?php echo Labels::getLabel('LBL_Reward_Point_Discount', $siteLangId); ?></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Total', $siteLangId); ?></th>
                                <?php
                                if (count($servicesOrders) > 0) {
                                    $colCount++;
                                ?>
                                    <th></th>
                                <?php } ?>
                            </tr> <?php
                                    $cartTotal = 0;
                                    $shippingCharges = 0;
                                    $total = 0;
                                    if ($primaryOrder) {
                                        $arr[] = $childOrderDetail;
                                    } else {
                                        $arr = $childOrderDetail;
                                    }
                                    $taxOptionsTotal = array();
                                    foreach ($arr as $childOrder) {
                                        $cartTotal = $cartTotal + CommonHelper::orderProductAmount($childOrder, 'cart_total');
                                        $shippingCharges = $shippingCharges + CommonHelper::orderProductAmount($childOrder, 'shipping');
                                        $volumeDiscount = CommonHelper::orderProductAmount($childOrder, 'VOLUME_DISCOUNT');
                                        $rewardPointDiscount = CommonHelper::orderProductAmount($childOrder, 'REWARDPOINT');
                                    ?>
                                <tr class="<?php echo ($primaryOrder) ? "no-border-row" : ""; ?>">
                                    <?php if (!$print) { ?>
                                        <td class="no-print">
                                            <div class="pic--cell-left"> <?php
                                                                            $prodOrBatchUrl = 'javascript:void(0)';
                                                                            if ($childOrder['op_is_batch']) {
                                                                                $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'batch', array($childOrder['op_selprod_id']));
                                                                                $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'BatchProduct', array($childOrder['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                            } else {
                                                                                if (Product::verifyProductIsValid($childOrder['op_selprod_id']) == true) {
                                                                                    $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id']));
                                                                                }
                                                                                $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($childOrder['selprod_product_id'], "SMALL", $childOrder['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                                if ($childOrder['op_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
                                                                                    $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id']));
                                                                                    $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($childOrder['op_selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                                }
                                                                            }
                                                                            ?> <figure class="item__pic"><a href="<?php echo $prodOrBatchUrl; ?>"><img src="<?php echo $prodOrBatchImgUrl; ?>" title="<?php echo $childOrder['op_product_name']; ?>" alt="<?php echo $childOrder['op_product_name']; ?>"></a></figure>
                                            </div>
                                        </td>
                                    <?php } ?>
                                    <td style="width:200px;">
                                        <div class="item__description" style="width:200px;">
                                            <?php if ($childOrder['op_selprod_title'] != '') { ?>
                                                <div class="item__title">
                                                    <a title="<?php echo $childOrder['op_selprod_title']; ?>" href="<?php echo $prodOrBatchUrl; ?>"><?php echo $childOrder['op_selprod_title'] . '<br/>'; ?></a>
                                                </div>
                                                <div class="item__category"><?php echo $childOrder['op_product_name']; ?></div>
                                            <?php } else { ?>
                                                <div class="item__category">
                                                    <a title="<?php echo $childOrder['op_product_name']; ?>" href="<?php echo CommonHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id'])); ?>"><?php echo $childOrder['op_product_name']; ?> </a>
                                                </div>
                                            <?php } ?>
                                            <div class="item__brand"><?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>: <?php echo CommonHelper::displayNotApplicable($siteLangId, $childOrder['op_brand_name']); ?></div>
                                            <?php if ($childOrder['op_selprod_options'] != '') { ?>
                                                <div class="item__specification"><?php echo $childOrder['op_selprod_options']; ?></div>
                                            <?php } ?>
                                            <div class="item__sold_by"><?php echo Labels::getLabel('LBL_Sold_By', $siteLangId) . ': ' . $childOrder['op_shop_name']; ?></div>
                                            <?php if ($childOrder['op_shipping_duration_name'] != '') { ?>
                                                <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $childOrder['op_shipping_durations'] . '-' . $childOrder['op_shipping_duration_name']; ?></div>
                                            <?php } ?>
                                        </div>
                                    </td>
                                    <!--<td style="width:20%;" ><?php echo $childOrder['op_shipping_durations'] . '-' . $childOrder['op_shipping_duration_name']; ?></td>-->
                                    <td><?php echo $childOrder['op_qty']; ?></td>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <td><?php echo CommonHelper::displayMoneyFormat($childOrder['op_unit_price'], true, false, true, false, true); ?></td>
                                    <?php } ?>
                                    <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'shipping'), true, false, true, false, true); ?></td>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <td><?php echo CommonHelper::displayMoneyFormat($volumeDiscount, true, false, true, false, true); ?></td>
                                    <?php } ?>
                                    <td>
                                        <?php
                                        if (empty($childOrder['taxOptions'])) {
                                            echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'TAX'), true, false, true, false, true);
                                        } else {
                                            foreach ($childOrder['taxOptions'] as $key => $val) {
                                        ?>
                                                <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?> :</strong> <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></p>
                                        <?php
                                                if (!isset($taxOptionsTotal[$key]['value'])) {
                                                    $taxOptionsTotal[$key]['value'] = 0;
                                                }
                                                $taxOptionsTotal[$key]['value'] += $val['value'];
                                                $taxOptionsTotal[$key]['title'] = CommonHelper::displayTaxPercantage($val);
                                            }
                                        }
                                        ?>
                                    </td>
                                    <!-- <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'tax'), true, false, true, false, true); ?></td> -->
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <td><?php echo CommonHelper::displayMoneyFormat($rewardPointDiscount, true, false, true, false, true); ?></td>
                                    <?php } ?>
                                    <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder), true, false, true, false, true); ?></td>
                                    <?php if (count($servicesOrders) > 0) { ?>
                                        <td></td>
                                    <?php } ?>

                                </tr>


                            <?php } ?>
                            <!-- [ SERVICES SECTION  -->
                            <?php if (count($servicesOrders) > 0) { ?>
                                <tr class="no-border-row">
                                    <th colspan="<?php echo $colCount; ?>"><?php echo Labels::getLabel('Lbl_Services', $siteLangId) ?></th>
                                </tr>
                                <?php
                                foreach ($servicesOrders as $service) {
                                    $cartTotal = $cartTotal + CommonHelper::orderProductAmount($service, 'cart_total');
                                    $shippingCharges = $shippingCharges + CommonHelper::orderProductAmount($service, 'shipping');
                                    $volumeDiscount = CommonHelper::orderProductAmount($service, 'VOLUME_DISCOUNT');
                                    $rewardPointDiscount = CommonHelper::orderProductAmount($service, 'REWARDPOINT');
                                ?>

                                    <tr class="no-border-row">
                                        <?php if (!$print) { ?>
                                            <td class="no-print">
                                                <div class="pic--cell-left"> <?php
                                                                                $serviceUrl = CommonHelper::generateUrl('Products', 'view', array($service['op_selprod_id']));
                                            $serviceImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($service['selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                                ?> <figure class="item__pic"><a href="<?php echo $serviceUrl; ?>"><img src="<?php echo $serviceImgUrl; ?>" title="<?php echo $service['op_selprod_title']; ?>" alt="<?php echo $service['op_selprod_title']; ?>"></a></figure>
                                                </div>
                                            </td>
                                        <?php } ?>
                                        <td>
                                            <div class="item__description">
                                                <?php if ($service['op_selprod_title'] != '') { ?>
                                                    <div class="item__title">
                                                        <a title="<?php echo $service['op_selprod_title']; ?>" href="<?php echo $serviceUrl; ?>"><?php echo $service['op_selprod_title'] . '<br/>'; ?></a>
                                                    </div>
                                                <?php } ?>
                                                <div class="item__sold_by"><?php echo Labels::getLabel('LBL_Sold_By', $siteLangId) . ': ' . $service['op_shop_name']; ?></div>
                                                <?php if ($service['op_shipping_duration_name'] != '') { ?>
                                                    <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $service['op_shipping_durations'] . '-' . $service['op_shipping_duration_name']; ?></div>
                                                <?php } ?>
                                            </div>
                                        </td>

                                        <td><?php echo $service['op_qty']; ?></td>
                                        <td><?php echo CommonHelper::displayMoneyFormat($service['op_unit_price'], true, false, true, false, true); ?></td>
                                        <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'shipping'), true, false, true, false, true); ?></td>
                                        <td><?php echo CommonHelper::displayMoneyFormat($volumeDiscount, true, false, true, false, true); ?></td>
                                        <td>
                                            <?php
                                            if (empty($service['taxOptions'])) {
                                                echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'TAX'), true, false, true, false, true);
                                            } else {
                                                foreach ($service['taxOptions'] as $key => $val) {
                                            ?>
                                                    <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?> :</strong> <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></p>
                                            <?php
                                                    if (!isset($taxOptionsTotal[$key]['value'])) {
                                                        $taxOptionsTotal[$key]['value'] = 0;
                                                    }
                                                    $taxOptionsTotal[$key]['value'] += $val['value'];
                                                    $taxOptionsTotal[$key]['title'] = CommonHelper::displayTaxPercantage($val);
                                                }
                                            }
                                            ?>
                                        </td>
                                        <td><?php echo CommonHelper::displayMoneyFormat($rewardPointDiscount, true, false, true, false, true); ?></td>
                                        <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service), true, false, true, false, true); ?></td>
                                        <td>
                                            <?php if (!$print) { ?>
                                                <ul class="actions">
                                                    <li>
                                                        <a href="<?php echo CommonHelper::generateUrl('buyer', 'viewOrder', [$service['op_order_id'], $service['op_id']]) ?>" class="" title="<?php echo Labels::getLabel('LBL_View_Details', $siteLangId); ?>">
                                                            <i class="fa fa-eye"></i>
                                                        </a>
                                                    </li>
                                                    <?php if (!in_array($service['op_status_id'], $cancellationNotAllowedStatues)) { ?>
                                                        <li>
                                                            <a href="<?php echo CommonHelper::generateUrl('buyer', 'orderCancellationRequest', [$service['op_id']]) ?>" class="" title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>">
                                                                <i class="fas fa-times"></i>
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                </ul>
                                            <?php } ?>
                                        </td>

                                    </tr>
                                <?php } ?>
                            <?php } ?>
                            <!--  ] -->

                            <?php
                            if (!$primaryOrder) {
                            ?>
                                <tr>
                                    <td colspan="<?php echo $colspan; ?>"><?php echo Labels::getLabel('Lbl_Cart_Total', $siteLangId) ?></td>
                                    <td><?php echo CommonHelper::displayMoneyFormat($cartTotal, true, false, true, false, true); ?></td>
                                </tr>
                                <tr>
                                    <td colspan="<?php echo $colspan; ?>"><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId) ?></td>
                                    <td><?php echo CommonHelper::displayMoneyFormat($shippingCharges, true, false, true, false, true); ?></td>
                                </tr>
                                <?php if (empty($taxOptionsTotal)) { ?>
                                    <tr>
                                        <td colspan="<?php echo $colspan; ?>">
                                            <?php echo Labels::getLabel('LBL_Tax_Charges', $siteLangId) ?>
                                        </td>
                                        <td>
                                            <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_tax_charged'], true, false, true, false, true); ?>
                                        </td>
                                    </tr>
                                    <?php
                                } else {
                                    foreach ($taxOptionsTotal as $key => $val) {
                                    ?>
                                        <tr>
                                            <td colspan="<?php echo $colspan; ?>"><?php echo $val['title']; ?></td>
                                            <td><?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></td>
                                        </tr>
                                <?php
                                    }
                                }
                                ?>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <?php if ($orderDetail['order_discount_total']) { ?>
                                        <tr>
                                            <td colspan="<?php echo $colspan; ?>"><?php echo Labels::getLabel('LBL_Discount', $siteLangId) ?></td>
                                            <td>-<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_discount_total'], true, false, true, false, true); ?></td>
                                        </tr>
                                    <?php } ?>
                                    <?php if ($orderDetail['order_volume_discount_total']) { ?>
                                        <tr>
                                            <td colspan="<?php echo $colspan; ?>"><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId) ?></td>
                                            <td>-<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_volume_discount_total'], true, false, true, false, true); ?></td>
                                        </tr>
                                    <?php } ?>
                                <?php } ?>
                                <tr>
                                    <td colspan="<?php echo $colspan; ?>"><?php echo Labels::getLabel('LBL_Total', $siteLangId) ?></td>
                                    <td><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'], true, false, true, false, true); ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                    <div class="divider">
                    </div>
                    <div class="gap"></div>
                    <div class="gap"></div>
                    <div class="row">
                        <div class="col-lg-6 col-md-6 mb-4">
                            <h5><?php echo Labels::getLabel('LBL_Billing_Details', $siteLangId); ?></h5> <?php
                                                                                                            $billingAddress = $orderDetail['billingAddress']['oua_name'] . '<br>';
                                                                                                            if ($orderDetail['billingAddress']['oua_address1'] != '') {
                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address1'] . '<br>';
                                                                                                            }

                                                                                                            if ($orderDetail['billingAddress']['oua_address2'] != '') {
                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address2'] . '<br>';
                                                                                                            }

                                                                                                            if ($orderDetail['billingAddress']['oua_city'] != '') {
                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_city'] . ',';
                                                                                                            }

                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_state'];
                                                                                                            }

                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                $billingAddress .= '-' . $orderDetail['billingAddress']['oua_zip'];
                                                                                                            }

                                                                                                            if ($orderDetail['billingAddress']['oua_phone'] != '') {
                                                                                                                $billingAddress .= '<br>' . $orderDetail['billingAddress']['oua_phone'];
                                                                                                            }
                                                                                                            ?> <div class="info--order">
                                <p><?php echo $billingAddress; ?></p>
                            </div>
                        </div>
                        <?php if (!empty($orderDetail['shippingAddress']) && $productType != Product::PRODUCT_TYPE_DIGITAL) { ?>
                            <div class="col-lg-6 col-md-6 mb-4">
                                <h5><?php echo Labels::getLabel('LBL_Shipping_Details', $siteLangId); ?></h5> <?php
                                                                                                                $shippingAddress = $orderDetail['shippingAddress']['oua_name'] . '<br>';
                                                                                                                if ($orderDetail['shippingAddress']['oua_address1'] != '') {
                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_address1'] . '<br>';
                                                                                                                }

                                                                                                                if ($orderDetail['shippingAddress']['oua_address2'] != '') {
                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_address2'] . '<br>';
                                                                                                                }

                                                                                                                if ($orderDetail['shippingAddress']['oua_city'] != '') {
                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_city'] . ',';
                                                                                                                }

                                                                                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_state'];
                                                                                                                }

                                                                                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                    $shippingAddress .= '-' . $orderDetail['shippingAddress']['oua_zip'];
                                                                                                                }

                                                                                                                if ($orderDetail['shippingAddress']['oua_phone'] != '') {
                                                                                                                    $shippingAddress .= '<br>' . $orderDetail['shippingAddress']['oua_phone'];
                                                                                                                }
                                                                                                                ?> <div class="info--order">
                                    <p><?php echo $shippingAddress; ?></p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <?php if (!empty($paymentHistory) && !$print) { ?>
                        <div class="gap"></div>
                        <p><strong><?php echo Labels::getLabel('LBL_Invoices_Details', $siteLangId); ?></strong></p>
                        <div class="section--repeated no-print">
                            <table class="table invoice-product">
                                <thead>
                                    <tr>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Amount', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Date', $siteLangId); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($paymentHistory as $phistory) { ?>
                                        <tr>
                                            <td><?php echo $phistory['opayment_method']; ?></td>
                                            <td>
                                                <?php echo CommonHelper::displayMoneyFormat($phistory['opayment_amount'], true, false, true, false, true); ?>
                                            </td>
                                            <td><?php echo FatDate::format($phistory['opayment_date'], true); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="gap"></div>
                    <?php } ?>


                    <?php if (!empty($orderDetail['comments'])) {
                    ?> <div class="gap">
                        </div>
                        <div class="section--repeated">
                            <h5><?php echo Labels::getLabel('LBL_Posted_Comments', $siteLangId); ?></h5>
                            <table class="table  table--orders">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Date_Added', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Customer_Notified', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Status', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Comments', $siteLangId); ?></th>
                                    </tr> <?php foreach ($orderDetail['comments'] as $row) {
                                            ?> <tr>
                                            <td><?php echo FatDate::format($row['oshistory_date_added']); ?></td>
                                            <td><?php echo $yesNoArr[$row['oshistory_customer_notified']]; ?></td>
                                            <td><?php
                                                echo ($row['oshistory_orderstatus_id'] > 0) ? $orderStatuses[$row['oshistory_orderstatus_id']] : CommonHelper::displayNotApplicable($siteLangId, '');
                                                echo ($row['oshistory_tracking_number']) ? ': ' . Labels::getLabel('LBL_Tracking_Number', $siteLangId) . ' ' . $row['oshistory_tracking_number'] . " VIA <em>" . $row['op_shipping_duration_name'] . "</em>" : ''
                                                ?></td>
                                            <td><?php echo !empty(trim(($row['oshistory_comments']))) ? nl2br($row['oshistory_comments']) : Labels::getLabel('LBL_N/A', $siteLangId); ?></td>
                                        </tr> <?php }
                                                ?>
                                </tbody>
                            </table>
                        </div>
                    <?php } ?>
                    <?php if (!empty($orderDetail['payments'])) {
                    ?> <span class="gap"></span>
                        <div class="section--repeated">
                            <h5><?php echo Labels::getLabel('LBL_Payment_History', $siteLangId); ?></h5>
                            <table class="table">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Date_Added', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Txn_Id', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Comments', $siteLangId); ?></th>
                                    </tr> <?php foreach ($orderDetail['payments'] as $row) {
                                            ?> <tr>
                                            <td><?php echo FatDate::format($row['opayment_date']); ?></td>
                                            <td><?php echo $row['opayment_gateway_txn_id']; ?></td>
                                            <td><?php echo $row['opayment_method']; ?></td>
                                            <td><?php echo CommonHelper::displayMoneyFormat($row['opayment_amount'], true, false, true, false, true); ?></td>
                                            <td><?php echo nl2br($row['opayment_comments']); ?></td>
                                        </tr> <?php }
                                                ?>
                                </tbody>
                            </table>
                        </div> <?php }
                                ?> <?php if (!empty($digitalDownloads)) {
                        ?> <span class="gap"></span>
                        <div class="section--repeated">
                            <h5><?php echo Labels::getLabel('LBL_Downloads', $siteLangId); ?></h5>
                            <table class="table  table--orders">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Sr_No', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_File', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Language', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Download_times', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Downloaded_count', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Expired_on', $siteLangId); ?></th>
                                        <th></th>
                                    </tr>
                                    <?php
                                    $sr_no = 1;
                                    foreach ($digitalDownloads as $key => $row) {
                                        $lang_name = Labels::getLabel('LBL_All', $siteLangId);
                                        if ($row['afile_lang_id'] > 0) {
                                            $lang_name = $languages[$row['afile_lang_id']];
                                        }

                                        if ($row['downloadable']) {
                                            $fileName = '<a href="' . CommonHelper::generateUrl('Buyer', 'downloadDigitalFile', array($row['afile_id'], $row['afile_record_id'])) . '">' . $row['afile_name'] . '</a>';
                                        } else {
                                            $fileName = $row['afile_name'];
                                        }
                                        $downloads = '<li><a href="' . CommonHelper::generateUrl('Buyer', 'downloadDigitalFile', array($row['afile_id'], $row['afile_record_id'])) . '"><i class="fa fa-download"></i></a></li>';

                                        $expiry = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if ($row['expiry_date'] != '') {
                                            $expiry = FatDate::Format($row['expiry_date']);
                                        }

                                        $downloadableCount = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if ($row['downloadable_count'] != -1) {
                                            $downloadableCount = $row['downloadable_count'];
                                        }
                                    ?>
                                        <tr>
                                            <td><?php echo $sr_no; ?></td>
                                            <td><?php echo $fileName; ?></td>
                                            <td><?php echo $lang_name; ?></td>
                                            <td><?php echo $downloadableCount; ?></td>
                                            <td><?php echo $row['afile_downloaded_times']; ?></td>
                                            <td><?php echo $expiry; ?></td>
                                            <td><?php if ($row['downloadable']) {
                                                ?><ul class="actions"><?php echo $downloads; ?></ul><?php }
                                                                                                ?></td>
                                        </tr> <?php
                                                $sr_no++;
                                            }
                                                ?>
                                </tbody>
                            </table>
                        </div> <?php }
                                ?> <?php if (!empty($digitalDownloadLinks)) {
                                    ?> <span class="gap"></span>
                        <div class="section--repeated">
                            <h5><?php echo Labels::getLabel('LBL_Download_Links', $siteLangId); ?></h5>
                            <table class="table  table--orders">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Sr_No', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Link', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Download_times', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Downloaded_count', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Expired_on', $siteLangId); ?></th>
                                    </tr> <?php
                                            $sr_no = 1;
                                            foreach ($digitalDownloadLinks as $key => $row) {
                                                $expiry = Labels::getLabel('LBL_N/A', $siteLangId);
                                                if ($row['expiry_date'] != '') {
                                                    $expiry = FatDate::Format($row['expiry_date']);
                                                }

                                                $downloadableCount = Labels::getLabel('LBL_N/A', $siteLangId);
                                                if ($row['downloadable_count'] != -1) {
                                                    $downloadableCount = $row['downloadable_count'];
                                                }

                                                $link = ($row['downloadable'] != 1) ? Labels::getLabel('LBL_N/A', $siteLangId) : $row['opddl_downloadable_link'];
                                                $linkUrl = ($row['downloadable'] != 1) ? 'javascript:void(0)' : $row['opddl_downloadable_link'];
                                                $linkOnClick = ($row['downloadable'] != 1) ? '' : 'return increaseDownloadedCount(' . $row['opddl_link_id'] . ',' . $row['op_id'] . '); ';
                                                $linkTitle = ($row['downloadable'] != 1) ? '' : Labels::getLabel('LBL_Click_to_download', $siteLangId);
                                            ?> <tr>
                                            <td><?php echo $sr_no; ?></td>
                                            <td><a target="_blank" onClick="<?php echo $linkOnClick; ?>" href="<?php echo $linkUrl; ?>" data-link="<?php echo $linkUrl; ?>" title="<?php echo $linkTitle; ?>"><?php echo $link; ?></a></td>
                                            <td><?php echo $downloadableCount; ?></td>
                                            <td><?php echo $row['opddl_downloaded_times']; ?></td>
                                            <td><?php echo $expiry; ?></td>
                                        </tr> <?php
                                                $sr_no++;
                                            }
                                                ?>
                                </tbody>
                            </table>
                        </div> <?php }
                                ?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php if ($print) { ?>
    <script>
        $(".sidebar-is-expanded").addClass('sidebar-is-reduced').removeClass('sidebar-is-expanded');
        /*window.print();
         window.onafterprint = function() {
         location.href = history.back();
         }*/
    </script>
<?php } ?> <script>
    function increaseDownloadedCount(linkId, opId) {
        fcom.ajax(fcom.makeUrl('buyer', 'downloadDigitalProductFromLink', [linkId, opId]), '', function(t) {
            var ans = $.parseJSON(t);
            if (ans.status == 0) {
                $.systemMessage(ans.msg, 'alert--danger');
                return false;
            }
            /* var dataLink = $(this).attr('data-link');
             window.location.href= dataLink; */
            location.reload();
            return true;
        });
    }
</script>
<style>
    .no-border-row th,
    .no-border-row td {
        border: 0px;
    }

    .uploaded--documents a {
        color: #000;
    }

    .table th {
        width: 175px;
        max-width: 100%
    }

    .invoice-product tr {
        border-left: 1px solid #ddd;
        border-right: 1px solid #ddd;
    }

    .invoice-product tr:first-child {
        border-top: 1px solid #ddd;
    }

    .invoice-product.table tr:last-child td {
        border-bottom: 1px solid #dee2e6 !important;
    }
</style>