<?php
defined('SYSTEM_INIT') or die('Invalid Usage . ');
$canCancelOrder = true;
$canReturnRefund = true;
$canReviewOrders = false;
$canSubmitFeedback = false;
if (true == $primaryOrder) {
    if ($childOrderDetail['op_product_type'] == Product::PRODUCT_TYPE_DIGITAL) {
        $canCancelOrder = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses(true)));
        $canReturnRefund = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses(true)));
    } else {
        $canCancelOrder = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses()));
        $canReturnRefund = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses()));
    }

    if (in_array($childOrderDetail["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses())) {
        $canReviewOrders = true;
    }

    $canSubmitFeedback = Orders::canSubmitFeedback($childOrderDetail['order_user_id'], $childOrderDetail['order_id'], $childOrderDetail['op_selprod_id']);
}
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
$cartTotal = 0;
$shippingCharges = 0;
$total = 0;
if ($primaryOrder) {
    $arr[] = $childOrderDetail;
} else {
    $arr = $childOrderDetail;
}
$taxOptionsTotal = array();
$colCount = 6;
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
?>
<div style="background: #fff; padding: 20px;">
    <table class="table">
        <thead>
            <tr>
                <td>
                    <?php
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, false);
                    if (true == $primaryOrder) {
                        $shopIdentifier = (isset($shopAddress)) ? $shopAddress['shop_identifier'] : $orderDetail['op_shop_name'];
                    } else {
                        $shopIdentifier = FatApp::getConfig("CONF_WEBSITE_NAME_" . $siteLangId, FatUtility::VAR_STRING, '');
                    }
                    ?>
                    <div class="info--order">
                        <h5 class="logo-invoice">
                            <?php if (true == $primaryOrder) { ?>
                                <img style="max-height: 50px;" src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'shopLogo', array($childOrderDetail['op_shop_id'], $siteLangId, "THUMB", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $shopIdentifier; ?>">
                            <?php
                                echo '<span>' . $shopIdentifier . '</span>';
                            } else {
                            ?>
                                <img style="max-height: 50px;" src="<?php echo CommonHelper::generateFullFileUrl('image', 'siteLogo', array($siteLangId), CONF_WEBROOT_FRONT_URL); ?>" alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>">
                            <?php
                                echo '<span>' . FatApp::getConfig("CONF_WEBSITE_NAME_" . $siteLangId, FatUtility::VAR_STRING, '') . '</span>';
                            }
                            ?>
                        </h5>
                        <?php
                        if (true == $primaryOrder && !empty($shopAddress)) {
                            $shopAddressTxt = $shopAddress['shop_name'] . '<br>';
                            if ($shopAddress['shop_address_line_1'] != '') {
                                $shopAddressTxt .= $shopAddress['shop_address_line_1'] . '<br>';
                            }

                            if ($shopAddress['shop_address_line_2'] != '') {
                                $shopAddressTxt .= $shopAddress['shop_address_line_2'] . '<br>';
                            }

                            if ($shopAddress['shop_city'] != '') {
                                $shopAddressTxt .= $shopAddress['shop_city'] . ',';
                            }

                            if ($shopAddress['state_identifier'] != '') {
                                $shopAddressTxt .= $shopAddress['state_identifier'] . ', ';
                            }

                            if ($shopAddress['shop_postalcode'] != '') {
                                $shopAddressTxt .= '-' . $shopAddress['shop_postalcode'] . '<br>';
                            }

                            if ($shopAddress['country_name'] != '') {
                                $shopAddressTxt .= $shopAddress['country_name'] . '';
                            } elseif ($shopAddress['country_code'] != '') {
                                $shopAddressTxt .= $shopAddress['country_code'] . '';
                            }

                            if ($shopAddress['shop_phone'] != '') {
                                $shopAddressTxt .= '<br>' . $shopAddress['shop_phone'];
                            }

                            if (isset($orderDetail['op_shop_owner_email'])) {
                                $shopAddressTxt .= '<br>' . $orderDetail['op_shop_owner_email'];
                            }

                            $shopAddressTxt .= '<br>' . Labels::getLabel('LBL_Shop_URL:', $siteLangId) . ' <a href="' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']]) . '">' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']]) . '</a>';

                        ?>
                            <p><?php echo $shopAddressTxt; ?></p>
                        <?php } ?>
                    </div>
                </td>
                <td>
                    <div class="info--order ">
                        <h4 class="info-invioce"><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> </h4>
                        <p><strong><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>: </strong><?php echo FatDate::format($orderDetail['order_date_added']); ?></p>
                        <?php if (true == $primaryOrder) { ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> #: </strong><?php echo $childOrderDetail['op_invoice_number']; ?></p>
                        <?php } else { ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> #: </strong><?php echo $orderDetail['order_id']; ?></p>
                            <p>
                                <strong><?php echo Labels::getLabel('LBL_Order_Total', $siteLangId); ?>: </strong>
                                <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'], true, false, true, false, true); ?>
                            </p>

                        <?php } ?>
                        <?php if (true == $primaryOrder && $orderDetail['order_is_rfq'] == AppConstants::YES) { ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Total_Paid', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                            <p><strong><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'] - $orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                        <?php } ?>
                        <?php if ($primaryOrder) { ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Customer_Name', $siteLangId); ?>: </strong><?php echo $childOrderDetail['user_name']; ?></p>
                        <?php } ?>
                        <?php if ($primaryOrder) { ?>
                            <?php
                            $paymentMethodName = !empty($orderDetail['pmethod_name']) ? $orderDetail['pmethod_identifier'] : '';
                            if ($orderDetail['order_pmethod_id'] > 0 && $orderDetail['order_is_wallet_selected'] > 0) {
                                $paymentMethodName .= ' + ';
                            }
                            if ($orderDetail['order_is_wallet_selected'] > 0) {
                                $paymentMethodName .= Labels::getLabel("LBL_Wallet", $siteLangId);
                            }
							
							if (empty($paymentMethodName)) {
                                $paymentMethodName = $childOrderDetail['pmethod_name'];
                            }
                            ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?>: </strong><?php echo $paymentMethodName; ?></p>
                        <?php } ?>
                        <p><strong><?php echo Labels::getLabel('LBL_Payment_Status', $siteLangId); ?>: </strong>
                            <?php
                            echo Orders::getOrderPaymentStatusArr($siteLangId)[$orderDetail['order_is_paid']];
                            if (($primaryOrder) && '' != $childOrderDetail['pmethod_name'] && 'CashOnDeliv$childOrderDetailery' == $childOrderDetail['pmethod_code']) {
                                echo ' (' . $childOrderDetail['pmethod_name'] . ' )';
                            }
                            ?>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <h6 class="invoice-subheading"><?php echo Labels::getLabel('LBL_Billing_Address', $siteLangId); ?></h6> <?php
                                                                                                                            $billingAddress = $orderDetail['billingAddress']['oua_name'] . '<br>';
                                                                                                                            if ($orderDetail['billingAddress']['oua_address1'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address1'] . '<br>';
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_address2'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address2'] . '<br>';
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_city'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_city'] . ',';
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_state'];
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                                $billingAddress .= '-' . $orderDetail['billingAddress']['oua_zip'];
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_phone'] != '') {
                                                                                                                                $billingAddress .= '<br>' . $orderDetail['billingAddress']['oua_phone'];
                                                                                                                            }
                                                                                                                            ?> <div class="info--order">
                        <p><?php echo $billingAddress; ?></p>
                    </div>
                </td>
                <td>
                    <h6 class="invoice-subheading"><?php echo Labels::getLabel('LBL_Shipping_Address', $siteLangId); ?></h6> <?php
                                                                                                                                $shippingAddress = $orderDetail['shippingAddress']['oua_name'] . '<br>';
                                                                                                                                if ($orderDetail['shippingAddress']['oua_address1'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_address1'] . '<br>';
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_address2'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_address2'] . '<br>';
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_city'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_city'] . ',';
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_state'];
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                                    $shippingAddress .= '-' . $orderDetail['shippingAddress']['oua_zip'];
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_phone'] != '') {
                                                                                                                                    $shippingAddress .= '<br>' . $orderDetail['shippingAddress']['oua_phone'];
                                                                                                                                }
                                                                                                                                ?>
                    <div class="info--order">
                        <p><?php echo $shippingAddress; ?></p>
                    </div>
                </td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="2">
                    <!-- PRODUCT DETAILS TABLE -->
                    <table class="table table-striped invioce-table-bg">
                        <thead>
                            <tr class="invoice-tbl-heading">
                                <th><?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?></th>
                                <?php
                                if (!$print) {
                                    $colCount++;
                                ?>
                                    <th class="no-print" style="width:200px;"></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Qty', $siteLangId); ?></th>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th><?php echo Labels::getLabel('LBL_Price', $siteLangId); ?></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId); ?></th>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId); ?></th>
                                <?php } ?>
                                <th> <?php echo Labels::getLabel('LBL_Tax_Charges', $siteLangId); ?></th>
                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th> <?php echo Labels::getLabel('LBL_Reward_Point_Discount', $siteLangId); ?></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Total', $siteLangId); ?></th>
                                <?php
                                if (count($servicesOrders) > 0) {
                                    $colCount++;
                                ?>
                                    <th></th>
                                <?php } ?>
                            </tr>

                            <?php
                            $orderTotalAmount = 0;
                            foreach ($arr as $childOrder) {
                                $cartTotal = $cartTotal + CommonHelper::orderProductAmount($childOrder, 'cart_total');
                                $shippingCharges = $shippingCharges + CommonHelper::orderProductAmount($childOrder, 'shipping');
                                $volumeDiscount = CommonHelper::orderProductAmount($childOrder, 'VOLUME_DISCOUNT');
                                $rewardPointDiscount = CommonHelper::orderProductAmount($childOrder, 'REWARDPOINT');
                                $orderTotalAmount += CommonHelper::orderProductAmount($childOrder, 'NETAMOUNT');
                            ?>
                                <tr class="<?php echo ($primaryOrder) ? "no-border-row" : ""; ?>">
                                    <?php if (!$print) { ?>
                                        <td class="no-print">
                                            <div class="pic--cell-left">
                                                <?php
                                                $prodOrBatchUrl = 'javascript:void(0)';
                                                if ($childOrder['op_is_batch']) {
                                                    $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'batch', array($childOrder['op_selprod_id']));
                                                    $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'BatchProduct', array($childOrder['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                } else {
                                                    if (Product::verifyProductIsValid($childOrder['op_selprod_id']) == true) {
                                                        $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id']));
                                                    }
                                                    $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($childOrder['selprod_product_id'], "SMALL", $childOrder['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                    if ($childOrder['op_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
                                                        $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id']));
                                                        $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($childOrder['op_selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                    }
                                                }
                                                ?> <figure class="item__pic"><a href="<?php echo $prodOrBatchUrl; ?>"><img src="<?php echo $prodOrBatchImgUrl; ?>" title="<?php echo $childOrder['op_product_name']; ?>" alt="<?php echo $childOrder['op_product_name']; ?>"></a></figure>
                                            </div>
                                        </td>
                                    <?php } ?>
                                    <td style="width:200px;">
                                        <div class="item__description" style="width:200px;">
                                            <?php if ($childOrder['op_selprod_title'] != '') { ?>
                                                <div class="item__title">
                                                    <a title="<?php echo $childOrder['op_selprod_title']; ?>" href="<?php echo $prodOrBatchUrl; ?>"><?php echo $childOrder['op_selprod_title'] . '<br/>'; ?></a>
                                                </div>
                                                <div class="item__category"><?php echo $childOrder['op_product_name']; ?></div>
                                            <?php } else { ?>
                                                <div class="item__category">
                                                    <a title="<?php echo $childOrder['op_product_name']; ?>" href="<?php echo CommonHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id'])); ?>"><?php echo $childOrder['op_product_name']; ?> </a>
                                                </div>
                                            <?php } ?>
                                            <div class="item__brand"><?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>: <?php echo CommonHelper::displayNotApplicable($siteLangId, $childOrder['op_brand_name']); ?></div>
                                            <?php if ($childOrder['op_selprod_options'] != '') { ?>
                                                <div class="item__specification"><?php echo $childOrder['op_selprod_options']; ?></div>
                                            <?php } ?>
                                            <div class="item__sold_by"><?php echo Labels::getLabel('LBL_Sold_By', $siteLangId) . ': ' . $childOrder['op_shop_name']; ?></div>
                                            <?php if ($childOrder['op_shipping_duration_name'] != '') { ?>
                                                <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $childOrder['op_shipping_durations'] . '-' . $childOrder['op_shipping_duration_name']; ?></div>
                                            <?php } ?>
                                        </div>
                                    </td>
                                    <!--<td style="width:20%;" ><?php echo $childOrder['op_shipping_durations'] . '-' . $childOrder['op_shipping_duration_name']; ?></td>-->
                                    <td><?php echo $childOrder['op_qty']; ?></td>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <td><?php echo CommonHelper::displayMoneyFormat($childOrder['op_unit_price'], true, false, true, false, true); ?></td>
                                    <?php } ?>
                                    <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'shipping'), true, false, true, false, true); ?></td>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <td><?php echo CommonHelper::displayMoneyFormat($volumeDiscount, true, false, true, false, true); ?></td>
                                    <?php } ?>
                                    <td>
                                        <?php
                                        if (empty($childOrder['taxOptions'])) {
                                            echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'TAX'), true, false, true, false, true);
                                        } else {
                                            foreach ($childOrder['taxOptions'] as $key => $val) {
                                        ?>
                                                <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?> :</strong> <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></p>
                                        <?php
                                                if (!isset($taxOptionsTotal[$key]['value'])) {
                                                    $taxOptionsTotal[$key]['value'] = 0;
                                                }
                                                $taxOptionsTotal[$key]['value'] += $val['value'];
                                                $taxOptionsTotal[$key]['inPercentage'] = $val['inPercentage'];
                                                $taxOptionsTotal[$key]['percentageValue'] = $val['percentageValue'];
                                                $taxOptionsTotal[$key]['name'] = CommonHelper::displayTaxPercantage($val);
                                            }
                                        }
                                        ?>
                                    </td>
                                    <!-- <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'tax'), true, false, true, false, true); ?></td> -->
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <td><?php echo CommonHelper::displayMoneyFormat($rewardPointDiscount, true, false, true, false, true); ?></td>
                                    <?php } ?>
                                    <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder), true, false, true, false, true); ?></td>
                                    <?php if (count($servicesOrders) > 0) { ?>
                                        <td></td>
                                    <?php } ?>
                                </tr>

                                <!-- [ SERVICES SECTION  -->
                                <?php if (count($servicesOrders) > 0) { ?>
                                    <tr class="no-border-row no-bg-color">
                                        <th colspan="12"><?php echo Labels::getLabel('Lbl_Services', $siteLangId) ?></th>
                                    </tr>
                                    <?php
                                    $rowCount = 1;
                                    foreach ($servicesOrders as $service) {
                                        $cartTotal = $cartTotal + CommonHelper::orderProductAmount($service, 'cart_total');
                                        $shippingCharges = $shippingCharges + CommonHelper::orderProductAmount($service, 'shipping');
                                        $volumeDiscount = CommonHelper::orderProductAmount($service, 'VOLUME_DISCOUNT');
                                        $rewardPointDiscount = CommonHelper::orderProductAmount($service, 'REWARDPOINT');
                                        $orderTotalAmount += CommonHelper::orderProductAmount($service, 'NETAMOUNT');
                                    ?>

                                        <tr class="no-border-row">
                                            <?php if (!$print) { ?>
                                                <td class="no-print <?php echo ($rowCount / 2 == 0) ? "" : "odd-row-td"; ?>">
                                                    <div class="pic--cell-left"> <?php
                                                                                    $serviceUrl = CommonHelper::generateUrl('Products', 'view', array($service['op_selprod_id']));
                                                                                    $serviceImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($service['selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                                    ?> <figure class="item__pic"><a href="<?php echo $serviceUrl; ?>"><img src="<?php echo $serviceImgUrl; ?>" title="<?php echo $service['op_selprod_title']; ?>" alt="<?php echo $service['op_selprod_title']; ?>"></a></figure>
                                                    </div>
                                                </td>
                                            <?php } ?>
                                            <td class="<?php echo ($rowCount / 2 == 0) ? "" : "odd-row-td"; ?>">
                                                <div class="item__description">
                                                    <?php if ($service['op_selprod_title'] != '') { ?>
                                                        <div class="item__title">
                                                            <a title="<?php echo $service['op_selprod_title']; ?>" href="<?php echo $serviceUrl; ?>"><?php echo $service['op_selprod_title'] . '<br/>'; ?></a>
                                                        </div>
                                                    <?php } ?>
                                                    <div class="item__sold_by"><?php echo Labels::getLabel('LBL_Sold_By', $siteLangId) . ': ' . $service['op_shop_name']; ?></div>
                                                    <?php if ($service['op_shipping_duration_name'] != '') { ?>
                                                        <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $service['op_shipping_durations'] . '-' . $service['op_shipping_duration_name']; ?></div>
                                                    <?php } ?>
                                                </div>
                                            </td>

                                            <td class="<?php echo ($rowCount / 2 == 0) ? "" : "odd-row-td"; ?>"><?php echo $service['op_qty']; ?></td>
                                            <td class="<?php echo ($rowCount / 2 == 0) ? "" : "odd-row-td"; ?>"><?php echo CommonHelper::displayMoneyFormat($service['op_unit_price'], true, false, true, false, true); ?></td>
                                            <td class="<?php echo ($rowCount / 2 == 0) ? "" : "odd-row-td"; ?>"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'shipping'), true, false, true, false, true); ?></td>
                                            <td><?php echo CommonHelper::displayMoneyFormat($volumeDiscount, true, false, true, false, true); ?></td>
                                            <td>
                                                <?php
                                                if (empty($service['taxOptions'])) {
                                                    echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'TAX'), true, false, true, false, true);
                                                } else {
                                                    foreach ($service['taxOptions'] as $key => $val) {
                                                ?>
                                                        <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?> :</strong> <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></p>
                                                <?php
                                                        if (!isset($taxOptionsTotal[$key]['value'])) {
                                                            $taxOptionsTotal[$key]['value'] = 0;
                                                        }
                                                        $taxOptionsTotal[$key]['value'] += $val['value'];
                                                        $taxOptionsTotal[$key]['title'] = CommonHelper::displayTaxPercantage($val);
                                                    }
                                                }
                                                ?>
                                            </td>
                                            <td><?php echo CommonHelper::displayMoneyFormat($rewardPointDiscount, true, false, true, false, true); ?></td>
                                            <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service), true, false, true, false, true); ?></td>
                                            <td>
                                                <?php if (!$print) { ?>
                                                    <ul class="actions">
                                                        <li>
                                                            <a href="<?php echo CommonHelper::generateUrl('buyer', 'viewOrder', [$service['op_order_id'], $service['op_id']]) ?>" class="" title="<?php echo Labels::getLabel('LBL_View_Details', $siteLangId); ?>">
                                                                <i class="fa fa-eye"></i>
                                                            </a>
                                                        </li>
                                                        <?php if (!in_array($service['op_status_id'], $cancellationNotAllowedStatues)) { ?>
                                                            <li>
                                                                <a href="<?php echo CommonHelper::generateUrl('buyer', 'orderCancellationRequest', [$service['op_id']]) ?>" class="" title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>">
                                                                    <i class="fas fa-times"></i>
                                                                </a>
                                                            </li>
                                                        <?php } ?>
                                                    </ul>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                    <?php
                                        $rowCount++;
                                    }
                                    ?>
                                <?php } ?>
                                <!--  ] -->
                            <?php } ?>
                            <!--  [ RFQ PRODUCT SERVICES -->
                            <?php
                            if (!empty($rfqServices)) {
                                foreach ($rfqServices as $service) {
                                    $serviceAttachment = (isset($attachments[$service['rfqattser_selprod_id']])) ? $attachments[$service['rfqattser_selprod_id']] : [];
                            ?>
                                    <tr>
                                        <?php if (!$print) { ?>
                                            <td class="no-print">
                                                <div class="pic--cell-left"> <?php
                                                                                $serviceUrl = CommonHelper::generateUrl('Products', 'view', array($service['rfqattser_selprod_id']));
                                                                                $serviceImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($service['rfqattser_selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                                ?>
                                                    <figure class="item__pic"><a href="<?php echo $serviceUrl; ?>"><img src="<?php echo $serviceImgUrl; ?>" title="<?php echo $service['selprod_title']; ?>" alt="<?php echo $service['selprod_title']; ?>"></a></figure>
                                                </div>
                                            </td>
                                        <?php } ?>
                                        <td>
                                            <div class="item__title">
                                                <a title="<?php echo $service['selprod_title']; ?>" href="<?php echo $serviceUrl; ?>"><?php echo $service['selprod_title']; ?></a>
                                            </div>
                                            <?php if (!empty($serviceAttachment) && !$print) { ?>
                                                <div class="pic--cell-left">
                                                    <ul class="order-service-docs">
                                                        <?php
                                                        $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                        foreach ($serviceAttachment as $attachment) {
                                                            $attachmentId = $attachment['afile_id'];
                                                            $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                            $documentUrl = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 50, 50]);
                                                            echo "<li><span id='document-js-" . $attachmentId . "'>";
                                                            if (in_array($ext, $imageType)) {
                                                        ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                    <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                </a>
                                                            <?php } else { ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                    <i class="icn rfq-doc-file-icon">
                                                                        <svg class="svg">
                                                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                        <?php
                                                            }
                                                            /* echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>'; */

                                                            echo "</span></li>";
                                                            /* $icon = '<i class="fa fa-download"></i>';
                                                              $link = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', array($attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER));
                                                              echo '<a target="_blank" href="' . $link . '"><span>' . $attachment["afile_name"] . $icon . '</span></a>'; */
                                                        }
                                                        ?>
                                                    </ul>
                                                </div>
                                            <?php
                                            }
                                            ?>

                                        </td>
                                        <td><?php echo $service['rfqattser_quantity'] ?></td>
                                        <td><i class="fa fa-minus"></i></td>
                                        <td><i class="fa fa-minus"></i></td>
                                        <td><i class="fa fa-minus"></i></td>
                                    </tr>
                            <?php
                                }
                            }
                            ?>
                        </thead>
                    </table>
                    <!-- ] -->
                </td>
            </tr>
            <?php
            //if (!$primaryOrder) {
            ?>
            <tr>
                <td></td>
                <td>
                    <p>
                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('Lbl_Cart_Total', $siteLangId) ?> : </strong></span>
                        <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat($cartTotal, true, false, true, false, true); ?> </span>
                    </p>
                    <p>
                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId) ?> : </strong></span>
                        <span class="invoice-amount-txt"> <?php echo CommonHelper::displayMoneyFormat($shippingCharges, true, false, true, false, true); ?> </span>
                    </p>
                    <?php if (empty($taxOptionsTotal) || !$primaryOrder) { ?>
                        <p>
                            <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Tax_Charges', $siteLangId) ?> : </strong></span>
                            <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_tax_charged'], true, false, true, false, true); ?> </span>
                        </p>
                        <?php
                    } else {
                        foreach ($taxOptionsTotal as $key => $val) {
                        ?>
                            <p>
                                <span class="invoice-amount-txt"><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?> : </strong></span>
                                <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></span>
                            </p>
                    <?php
                        }
                    }
                    ?>
                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                        <?php if ($orderDetail['order_discount_total']) { ?>
                            <p>
                                <span class="invoice-amount-txt">
                                    <strong><?php echo Labels::getLabel('LBL_Discount', $siteLangId) ?> : </strong>
                                </span>
                                <span class="invoice-amount-txt">
                                    -<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_discount_total'], true, false, true, false, true); ?>
                                </span>
                            </p>
                        <?php } ?>
                        <?php if ($orderDetail['order_volume_discount_total']) { ?>
                            <p>
                                <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId) ?> : </strong></span>
                                <span class="invoice-amount-txt">
                                    -<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_volume_discount_total'], true, false, true, false, true); ?>
                                </span>
                            </p>
                        <?php } ?>
                    <?php } ?>
                    <p>
                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Total', $siteLangId) ?> : </strong></span>
                        <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat($orderTotalAmount, true, false, true, false, true); ?></span>
                    </p>
                </td>
            </tr>
            <?php /* } */ ?>
        </tbody>
    </table>
    <h6 class="text-right"><?php echo Labels::getLabel('LBL_Thank_You_For_Your_Business!', $siteLangId) ?></h6>
</div>
<style>
    .no-border-row th,
    .no-border-row td {
        border: 0px;
    }

    .uploaded--documents a {
        color: #000;
    }

    .table th {
        width: 175px;
        max-width: 100%;
    }

    .invoice-product tr {
        border-left: 1px solid #ddd;
        border-right: 1px solid #ddd;
    }

    .invoice-product tr:first-child {
        border-top: 1px solid #ddd;
    }

    .invoice-product.table tr:last-child td {
        border-bottom: 1px solid #dee2e6 !important;
    }

    @media print {
        .invoice-tbl-heading th {
            background-color: var(--brand-color) !important;
            color: #fff;
            padding: 5px;
        }

        .odd-row-td {
            background-color: var(--brand-color) !important;
            color: #fff;
            padding: 0px;
        }
    }
</style>
<script>
    $(".sidebar-is-expanded").addClass('sidebar-is-reduced').removeClass('sidebar-is-expanded');
</script>