<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<?php if (CommonHelper::demoUrl()) { ?>
    <div class="feedback-btn">
        <a href="https://www.yo-kart.com/yokart-marketing-website-feedback.html<?php /* echo CommonHelper::generateUrl('Custom','feedback'); */ ?>" class="crcle-btn" data-toggle="tooltip" data-placement="left" title="Give Feedback">
            <svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="comments-alt" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                <path d="M416 224V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64v160c0 35.3 28.7 64 64 64v54.2c0 8 9.1 12.6 15.5 7.8l82.8-62.1H352c35.3.1 64-28.6 64-63.9zm96-64h-64v64c0 52.9-43.1 96-96 96H192v64c0 35.3 28.7 64 64 64h125.7l82.8 62.1c6.4 4.8 15.5.2 15.5-7.8V448h32c35.3 0 64-28.7 64-64V224c0-35.3-28.7-64-64-64z" class=""></path>
            </svg>
        </a>

    </div>
<?php } ?>
<?php if (!$isUserDashboard) { ?>
    <footer class="footer">
        <div class="back-to-top">
            <a href="#top">
                <svg class="svg">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#up-arrow" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#up-arrow"></use>
                </svg>
                <span><?php echo Labels::getLabel("LBL_Top", $siteLangId); ?></span>
            </a>
        </div>
        <?php $this->includeTemplate('_partial/footerTrustBanners.php'); ?>
        <section class="footer__primary">
            <?php $this->includeTemplate('_partial/footerNewsLetterForm.php'); ?>


            <div class="footer-row footer-row--outlined">
                <div class="container">
                    <div class="footer-flex">
                        <?php $this->includeTemplate('_partial/footerNavigation.php'); ?>
                        <?php $this->includeTemplate('_partial/footerSocialMedia.php'); ?>
                        <?php $this->includeTemplate('_partial/footerAddresses.php', ['siteLangId' => $siteLangId]); ?>
                    </div>
                </div>
            </div>



            <div class="footer-row">
                <div class="container">
                    <?php
                    $isSeller = false;
                    if (UserAuthentication::isUserLogged() && User::canViewSupplierTab()) {
                        $isSeller = true;
                    }
                    $isAffiliate = false;
                    if (UserAuthentication::isUserLogged() && User::canViewAffiliateTab()) {
                        $isAffiliate = true;
                    }
                    $isAdvertiser = false;
                    if (UserAuthentication::isUserLogged() && User::canViewAdvertiserTab()) {
                        $isAdvertiser = true;
                    }

                    ?>



                    <div class="footer-flex">
                        <div class="footer-flex__colum footer-flex__colum-large">
                            <div class="footer-sitemap">
                                <div class="footer-sitemap__title footer-trigger-js"><?php echo Labels::getLabel("LBL_Be_a_Part_of_our_Family", $siteLangId); ?></div>
                                <div class="footer-sitemap__links footer-target-js">
                                    <div class="footer-actions d-md-flex align-items-center">
                                        <?php if (!$isSeller) { ?>
                                            <a href="<?php echo CommonHelper::generateUrl("supplier"); ?>" class="btn btn--primary mr-2"><?php echo Labels::getLabel("LBL_Become_a_Seller", $siteLangId); ?></a>
                                        <?php } ?>
                                        <?php if (!$isAffiliate) { ?>
                                            <a href="<?php echo CommonHelper::generateUrl("GuestAffiliate"); ?>" class="btn btn--primary mr-2"><?php echo Labels::getLabel("LBL_Become_an_Affiliate", $siteLangId); ?></a>
                                        <?php } ?>
                                        <?php if (!$isAdvertiser) { ?>
                                            <a href="<?php echo CommonHelper::generateUrl("GuestAdvertiser", "account"); ?>" class="btn btn--primary mr-2"><?php echo Labels::getLabel("LBL_Become_an_Advertiser", $siteLangId); ?></a>
                                        <?php } ?>


                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="footer-flex__colum footer-flex__colum-small">

                            <div class="footer-sitemap">
                                <div class="footer-sitemap__title footer-trigger-js"><?php echo Labels::getLabel("LBL_Payment_Options", $siteLangId); ?></div>
                                <div class="footer-sitemap__links footer-target-js">
                                    <div class="d-flex align-items-center">
                                        <img src="<?php echo CONF_WEBROOT_URL; ?>images/payment.png" alt="<?php echo Labels::getLabel('LBL_PAYMENT_OPTIONS', $siteLangId); ?>">
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <?php $this->includeTemplate('_partial/footerTrendingSuppliers.php', ['siteLangId' => $siteLangId]); ?>
                    <?php $this->includeTemplate('_partial/footerPopularCategories.php', ['siteLangId' => $siteLangId]); ?>

                </div>
            </div>

            <div class="footer-row footer-row--last">
                <div class="container">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-md-auto">
                            <p>
                                <?php
                                $url = CommonHelper::generateUrl();
                                if (CommonHelper::demoUrl()) {
                                    $url =    "https://www.yo-kart.com/b2b-multivendor-ecommerce-platform.html";
                                }
                                $replacements = array(
                                    '{YEAR}' => '&copy; ' . date("Y"),
                                    '{PRODUCT}' => '<a target="_blank" href="' . $url . '" rel="noopener">' . FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') . '</a>',
                                    '{OWNER}' => '',
                                );
                                echo CommonHelper::replaceStringData(Labels::getLabel('LBL_COPYRIGHT_TEXT', $siteLangId), $replacements);
                                ?>
                            </p>
                        </div>
                        <?php 
                        $websiteName = FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, ''); 
                        if($websiteName != '') {
                        ?>
                        <div class="col-md-auto">
                            <p><?php echo Labels::getLabel("LBL_Developed_by", $siteLangId); ?> <a href="<?php echo $url; ?>"><?php echo $websiteName ?></a></p>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>



        </section>
    </footer>
<?php } ?>
<?php if (FatApp::getConfig('CONF_ENABLE_COOKIES', FatUtility::VAR_INT, 1) && !CommonHelper::getUserCookiesEnabled()) { ?>
    <div class="cc-window cc-banner cc-type-info cc-theme-block cc-bottom cookie-alert no-print">
        <?php if (FatApp::getConfig('CONF_COOKIES_TEXT_' . $siteLangId, FatUtility::VAR_STRING, '')) { ?>
            <div class="box-cookies">
                <span id="cookieconsent:desc" class="cc-message">
                    <?php echo FatUtility::decodeHtmlEntities(mb_substr(FatApp::getConfig('CONF_COOKIES_TEXT_' . $siteLangId, FatUtility::VAR_STRING, ''), 0, 500)); ?>
                    <a href="<?php echo CommonHelper::generateUrl('cms', 'view', array(FatApp::getConfig('CONF_COOKIES_BUTTON_LINK', FatUtility::VAR_INT))); ?>"><?php echo Labels::getLabel('LBL_Read_More', $siteLangId); ?></a></span>
                <span class="cc-close cc-cookie-accept-js"><?php echo Labels::getLabel('LBL_Accept_Cookies', $siteLangId); ?></span>
            </div>
        <?php } ?>
    </div>
<?php } ?>
<?php if (!isset($_SESSION['geo_location']) && FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '') != '') { ?>
    <script type="text/javascript" src='https://maps.google.com/maps/api/js?key=<?php echo FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, ''); ?>&libraries=places'></script>

    <script>
        window.onload = function() {
            var startPos;
            var geoOptions = {
                enableHighAccuracy: true,
            };
            /* initialize(); */
            var geocoder;
            var geoSuccess = function(position) {
                startPos = position;
                codeLatLng(startPos.coords.latitude, startPos.coords.longitude);
            };

            var geoError = function(error) {
                if (error.code == 1) {
                    alert("Allow google To Access Your Current Location");
                }
                console.log('Error occurred. Error code: ' + error.code);
            };
            /* navigator.geolocation.getCurrentPosition(geoSuccess, geoError, geoOptions); */
        }
    </script>
<?php } ?>
<?php
if (FatApp::getConfig('CONF_ENABLE_LIVECHAT', FatUtility::VAR_STRING, '')) {
    echo FatApp::getConfig('CONF_LIVE_CHAT_CODE', FatUtility::VAR_STRING, '');
}
?>
<?php
if (FatApp::getConfig('CONF_SITE_TRACKER_CODE', FatUtility::VAR_STRING, '')) {
    echo FatApp::getConfig('CONF_SITE_TRACKER_CODE', FatUtility::VAR_STRING, '');
}
?>

<?php /* ?><script type="text/javascript" src="<?php
  $fl = 'js/variables.js';
  echo FatUtility::generateUrl('JsCss', 'js', array(), '', false). '&f=' . rawurlencode($fl);
  ?>"></script> <?php */ ?>
<div class="no-print">
    <?php if (CommonHelper::demoUrl()) { ?>
        <!--Start of Tawk.to Script-->
        <script type="text/javascript">
            var Tawk_API = Tawk_API || {},
                Tawk_LoadStart = new Date();
            (function() {
                var s1 = document.createElement("script"),
                    s0 = document.getElementsByTagName("script")[0];
                s1.async = true;
                s1.src = 'https://embed.tawk.to/5898f87bf1b57c0a05d78696/default';
                s1.charset = 'UTF-8';
                s1.setAttribute('crossorigin', '*');
                s0.parentNode.insertBefore(s1, s0);
            })();

            window.onbeforeprint = function() {
                Tawk_API.hideWidget();
            };
            window.onafterprint = function() {
                Tawk_API.showWidget();
            };
        </script>
        <!--End of Tawk.to Script-->
    <?php
        if (FatApp::getConfig('CONF_AUTO_RESTORE_ON', FatUtility::VAR_INT, 1) && CommonHelper::demoUrl()) {
            $this->includeTemplate('restore-system/page-content.php');
        }
    }
    ?>

</div>
</body>

</html>
<?php
//$content  = ob_get_clean();
//echo CommonHelper::minifyHtml($content);
?>