<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');

$frm->setFormTagAttribute('class', 'form');
$frm->developerTags['colClassPrefix'] = 'col-lg-6 col-md-6 col-sm-';
$frm->developerTags['fld_default_col'] = 6;
$frm->setFormTagAttribute('onsubmit', 'generateInvoice(this); return(false);');

$commentFld = $frm->getField('invoice_description');
$commentFld->setWrapperAttribute("class", "col-lg-12 col-md-12 col-sm-12");

$dateFld = $frm->getField('invoice_delivery_duration');
$dateFld->setFieldTagAttribute('class', 'delivery-date-picker--js');
?>

<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <div class="content-header row">
            <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
        </div>
        <div class="content-body">
            <div class="row mb-4">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <p class="text-right">
                                <a href="<?php echo CommonHelper::generateUrl('seller', 'sales'); ?>" class="btn btn-outline-primary btn--sm" title="<?php echo Labels::getLabel('LBL_Back_to_orders', $siteLangId); ?>">
                                    <?php echo Labels::getLabel('LBL_Back_To_Orders', $siteLangId); ?>
                                </a>
                            </p>
                            <h5 class="content-header-title"><?php echo Labels::getLabel('LBL_Invoice_For:', $siteLangId); ?> #<?php echo $orderId; ?></h5>
                            <span class="gap"></span>
                            <table class="table">
                                <tr style="background: #d2d2d238;">
                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Product_Total_Cost:', $siteLangId); ?> </strong> :
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_net_amount'] - $orderDetails['op_actual_shipping_charges'] - $orderDetails['order_tax_charged'], true, true, true, false, true); ?>
                                    </td>

                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Tax_Charges:', $siteLangId); ?></strong> : 
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_tax_charged'], true, true, true, false, true); ?>
                                    </td>

                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Shipping_Charges:', $siteLangId); ?></strong> : 
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['op_actual_shipping_charges'], true, true, true, false, true); ?>
                                    </td>
                                </tr>
                                <tr style="background: #d2d2d238;">
                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Order_Total_Amount:', $siteLangId); ?> </strong> :
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_net_amount'], true, true, true, false, true); ?>
                                    </td>

                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Paid_Amount:', $siteLangId); ?></strong> : 
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['total_paid_amount'], true, true, true, false, true); ?>
                                    </td>

                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Balance_Amount:', $siteLangId); ?></strong> : 
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_net_amount'] - $orderDetails['total_paid_amount'], true, true, true, false, true); ?>
                                    </td>
                                </tr>
                            </table>
                            <span class="gap"></span>
                            <?php echo $frm->getFormHtml(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
    .table tr td {
        padding: 20px !important;
    }
</style>

<script>
    $(document).ready(function () {
        $('select[name="invoice_payment_type"]').on('change', function () {
            var paymentType = $(this).val();
            if (paymentType == <?php echo Orders::PAYMENT_TYPE_FULL ?>) {
                var totalAmountToPay = $('input[name="invoice_payment_amount"]').data('totalamount');
                $('input[name="invoice_payment_amount"]').val(totalAmountToPay);
                $('input[name="invoice_payment_amount"]').attr('disabled', 'disabled');
            } else {
                $('input[name="invoice_payment_amount"]').removeAttr('disabled');
            }
        });
    });
</script>
<script>
    $(document).ready(function () {
        $('.delivery-date-picker--js').datetimepicker({
            minDate: new Date(),
            dateFormat: 'yy-mm-dd',
            timeFormat: 'HH:mm',

        });        
		$('.expiry-date-picker--js').datetimepicker({
            dateFormat: 'yy-mm-dd',
            timeFormat: 'HH:mm',
			minDate: "+2d"
        });
    });
</script>