<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div style="width: 100%; background: #fff; padding: 20px;">
    <table class="table">
        <thead>
            <tr class="no-border-row">
                <td>
                    <?php
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, false);
                    $shopIdentifier = (isset($shopAddress)) ? $shopAddress['shop_identifier'] : $orderDetail['op_shop_name'];
                    ?>
                    <div class="info--order">
                        <h5 class="logo-invoice">
                            <img style="max-height: 50px;" src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'shopLogo', array($orderDetail['op_shop_id'], $siteLangId, "THUMB", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $orderDetail['op_shop_name']; ?>">
                            <?php
                            echo '<span>' . $shopIdentifier . '</span>';
                            ?>
                        </h5>
                        <?php
                        if (!empty($shopAddress)) {
                            $shopAddressTxt = $shopAddress['shop_name'] . '<br>';
                            if ($shopAddress['shop_address_line_1'] != '') {
                                $shopAddressTxt .= $shopAddress['shop_address_line_1'] . '<br>';
                            }

                            if ($shopAddress['shop_address_line_2'] != '') {
                                $shopAddressTxt .= $shopAddress['shop_address_line_2'] . '<br>';
                            }

                            if ($shopAddress['shop_city'] != '') {
                                $shopAddressTxt .= $shopAddress['shop_city'] . ',';
                            }

                            if ($shopAddress['state_identifier'] != '') {
                                $shopAddressTxt .= $shopAddress['state_identifier'] . ', ';
                            }

                            if ($shopAddress['shop_postalcode'] != '') {
                                $shopAddressTxt .= '-' . $shopAddress['shop_postalcode'] . '<br>';
                            }

                            if ($shopAddress['country_name'] != '') {
                                $shopAddressTxt .= $shopAddress['country_name'] . '';
                            } elseif ($shopAddress['country_code'] != '') {
                                $shopAddressTxt .= $shopAddress['country_code'] . '';
                            }

                            if ($shopAddress['shop_phone'] != '') {
                                $shopAddressTxt .= '<br>' . $shopAddress['shop_phone'];
                            }

                            if (isset($orderDetail['op_shop_owner_email'])) {
                                $shopAddressTxt .= '<br>' . $orderDetail['op_shop_owner_email'];
                            }

                            $shopAddressTxt .= '<br>' . Labels::getLabel('LBL_Shop_URL:', $siteLangId) . ' <a href="' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']]) . '">' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']]) . '</a>';
                        ?>
                            <p><?php echo $shopAddressTxt; ?></p>

                            <?php if ($orderDetail['invoice_description'] != '') { ?>
                                <p>
                                    <strong><?php echo Labels::getLabel('LBL_Seller_Comments', $siteLangId); ?>: </strong>
                                    <?php echo $orderDetail['invoice_description']; ?>
                                </p>
                            <?php } ?>

                    </div>

                <?php } ?>
                </td>
                <td>
                    <div class="info--order ">
                        <h4 class="info-invioce"><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> </h4>
                        <p><strong><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>: </strong><?php echo FatDate::format($orderDetail['order_date_added']); ?></p>
                        <p><strong><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> #: </strong><?php echo $orderDetail['op_invoice_number']; ?></p>
                        <p>
                            <strong><?php echo Labels::getLabel('LBL_Order_Total', $siteLangId); ?>: </strong>
                            <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'], true, false, true, false, true); ?>
                        </p>
                        <?php if ($orderDetail['order_is_rfq'] == AppConstants::YES) { ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Total_Paid', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                            <p>
                                <strong><?php echo Labels::getLabel('LBL_Amount_To_Pay', $siteLangId); ?>: </strong>
                                <?php echo CommonHelper::displayMoneyFormat($orderDetail['invoice_payment_amount'], true, false, true, false, true); ?>
                            </p>
                            <p><strong><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'] - $orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                        <?php } ?>
                        <p><strong><?php echo Labels::getLabel('LBL_Customer_Name', $siteLangId); ?>: </strong><?php echo $orderDetail['user_name']; ?></p>
                        <p>
                            <strong><?php echo Labels::getLabel('LBL_Payment_Type', $siteLangId); ?>: </strong>
                            <?php echo $paymentTypes[$orderDetail['invoice_payment_type']]; ?>
                        </p>
                        <p>
                            <strong><?php echo Labels::getLabel('LBL_Delivery_Duration', $siteLangId); ?>: </strong>
                            <?php echo FatDate::format($orderDetail['invoice_delivery_duration'], true); ?>
                        </p>
                        <?php
                        $selected_method = '';
                        if ($orderDetail['order_pmethod_id'] > 0) {
                            $selected_method .= CommonHelper::displayNotApplicable($siteLangId, $orderDetail["pmethod_name"]);
                        }
                        ?>
                        <?php if ($selected_method != '') { ?>
                            <p><strong><?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?>: </strong><?php echo $selected_method; ?></p>
                        <?php } ?>
                        <p><strong><?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>: </strong>
                            <?php
                            echo Orders::getOrderPaymentStatusArr($siteLangId)[$orderDetail['order_is_paid']];
                            if ('' != $orderDetail['pmethod_name'] && 'CashOnDelivery' == $orderDetail['pmethod_code']) {
                                echo ' (' . $orderDetail['pmethod_name'] . ' )';
                            }
                            ?>
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <h6 class="invoice-subheading"><?php echo Labels::getLabel('LBL_Billing_Address', $siteLangId); ?></h6> <?php
                                                                                                                            $billingAddress = $orderDetail['billingAddress']['oua_name'] . '<br>';
                                                                                                                            if ($orderDetail['billingAddress']['oua_address1'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address1'] . '<br>';
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_address2'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address2'] . '<br>';
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_city'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_city'] . ',';
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_state'];
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                                $billingAddress .= '-' . $orderDetail['billingAddress']['oua_zip'];
                                                                                                                            }

                                                                                                                            if ($orderDetail['billingAddress']['oua_phone'] != '') {
                                                                                                                                $billingAddress .= '<br>' . $orderDetail['billingAddress']['oua_phone'];
                                                                                                                            }
                                                                                                                            ?>
                    <div class="info--order">
                        <p><?php echo $billingAddress; ?></p>
                    </div>
                </td>
                <td>
                    <h6 class="invoice-subheading"><?php echo Labels::getLabel('LBL_Shipping_Address', $siteLangId); ?></h6> <?php
                                                                                                                                $shippingAddress = $orderDetail['shippingAddress']['oua_name'] . '<br>';
                                                                                                                                if ($orderDetail['shippingAddress']['oua_address1'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_address1'] . '<br>';
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_address2'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_address2'] . '<br>';
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_city'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_city'] . ',';
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_state'];
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                                    $shippingAddress .= '-' . $orderDetail['shippingAddress']['oua_zip'];
                                                                                                                                }

                                                                                                                                if ($orderDetail['shippingAddress']['oua_phone'] != '') {
                                                                                                                                    $shippingAddress .= '<br>' . $orderDetail['shippingAddress']['oua_phone'];
                                                                                                                                }
                                                                                                                                ?>
                    <div class="info--order">
                        <p><?php echo $shippingAddress; ?></p>
                    </div>
                </td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="2">
                    <!-- PRODUCT DETAILS TABLE -->
                    <table class="table table-striped invioce-table-bg">
                        <thead>
                            <tr class="invoice-tbl-heading">
                                <th><?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Qty', $siteLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Tax_Charges', $siteLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Total', $siteLangId); ?></th>
                            </tr>

                            <tr class="">
                                <td>
                                    <div class="item__description" style="width: 200px;">
                                        <?php if ($orderDetail['op_selprod_title'] != '') { ?>
                                            <div class="item__title"><a title="<?php echo $orderDetail['op_selprod_title']; ?>" href="<?php echo $prodUrl; ?>"><?php echo $orderDetail['op_selprod_title']; ?></a></div>
                                            <div class="item__category"><?php echo $orderDetail['op_product_name']; ?></div>
                                        <?php } else { ?>
                                            <div class="item__brand"><a title="<?php echo $orderDetail['op_product_name']; ?>" href="<?php echo $prodUrl; ?>"><?php echo $orderDetail['op_product_name']; ?>
                                                </a></div>
                                        <?php } ?>
                                        <div class="item__brand"><?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>: <?php echo CommonHelper::displayNotApplicable($siteLangId, $orderDetail['op_brand_name']); ?></div>
                                        <?php if ($orderDetail['op_selprod_options'] != '') { ?>
                                            <div class="item__specification"><?php echo $orderDetail['op_selprod_options']; ?></div>
                                        <?php } ?>
                                        <?php if ($orderDetail['op_shipping_duration_name'] != '') { ?>
                                            <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $orderDetail['op_shipping_durations'] . '-' . $orderDetail['op_shipping_duration_name']; ?></div>
                                    </div>
                                <?php } ?>
                                </td>
                                <td><?php echo $orderDetail['op_qty']; ?></td>
                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'shipping'), true, false, true, false, true); ?></td>
                                <td>
                                    <?php
                                    if (empty($orderDetail['taxOptions'])) {
                                        echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'TAX'), true, false, true, false, true);
                                    } else {
                                        foreach ($orderDetail['taxOptions'] as $key => $val) {
                                    ?>
                                            <p>
                                                <strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong>
                                                <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?>
                                            </p>
                                    <?php
                                        }
                                    }
                                    ?>
                                </td>
                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'netamount', false, User::USER_TYPE_SELLER), true, false, true, false, true); ?></td>
                            </tr>

                            <!-- [ ATTACHED SERVICES LISTING -->
                            <?php
                            if (!empty($rfqServices)) {
                                foreach ($rfqServices as $service) {
                                    $serviceAttachment = (isset($attachments[$service['rfqattser_selprod_id']])) ? $attachments[$service['rfqattser_selprod_id']] : [];
                            ?>
                                    <tr>
                                        <td>
                                            <div class="item__title">
                                                <a title="<?php echo $service['selprod_title']; ?>" href="<?php echo $serviceUrl; ?>"><?php echo $service['selprod_title']; ?></a>
                                            </div>
                                            <?php if (!empty($serviceAttachment) && !$print) { ?>
                                                <div class="pic--cell-left">
                                                    <ul class="order-service-docs">
                                                        <?php
                                                        $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                        foreach ($serviceAttachment as $attachment) {
                                                            $attachmentId = $attachment['afile_id'];
                                                            $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                            $documentUrl = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 50, 50]);
                                                            echo "<li><span id='document-js-" . $attachmentId . "'>";
                                                            if (in_array($ext, $imageType)) {
                                                        ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                    <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                </a>
                                                            <?php } else { ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                    <i class="icn rfq-doc-file-icon">
                                                                        <svg class="svg">
                                                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                        <?php
                                                            }
                                                            //echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>';
                                                            echo "</span></li>";
                                                            /* $icon = '<i class="fa fa-download"></i>';
                                                              $link = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', array($attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER));
                                                              echo '<a target="_blank" href="' . $link . '"><span>' . $attachment["afile_name"] . $icon . '</span></a>'; */
                                                        }
                                                        ?>
                                                    </ul>
                                                </div>
                                            <?php
                                            }
                                            ?>

                                        </td>
                                        <td><?php echo $service['rfqattser_quantity'] ?></td>
                                        <td><i class="fa fa-minus"></i></td>
                                        <td><i class="fa fa-minus"></i></td>
                                        <td><i class="fa fa-minus"></i></td>
                                    </tr>
                            <?php
                                }
                            }
                            ?>
                            <!-- ] -->
                        </thead>
                    </table>
                    <!-- ] -->
                </td>
            </tr>

            <tr>
                <td></td>
                <td>
                    <p>
                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('Lbl_Cart_Total', $siteLangId) ?> : </strong></span>
                        <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'CART_TOTAL'), true, false, true, false, true); ?> </span>
                    </p>
                    <p>
                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId) ?> : </strong></span>
                        <span class="invoice-amount-txt"> <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'SHIPPING'), true, false, true, false, true); ?> </span>
                    </p>

                    <?php if ($orderDetail['op_tax_collected_by_seller']) { ?>
                        <?php if (empty($orderDetail['taxOptions'])) { ?>
                            <p>
                                <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Tax', $siteLangId); ?>:</strong></span>
                                <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'TAX'), true, false, true, false, true); ?> </span>
                            </p>
                            <?php
                        } else {
                            foreach ($orderDetail['taxOptions'] as $key => $val) {
                            ?>
                                <p>
                                    <span class="invoice-amount-txt"><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong></span>
                                    <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></span>
                                </p>
                        <?php
                            }
                        }
                        ?>
                    <?php } ?>
                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                        <?php if ($orderDetail['order_discount_total']) { ?>
                            <p>
                                <span class="invoice-amount-txt">
                                    <strong><?php echo Labels::getLabel('LBL_Discount', $siteLangId) ?> : </strong>
                                </span>
                                <span class="invoice-amount-txt">
                                    -<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_discount_total'], true, false, true, false, true); ?>
                                </span>
                            </p>
                        <?php } ?>
                        <?php if ($orderDetail['order_volume_discount_total']) { ?>
                            <p>
                                <span class="invoice-amount-txt">
                                    <strong><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId) ?> : </strong>
                                </span>
                                <span class="invoice-amount-txt">
                                    -<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_volume_discount_total'], true, false, true, false, true); ?>
                                </span>
                            </p>
                        <?php } ?>
                    <?php } ?>
                    <p>
                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Total', $siteLangId) ?> : </strong></span>
                        <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'netamount', false, User::USER_TYPE_SELLER), true, false, true, false, true); ?></span>
                    </p>
                </td>
            </tr>
            <?php /* } */ ?>
        </tbody>
    </table>
    <h6 class="text-right m-2"><?php echo Labels::getLabel('LBL_Thank_You_For_Your_Business!', $siteLangId) ?></h6>
</div>
<script>
    $(".sidebar-is-expanded").addClass('sidebar-is-reduced').removeClass('sidebar-is-expanded');
</script>

<style>
    .no-border-row th,
    .no-border-row td {
        border: 0px;
    }

    @media print {
        .invoice-tbl-heading th {
            background-color: var(--brand-color) !important;
            color: #fff;
            padding: 5px;
        }

        .odd-row-td {
            background-color: var(--brand-color) !important;
            color: #fff;
            padding: 5px;
        }
    }
</style>