<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (empty($products)) {
    $pSrchFrm = Common::getSiteSearchForm();
    $pSrchFrm->fill(array('btnSiteSrchSubmit' => Labels::getLabel('LBL_Submit', $siteLangId)));
    $pSrchFrm->setFormTagAttribute('onSubmit', 'submitSiteSearch(this); return(false);');

    $this->includeTemplate('_partial/no-product-found.php', array('pSrchFrm' => $pSrchFrm, 'siteLangId' => $siteLangId, 'postedData' => $postedData), true);
    return;
}

$frmProductSearch->setFormTagAttribute('onSubmit', 'searchProducts(this); return(false);');
$keywordFld = $frmProductSearch->getField('keyword');
$keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search', $siteLangId));
$keywordFld = $frmProductSearch->getField('keyword');
$keywordFld->overrideFldType("hidden");

$sortByFld = $frmProductSearch->getField('sortBy');
$sortByFld->addFieldTagAttribute('class', 'custom-select1 custom-select-sm1');

$pageSizeFld = $frmProductSearch->getField('pageSize');
$pageSizeFld->addFieldTagAttribute('class', 'custom-select1 custom-select-sm1');

$desktop_url = '';
$tablet_url = '';
$mobile_url = '';
$category['banner'] = isset($category['banner']) ? (array) $category['banner'] : array();
//$shop = isset($shop) ? $shop : 0;

/* if (isset($pageTitle)) { ?>
    <section class="bg-second pt-3 pb-3">
        <div class="container">
            <div class="section-head section--white--head section--head--center mb-0">
                <div class="section__heading">
                    <h2 class="mb-0">
                        <?php
                        $keywordStr = '';
                        if (isset($keyword) && !empty($keyword)) {
                            $short_keyword = (mb_strlen($keyword) > 20) ? mb_substr($keyword, 0, 20) . "..." : $keyword;
                            $keywordStr = '<span title="' . $keyword . '" class="search-results">"' . $short_keyword . '"</span>';
                        }
                        echo $pageTitle;
                        ?> <?php echo $keywordStr; ?></h2>
                    <?php if (isset($showBreadcrumb) && $showBreadcrumb) { ?>
                        <div class="breadcrumbs breadcrumbs--white breadcrumbs--center">
                            <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } */ ?>
<?php $this->includeTemplate('_partial/productsSearchForm.php', array('frmProductSearch' => $frmProductSearch, 'siteLangId' => $siteLangId, 'recordCount' => $recordCount, 'pageTitle' => (isset($pageTitle)) ? $pageTitle : 'Products'), false); ?>
<section class="section section-listing">
    <div class="container">
        <?php if (isset($shop)) { ?>
            <div class="sorting-bar">
                <div class="row align-items-center justify-content-between">
                    <div class="col-lg-6">
                        <h1 class="page-title"><?php echo isset($scollection_name) && !empty($scollection_name) ? $scollection_name : Labels::getLabel('LBL_All_Products', $siteLangId); ?> <span class="count-text"> (<span id="total_records"><?php echo $recordCount; ?></span> <?php echo Labels::getLabel('LBL_products_available', $siteLangId); ?>)</span></h1>
                    </div>
                    <div class="col-lg-auto">
                        <div class="sorting-controls">

                            <div class="sorting-controls__item">
                                <?php echo $frmProductSearch->getFieldHtml('sortBy'); ?>
                            </div>
                            <div class="sorting-controls__item sorting-controls__item-secondlast">
                                <?php echo $frmProductSearch->getFieldHtml('pageSize'); ?></li>
                            </div>

                            <div class="sorting-controls__item sorting-controls__item-last">
                                <a href="javascript:void(0)" onclick="saveProductSearch()" class="btn btn--bordered btn--icon btn--bordered-secondary saveSearch-js">
                                    <span class="svg-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14 12.6">
                                            <path d="M9.7,7.9h3.5L9,12.1,4.8,7.9H8.3V3H9.7ZM3.4,14.2H14.6V9.3H16v5.6a.7.7,0,0,1-.7.7H2.7a.7.7,0,0,1-.7-.7V9.3H3.4Z" transform="translate(-2 -3)"></path>
                                        </svg>

                                    </span> <?php echo Labels::getLabel('LBL_Save_Search', $siteLangId); ?>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>

        <div class="page-view">
            <aside class="page-view__small">
                <div id="filters-js" class="filters productFilters-js">

                </div>
                <a href="#filters-js" class="filters-overlay trigger-js"></a>
            </aside>
            <div class="page-view__large">
                <?php if (isset($showBreadcrumb) && $showBreadcrumb) { ?>
                    <div class="breadcrumbs">
                        <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
                    </div>
                <?php } ?>

                <?php
                $keywordStr = '';
                if (isset($keyword) && !empty($keyword)) {
                    $short_keyword = (mb_strlen($keyword) > 20) ? mb_substr($keyword, 0, 20) . "..." : $keyword;
                    $keywordStr = '<span title="' . $keyword . '" class="search-results">"' . $short_keyword . '"</span>';
                } else {
                    $pageTitle = Labels::getLabel('LBL_PRODUCTS_Search', $siteLangId);
                }
                ?>

                <?php if (!isset($shop)) { ?>
                    <h1 class="page-title"><?php echo $pageTitle . ' ' . $keywordStr; ?> <span class="count-text">(<span id="total_records"><?php echo $recordCount; ?></span> <?php echo Labels::getLabel('LBL_products_available', $siteLangId); ?>)</span></h1>
                    <!-- Slider images Start from here -->
                    <?php
                    if (!empty($category['banner'])) {
                        $catBannerArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_CATEGORY_BANNER, $category['prodcat_id'], 0, $siteLangId);
                        foreach ($catBannerArr as $slideScreen) {
                            $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
                            switch ($slideScreen['afile_screen']) {
                                case AppConstants::SCREEN_MOBILE:
                                    $mobile_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'MOBILE', AppConstants::SCREEN_MOBILE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                                    break;
                                case AppConstants::SCREEN_IPAD:
                                    $tablet_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'TABLET', AppConstants::SCREEN_IPAD)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                                    break;
                                case AppConstants::SCREEN_DESKTOP:
                                    $desktop_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'DESKTOP', AppConstants::SCREEN_DESKTOP)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                                    break;
                            }
                    ?>
                        <?php } ?>
                        <div class="page-hero-media">
                            <picture>
                                <source data-aspect-ratio="4:3" srcset="<?php echo $mobile_url; ?>" media="(max-width: 767px)">
                                <source data-aspect-ratio="4:3" srcset="<?php echo $tablet_url; ?>" media="(max-width: 1024px)">
                                <source data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>">
                                <img data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>" alt="">
                            </picture>
                        </div>
                        <?php
                    }
                    if (array_key_exists('brand_id', $postedData) && $postedData['brand_id'] > 0) {
                        $brandImgArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, $siteLangId);
                        if (!empty($brandImgArr)) {
                            foreach ($brandImgArr as $slideScreen) {
                                $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
                                switch ($slideScreen['afile_screen']) {
                                    case AppConstants::SCREEN_MOBILE:
                                        $mobile_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'MOBILE', 0, AppConstants::SCREEN_MOBILE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                                        break;
                                    case AppConstants::SCREEN_IPAD:
                                        $tablet_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'TABLET', 0, AppConstants::SCREEN_IPAD)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                                        break;
                                    case AppConstants::SCREEN_DESKTOP:
                                        $desktop_url = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'DESKTOP', 0, AppConstants::SCREEN_DESKTOP)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                                        break;
                                }
                            }
                        ?>
                            <div class="page-hero-media">
                                <picture>
                                    <source data-aspect-ratio="4:3" srcset="<?php echo $mobile_url; ?>" media="(max-width: 767px)">
                                    <source data-aspect-ratio="4:3" srcset="<?php echo $tablet_url; ?>" media="(max-width: 1024px)">
                                    <source data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>">
                                    <img data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>" alt="">
                                </picture>
                            </div>
                        <?php } ?>
                    <?php } ?>


                    <div class="sorting-bar">
                        <div class="row align-items-center justify-content-between">
                            <div class="col-sm-6">
                                <div class="sorting-controls">
                                    <div class="sorting-controls__item">
                                        <?php echo $frmProductSearch->getFieldHtml('sortBy'); ?>
                                    </div>
                                    <div class="sorting-controls__item">
                                        <?php echo $frmProductSearch->getFieldHtml('pageSize'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-auto">
                                <div class="sorting-controls">
                                    <div class="sorting-controls__item">
                                        <a href="javascript:void(0)" onclick="saveProductSearch()" class="btn btn--bordered btn--icon btn--bordered-secondary saveSearch-js">
                                            <span class="svg-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14 12.6">
                                                    <path d="M9.7,7.9h3.5L9,12.1,4.8,7.9H8.3V3H9.7ZM3.4,14.2H14.6V9.3H16v5.6a.7.7,0,0,1-.7.7H2.7a.7.7,0,0,1-.7-.7V9.3H3.4Z" transform="translate(-2 -3)"></path>
                                                </svg>

                                            </span> <?php echo Labels::getLabel('LBL_Save_Search', $siteLangId); ?>
                                        </a>
                                    </div>
                                    <div class="sorting-controls__item">

                                        <div class="tab-switch">
                                            <a href="javascript:void(0)" class="tab-switch__item  switch-js is-grid">
                                                <span class="svg-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 408.96 409.04">
                                                        <g>
                                                            <g>
                                                                <path d="M41.67,409c-6.29-2.34-13.09-3.82-18.78-7.18C8.34,393.23.51,379.85.3,363q-.61-48.11,0-96.21a46.7,46.7,0,0,1,46.21-46.09q47.9-.48,95.79,0a46.75,46.75,0,0,1,46.23,46.49c.29,31.67.24,63.34,0,95-.16,23.29-16.67,42.22-39.64,46.18a9.09,9.09,0,0,0-1.81.69Zm53-156.53c-15.17,0-30.33,0-45.49,0-10.9,0-17.08,6.18-17.1,17.07q0,45.09,0,90.2c0,11.17,6.12,17.29,17.27,17.3q45.09,0,90.18,0c10.9,0,17.08-6.19,17.09-17.07q0-45.11,0-90.21c0-11.16-6.12-17.27-17.27-17.29Q117,252.48,94.68,252.51Z"></path>
                                                                <path d="M409,146.29c-1.8,8.37-4.34,16.42-9.74,23.28-9.35,11.88-21.53,18.74-36.64,18.9-31.93.34-63.87.4-95.79,0-24.93-.31-45.79-21.1-46.12-46q-.61-48.11,0-96.22C221,21.38,241.86.59,266.79.28q47.88-.58,95.79,0c22.58.24,41.67,17.21,45.62,39.55a22.79,22.79,0,0,0,.76,2.65Zm-94.31,10.38c14.9,0,29.8,0,44.7,0,11.14,0,17.64-6.48,17.66-17.57q0-44.71,0-89.43c0-11.09-6.53-17.55-17.67-17.56q-44.5,0-89,0c-11.4,0-17.85,6.43-17.86,17.78q0,44.52,0,89c0,11.35,6.46,17.74,17.87,17.77Q292.5,156.7,314.65,156.67Z"></path>
                                                                <path d="M262.84,409c-8.5-1.82-16.64-4.43-23.58-10-11.68-9.33-18.43-21.43-18.59-36.37-.34-31.91-.4-63.84,0-95.75.3-25.11,21.13-45.95,46.23-46.25q47.85-.58,95.73,0c22.55.24,41.64,17.22,45.58,39.55a23.21,23.21,0,0,0,.76,2.64V366.71c-.26.88-.58,1.74-.77,2.63-3.87,18.87-15,31.36-33.16,37.54-2.73.93-5.59,1.45-8.39,2.16ZM377,314.94q0-22.17,0-44.32c0-11.69-6.34-18.09-17.93-18.1q-44.31,0-88.61,0c-11.63,0-18,6.38-18,18q0,44.32,0,88.63c0,11.43,6.4,17.9,17.73,17.91q44.51,0,89,0c11.36,0,17.78-6.45,17.8-17.84Q377.06,337.1,377,314.94Z"></path>
                                                                <path d="M188.58,94.72q0,22.35,0,44.72c-.05,28.66-20.4,49.13-49,49.17q-45.3.06-90.61,0C20.67,188.56.2,168.1.16,139.76Q.09,94.45.16,49.12C.2,20.56,20.65.18,49.29.15q45.12-.06,90.22,0c28.62,0,49,20.44,49.07,49.05C188.61,64.37,188.58,79.54,188.58,94.72ZM94.42,156.67q22.35,0,44.7,0c11.43,0,17.51-6.06,17.52-17.45q0-44.7,0-89.4c0-11.71-6-17.72-17.64-17.73q-44.7,0-89.39,0c-11.43,0-17.51,6.06-17.52,17.44q0,44.91,0,89.81c0,11.18,6.11,17.3,17.24,17.33C64.36,156.7,79.39,156.67,94.42,156.67Z"></path>
                                                            </g>
                                                        </g>
                                                    </svg>

                                                </span>
                                            </a>
                                            <a href="javascript:void(0)" class="tab-switch__item  switch-js is-active is-list">
                                                <span class="svg-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 378.9 306.1">
                                                        <g>
                                                            <g>
                                                                <path d="M0,21.8C.45,20.53.92,19.26,1.35,18,4.83,7.52,14.29.18,25.22.12q40.58-.21,81.17,0a25.6,25.6,0,0,1,25.29,25.44q.25,40.49,0,81A25.67,25.67,0,0,1,106,132c-26.68.15-53.36.11-80,0C13.86,132,4,124.08.78,112.34a19.44,19.44,0,0,0-.78-2Zm65.87,86.25c12.6,0,25.19-.07,37.79,0,3,0,4.19-.94,4.18-4.09q-.14-37.86,0-75.73c0-3.33-1.16-4.29-4.37-4.28q-37.61.13-75.22,0c-3.2,0-4.38.94-4.36,4.27q.15,37.68,0,75.36c0,3.5,1.16,4.53,4.56,4.48C40.92,108,53.39,108.05,65.87,108.05Z"></path>
                                                                <path d="M0,195.8c.45-1.27.92-2.54,1.35-3.82,3.48-10.46,12.94-17.8,23.87-17.86q40.58-.21,81.17,0a25.6,25.6,0,0,1,25.29,25.44q.25,40.49,0,81A25.67,25.67,0,0,1,106,306q-40.2.21-80.42,0A25.85,25.85,0,0,1,1.08,287.42C.76,286.37.36,285.34,0,284.3Zm65.49,86.25c12.73,0,25.45-.07,38.17.05,3,0,4.19-.94,4.18-4.09q-.14-37.86,0-75.73c0-3.33-1.16-4.29-4.37-4.28q-37.61.15-75.21,0c-3.21,0-4.39.94-4.37,4.27q.15,37.68,0,75.36c0,3.5,1.16,4.53,4.56,4.48C40.79,282,53.14,282.05,65.49,282.05Z"></path>
                                                                <rect x="170.55" y="20.83" width="207.26" height="30.59" rx="15.3"></rect>
                                                                <rect x="172.78" y="74.37" width="149.55" height="30.59" rx="15.3"></rect>
                                                                <rect x="171.64" y="193.97" width="207.26" height="30.59" rx="15.3"></rect>
                                                                <rect x="173.87" y="247.51" width="149.55" height="30.59" rx="15.3"></rect>
                                                            </g>
                                                        </g>
                                                    </svg>

                                                </span>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php } ?>

                <!-- Slider images End from here -->

                <?php $shop = isset($shop) ? $shop : 0; ?>
                <div class="product-listing">
                    <div class="product-list  <?php if (!$shop) {
                                                    echo "is-listview";
                                                } else {
                                                    echo "is-gridview";
                                                } ?>" id="productsList">
                        <?php
                        $productsData = array(
                            'products' => $products,
                            'page' => $page,
                            'pageCount' => $pageCount,
                            'postedData' => $postedData,
                            'recordCount' => $recordCount,
                            'siteLangId' => $siteLangId,
                            'shop' => isset($shop) ? $shop : 0,
                        );
                        $this->includeTemplate('products/products-list.php', $productsData, false);
                        ?>
                    </div>

                    <div class="page-sticky-actions page-sticky-actions-js">
                        <a href="#filters-js" class="btn btn--filter trigger-js is-active mobile-ftr-js">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="16" height="16">
                                <path d="M6.17 18a3.001 3.001 0 0 1 5.66 0H22v2H11.83a3.001 3.001 0 0 1-5.66 0H2v-2h4.17zm6-7a3.001 3.001 0 0 1 5.66 0H22v2h-4.17a3.001 3.001 0 0 1-5.66 0H2v-2h10.17zm-6-7a3.001 3.001 0 0 1 5.66 0H22v2H11.83a3.001 3.001 0 0 1-5.66 0H2V4h4.17z"></path>
                            </svg> <?php echo Labels::getLabel('LBL_Filters', $siteLangId); ?>
                        </a>
                    </div>

                </div>

            </div>
        </div>
    </div>
</section>
<section>
    <div class="container">
        <div class="row">
            <div class="col-md-3 col--left col--left-adds">
                <div class="wrapper--adds">
                    <div class="grids" id="searchPageBanners">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
if (isset($keyword)) {
    $obj = new Extrapage();
    $footerData = $obj->getContentByPageType(Extrapage::PRODUCT_SEARCH_PAGE_FOOTER_CONTENT_BLOCK, $siteLangId);
    if (isset($footerData['epage_content']) && !empty($footerData['epage_content'])) {
?>
        <section class="section section-cms">
            <div class="container">
                <?php
                echo FatUtility::decodeHtmlEntities($footerData['epage_content']);
                ?>
            </div>
        </section>
<?php }
} ?>

<script type="text/javascript">
    $(document).ready(function() {
        $currentPageUrl = '<?php echo html_entity_decode($canonicalUrl); ?>';
        $productSearchPageType = '<?php echo $productSearchPageType; ?>';
        $recordId = <?php echo $recordId; ?>;
        bannerAdds('<?php echo $bannerListigUrl; ?>');
        loadProductListingfilters(document.frmProductSearch);

    });
</script>