<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$packageMemberLabels = SellerPackages::getPackageMemberLabels($siteLangId);
if ($products) {
    $showActionBtns = !empty($showActionBtns) ? $showActionBtns : false;
    $isWishList = isset($isWishList) ? $isWishList : 0;
    foreach ($products as $product) {  //echo '<pre>';print_r($product); die;
        $showActionbtnWithProduct = $showActionBtns;
        $product['from_listing'] = true;
        if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
            $showActionbtnWithProduct = false;
        }


        $productUrl = CommonHelper::generateUrl('Products', 'View', array($product['selprod_id']));
        ?> <div class="product-list__item">
            <!--product tile-->
            <div class="product-card product-card--hovered">
                <?php include(CONF_THEME_PATH . '_partial/collection/product-card.php');
                ?>
            </div>
            <!--/product tile-->
        </div> <?php
    }

    $searchFunction = 'goToProductListingSearchPage';
    if (isset($pagingFunc)) {
        $searchFunction = $pagingFunc;
    }

    $postedData['page'] = (isset($page)) ? $page : 1;
    $postedData['recordDisplayCount'] = $recordCount;
    echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmProductSearchPaging', 'id' => 'frmProductSearchPaging'));
    $pagingArr = array('pageCount' => $pageCount, 'page' => $postedData['page'], 'recordCount' => $recordCount, 'callBackJsFunc' => $searchFunction);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
} else {
    $arr['recordDisplayCount'] = $recordCount;
    echo FatUtility::createHiddenFormFromData($arr, array('name' => 'frmProductSearchPaging', 'id' => 'frmProductSearchPaging'));
    $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
}
?>
<style>
    span.tag--soldouts {
        width: 100%;
        margin: 0 auto;
        display: block;
        text-align: center;
        margin-top: 10 px;
    }
</style>
<?php if(!empty($products)) { ?>
<script type='application/ld+json'>
    {
      "@context": "http://www.schema.org",
      "numberOfItems": <?php echo count($products); ?>,
      "itemListElement": [
        <?php foreach($products as $key=>$product) { ?>
        {
            "@type": "ListItem",
            "position": <?php echo $key+1; ?>,
            "url": <?php echo CommonHelper::generateFullUrl('Products', 'View', [$product['selprod_id']]); ?>,
        },
        <?php } ?>
      ]
    }
  </script>
<?php } ?>