(function () {
    offersListing = function ($rfqId) {
        var data = 'rfq_id=' + $rfqId;
        $('#listing').html(fcom.getLoader());
        fcom.ajax(fcom.makeUrl('CounterOffer', 'listingForBuyer'), data, function (res) {
            $('#listing').html(res);
        });
    };

    getUploadedDocuments = function (rfqId) {
        let data = 'rfq_id=' + rfqId;
        fcom.ajax(fcom.makeUrl('RequestForQuotes', 'getUploadedDocuments'), data, function (res) {
            $('#uploaded-documents-js').html(res);
        });
    }

    counterOfferForm = function (rfqId) {
        var data = 'rfq_id=' + rfqId;
        fcom.ajax(fcom.makeUrl('CounterOffer', 'form'), data, function (res) {
            $('#counter-offer-form-js').html(res);
            $('#counter-offer-form-section-js').show();
            var position = $("#counter-offer-form-section-js").offset().top - 100;
            $("html,body").animate({scrollTop: position}, "slow");
        });
    }

    changeStatus = function (rfqId, status) {
        var data = 'rfq_id=' + rfqId + '&status=' + status;
        fcom.ajax(fcom.makeUrl('CounterOffer', 'updateStatusByBuyer'), data, function (ans) {
            var ans = JSON.parse(ans);
            if (ans.status == 1) {
                $.mbsmessage(ans.msg, true, 'alert--success');
                window.location.reload();
            } else {
                $.mbsmessage(ans.msg, true, 'alert--danger');
            }
        });
    }

    setupCounterOffer = function (frm) {

        if (!$(frm).validate()) {
            return false;
        }

        var data = fcom.frmData(frm);
        fcom.ajax(fcom.makeUrl('CounterOffer', 'setupBuyerCounterOffer'), data, function (ans) {
            var ans = JSON.parse(ans);
            if (ans.status == 1) {
                $.mbsmessage(ans.msg, true, 'alert--success');
                window.location.reload();
            } else {
                $.mbsmessage(ans.msg, true, 'alert--danger');
            }
        });
    };

})();