<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/buyerDashboardNavigation.php'); ?>
<main id="main-area" class="main offer-detail-page" role="main">
    <div class="content-wrapper content-space">
        <div class="content-header row">
            <div class="col">
                <h2 class="content-header-title"><?php echo Labels::getLabel('LBL_Details', $siteLangId); ?>: <?php echo $rfqData['selprod_title']; ?> <span>(#<?php echo $rfqData['rfq_id']; ?>)</span></h2>
            </div>
            <div class="col-auto">
                <span class="status status--inprocess"><?php echo $statusArr[$rfqData['rfq_status']]; ?></span>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="btn-group rfq-view-action-btn">
                    <?php if ($rfqData['rfq_parent_id'] > 0) { ?>
                        <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'RequestView', array($rfqData['rfq_parent_id'])); ?>" class="btn btn-outline-primary btn--sm"><?php echo Labels::getLabel('LBL_Back_Original_Offer', $siteLangId); ?></a>
                    <?php } ?>
                    <?php if (!empty($reQuoteOfferDetail)) { ?>
                        <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'RequestView', array($reQuoteOfferDetail['rfq_id'])); ?>" class="btn btn-outline-primary btn--sm"><?php echo Labels::getLabel('LBL_Move_to_Re-Quote_Offer', $siteLangId); ?></a>
                    <?php } ?>
                    <div class="btn-group"><a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'rfqMessage', array($rfqData['rfq_id'])); ?>" class="btn btn-outline-primary btn--sm">Send Messages</a></div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <div class="row mb-4">
                <div class="col-lg-6">
                    <div class="cards">
                        <div class="cards-content">
                            <div class="box-group">
                                <div class="heading-box"><?php echo Labels::getLabel('LBL_Original_Offer', $siteLangId); ?></div>
                                <div class="box-group__body box-group__body-js">
                                    <table class="table table--two-cols">
                                        <tbody>
                                            <tr>
                                                <td class="child-first no-padding">
                                                    <div class="td__data-right">
                                                        <div class="cart-item">
                                                            <div class="date"><label><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>:&nbsp;</label><?php echo FatDate::Format($rfqData['rfq_added_on']); ?></div>
                                                            <div class="cart-item__pic">
                                                                <a href="<?php echo CommonHelper::generateUrl('Products', 'View', array($rfqData['selprod_id'])); ?>">
                                                                    <?php $uploadedTime = AttachedFile::setTimeParam($rfqData['product_updated_on']); ?>
                                                                    <?php if ($rfqData['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) { ?>
                                                                        <img data-ratio="1:1 (500x500)" src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($rfqData['selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg') ?>" alt="<?php echo $rfqData['selprod_title']; ?>">
                                                                    <?php } else { ?>
                                                                        <img data-ratio="1:1 (500x500)" src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($rfqData['selprod_product_id'], "CLAYOUT3", $rfqData['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $rfqData['selprod_title']; ?>">
                                                                    <?php } ?>
                                                                </a>
                                                            </div>
                                                            <div class="cart-item__details">
                                                                <span class="cart-item__title"><a href="<?php echo CommonHelper::generateUrl('Products', 'View', array($rfqData['selprod_id'])); ?>"><?php echo $rfqData['selprod_title']; ?></a> </span>
                                                                <span class="text--normal text--normal-secondary">
                                                                    <?php
                                                                    if ($rfqData['in_stock']) {
                                                                        echo Labels::getLabel('LBL_In_Stock', $siteLangId);
                                                                    } else {
                                                                        echo Labels::getLabel('LBL_Out_Of_Stock', $siteLangId);
                                                                    }
                                                                    ?>
                                                                </span>
                                                                <h5>

                                                                    <?php if (CommonHelper::isDisplayPrice($rfqData)) {
                                                                        echo CommonHelper::displayMoneyFormat($rfqData['selprod_price'], true, true);
                                                                    }


                                                                    ?></h5>
                                                                <?php if (!empty($selProdOptions)) { ?>
                                                                    <ul class="list--devider">
                                                                        <?php
                                                                        foreach ($selProdOptions as $option) {
                                                                            echo '<li><span>' . $option["option_name"] . ':</span> ' . $option["optionvalue_name"] . '</li>';
                                                                        }
                                                                        ?>
                                                                    </ul>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table--two-cols ">
                                        <tbody>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Product_Qty', $siteLangId); ?> </th>
                                                <td><?php echo $rfqData['rfq_quantity']; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Product_Capacity', $siteLangId); ?></th>
                                                <td><?php echo $rfqData['rfq_capacity']; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Delivery_Duration', $siteLangId); ?></th>
                                                <td><?php echo FatDate::Format($rfqData['rfq_delivery_time'], true); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Comments_for_Seller', $siteLangId); ?></th>
                                                <td><?php echo $rfqData['rfq_comments']; ?></td>
                                            </tr>
                                            <?php if (!empty($attachments) && $rfqData['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) { ?>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Uploaded_documents', $siteLangId); ?></th>
                                                    <td class="uploaded--documents quoted--offer">
                                                        <?php
                                                        $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                        foreach ($attachments as $attachment) {
                                                            $attachmentId = isset($attachment['afile_id'])? $attachment['afile_id'] : 0;
                                                            $ext = pathinfo(isset($attachment['afile_name'])?$attachment['afile_name']:'', PATHINFO_EXTENSION);
															$afileRecordId = isset($attachment["afile_record_id"]) ? $attachment["afile_record_id"] : 0;
                                                            $documentUrl = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$afileRecordId, $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 70, 70]);
                                                            echo "<span id='document-js-" . $attachmentId . "'>";
                                                            if (in_array($ext, $imageType)) {
                                                        ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$afileRecordId, $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                    <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                </a>
                                                            <?php } else { ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$afileRecordId, $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                    <i class="icn rfq-doc-file-icon">
                                                                        <svg class="svg">
                                                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                        <?php
                                                            }
                                                            echo '<p class="doc-title"><span>' . $icon = isset($attachment["afile_name"]) ? $attachment["afile_name"] :'' . '</span></p>';
                                                            echo "</span>";

                                                            /* $icon = '<i class="fa fa-download"></i>';
                                                              $link = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', array($attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER));
                                                              echo '<a target="_blank" href="' . $link . '"><span>' . $attachment["afile_name"] . $icon . '</span></a>'; */
                                                        }
                                                        ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="cards">
                        <div class="cards-content">
                            <div class="box-group">
                                <div class="heading-box"><?php echo Labels::getLabel('LBL_Quoted_Offer_By_Seller', $siteLangId); ?> <small class="note"><?php echo Labels::getLabel('LBL_All_Prices_in', $siteLangId); ?> [<?php echo CommonHelper::getSystemDefaultCurrenyCode(); ?>]</small></div>
                                <div class="box-group__body box-group__body-js">

                                    <?php if (!empty($quotedOfferDetail)) { ?>
                                        <?php if (!empty($servicesList)) { ?>
                                            <h6 class="text-danger"><?php echo Labels::getLabel('LBL_All_Prices_are_including_services_prices', $siteLangId); ?></h6>
                                        <?php } ?>
                                        <table class="table table--two-cols">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Product_Total_Cost', $siteLangId); ?> </th>
                                                    <td><?php echo CommonHelper::displayMoneyFormat($quotedOfferDetail['counter_offer_total_cost'], true, true); ?> <small class="note">(<?php echo Labels::getLabel('LBL_Excluded_Shipping_and_Tax_Charges', $siteLangId); ?>)</small></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Shipping_Cost', $siteLangId); ?></th>
                                                    <td><?php echo CommonHelper::displayMoneyFormat($quotedOfferDetail['counter_offer_shipping_cost'], true, true); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Quote_Valid_for_Days', $siteLangId); ?> </th>
                                                    <td><?php echo $quotedOfferDetail['rfq_quote_validity']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Delivery_Duration', $siteLangId); ?></th>
                                                    <td><?php echo FatDate::Format($quotedOfferDetail['counter_offer_delivery_time'], true); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Comments_for_Buyer', $siteLangId); ?></th>
                                                    <td><?php echo $quotedOfferDetail['counter_offer_comment']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Uploaded_documents', $siteLangId); ?></th>
                                                    <td id="uploaded-documents-js" class="uploaded--documents quoted--offer"></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <?php } else { ?>
                                        <div class="info--order">
                                            <p>
                                                <?php echo Labels::getLabel('LBL_Offer_not_quoted_yet_by_seller', $siteLangId); ?>
                                            </p>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ATTACHED SERVICES LISTING  -->
            <?php if (!empty($servicesList)) { ?>
                <div class="row mb-4" id="offers-listing-js">
                    <div class="col-lg-12">
                        <div class="cards">
                            <div class="cards-content">
                                <div class="box-group">
                                    <div class="heading-box"><?php echo Labels::getLabel('LBL_Attached_Services', $siteLangId); ?></div>
                                    <div class="box-group__body">
                                        <table class="table table--two-cols ">
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Service_Name', $siteLangId); ?> </th>
                                                <th><?php echo Labels::getLabel('LBL_Service_Original_Price', $siteLangId); ?> </th>
                                                <th><?php echo Labels::getLabel('LBL_Service_Qty', $siteLangId); ?> </th>
                                                <th><?php echo Labels::getLabel('LBL_Service_Capacity', $siteLangId); ?></th>
                                                <th><?php echo Labels::getLabel('LBL_Uploaded_documents', $siteLangId); ?></th>
                                            </tr>

                                            <tbody>
                                                <?php
                                                foreach ($servicesList as $service) {
                                                    $attachedDocs = (isset($attachments[$service['rfqattser_selprod_id']])) ? $attachments[$service['rfqattser_selprod_id']] : [];
                                                ?>
                                                    <tr>
                                                        <td><?php echo $service['selprod_title']; ?></td>
                                                        <td><?php
                                                            echo CommonHelper::displayMoneyFormat($service['selprod_price'], true, true);;
                                                            ?></td>
                                                        <td><?php echo $service['rfqattser_quantity']; ?></td>
                                                        <td><?php echo $service['rfqattser_required_capacity']; ?></td>
                                                        <td class="uploaded--documents quoted--offer">
                                                            <?php
                                                            if (!empty($attachedDocs)) {
                                                                $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                                foreach ($attachedDocs as $attachment) {
                                                                    $attachmentId = $attachment['afile_id'];
                                                                    $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                                    $documentUrl = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 70, 70]);
                                                                    echo "<span id='document-js-" . $attachmentId . "'>";
                                                                    if (in_array($ext, $imageType)) {
                                                            ?>
                                                                        <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                            <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                        </a>
                                                                    <?php } else { ?>
                                                                        <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                            <i class="icn rfq-doc-file-icon">
                                                                                <svg class="svg">
                                                                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                            <?php
                                                                    }
                                                                    echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>';
                                                                    echo "</span>";
                                                                }
                                                            }
                                                            ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <!-- ] -->


            <div class="row mb-4" id="offers-listing-js">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <div class="box-group">
                                <div class="heading-box"><?php echo Labels::getLabel('LBL_Offers_listing', $siteLangId); ?></div>
                                <div class="box-group__body">
                                    <?php if (!empty($servicesList)) { ?>
                                        <h6 class="text-danger"><?php echo Labels::getLabel('LBL_All_Prices_are_including_services_prices', $siteLangId); ?></h6>
                                    <?php } ?>
                                    <div id="listing"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row" id="counter-offer-form-section-js" style="display:none">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <div class="box-group">
                                <div class="heading-box"><?php echo Labels::getLabel('LBL_Counter_Offer', $siteLangId); ?></div>
                                <div class="box-group__body">
                                    <div class="col-lg-5">
                                        <div id="counter-offer-form-js"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<script>
    var rfq_id = '<?php echo $rfqData['rfq_id']; ?>';
    offersListing(rfq_id);

    <?php if (!empty($quotedOfferDetail)) { ?>
        getUploadedDocuments(rfq_id);
    <?php } ?>
</script>