<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php if ($reviewsList) { ?>
    <ul class="reviews-list">
        <?php foreach ($reviewsList as $review) { ?>
         	
		<li>
			<div class="reviews-list__head">
				<div class="ratings">
					<span class="ratings__star site-icon site-icon--small">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
							<path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
						</svg>
					</span>
					<span class="ratings__value"><?php echo round($review["shop_rating"], 1); ?></span>
				</div>
				<h5 class="reviews-title"><?php echo $review['spreview_title']; ?></h5>
			</div>

			<div class="reviews-list__desc mb-4">
				<div class="cms">
					<p>
						<span class='lessText'><?php echo CommonHelper::truncateCharacters($review['spreview_description'], 200, '', '', true); ?></span>
						<?php if (strlen($review['spreview_description']) > 200) { ?>
							<span class='moreText hidden'>
								<?php echo nl2br($review['spreview_description']); ?>
							</span>
							<a class="readMore link--arrow" href="javascript:void(0);"> <?php echo Labels::getLabel('Lbl_SHOW_MORE', $siteLangId); ?> </a>
						<?php } ?>
					</p>

				</div>
			</div>

			<div class="reviews-list__footer">
				<div class="row justify-content-between align-items-center">
					<div class="col-sm-8">
						<p class="reviews-author"><?php echo CommonHelper::displayName($review['user_name']).', '.FatDate::format($review['spreview_posted_on']); ?></p>
					</div>
					<div class="col-sm-auto">

						<div class="yes-no">
							<ul>
								<li><a href="javascript:undefined;" onclick='markReviewHelpful(<?php echo FatUtility::int($review['spreview_id']); ?>,1);return false;' class="yes"><img src="<?php echo CONF_WEBROOT_URL; ?>images/thumb-up.png" alt="<?php echo Labels::getLabel('LBL_Helpful', $siteLangId); ?>"> (<?php echo $review['helpful']; ?>) </a></li>
								<li><a href="javascript:undefined;" onclick='markReviewHelpful("<?php echo $review['spreview_id']; ?>",0);return false;' class="no"><img src="<?php echo CONF_WEBROOT_URL; ?>images/thumb-down.png" alt="<?php echo Labels::getLabel('LBL_Not_Helpful', $siteLangId); ?>"> (<?php echo $review['notHelpful']; ?>) </a></li>
							
							</ul>
						</div>

					</div>
				</div>
			</div>
		</li>			
			
        <?php } ?>
    </ul>
<?php
    echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchReviewsPaging'));
} else {
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false);
}
