<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="js-scrollable table-wrap">
    <?php 
    $arr_flds = array(
        'listserial' => 'Sr.',
        'taxcat_name' => Labels::getLabel('LBL_Tax_Category', $siteLangId)
    );
    $tableClass = '';
    if ($activatedTaxServiceId) {
        $arr_flds['taxcat_code'] = Labels::getLabel('LBL_Tax_Code', $siteLangId);
    } else {
        if (0 < count($arr_listing)) {
            $tableClass = "table-justified";
        }
        //$arr_flds['tax_rates'] = Labels::getLabel('LBL_Tax_Rates_FOR_USA', $siteLangId);
    }

    $arr_flds['taxval_value'] = Labels::getLabel('LBL_Tax_rates', $siteLangId);
    $arr_flds['taxval_admin_value'] = Labels::getLabel('LBL_Admin_Tax_rates', $siteLangId);
    $arr_flds['action'] = Labels::getLabel('LBL_Action', $siteLangId);
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table ' . $tableClass));
    $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
    foreach ($arr_flds as $key => $val) {
        /*if ($key == 'taxcat_name') {
            $e = $th->appendElement('th', array('width' => '25%'), $val);
        } else if ($key == 'edit_tax_rates_other_than_USA') {
            $e = $th->appendElement('th', array('width' => '20%'), $val);
        } else {
            $e = $th->appendElement('th', array(), $val);
        }*/
		$e = $th->appendElement('th', array(), $val);
    }

$defaultStringLength = AppConstants::DEFAULT_STRING_LENGTH;
    $sr_no = ($page == 1) ? 0 : ($pageSize * ($page - 1));
    foreach ($arr_listing as $sn => $row) {
        $sr_no++;
        $tr = $tbl->appendElement('tr', array('class' => ''));

        foreach ($arr_flds as $key => $val) {
            $attr = ('taxcat_name' == $key ? ['title' => $row[$key]] : []);
            $td = $tr->appendElement('td', $attr);
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no, true);
                    break;
                case 'taxcat_name':
                    $taxCatName = substr($row[$key], 0, $defaultStringLength);
                    if ($defaultStringLength < strlen($row[$key])) {
                        $taxCatName .= '...';
                    }
                    $td->appendElement('plaintext', array(), $taxCatName . '<br>', true);
                    break;
                case 'tax_rates':
                    $ul = $td->appendElement("ul", array("class" => "actions"), '', true);
                    $li = $ul->appendElement("li");
                    $li->appendElement(
                        'a',
                        array('href' => CommonHelper::generateUrl('Seller', 'taxRules', array($row['taxcat_id'])), 'class' => '', 'title' => Labels::getLabel('LBL_Tax_Rates', $siteLangId)),
                        '<i class="fa fa-eye"></i>',
                        true
                    );
                    break;
                case 'taxval_value':
                    $str = '';
                    $taxIsPercent = 0;
                    if ($row[$key] > 0) {
                        $taxIsPercent = $row['taxval_is_percent'];
                    } else {
                        $row[$key] = '0.00';
                        if (isset($adminRates[$row['taxcat_id']]['taxval_is_percent']) && isset($adminRates[$row['taxcat_id']]['taxval_value'])) {
                            $taxIsPercent = $adminRates[$row['taxcat_id']]['taxval_is_percent'];
                        }
                    }
                    
                     $str = '<span class="item__price--old">' . CommonHelper::displayTaxFormat($taxIsPercent, $row[$key]) . '</span> ';

                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'taxval_admin_value':
                    $str = '';
                    if (isset($adminRates[$row['taxcat_id']]['taxval_is_percent']) && isset($adminRates[$row['taxcat_id']]['taxval_value'])) {
                        $str = CommonHelper::displayTaxFormat($adminRates[$row['taxcat_id']]['taxval_is_percent'], $adminRates[$row['taxcat_id']]['taxval_value']);
                    }
                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'action':
                    $ul = $td->appendElement("ul", array("class" => "actions"), '', true);
                    $li = $ul->appendElement("li");
                    $li->appendElement(
                        'a',
                        array('href'=>'javascript:void(0)', 'class'=>'', 'title'=>Labels::getLabel('LBL_Edit', $siteLangId),"onclick"=>"changeTaxRates(".$row['taxcat_id'].")"),
                        '<i class="fa fa-edit"></i>',
                        true
                    );
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
    }

    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $message = Labels::getLabel('LBL_No_Record_found', $siteLangId);
        $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
    } ?>
</div>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchTaxCatPaging'));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'callBackJsFunc' => 'goToSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
