<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (!$print) {
    $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');
?>
<?php
}
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
?>
<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <?php if (!$print) { ?>
            <div class="content-header row">
                <?php /* <div class="col">
                  <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                  <h2 class="content-header-title">
                  <?php echo Labels::getLabel('LBL_View_Sale_Order', $siteLangId); ?>
                  </h2>
                  </div> */ ?>
                <?php
                $orderObj = new Orders();
                $processingStatuses = $orderObj->getVendorAllowedUpdateOrderStatuses();
                $processingStatuses = array_merge($processingStatuses, (array) FatApp::getConfig("CONF_DEFAULT_PARTIAL_PAID_ORDER_STATUS", FatUtility::VAR_STRING, ''));
                if ($orderDetail['order_is_rfq'] != AppConstants::YES) {
                    unset($processingStatuses[FatApp::getConfig("CONF_DEFAULT_QUALITY_INSPECTION_ORDER_STATUS")]);
                }
                if (in_array($orderDetail['orderstatus_id'], $processingStatuses) && $canEdit) {
                ?>
                    <div class="col-auto">
                        <div class="btn-group">
                            <ul class="actions">
                                <li>
                                    <a href="<?php echo CommonHelper::generateUrl('seller', 'cancelOrder', array($orderDetail['op_id'])); ?>" class="icn-highlighted" title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>">
                                        <i class="fas fa-times"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
                <?php if (!$print) { ?>
                    <div class="col-auto">
                        <div class="">
                            <?php if ($orderDetail['order_is_paid'] == Orders::ORDER_IS_PAID) { ?>
                                <iframe src="<?php echo Fatutility::generateUrl('seller', 'viewOrder', $urlParts) . '/print'; ?>" name="frame" style="display:none"></iframe>
                                <a href="javascript:void(0)" onclick="frames['frame'].print()" class="btn btn--primary btn--sm no-print">
                                    <?php echo Labels::getLabel('LBL_Print', $siteLangId); ?>
                                </a>
                            <?php } else if ($orderDetail['order_is_paid'] == Orders::ORDER_IS_PARTIAL_PAID) { ?>
                                <a href="<?php echo CommonHelper::generateUrl('Invoices', 'previousInvoice', [$orderDetail['order_id']]); ?>" class="btn btn--primary btn--sm no-print">
                                    <?php echo Labels::getLabel('LBL_Previous_Invoice', $siteLangId); ?>
                                </a>
                            <?php } ?>
                            <a href="<?php echo CommonHelper::generateUrl('Seller', 'sales'); ?>" class="btn btn-outline-primary  btn--sm no-print">
                                <?php echo Labels::getLabel('LBL_Back_to_order', $siteLangId); ?>
                            </a>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
        <div class="content-body">
            <div class="cards">
                <div class="cards-content ">
                    <a href="../../controllers/SellerController.php"></a>
                    <table class="table">
                        <thead>
                            <tr>
                                <td>
                                    <?php
                                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, false);
                                    $shopIdentifier = (isset($shopAddress)) ? $shopAddress['shop_identifier'] : $orderDetail['op_shop_name'];
                                    ?>
                                    <div class="info--order">
                                        <h5 class="logo-invoice">
                                            <img style="max-height: 50px;" src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'shopLogo', array($orderDetail['op_shop_id'], $siteLangId, "THUMB", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $shopIdentifier; ?>">
                                            <?php echo '<span>' . $shopIdentifier . '</span>'; ?>
                                        </h5>
                                        <?php
                                        if (!empty($shopAddress)) {
                                            $shopAddressTxt = $shopAddress['shop_name'] . '<br>';
                                            if ($shopAddress['shop_address_line_1'] != '') {
                                                $shopAddressTxt .= $shopAddress['shop_address_line_1'] . '<br>';
                                            }

                                            if ($shopAddress['shop_address_line_2'] != '') {
                                                $shopAddressTxt .= $shopAddress['shop_address_line_2'] . '<br>';
                                            }

                                            if ($shopAddress['shop_city'] != '') {
                                                $shopAddressTxt .= $shopAddress['shop_city'] . ',';
                                            }

                                            if ($shopAddress['state_identifier'] != '') {
                                                $shopAddressTxt .= $shopAddress['state_identifier'] . ', ';
                                            }

                                            if ($shopAddress['shop_postalcode'] != '') {
                                                $shopAddressTxt .= '-' . $shopAddress['shop_postalcode'] . '<br>';
                                            }

                                            if ($shopAddress['country_name'] != '') {
                                                $shopAddressTxt .= $shopAddress['country_name'] . '';
                                            } elseif ($shopAddress['country_code'] != '') {
                                                $shopAddressTxt .= $shopAddress['country_code'] . '';
                                            }

                                            if ($shopAddress['shop_phone'] != '') {
                                                $shopAddressTxt .= '<br>' . $shopAddress['shop_phone'];
                                            }

                                            if (isset($orderDetail['op_shop_owner_email'])) {
                                                $shopAddressTxt .= '<br>' . $orderDetail['op_shop_owner_email'];
                                            }

                                            $shopAddressTxt .= '<br>' . Labels::getLabel('LBL_Shop_URL:', $siteLangId) . ' <a href="' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']]) . '">' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']]) . '</a>';

                                        ?>
                                            <p><?php echo $shopAddressTxt; ?></p>
                                        <?php } ?>
                                    </div>


                                </td>
                                <td>
                                    <div class="info--order ">
                                        <h4 class="info-invioce"><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> </h4>
                                        <p><strong><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>: </strong><?php echo FatDate::format($orderDetail['order_date_added']); ?></p>
                                        <p><strong><?php echo Labels::getLabel('LBL_Invoice', $siteLangId); ?> #: </strong><?php echo $orderDetail['op_invoice_number']; ?></p>

                                        <?php if ($orderDetail['order_is_rfq'] == AppConstants::YES) { ?>
                                            <p><strong><?php echo Labels::getLabel('LBL_Total_Paid', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                                            <p><strong><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>: </strong><?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount'] - $orderDetail['total_paid_amount'], true, false, true, false, true); ?></p>
                                        <?php } ?>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td <?php if ($orderDetail['op_product_type'] == Product::PRODUCT_TYPE_DIGITAL) { ?> colspan="2" <?php } ?>>
                                    <h6 class="invoice-subheading"><?php echo Labels::getLabel('LBL_Billing_Address', $siteLangId); ?></h6> <?php
                                                                                                                                            $billingAddress = $orderDetail['billingAddress']['oua_name'] . '<br>';
                                                                                                                                            if ($orderDetail['billingAddress']['oua_address1'] != '') {
                                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address1'] . '<br>';
                                                                                                                                            }

                                                                                                                                            if ($orderDetail['billingAddress']['oua_address2'] != '') {
                                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_address2'] . '<br>';
                                                                                                                                            }

                                                                                                                                            if ($orderDetail['billingAddress']['oua_city'] != '') {
                                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_city'] . ',';
                                                                                                                                            }

                                                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                                                $billingAddress .= $orderDetail['billingAddress']['oua_state'];
                                                                                                                                            }

                                                                                                                                            if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                                                                                                                $billingAddress .= '-' . $orderDetail['billingAddress']['oua_zip'];
                                                                                                                                            }

                                                                                                                                            if ($orderDetail['billingAddress']['oua_phone'] != '') {
                                                                                                                                                $billingAddress .= '<br>' . $orderDetail['billingAddress']['oua_phone'];
                                                                                                                                            }
                                                                                                                                            ?> <div class="info--order">
                                        <p><?php echo $billingAddress; ?></p>
                                    </div>
                                </td>
                                <?php if ($orderDetail['op_product_type'] != Product::PRODUCT_TYPE_DIGITAL) { ?>
                                    <td>
                                        <h6 class="invoice-subheading"><?php echo Labels::getLabel('LBL_Shipping_Address', $siteLangId); ?></h6> <?php
                                                                                                                                                    $shippingAddress = $orderDetail['shippingAddress']['oua_name'] . '<br>';
                                                                                                                                                    if ($orderDetail['shippingAddress']['oua_address1'] != '') {
                                                                                                                                                        $shippingAddress .= $orderDetail['shippingAddress']['oua_address1'] . '<br>';
                                                                                                                                                    }

                                                                                                                                                    if ($orderDetail['shippingAddress']['oua_address2'] != '') {
                                                                                                                                                        $shippingAddress .= $orderDetail['shippingAddress']['oua_address2'] . '<br>';
                                                                                                                                                    }

                                                                                                                                                    if ($orderDetail['shippingAddress']['oua_city'] != '') {
                                                                                                                                                        $shippingAddress .= $orderDetail['shippingAddress']['oua_city'] . ',';
                                                                                                                                                    }

                                                                                                                                                    if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                                                        $shippingAddress .= $orderDetail['shippingAddress']['oua_state'];
                                                                                                                                                    }

                                                                                                                                                    if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                                                                                                                        $shippingAddress .= '-' . $orderDetail['shippingAddress']['oua_zip'];
                                                                                                                                                    }

                                                                                                                                                    if ($orderDetail['shippingAddress']['oua_phone'] != '') {
                                                                                                                                                        $shippingAddress .= '<br>' . $orderDetail['shippingAddress']['oua_phone'];
                                                                                                                                                    }
                                                                                                                                                    ?>
                                        <div class="info--order">
                                            <p><?php echo $shippingAddress; ?></p>
                                        </div>
                                    </td>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="2">
                                    <!-- PRODUCT DETAILS TABLE -->
                                    <table class="table table-striped invioce-table-bg">
                                        <thead>
                                            <tr class="invoice-tbl-heading">
                                                <?php $columnCount = 7; ?>
                                                <th><?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?></th>
                                                <?php
                                                if (!$print) {
                                                    $columnCount++;
                                                ?>
                                                    <th class="no-print"></th>
                                                <?php } ?>
                                                <th><?php echo Labels::getLabel('LBL_Qty', $siteLangId); ?></th>
                                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                                    <th><?php echo Labels::getLabel('LBL_Price', $siteLangId); ?></th>
                                                <?php } ?>
                                                <th><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId); ?></th>
                                                <th><?php echo Labels::getLabel('LBL_Tax_Charges', $siteLangId); ?></th>
                                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                                    <th style=" width: 190px;"><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId); ?></th>
                                                <?php } ?>

                                                <th><?php echo Labels::getLabel('LBL_Total', $siteLangId); ?></th>
                                                <?php
                                                if (count($servicesRows) > 0) {
                                                    $columnCount++;
                                                ?>
                                                    <th></th>
                                                <?php } ?>
                                            </tr>

                                            <tr class="no-border-row">
                                                <?php if (!$print) { ?>
                                                    <td>
                                                        <div class="pic--cell-left">
                                                            <?php
                                                            $prodOrBatchUrl = 'javascript:void(0)';
                                                            if ($orderDetail['op_is_batch']) {
                                                                $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'batch', array($orderDetail['op_selprod_id']));
                                                                $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'BatchProduct', array($orderDetail['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                            } else {
                                                                if (Product::verifyProductIsValid($orderDetail['op_selprod_id']) == true) {
                                                                    $prodOrBatchUrl = CommonHelper::generateUrl('Products', 'view', array($orderDetail['op_selprod_id']));
                                                                }
                                                                $prodOrBatchImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($orderDetail['selprod_product_id'], "SMALL", $orderDetail['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                            }
                                                            ?>
                                                            <figure class="item__pic">
                                                                <a href="<?php echo $prodOrBatchUrl; ?>">
                                                                    <img src="<?php echo $prodOrBatchImgUrl; ?>" title="<?php echo $orderDetail['op_product_name']; ?>" alt="<?php echo $orderDetail['op_product_name']; ?>">
                                                                </a>
                                                            </figure>
                                                        </div>
                                                    </td>
                                                <?php } ?>
                                                <td>
                                                    <div class="item__description" style="width: 200px;">
                                                        <?php if ($orderDetail['op_selprod_title'] != '') { ?>
                                                            <div class="item__title"><a title="<?php echo $orderDetail['op_selprod_title']; ?>" href="<?php echo $prodOrBatchUrl; ?>"><?php echo $orderDetail['op_selprod_title']; ?></a></div>
                                                            <div class="item__category"><?php echo $orderDetail['op_product_name']; ?></div>
                                                        <?php } else { ?>
                                                            <div class="item__brand"><a title="<?php echo $orderDetail['op_product_name']; ?>" href="<?php echo $prodOrBatchUrl; ?>"><?php echo $orderDetail['op_product_name']; ?>
                                                                </a></div>
                                                        <?php } ?>
                                                        <div class="item__brand"><?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>: <?php echo CommonHelper::displayNotApplicable($siteLangId, $orderDetail['op_brand_name']); ?></div>
                                                        <?php if ($orderDetail['op_selprod_options'] != '') { ?>
                                                            <div class="item__specification"><?php echo $orderDetail['op_selprod_options']; ?></div>
                                                        <?php } ?>
                                                        <?php if ($orderDetail['op_shipping_duration_name'] != '') { ?>
                                                            <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $orderDetail['op_shipping_durations'] . '-' . $orderDetail['op_shipping_duration_name']; ?></div>
                                                    </div>
                                                <?php } ?>
                                                </td>
                                                <td><?php echo $orderDetail['op_qty']; ?></td>
                                                <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                                    <td><?php echo CommonHelper::displayMoneyFormat($orderDetail['op_unit_price'], true, false, true, false, true); ?></td>
                                                <?php } ?>

                                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'shipping'), true, false, true, false, true); ?></td>
                                                <td>
                                                    <?php
                                                    if (empty($orderDetail['taxOptions'])) {
                                                        echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'TAX'), true, false, true, false, true);
                                                    } else {
                                                        foreach ($orderDetail['taxOptions'] as $key => $val) {
                                                    ?>
                                                            <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></p>
                                                    <?php
                                                        }
                                                    }
                                                    ?>
                                                </td>
                                                <?php
                                                $volumeDiscount = CommonHelper::orderProductAmount($orderDetail, 'VOLUME_DISCOUNT');
                                                if ($orderDetail['order_is_rfq'] == AppConstants::NO) {
                                                ?>
                                                    <td><?php echo CommonHelper::displayMoneyFormat($volumeDiscount, true, false, true, false, true); ?></td>
                                                <?php } ?>

                                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'netamount', false, User::USER_TYPE_SELLER), true, false, true, false, true); ?></td>
                                                <?php if (count($servicesRows) > 0) { ?>
                                                    <td></td>
                                                <?php } ?>

                                            </tr>

                                            <?php if (count($servicesRows) > 0) { ?>
                                                <tr class="no-border-row">
                                                    <th colspan="<?php echo $columnCount; ?>"><?php echo Labels::getLabel('LBL_Services', $siteLangId); ?></th>
                                                </tr>
                                                <?php
                                                foreach ($servicesRows as $service) {
                                                    $taxOptionJson = $service['op_product_tax_options'];
                                                    $serviceTaxOptions = json_decode(FatUtility::decodeHtmlEntities($taxOptionJson), true);
                                                    $service['taxOptions'] = $serviceTaxOptions;
                                                    $serviceImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($service['op_selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                ?>
                                                    <tr class="no-border-row">
                                                        <?php if (!$print) { ?>
                                                            <td>
                                                                <div class="pic--cell-left">
                                                                    <figure class="item__pic">
                                                                        <a href="<?php echo CommonHelper::generateUrl('Products', 'view', array($service['op_selprod_id'])); ?>">
                                                                            <img src="<?php echo $serviceImgUrl; ?>" title="<?php echo $service['op_selprod_title']; ?>" alt="<?php echo $service['op_selprod_title']; ?>">
                                                                        </a>
                                                                    </figure>
                                                                </div>
                                                            </td>
                                                        <?php } ?>

                                                        <td>
                                                            <div class="item__description">
                                                                <?php if ($service['op_selprod_title'] != '') { ?>
                                                                    <div class="item__title">
                                                                        <a title="<?php echo $service['op_selprod_title']; ?>" href="<?php echo CommonHelper::generateUrl('Products', 'view', array($service['op_selprod_id'])); ?>">
                                                                            <?php echo $service['op_selprod_title']; ?>
                                                                        </a>
                                                                    </div>
                                                                    <div class="item__category">
                                                                        <?php echo $service['op_product_name']; ?>
                                                                    </div>
                                                                <?php } ?>
                                                                <?php if ($service['op_shipping_duration_name'] != '') { ?>
                                                                    <div class="item__shipping"><?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>: <?php echo $service['op_shipping_durations'] . '-' . $service['op_shipping_duration_name']; ?></div>
                                                                <?php } ?>
                                                            </div>
                                                        </td>
                                                        <td><?php echo $service["op_qty"] ?></td>
                                                        <td><?php echo CommonHelper::displayMoneyFormat($service["op_unit_price"], true, true); ?></td>
                                                        <td>
                                                            <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'SHIPPING'), true, true); ?>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            if (empty($service['taxOptions'])) {
                                                                echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'TAX'), true, true);
                                                            } else {
                                                                foreach ($service['taxOptions'] as $key => $val) {
                                                            ?>
                                                                    <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($val['value']); ?></p>
                                                            <?php
                                                                }
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'VOLUME_DISCOUNT'), true, true); ?>
                                                        </td>
                                                        <td>
                                                            <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'netamount', false, User::USER_TYPE_SELLER), true, true); ?>
                                                        </td>
                                                        <td>
                                                            <?php if (!$print) { ?>
                                                                <ul class="actions">
                                                                    <li>
                                                                        <a href="<?php echo CommonHelper::generateUrl('seller', 'viewOrder', [$service['op_id']]) ?>" class="" title="<?php echo Labels::getLabel('LBL_View_Details', $siteLangId); ?>">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                    <?php if (!in_array($service['op_status_id'], $cancellationNotAllowedStatues)) { ?>
                                                                        <li>
                                                                            <a href="<?php echo CommonHelper::generateUrl('seller', 'cancelOrder', [$service['op_id']]) ?>" class="" title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>">
                                                                                <i class="fas fa-times"></i>
                                                                            </a>
                                                                        </li>
                                                                    <?php } ?>
                                                                </ul>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            <?php } ?>

                                            <!--  [ RFQ PRODUCT SERVICES -->
                                            <?php
                                            if (!empty($rfqServices)) {
                                                foreach ($rfqServices as $service) {
                                                    $serviceAttachment = (isset($attachments[$service['rfqattser_selprod_id']])) ? $attachments[$service['rfqattser_selprod_id']] : [];
                                            ?>
                                                    <tr>
                                                        <?php if (!$print) { ?>
                                                            <td class="no-print">
                                                                <div class="pic--cell-left"> <?php
                                                                                                $serviceUrl = CommonHelper::generateUrl('Products', 'view', array($service['rfqattser_selprod_id']));
                                                                                                $serviceImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($service['rfqattser_selprod_id'], "SMALL", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                                                ?>
                                                                    <figure class="item__pic"><a href="<?php echo $serviceUrl; ?>"><img src="<?php echo $serviceImgUrl; ?>" title="<?php echo $service['selprod_title']; ?>" alt="<?php echo $service['selprod_title']; ?>"></a></figure>
                                                                </div>
                                                            </td>
                                                        <?php } ?>
                                                        <a href="../../controllers/InvoicesController.php"></a>
                                                        <td>
                                                            <div class="item__title">
                                                                <a title="<?php echo $service['selprod_title']; ?>" href="<?php echo $serviceUrl; ?>"><?php echo $service['selprod_title']; ?></a>
                                                            </div>
                                                            <?php if (!empty($serviceAttachment) && !$print) { ?>
                                                                <div class="pic--cell-left">
                                                                    <ul class="order-service-docs">
                                                                        <?php
                                                                        $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                                        foreach ($serviceAttachment as $attachment) {
                                                                            $attachmentId = $attachment['afile_id'];
                                                                            $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                                            $documentUrl = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 50, 50]);
                                                                            echo "<li><span id='document-js-" . $attachmentId . "'>";
                                                                            if (in_array($ext, $imageType)) {
                                                                        ?>
                                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                                    <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                                </a>
                                                                            <?php } else { ?>
                                                                                <a href="<?php echo CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                                    <i class="icn rfq-doc-file-icon">
                                                                                        <svg class="svg">
                                                                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                                        </svg>
                                                                                    </i>
                                                                                </a>
                                                                        <?php
                                                                            }
                                                                            //echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>';
                                                                            echo "</span></li>";
                                                                            /* $icon = '<i class="fa fa-download"></i>';
                                                                      $link = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', array($attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER));
                                                                      echo '<a target="_blank" href="' . $link . '"><span>' . $attachment["afile_name"] . $icon . '</span></a>'; */
                                                                        }
                                                                        ?>
                                                                    </ul>
                                                                </div>
                                                            <?php
                                                            }
                                                            ?>

                                                        </td>
                                                        <td><?php echo $service['rfqattser_quantity'] ?></td>
                                                        <td><i class="fa fa-minus"></i></td>
                                                        <td><i class="fa fa-minus"></i></td>
                                                        <td><i class="fa fa-minus"></i></td>
                                                    </tr>
                                            <?php
                                                }
                                            }
                                            ?>
                                            <!-- ]-->


                                        </thead>
                                    </table>
                                    <!-- ] -->
                                </td>
                            </tr>
                            <?php ?>
                            <tr>
                                <td></td>
                                <td>
                                    <p>
                                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('Lbl_Cart_Total', $siteLangId) ?> : </strong></span>
                                        <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'CART_TOTAL'), true, false, true, false, true); ?> </span>
                                    </p>
                                    <p>
                                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId) ?> : </strong></span>
                                        <span class="invoice-amount-txt"> <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'SHIPPING'), true, false, true, false, true); ?> </span>
                                    </p>

                                    <?php if ($orderDetail['op_tax_collected_by_seller']) { ?>
                                        <?php if (empty($orderDetail['taxOptions'])) { ?>
                                            <p>
                                                <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Tax', $siteLangId); ?>:</strong></span>
                                                <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'TAX'), true, false, true, false, true); ?> </span>
                                            </p>
                                            <?php
                                        } else {
                                            foreach ($orderDetail['taxOptions'] as $key => $val) {
                                            ?>
                                                <p>
                                                    <span class="invoice-amount-txt"><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong></span>
                                                    <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true); ?></span>
                                                </p>
                                        <?php
                                            }
                                        }
                                        ?>
                                    <?php } ?>
                                    <?php if ($orderDetail['order_is_rfq'] == AppConstants::NO) { ?>
                                        <?php if ($orderDetail['order_discount_total']) { ?>
                                            <p>
                                                <span class="invoice-amount-txt">
                                                    <strong><?php echo Labels::getLabel('LBL_Discount', $siteLangId) ?> : </strong>
                                                </span>
                                                <span class="invoice-amount-txt">
                                                    -<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_discount_total'], true, false, true, false, true); ?>
                                                </span>
                                            </p>
                                        <?php } ?>
                                        <?php if ($orderDetail['order_volume_discount_total']) { ?>
                                            <p>
                                                <span class="invoice-amount-txt">
                                                    <strong><?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId) ?> : </strong>
                                                </span>
                                                <span class="invoice-amount-txt">
                                                    -<?php echo CommonHelper::displayMoneyFormat($orderDetail['order_volume_discount_total'], true, false, true, false, true); ?>
                                                </span>
                                            </p>
                                        <?php } ?>
                                    <?php } ?>
                                    <p>
                                        <span class="invoice-amount-txt"><strong><?php echo Labels::getLabel('LBL_Total', $siteLangId) ?> : </strong></span>
                                        <span class="invoice-amount-txt"><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'netamount', false, User::USER_TYPE_SELLER), true, false, true, false, true); ?></span>
                                    </p>
                                </td>
                            </tr>
                            <?php /* } */ ?>
                        </tbody>
                    </table>
                    <h6 class="text-right m-2"><?php echo Labels::getLabel('LBL_Thank_You_For_Your_Business!', $siteLangId) ?></h6>

                    <!-- [ SERVICE DOCUMENTS LISTING SECTION -->
                    <?php if (!empty($service_documents && !$print)) { ?>
                        <span class="gap"></span>
                        <div class="uploaded--documents">
                            <h6><?php echo Labels::getLabel('LBL_Service_Documents', $siteLangId); ?></h6>
                            <?php
                            foreach ($service_documents as $document) {
                                $attachmentId = $document['afile_id'];
                                $ext = pathinfo($document['afile_name'], PATHINFO_EXTENSION);
                                $documentUrl = CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type'], true, 70, 70]);
                            ?>
                                <span id="document-js-<?php echo $document['afile_id'] ?>">
                                    <?php if (in_array($ext, $imageType)) {
                                    ?>
                                        <a href="<?php echo CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <img src="<?php echo $documentUrl; ?>" alt="<?php echo $document['afile_name']; ?>" title="<?php echo $document['afile_name']; ?>" />
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <i class="icn rfq-doc-file-icon">
                                                <svg class="svg">
                                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                </svg>
                                            </i>
                                        </a>
                                    <?php
                                    }
                                    echo '<p class="doc-title"><a href="' . CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']]) . '"><span>' . $document["afile_name"] . '</a></span></p>';
                                    ?>
                                </span>
                            <?php } ?>
                        </div>
                        <span class="gap"></span>
                        <span class="gap"></span>
                    <?php } ?>
                    <!-- ] -->
                    <!-- [ QUALITY CERTIFICATE LISTING SECTION -->
                    <?php if (!empty($quality_certificates && !$print)) { ?>
                        <span class="gap"></span>
                        <div class="uploaded--documents">
                            <h6><?php echo Labels::getLabel('LBL_Quality_Certificates', $siteLangId); ?></h6>
                            <?php
                            foreach ($quality_certificates as $certificate) {
                                $attachmentId = $certificate['afile_id'];
                                $ext = pathinfo($certificate['afile_name'], PATHINFO_EXTENSION);
                                $documentUrl = CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type'], true, 70, 70]);
                            ?>
                                <span id="document-js-<?php echo $certificate['afile_id'] ?>">
                                    <?php if (in_array($ext, $imageType)) {
                                    ?>
                                        <a href="<?php echo CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <img src="<?php echo $documentUrl; ?>" alt="<?php echo $certificate['afile_name']; ?>" title="<?php echo $certificate['afile_name']; ?>" />
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo CommonHelper::generateUrl('seller', 'downloadOrderDocument', [$certificate["afile_record_id"], $certificate["afile_id"], $certificate['afile_type']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <i class="icn rfq-doc-file-icon">
                                                <svg class="svg">
                                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                </svg>
                                            </i>
                                        </a>
                                    <?php
                                    }
                                    $btnHtml = "";
                                    if ($orderDetail['op_status_id'] == FatApp::getConfig("CONF_DEFAULT_QUALITY_INSPECTION_ORDER_STATUS")) {
                                        $btnHtml = '<i class="fa fa-trash" onclick="removeQualityDocument(' . $certificate['afile_id'] . ',' . $certificate['afile_record_id'] . ')"></i>';
                                    }
                                    echo '<p class="doc-title"><span>' . $certificate["afile_name"] . '</span>' . $btnHtml . '</p>';
                                    ?>
                                </span>
                            <?php } ?>
                        </div>
                        <span class="gap"></span>
                        <span class="gap"></span>
                    <?php } ?>
                    <!-- ] -->
                    <?php if (!empty($paymentHistory) && !$print) { ?>
                        <div class="gap"></div>
                        <p><strong><?php echo Labels::getLabel('LBL_Invoices_Details', $siteLangId); ?></strong></p>
                        <div class="section--repeated no-print">
                            <table class="table invoice-product">
                                <thead>
                                    <tr>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Amount', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Payment_Date', $siteLangId); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($paymentHistory as $phistory) { ?>
                                        <tr>
                                            <td><?php echo $phistory['opayment_method']; ?></td>
                                            <td>
                                                <?php echo CommonHelper::displayMoneyFormat($phistory['opayment_amount'], true, false, true, false, true); ?>
                                            </td>
                                            <td><?php echo FatDate::format($phistory['opayment_date'], true); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="gap"></div>
                    <?php } ?>
                    <?php if ($canEdit && $displayForm && !$print) { ?>
                        <div class="section--repeated no-print">
                            <h5><?php echo Labels::getLabel('LBL_Comments_on_order', $siteLangId); ?></h5>
                            <?php
                            $frm->setFormTagAttribute('onsubmit', 'updateStatus(); return(false);');
                            $frm->setFormTagAttribute('class', 'form');
                            $frm->developerTags['colClassPrefix'] = 'col-md-';
                            $frm->developerTags['fld_default_col'] = 12;

                            $fld = $frm->getField('op_status_id');
                            $fld->developerTags['col'] = 6;

                            $fld1 = $frm->getField('customer_notified');
                            $fld1->developerTags['col'] = 6;

                            $fldTracking = $frm->getField('tracking_number');
                            $fldTracking->setWrapperAttribute('class', 'div_tracking_number');
                            $fldTracking->developerTags['col'] = 6;


                            $fldQc = $frm->getField('quality_certificate');
                            $fldQc->developerTags['col'] = 6;
                            $fldQc->setWrapperAttribute('class', 'quality_certificate--js');
                            /* $fldQc->setFieldTagAttribute('onChange', 'updateStatus()'); */

                            $fldBtn = $fldTracking = $frm->getField('btn_submit');
                            $fldBtn->developerTags['col'] = 6;
                            echo $frm->getFormHtml();
                            ?>
                        </div>
                    <?php } ?>
                    <span class="gap"></span>
                    <?php if (!empty($orderDetail['comments']) && !$print) { ?>
                        <div class="section--repeated no-print">
                            <h5><?php echo Labels::getLabel('LBL_Posted_Comments', $siteLangId); ?></h5>
                            <table class="table  table--orders">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Date_Added', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Customer_Notified', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Status', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Comments', $siteLangId); ?></th>
                                    </tr>
                                    <?php foreach ($orderDetail['comments'] as $row) { ?>
                                        <tr>
                                            <td><?php echo FatDate::format($row['oshistory_date_added'], true); ?></td>
                                            <td><?php echo $yesNoArr[$row['oshistory_customer_notified']]; ?></td>
                                            <td><?php
                                                echo $orderStatuses[$row['oshistory_orderstatus_id']];
                                                echo ($row['oshistory_tracking_number']) ? ': ' . Labels::getLabel('LBL_Tracking_Number', $siteLangId) . ' ' . $row['oshistory_tracking_number'] . " VIA <em>" . $row['op_shipping_duration_name'] . "</em>" : ''
                                                ?>
                                            </td>
                                            <td><?php echo !empty($row['oshistory_comments']) ? nl2br($row['oshistory_comments']) : Labels::getLabel('LBL_N/A', $siteLangId); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    <?php } ?>
                    <span class="gap"></span>
                    <?php if (!empty($digitalDownloads)) { ?>
                        <div class="section--repeated">
                            <h5><?php echo Labels::getLabel('LBL_Downloads', $siteLangId); ?></h5>
                            <table class="table  table--orders">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Sr_No', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_File', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Language', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Download_times', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Downloaded_count', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Expired_on', $siteLangId); ?></th>
                                        <?php if ($canEdit) { ?>
                                            <th></th>
                                        <?php } ?>
                                    </tr>
                                    <?php
                                    $sr_no = 1;
                                    foreach ($digitalDownloads as $key => $row) {
                                        $lang_name = Labels::getLabel('LBL_All', $siteLangId);
                                        if ($row['afile_lang_id'] > 0) {
                                            $lang_name = $languages[$row['afile_lang_id']];
                                        }

                                        $fileName = '<a href="' . CommonHelper::generateUrl('Seller', 'downloadDigitalFile', array($row['afile_id'], $row['afile_record_id'], AttachedFile::FILETYPE_ORDER_PRODUCT_DIGITAL_DOWNLOAD)) . '">' . $row['afile_name'] . '</a>';
                                        $downloads = '<li><a href="' . CommonHelper::generateUrl('Seller', 'downloadDigitalFile', array($row['afile_id'], $row['afile_record_id'], AttachedFile::FILETYPE_ORDER_PRODUCT_DIGITAL_DOWNLOAD)) . '"><i class="fa fa-download"></i></a></li>';

                                        $expiry = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if ($row['expiry_date'] != '') {
                                            $expiry = FatDate::Format($row['expiry_date']);
                                        }

                                        $downloadableCount = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if ($row['downloadable_count'] != -1) {
                                            $downloadableCount = $row['downloadable_count'];
                                        }
                                    ?>
                                        <tr>
                                            <td><?php echo $sr_no; ?></td>
                                            <td><?php echo $fileName; ?></td>
                                            <td><?php echo $lang_name; ?></td>
                                            <td><?php echo $downloadableCount; ?></td>
                                            <td><?php echo $row['afile_downloaded_times']; ?></td>
                                            <td><?php echo $expiry; ?></td>
                                            <td>
                                                <ul class="actions"><?php echo ($canEdit) ? $downloads : ''; ?></ul>
                                            </td>
                                        </tr>
                                    <?php
                                        $sr_no++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    <?php } ?>

                    <span class="gap"></span>
                    <?php if (!empty($digitalDownloadLinks)) { ?>
                        <div class="section--repeated">
                            <h5><?php echo Labels::getLabel('LBL_Downloads', $siteLangId); ?></h5>
                            <table class="table  table--orders">
                                <tbody>
                                    <tr class="">
                                        <th><?php echo Labels::getLabel('LBL_Sr_No', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Link', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Download_times', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Downloaded_count', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Expired_on', $siteLangId); ?></th>
                                    </tr>
                                    <?php
                                    $sr_no = 1;
                                    foreach ($digitalDownloadLinks as $key => $row) {
                                        /* $fileName = '<a href="'.CommonHelper::generateUrl('Seller','downloadDigitalFile',array($row['afile_id'],$row['afile_record_id'],AttachedFile::FILETYPE_ORDER_PRODUCT_DIGITAL_DOWNLOAD)).'">'.$row['afile_name'].'</a>'; */
                                        /* $downloads = '<li><a href="'.CommonHelper::generateUrl('Seller','downloadDigitalFile',array($row['afile_id'],$row['afile_record_id'],AttachedFile::FILETYPE_ORDER_PRODUCT_DIGITAL_DOWNLOAD)).'"><i class="fa fa-download"></i></a></li>'; */

                                        $expiry = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if ($row['expiry_date'] != '') {
                                            $expiry = FatDate::Format($row['expiry_date']);
                                        }

                                        $downloadableCount = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if ($row['downloadable_count'] != -1) {
                                            $downloadableCount = $row['downloadable_count'];
                                        }
                                    ?>
                                        <tr>
                                            <td><?php echo $sr_no; ?></td>
                                            <td><a target="_blank" href="<?php echo $row['opddl_downloadable_link']; ?>" title="<?php echo Labels::getLabel('LBL_Click_to_download', $siteLangId); ?>"><?php echo $row['opddl_downloadable_link']; ?></a></td>
                                            <td><?php echo $downloadableCount; ?></td>
                                            <td><?php echo $row['opddl_downloaded_times']; ?></td>
                                            <td><?php echo $expiry; ?></td>
                                        </tr>
                                    <?php
                                        $sr_no++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php if ($print) { ?>
    <script>
        $(".sidebar-is-expanded").addClass('sidebar-is-reduced').removeClass('sidebar-is-expanded');
        /*window.print();
         window.onafterprint = function() {
         location.href = history.back();
         }*/
    </script>
<?php } ?>
<style>
    .no-border-row th,
    .no-border-row td {
        border: 0px;
    }

    .uploaded--documents a {
        color: #000;
    }

    .table th {
        width: 175px;
        max-width: 100%
    }

    .invoice-product tr {
        border-left: 1px solid #ddd;
        border-right: 1px solid #ddd;
    }

    .invoice-product tr:first-child {
        border-top: 1px solid #ddd;
    }

    .invoice-product.table tr:last-child td {
        border-bottom: 1px solid #dee2e6 !important;
    }

    @media print {
        .invoice-tbl-heading th {
            background-color: var(--brand-color) !important;
            color: #fff;
            padding: 5px;
        }

        .odd-row-td {
            background-color: var(--brand-color) !important;
            color: #fff;
            padding: 5px;
        }
    }
</style>
<?php if ($orderDetail['op_status_id'] != FatApp::getConfig("CONF_DEFAULT_QUALITY_INSPECTION_ORDER_STATUS")) { ?>
    <script>
        $(document).ready(function() {
            $(".quality_certificate--js").hide();
        });
    </script>
<?php } ?>