<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$form->setFormTagAttribute('onsubmit', 'setupService(this); return(false);');

$form->setFormTagAttribute('class', 'form');
$form->developerTags['colClassPrefix'] = 'col-md-';
$form->developerTags['fld_default_col'] = 6;

$autoUpdateFld = $form->getField('auto_update_other_langs_data');
$autoUpdateFld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
$autoUpdateFld->developerTags['cbHtmlAfterCheckbox'] = '<i class="input-helper"></i>';

$btnDiscardFld = $form->getField('btn_discard');
$btnDiscardFld->addFieldTagAttribute('onClick', 'servicesList();');
$btnDiscardFld->value = Labels::getLabel('LBL_Discard', $siteLangId);

$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');
?>
<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <div class="content-header row">
            <div class="col">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-title"><?php echo Labels::getLabel('LBL_Service_Setup', $siteLangId); ?></h2>
            </div>
            <div class="col-auto">
                <div class="btn-group">
                    <a class="btn btn-outline-primary btn--sm" title="<?php echo Labels::getLabel('LBL_Back_to_Services', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Services'); ?>"><?php echo Labels::getLabel('LBL_Back_to_Services', $siteLangId); ?></a>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="tabs">
                <ul class="tabs_nav-js">
                    <li class="is-active">
                        <a class="tabs_001" rel="tabs_001" href="javascript:void(0)">
                            <?php echo Labels::getLabel('LBL_Initial_Setup', $siteLangId); ?> <i class="tabs-icon fa fa-info-circle" data-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Setup_Basic_Details', $siteLangId); ?>">
                            </i>
                        </a>
                    </li>
                    <li>
                        <a rel="tabs_002" <?php if ($serviceId > 0) { ?> class="tabs_002" <?php } ?> href="javascript:void(0)">
                            <?php echo Labels::getLabel('LBL_Media', $siteLangId); ?>
                            <i class="tabs-icon fa fa-info-circle" data-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Add_Media', $siteLangId); ?>"></i>
                        </a>
                    </li>
                    <?php /* if ($serviceId > 0) { */ ?>
                    <li class="shipping-tab--js <?php echo ($isShippingRequired == AppConstants::YES && $serviceId > 0) ? "" : "hide-tab--js"; ?>">
                        <a rel="tabs_003" class="<?php echo ($serviceId > 0) ? "tabs_003" : ""; ?>" href="javascript:void(0)">
                            <?php echo Labels::getLabel('LBL_Shipping_Information', $siteLangId); ?>
                            <i class="tabs-icon fa fa-info-circle" data-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Shipping_Information', $siteLangId); ?>"></i>
                        </a>
                    </li>
                    <?php /* } */ ?>
                </ul>
            </div>
            <div class="cards">
                <div class="cards-content">
                    <div class="tabs__content">
                        <div id="tabs_001" class="tabs_panel" style="display: block;">
                            <div class="row justify-content-center">
                                <div class="col-md-12">
                                    <?php echo $form->getFormTag(); ?>

                                    <?php $divLayout = Language::getLayoutDirection($siteDefaultLangId); ?>
                                    <div class="p-4 mb-4" dir="<?php echo $divLayout; ?>">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="field-set">
                                                    <div class="caption-wraper">
                                                        <label class="field_label">
                                                            <?php
                                                            $fld = $form->getField('service_title[' . $siteDefaultLangId . ']');
                                                            echo $fld->getCaption();
                                                            ?>
                                                            <span class="spn_must_field">*</span>
                                                        </label>
                                                    </div>
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php echo $form->getFieldHtml('service_title[' . $siteDefaultLangId . ']'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="field-set">
                                                    <div class="caption-wraper">
                                                        <label class="field_label">
                                                            <?php
                                                            $fld = $form->getField('service_price');
                                                            echo $fld->getCaption();
                                                            ?>
                                                        </label>
                                                        <span class="spn_must_field">*</span>
                                                    </div>
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php echo $form->getFieldHtml('service_price'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="field-set">
                                                    <div class="caption-wraper">
                                                        <label class="field_label">
                                                            <?php
                                                            $fld = $form->getField('category_name');
                                                            echo $fld->getCaption();
                                                            ?>
                                                        </label>
                                                        <span class="spn_must_field">*</span>
                                                    </div>
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php echo $form->getFieldHtml('category_name'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="field-set">
                                                    <div class="caption-wraper">
                                                        <label class="field_label">
                                                            <?php
                                                            $fld = $form->getField('ptt_taxcat_id');
                                                            echo $fld->getCaption();
                                                            ?>
                                                        </label>
                                                        <span class="spn_must_field">*</span>
                                                    </div>
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php echo $form->getFieldHtml('ptt_taxcat_id'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="field-set">
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php
                                                            $fld = $form->getField('is_shipping_required');
                                                            $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
                                                            $fld->developerTags['cbHtmlAfterCheckbox'] = '<i class="input-helper"></i>';
                                                            ?>

                                                            <?php echo $form->getFieldHtml('is_shipping_required'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="field-set">
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php
                                                            $fld = $form->getField('is_document_required');
                                                            $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
                                                            $fld->developerTags['cbHtmlAfterCheckbox'] = '<i class="input-helper"></i>';
                                                            ?>

                                                            <?php echo $form->getFieldHtml('is_document_required'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="field-set mb-0">
                                                    <div class="caption-wraper">
                                                        <label class="field_label">
                                                            <?php
                                                            $fld = $form->getField('service_description_' . $siteDefaultLangId);
                                                            echo $fld->getCaption();
                                                            ?>
                                                        </label>
                                                    </div>
                                                    <div class="field-wraper">
                                                        <div class="field_cover">
                                                            <?php echo $form->getFieldHtml('service_description_' . $siteDefaultLangId); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                                        if (!empty($translatorSubscriptionKey) && count($otherLanguages) > 0) {
                                        ?>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="field-set mb-0">
                                                        <div class="caption-wraper"></div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover">
                                                                <?php echo $form->getFieldHtml('auto_update_other_langs_data'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>

                                    <?php
                                    if (!empty($otherLanguages)) {
                                        $editorIndex = 1;
                                        foreach ($otherLanguages as $langId => $data) {
                                            $layout = Language::getLayoutDirection($langId);
                                    ?>
                                            <div class="accordion my-4" id="specification-accordion-<?php echo $langId; ?>">
                                                <h6 class="dropdown-toggle" data-toggle="collapse" data-target="#collapse-<?php echo $langId; ?>" aria-expanded="true" aria-controls="collapse-<?php echo $langId; ?>" onclick="translateData(this, '<?php echo $siteDefaultLangId; ?>', '<?php echo $langId; ?>', '<?php echo $editorIndex; ?>')">
                                                    <span>
                                                        <?php echo $data . " " . Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                                                    </span>
                                                </h6>
                                                <div id="collapse-<?php echo $langId; ?>" class="collapse collapse-js-<?php echo $langId; ?>" aria-labelledby="headingOne" data-parent="#specification-accordion-<?php echo $langId; ?>">
                                                    <div class="p-4 mb-4 bg-gray rounded" dir="<?php echo $layout; ?>">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="field-set">
                                                                    <div class="caption-wraper">
                                                                        <label class="field_label">
                                                                            <?php
                                                                            $fld = $form->getField('service_title[' . $langId . ']');
                                                                            echo $fld->getCaption();
                                                                            ?>
                                                                        </label>
                                                                    </div>
                                                                    <div class="field-wraper">
                                                                        <div class="field_cover">
                                                                            <?php echo $form->getFieldHtml('service_title[' . $langId . ']'); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="field-set mb-0">
                                                                    <div class="caption-wraper">
                                                                        <label class="field_label">
                                                                            <?php
                                                                            $fld = $form->getField('service_description_' . $langId);
                                                                            echo $fld->getCaption();
                                                                            ?>
                                                                        </label>
                                                                    </div>
                                                                    <div class="field-wraper">
                                                                        <div class="field_cover">
                                                                            <?php echo $form->getFieldHtml('service_description_' . $langId); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                    <?php
                                            $editorIndex++;
                                        }
                                    }
                                    ?>

                                    <div class="row">
                                        <div class="col-6">
                                            <div class="field-set">
                                                <div class="caption-wraper"><label class="field_label"></label></div>
                                                <div class="field-wraper">
                                                    <div class="field_cover">
                                                        <?php echo $form->getFieldHtml('btn_discard'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 text-right">
                                            <div class="field-set">
                                                <div class="caption-wraper"><label class="field_label"></label></div>
                                                <div class="field-wraper">
                                                    <div class="field_cover">
                                                        <?php
                                                        echo $form->getFieldHtml('service_id');
                                                        echo $form->getFieldHtml('ptc_prodcat_id');
                                                        echo $form->getFieldHtml('btn_submit');
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </form>
                                    <?php echo $form->getExternalJS(); ?>
                                </div>
                            </div>
                        </div>
                        <div id="tabs_002" class="tabs_panel" style="display: none;">
                            <div id="media-form-js"></div>
                            <div id="media-listing-js"></div>
                        </div>

                        <div id="tabs_003" class="tabs_panel" style="display: none;">
                            <div id="shipping-form-js"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<script type="text/javascript">
    function servicesList() {
        window.location = fcom.makeUrl('Services');
    }

    function setupService(frm) {
        let getFrm = $('#serviceForm')[0];
        let validator = $(getFrm).validation({
            errordisplay: 3
        });
        validator.validate();
        if (!validator.isValid())
            return;
        var serviceId = $('input[name = "service_id"]').val();
        let data = fcom.frmData(getFrm);
        $('input[name="btn_submit"]').attr('disabled', 'disabled');
        fcom.ajax(fcom.makeUrl('Services', 'setup'), data, function(t) {
            let ans = JSON.parse(t);
            if (ans.status == 1) {
                $.mbsmessage(ans.msg, true, 'alert--success');
                /* location.href = fcom.makeUrl('Services', 'form', [t.service_id]); */
                if (serviceId == 0) {
                    /* location.href = fcom.makeUrl('Services', 'form', [ans.service_id]); */
                    $('input[name = "service_id"]').val(ans.service_id);
                    $('a[rel="tabs_002"]').addClass('tabs_002');
                    $('a[rel="tabs_003"]').addClass('tabs_003');
                    window.history.pushState({}, '', fcom.makeUrl('Services', 'form', [ans.service_id]));
                }
                $('.tabs_002').trigger('click');
                return;
            }
            $.mbsmessage(ans.msg, true, 'alert--danger');
            $('input[name="btn_submit"]').removeAttr('disabled');
        });
    }

    function mediaListing() {
        let service_id = $('input[name="service_id"]').val();
        fcom.ajax(fcom.makeUrl('Services', 'mediaListing'), 'service_id=' + service_id, function(res) {
            $('#media-listing-js').html(res);
        });
    }

    $(document).on('click', '.tabs_001', function() {
        $(".tabs_nav-js  > li").removeClass('is-active');
        $("a[rel='tabs_001']").parent().addClass('is-active');
        $('#tabs_002').hide();
        $('#tabs_001').show();
        $('#tabs_003').hide();
    });

    $(document).on('click', '.tabs_002', function() {
        $(".tabs_nav-js  > li").removeClass('is-active');
        $("a[rel='tabs_002']").parent().addClass('is-active');
        fcom.ajax(fcom.makeUrl('Services', 'mediaForm'), [], function(res) {
            $('#media-form-js').html(res);
            mediaListing();
        });
        $('#tabs_001').hide();
        $('#tabs_002').show();
        $('#tabs_003').hide();
    });

    $(document).on('click', '.tabs_003', function() {
        $(".tabs_nav-js  > li").removeClass('is-active');
        var serviceId = $('input[name = "service_id"]').val();
        $("a[rel='tabs_003']").parent().addClass('is-active');
        loadShippingDetailsSection(serviceId);
        $('#tabs_001').hide();
        $('#tabs_002').hide();
        $('#tabs_003').show();
    });


    function deleteImage(serviceId, image_id) {
        let agree = confirm(langLbl.confirmDelete);
        if (!agree) {
            return false;
        }
        fcom.ajax(fcom.makeUrl('Services', 'deleteImage', [serviceId, image_id]), '', function(t) {
            let ans = $.parseJSON(t);
            $.mbsmessage(ans.msg, true, 'alert--success');
            if (ans.status == 0) {
                return;
            }
            mediaListing();
        });
    }
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $('input[name=\'category_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $('input[name=\'ptc_prodcat_id\']').val(0);
                $.ajax({
                    url: fcom.makeUrl('Services', 'linksAutocomplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            select: function(event, ui) {
                $('input[name=\'ptc_prodcat_id\']').val(ui.item.id);
            }
        });

        $('input[name=\'category_name\']').change(function() {
            if ($(this).val() == '') {
                $("input[name='ptc_prodcat_id']").val(0);
            }
        });

        $('input[name="is_shipping_required"]').on('change', function() {
            if ($(this).prop('checked') == true) {
                $('.shipping-tab--js').removeClass('hide-tab--js');
            } else {
                $('.shipping-tab--js').addClass('hide-tab--js');
            }
        });

    });
</script>
<style>
    table {
        width: 100%;
    }

    .hide-tab--js {
        display: none !important;
    }
</style>