(function () {
    var runningAjaxReq = false;
    loadShippingDetailsSection = function (serviceId) {
        fcom.ajax(fcom.makeUrl('Services', 'shippingForm', [serviceId]), [], function (res) {
            $('#shipping-form-js').html(res);
        });
    };

    addShippingTab = function (id, type) {
        ShipDiv = "#tab_shipping";
        fcom.ajax(fcom.makeUrl('seller', 'getShippingTab', [type]), 'product_id=' + id, function (t) {
            var runningAjaxReq = true;
            try {
                res = jQuery.parseJSON(t);
                $.facebox(res.msg, 'faceboxWidth');
            } catch (e) {

                $(ShipDiv).html(t);
            }

        });
    };

    setupSellerShipping = function (frm) {
        if (!$(frm).validate())
            return;
        if (runningAjaxReq == true) {
            console.log(runningAjaxMsg);
            return;
        }
        var data = fcom.frmData(frm);

        fcom.updateWithAjax(fcom.makeUrl('Seller', 'setupSellerShipping'), (data), function (t) {
            runningAjaxReq = false;
            productId = t.product_id;
            loadShippingDetailsSection(productId);
        });
    }

    shippingautocomplete = function (shipping_row) {
        $('input[name="product_shipping[' + shipping_row + '][country_name]"]').focusout(function () {
            setTimeout(function () {
                $('.suggestions').hide();
            }, 500);
        });

        $('input[name="product_shipping[' + shipping_row + '][state_name]"]').focusout(function () {
            setTimeout(function () {
                $('.suggestions').hide();
            }, 500);
        });

        $('input[name="product_shipping[' + shipping_row + '][company_name]"]').focusout(function () {
            setTimeout(function () {
                $('.suggestions').hide();
            }, 500);
        });

        $('input[name="product_shipping[' + shipping_row + '][processing_time]"]').focusout(function () {
            setTimeout(function () {
                $('.suggestions').hide();
            }, 500);
        });
        $('input[name="product_shipping[' + shipping_row + '][country_name]"]').autocomplete({
            minLength: 0,
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                $.ajax({
                    url: fcom.makeUrl('seller', 'countries_autocomplete'),
                    data: {keyword: request['term'], fIsAjax: 1, includeEverywhere: true},
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {label: item['name'], value: item['name'], id: item['id']};
                        }));
                    },
                });
            },
            select: function (event, ui) {
                $('input[name="product_shipping[' + shipping_row + '][country_id]"]').siblings('.country-select--js').html('');
                $('input[name="product_shipping[' + shipping_row + '][country_name]"]').val(ui.item.label);
                $('input[name="product_shipping[' + shipping_row + '][country_id]"]').val(ui.item.id);
                $('input[name="product_shipping[' + shipping_row + '][state_name]"]').val('');
                $('input[name="product_shipping[' + shipping_row + '][state_id]"]').val(0);
            }
        }).focus(function () {
            $(this).autocomplete("search", $(this).val());
        });

        $('input[name="product_shipping[' + shipping_row + '][state_name]"]').autocomplete({
            minLength: 0,
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                var selectedCountry = $('input[name="product_shipping[' + shipping_row + '][country_id]"]').val();
                if (parseInt(selectedCountry) == 0) {
                    $('input[name="product_shipping[' + shipping_row + '][country_id]"]').siblings('.country-select--js').html('<small class="text-danger">' + langLbl.chooseCountryFromList + '</small>');
                } else {
                    $('input[name="product_shipping[' + shipping_row + '][country_id]"]').siblings('.country-select--js').html('');
                }

                $.ajax({
                    url: fcom.makeUrl('seller', 'states_autocomplete'),
                    data: {keyword: request['term'], fIsAjax: 1, includeEverywhere: true, countryId: selectedCountry},
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {label: item['name'], value: item['name'], id: item['id']};
                        }));
                    },
                });
            },
            select: function (event, ui) {
                $('input[name="product_shipping[' + shipping_row + '][state_name]"]').val(ui.item.label);
                $('input[name="product_shipping[' + shipping_row + '][state_id]"]').val(ui.item.id);
            }
        }).focus(function () {
            $(this).autocomplete("search", $(this).val());
        });


        $('input[name="product_shipping[' + shipping_row + '][company_name]"]').autocomplete({
            minLength: 0,
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                $.ajax({
                    url: fcom.makeUrl('seller', 'shippingCompanyAutocomplete'),
                    data: {keyword: request['term'], fIsAjax: 1},
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {label: item['name'], value: item['name'], id: item['id']};
                        }));
                    },
                });
            },
            select: function (event, ui) {
                $('input[name="product_shipping[' + shipping_row + '][company_name]"]').val(ui.item.label);
                $('input[name="product_shipping[' + shipping_row + '][company_id]"]').val(ui.item.id);
            }
        }).focus(function () {
            $(this).autocomplete("search", $(this).val());
        });

        $('input[name="product_shipping[' + shipping_row + '][processing_time]"]').autocomplete({
            minLength: 0,
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {

                $.ajax({
                    url: fcom.makeUrl('seller', 'shippingMethodDurationAutocomplete'),
                    data: {keyword: request['term'], fIsAjax: 1},
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                label: item['name'] + '[' + item['duraion'] + ']', 
                                value: item['duraion'], id: item['id'],
                                isfreeshipping: item['isFreeShipping']
                            };
                        }));
                    },
                });
            },
            select: function (event, ui) {
                $('input[name="product_shipping[' + shipping_row + '][processing_time]"]').val(ui.item.label);
                $('input[name="product_shipping[' + shipping_row + '][processing_time_id]"]').val(ui.item.id);
                if (ui.item.isfreeshipping == 1) {
                    $('input[name="product_shipping[' + shipping_row + '][cost]"]').attr('disabled', 'disabled');
                    $('input[name="product_shipping[' + shipping_row + '][cost]"]').val(0);
                } else {
                    $('input[name="product_shipping[' + shipping_row + '][cost]"]').removeAttr('disabled');
                }
                
            }
        }).focus(function () {
            $(this).autocomplete("search", $(this).val());
        });

        $('input[name="product_shipping[' + shipping_row + '][min_qty]"]').on('change', function () {
            var minQty = parseInt($(this).val());
            var maxQtyVal = parseInt($('input[name="product_shipping[' + shipping_row + '][max_qty]"]').val());
            if (maxQtyVal < minQty && maxQtyVal != -1) {
                $('input[name="product_shipping[' + shipping_row + '][max_qty]"]').val(minQty);
            }
            var minValue = minQty;
            if (maxQtyVal == -1) {
                minValue = -1;
            }
            $('input[name="product_shipping[' + shipping_row + '][max_qty]"]').attr('min', minValue);
        });

        $('input[name="product_shipping[' + shipping_row + '][max_qty]"]').on('change', function () {
            var maxQty = parseInt($(this).val());
            if (maxQty == -1) {
                $(this).attr('min', -1);
            }

            var minQtyVal = parseInt($('input[name="product_shipping[' + shipping_row + '][min_qty]"]').val());
            if (minQtyVal > maxQty && maxQty != -1) {
                $('input[name="product_shipping[' + shipping_row + '][max_qty]"]').val(minQtyVal);
            }
            $('input[name="product_shipping[' + shipping_row + '][mix_qty]"]').attr('max', maxQty);
        });

    }
    translateData = function (item, defaultLang, toLangId, editorIndex =0) {
        var autoTranslate = $("input[name='auto_update_other_langs_data']:checked").length;
        var prodName = $("input[name='service_title[" + defaultLang + "]']").val();
        var oEdit = eval(oUtil.arrEditor[0]);
        var prodDesc = oEdit.getTextBody();

        var alreadyOpen = $('.collapse-js-' + toLangId).hasClass('show');
        if (autoTranslate == 0 || prodName == "" || alreadyOpen == true) {
            return false;
        }
        /* var data = "product_name=" + prodName + '&product_description=' + prodDesc + "&toLangId=" + toLangId; */
        var data = {
            'product_name' :   prodName,
            'product_description' : prodDesc,
            'toLangId' : toLangId
        };
       
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'translatedProductData'), data, function (t) {
            if (t.status == 1) {
                $("input[name='service_title[" + toLangId + "]']").val(t.productName).text();
                var oEdit1 = eval(oUtil.arrEditor[editorIndex]);
                oEdit1.putHTML(t.productDesc);
                var layout = langLbl['language' + toLangId];
                $('#idContent' + oUtil.arrEditor[editorIndex]).contents().find("body").css('direction', layout);
                $('#idArea' + oUtil.arrEditor[editorIndex] + ' td[dir="ltr"]').attr('dir', layout);
            }
        });
    }
    

})();