<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
if (!empty($documents)) {
    foreach ($documents as $tdoc) {
?>
        <div class="block-info">
            <div class="block-heading">
                <div class="row">
                    <div class="col-sm-10">
                        <?php echo ($tdoc['shopdoc_name'] == '') ? $tdoc['shopdoc_identifier'] : $tdoc['shopdoc_name']; ?>
                    </div>
                    <div class="col-sm-2 text-right">
                        <ul class="actions" style="display : inline-block;">
                            <li>
                                <a href="javascript:void(0);" onclick="sellerCertificateForm(<?php echo $tdoc['shopdoc_type'] . ', ' . $tdoc['shopdoc_id'] ?>);" title="<?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>">
                                    <i class="fa fa-edit"></i>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" onclick="deleteCertificate(<?php echo $tdoc['shopdoc_type'] . ', ' . $tdoc['shopdoc_id'] ?>);" title="<?php echo Labels::getLabel('LBL_Delete', $siteLangId); ?>">
                                    <i class="fa fa-trash"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="block-content">
                <!-- [ repeating block -->
                <?php
                $files = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SHOP_DOCUMENT, $tdoc['shopdoc_id']);
                if (!empty($files)) {
                ?>

                    <ul class="image-block">
                        <?php
                        foreach ($files as $file) {
                            $ext = pathinfo($file['afile_name'], PATHINFO_EXTENSION);
                        ?>
                            <li>
                                <div class="img-border">
                                    <?php
                                    if (in_array($ext, $imageType)) {
                                        $documentUrl = CommonHelper::generateFileUrl('Image', 'shopDocument', [$tdoc['shopdoc_id'], $file['afile_id']]);
                                    ?>
                                        <img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopDocument', [$tdoc['shopdoc_id'], $file['afile_id'], 'THUMB']); ?>" />
                                    <?php
                                    } else {
                                        $documentUrl = CommonHelper::generateFileUrl('Image', 'shopFile', [$tdoc['shopdoc_id'], $file['afile_id']]);
                                    ?>
                                        <a href="<?php echo CommonHelper::generateFileUrl('Image', 'shopFile', [$tdoc['shopdoc_id'], $file['afile_id']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                            <i class="icn doc-file-icon">
                                                <svg class="svg">
                                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                </svg>
                                            </i>
                                        </a>
                                    <?php } ?>
                                </div>
                                <a href="<?php echo $documentUrl; ?>" target="_blank" class="text-center"><?php echo $file['afile_name']; ?></a>
                                <span class="delete-file-icon"><a href="javascript:void(0);" onclick="deleteCertificateFile(<?php echo $tdoc['shopdoc_type'] . ', ' . $tdoc['shopdoc_id'] . ', ' . $file['afile_id']; ?>);" title="<?php echo Labels::getLabel('LBL_Delete_File', $siteLangId); ?>">
                                        <i class="fa fa-trash"></i>
                                </span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>

                <!-- ] -->
            </div>
        </div>
    <?php } ?>
<?php } ?>
<style>
    .doc-file-icon svg {
        height: 50px;
        max-width: 150px;
        margin-top: 25px;
    }

    .block-info {
        border: 1px solid #E4E4E4;
        border-radius: 5px;
        margin-bottom: 15px;
    }

    .block-heading {
        background: #F6F6F6;
        padding: 10px 15px;
        font-size: 15px;
        font-weight: 600;
    }

    .block-content {
        padding: 15px;
    }

    .block-content h6 {
        font-weight: 400;
        font-size: 14px;
    }

    .block-content h6 img {
        margin-left: 5px;
    }

    .block-content h6 span {
        float: right;
    }

    .block-content p {
        margin-bottom: 0;
        font-size: 14px;
    }

    .image-block {
        /* display: flex; */
        margin-top: 10px;
        /* flex-direction: row; */
    }

    .image-block li {
        margin-right: 10px;
        width: calc(100% / 5 - 50px);
        display: inline-block;
        vertical-align: top;
        margin-bottom: 10px;
        min-width: 125px;
        text-align: center;
    }

    .image-block li .img-border {
        border: 1px solid #E9E9E9;
        border-radius: 5px;
        text-align: center;
        min-height: 100px;
    }

    .image-block li a {
        font-size: 13px;
        color: var(--primary-color);
        word-break: break-all;
    }

    .delete-file-icon {
        margin-left: 10px;
    }

    .delete-file-icon a {
        color: #000 !important;
    }
</style>