<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('onsubmit', 'setupSellerProfile(this); return(false);');
$frm->setFormTagAttribute('class', 'form');

$frm->developerTags['colClassPrefix'] = 'col-lg-4 col-md-';
$frm->developerTags['fld_default_col'] = 4;

$variables = array('language' => $language, 'siteLangId' => $siteLangId, 'shop_id' => $shop_id, 'action' => 'sellerProfile');
$this->includeTemplate('seller/_partial/shop-navigation.php', $variables, false);
?>
<div class="cards">
    <div class="cards-content ">
        <div class="tabs__content form">
            <div class="row">
                <div class="col-lg-12 col-md-12" id="shopFormBlock"> 
                    <div class="tabs tabs-sm tabs--scroll clearfix">
                        <ul class="setactive-js">
                            <li class="is-active"><a href="javascript:void(0)" onClick="sellerProfile(this);"><?php echo Labels::getLabel('LBL_General', $siteLangId); ?></a></li>
                            <li>
                                <a href="javascript:void(0);" onclick="sellerProfileLangForm(<?php echo FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1); ?>);">
                                    <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" onclick="sellerCertificates(<?php echo ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE;?>);">
                                    <?php echo Labels::getLabel('LBL_Quality_Certificates', $siteLangId); ?>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" onclick="sellerCertificates(<?php echo ShopDocument::SHOP_DOCUMENT_TYPE_TRADE_SHOW;?>);">
                                    <?php echo Labels::getLabel('LBL_Trade_Show_Certificates', $siteLangId); ?>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" onclick="sellerCertificates(<?php echo ShopDocument::SHOP_DOCUMENT_TYPE_INSPECTION_REPORT;?>);">
                                    <?php echo Labels::getLabel('LBL_Inspection_Report', $siteLangId); ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <?php if (!empty($countryCode)) { ?>
                        <p><small><?php echo Labels::getLabel('LBL_Country', $siteLangId); ?></small> <span><img src="<?php echo CommonHelper::generateFullUrl(); ?>/images/flags/<?php echo strtolower($countryCode); ?>.png"></span></p>
                    <?php } ?>
                    <?php echo $frm->getFormHtml(); ?> 
                </div>
            </div>
        </div>
    </div>
</div>