<?php
$totReviews = isset($reviews['totReviews']) ? FatUtility::int($reviews['totReviews']) : '';
$avgRating = isset($reviews['avg_seller_rating']) ? FatUtility::convertToType($reviews['avg_seller_rating'], FatUtility::VAR_FLOAT) : 0;
$rated_1 = isset($reviews['rated_1']) ? FatUtility::int($reviews['rated_1']) : '';
$rated_2 = isset($reviews['rated_2']) ? FatUtility::int($reviews['rated_2']) : '';
$rated_3 = isset($reviews['rated_3']) ? FatUtility::int($reviews['rated_3']) : '';
$rated_4 = isset($reviews['rated_4']) ? FatUtility::int($reviews['rated_4']) : '';
$rated_5 = isset($reviews['rated_5']) ? FatUtility::int($reviews['rated_5']) : '';

$pixelToFillRight = $avgRating / 5 * 160;
$pixelToFillRight = FatUtility::convertToType($pixelToFillRight, FatUtility::VAR_FLOAT);

$rate_5_width = $rate_4_width = $rate_3_width = $rate_2_width = $rate_1_width = 0;

if ($totReviews) {
    $rate_5_width = round(FatUtility::convertToType($rated_5 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_4_width = round(FatUtility::convertToType($rated_4 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_3_width = round(FatUtility::convertToType($rated_3 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_2_width = round(FatUtility::convertToType($rated_2 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
    $rate_1_width = round(FatUtility::convertToType($rated_1 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
}

?>

<div class="shop-panel__body">

    <div class="shop-view">
        <div class="shop-view__small">
            <div class="shop-view__logo">

                <?php
                $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_LOGO, $shop['shop_id'], 0, 0, false);
                $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                ?>
                <img <?php if (isset($fileData) && $fileData['afile_aspect_ratio'] > 0) { ?> data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?> src="<?php echo CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shop_id'], $siteLangId, 'SMALL')); ?>" alt="<?php echo $shop['shop_name']; ?>">
            </div>
        </div>
        <div class="shop-view__large">

            <div class="shop-view__meta">

                <div class="shop-view__meta-l">


                    <h1 class="page-title m-0"><?php echo $shop['shop_name']; ?></h1>

                    <!-- [ PANEL ACTIONS =========== -->
                    <div class="panel-list">

                        <div class="panel-list__item"><?php echo $shop['shop_state_name'] . ", " . $shop['shop_country_name']; ?></div>

                        <?php if (!empty($shopRating) ||  !empty($shopTotalReviews)) { ?>
                            <div class="panel-list__item">

                                <div class="ratings ratings--hovered">
                                    <a href="#ratings" class="ratings__trigger scrolls">
                                        <span class="ratings__star site-icon site-icon--xsmall">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
                                                <path d="M12.943,27.378,8,24.659,3.057,27.378,4,21.618,0,17.539l5.527-.84L8,11.378,10.473,16.7l5.527.84-4,4.079Z" transform="translate(0 -11.378)" fill="#f5961d"></path>
                                            </svg>

                                        </span>
                                        <span class="ratings__value"><?php echo round($shopRating, 1); ?></span>
                                        <?php if ($shopTotalReviews) { ?>
                                            <span class="ratings__count">| <?php echo $shopTotalReviews . ' ', Labels::getLabel('Lbl_Reviews', $siteLangId); ?></span>
                                        <?php } ?>
                                    </a>


                                    <div class="ratings__target">
                                        <div class="ratings-progress p-4">

                                            <div class="ratings">
                                                <span class="ratings__value m-0"><?php echo round($shopRating, 1), ' ', Labels::getLabel('Lbl_Out_of', $siteLangId), ' ', '5'; ?></span>
                                                <?php if ($shopTotalReviews) { ?>
                                                    <span class="ratings__count">| <?php echo $shopTotalReviews . ' ', Labels::getLabel('Lbl_Reviews_&_Ratings', $siteLangId); ?></span>
                                                <?php } ?>
                                            </div>

                                            <?php if ($shopTotalReviews) { ?>
                                                <div class="progress-list">
                                                    <ul>
                                                        <li>
                                                            <span class="progress-list__count">5 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                            <div class="progress-list__bar">
                                                                <div title="<?php echo $rate_5_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_5_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <span class="progress-list__count">4 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                            <div class="progress-list__bar">
                                                                <div title="<?php echo $rate_4_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_4_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <span class="progress-list__count">3 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                            <div class="progress-list__bar">
                                                                <div title="<?php echo $rate_3_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_3_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <span class="progress-list__count">2 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                            <div class="progress-list__bar">
                                                                <div title="<?php echo $rate_2_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_2_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <span class="progress-list__count">1 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                            <div class="progress-list__bar">
                                                                <div title="<?php echo $rate_1_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_1_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>

                                                <hr>
                                                <a href="<?php echo CommonHelper::generateUrl('Reviews', 'shop', array($shop['shop_id'])); ?>" class="link scrolls1"><?php echo Labels::getLabel('LBL_See_all_customer_reviews', $siteLangId) ?></a>
                                            <?php } ?>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        <?php } ?>

                        <?php $showAddToFavorite = true;
                        if (UserAuthentication::isUserLogged() && (!User::isBuyer())) $showAddToFavorite = false; ?>
                        <?php if ($showAddToFavorite) { ?>
                            <div class="panel-list__item">
                                <!-- <a href="#" class="btn btn--icon btn--fav is-active"> -->
                                <a href="javascript:void(0)" id="shop_<?php echo $shop['shop_id']; ?>" onclick="toggleShopFavorite(<?php echo $shop['shop_id']; ?>);" class="btn btn--icon btn--fav <?php echo ($shop['is_favorite']) ? 'is-active' : ''; ?>">
                                    <span class="site-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.8">
                                            <path d="M13.6,3A4.521,4.521,0,0,1,18,7.8c0,5.6-6,8.8-8,10-2-1.2-8-4.4-8-10A4.54,4.54,0,0,1,6.4,3,5.293,5.293,0,0,1,10,4.6,5.293,5.293,0,0,1,13.6,3Z" transform="translate(-2 -3)"></path>
                                        </svg>
                                    </span> <?php echo Labels::getLabel('Lbl_Favorite', $siteLangId); ?>
                                </a>
                            </div>
                        <?php } ?>

                        <div class="panel-list__item">

                            <div class="social-share social-share--hovered">
                                <a href="#social-target-js" class="btn btn--icon btn--share trigger-js">
                                    <span class="site-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13 13.009">
                                            <path d="M1514.616,192.269a2.38,2.38,0,0,0-1.866.908l-4.058-2.058a2.1,2.1,0,0,0-.017-1.278l4.039-2.049a2.356,2.356,0,1,0-.487-1.421,2.331,2.331,0,0,0,.092.615l-4.056,2.059a2.368,2.368,0,1,0,.035,2.879l4.038,2.049a2.32,2.32,0,0,0-.109.667,2.389,2.389,0,1,0,2.388-2.371Z" transform="translate(-1504.006 -184.001)"></path>
                                        </svg>
                                    </span> <?php echo Labels::getLabel('Lbl_Share', $siteLangId); ?>
                                </a>
                                <div id="social-target-js" class="social-share__target social-share__target-js">
                                    <ul class="sharing-actions">
                                        <li class="social-facebook">
                                            <a class="st-custom-button" data-network="facebook" data-url="<?php echo CommonHelper::generateFullUrl('Shops', 'view', array($shop['shop_id'])); ?>/">
                                                <i class="icn">
                                                    <svg class="svg" viewBox="0 0 430.113 430.114">
                                                        <path d="M158.081,83.3c0,10.839,0,59.218,0,59.218h-43.385v72.412h43.385v215.183h89.122V214.936h59.805   c0,0,5.601-34.721,8.316-72.685c-7.784,0-67.784,0-67.784,0s0-42.127,0-49.511c0-7.4,9.717-17.354,19.321-17.354   c9.586,0,29.818,0,48.557,0c0-9.859,0-43.924,0-75.385c-25.016,0-53.476,0-66.021,0C155.878-0.004,158.081,72.48,158.081,83.3z"></path>
                                                    </svg></i>
                                            </a>
                                        </li>
                                        <li class="social-twitter">
                                            <a class="st-custom-button" data-network="twitter">
                                                <i class="icn">
                                                    <svg class="svg" viewBox="0 0 512 512">
                                                        <path d="M512,97.248c-19.04,8.352-39.328,13.888-60.48,16.576c21.76-12.992,38.368-33.408,46.176-58.016    c-20.288,12.096-42.688,20.64-66.56,25.408C411.872,60.704,384.416,48,354.464,48c-58.112,0-104.896,47.168-104.896,104.992    c0,8.32,0.704,16.32,2.432,23.936c-87.264-4.256-164.48-46.08-216.352-109.792c-9.056,15.712-14.368,33.696-14.368,53.056    c0,36.352,18.72,68.576,46.624,87.232c-16.864-0.32-33.408-5.216-47.424-12.928c0,0.32,0,0.736,0,1.152    c0,51.008,36.384,93.376,84.096,103.136c-8.544,2.336-17.856,3.456-27.52,3.456c-6.72,0-13.504-0.384-19.872-1.792    c13.6,41.568,52.192,72.128,98.08,73.12c-35.712,27.936-81.056,44.768-130.144,44.768c-8.608,0-16.864-0.384-25.12-1.44    C46.496,446.88,101.6,464,161.024,464c193.152,0,298.752-160,298.752-298.688c0-4.64-0.16-9.12-0.384-13.568    C480.224,136.96,497.728,118.496,512,97.248z"></path>
                                                    </svg></i>
                                            </a>
                                        </li>
                                        <li class="social-pintrest">
                                            <a class="st-custom-button" data-network="pinterest">
                                                <i class="icn"><svg class="svg" viewBox="0 0 100.001 100.001">
                                                        <path d="M43.081,66.14c-2.626,13.767-5.833,26.966-15.333,33.861c-2.932-20.809,4.307-36.436,7.668-53.027   c-5.73-9.646,0.689-29.062,12.777-24.277c14.873,5.885-12.881,35.865,5.75,39.611c19.453,3.908,27.395-33.752,15.332-46   C51.847-1.376,18.542,15.905,22.638,41.224c0.996,6.191,7.391,8.068,2.555,16.611c-11.154-2.473-14.484-11.27-14.055-23   c0.69-19.197,17.25-32.639,33.86-34.498c21.006-2.352,40.721,7.711,43.443,27.471c3.066,22.303-9.48,46.459-31.943,44.721   C50.41,72.056,47.853,69.04,43.081,66.14z"></path>
                                                    </svg></i>
                                            </a>
                                        </li>
                                        <li class="social-email">
                                            <a class="st-custom-button" data-network="email">
                                                <i class="icn"><svg class="svg" viewBox="0 0 483.3 483.3">
                                                        <g>
                                                            <path d="M424.3,57.75H59.1c-32.6,0-59.1,26.5-59.1,59.1v249.6c0,32.6,26.5,59.1,59.1,59.1h365.1c32.6,0,59.1-26.5,59.1-59.1    v-249.5C483.4,84.35,456.9,57.75,424.3,57.75z M456.4,366.45c0,17.7-14.4,32.1-32.1,32.1H59.1c-17.7,0-32.1-14.4-32.1-32.1v-249.5    c0-17.7,14.4-32.1,32.1-32.1h365.1c17.7,0,32.1,14.4,32.1,32.1v249.5H456.4z"></path>
                                                            <path d="M304.8,238.55l118.2-106c5.5-5,6-13.5,1-19.1c-5-5.5-13.5-6-19.1-1l-163,146.3l-31.8-28.4c-0.1-0.1-0.2-0.2-0.2-0.3    c-0.7-0.7-1.4-1.3-2.2-1.9L78.3,112.35c-5.6-5-14.1-4.5-19.1,1.1c-5,5.6-4.5,14.1,1.1,19.1l119.6,106.9L60.8,350.95    c-5.4,5.1-5.7,13.6-0.6,19.1c2.7,2.8,6.3,4.3,9.9,4.3c3.3,0,6.6-1.2,9.2-3.6l120.9-113.1l32.8,29.3c2.6,2.3,5.8,3.4,9,3.4    c3.2,0,6.5-1.2,9-3.5l33.7-30.2l120.2,114.2c2.6,2.5,6,3.7,9.3,3.7c3.6,0,7.1-1.4,9.8-4.2c5.1-5.4,4.9-14-0.5-19.1L304.8,238.55z"></path>
                                                        </g>
                                                    </svg></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>


                        </div>



                    </div>
                    <!-- ] -->
                    <?php if (isset($shop_main_page) && $shop_main_page == 1) { ?>
                        <?php if ($subscription_package_id > 0) { ?>
                            <div class="seller-badges seller-badges--inline">
                                <?php if ((isset($subscription_package_id) && $subscription_package_id == SellerPackages::GOLD_PACKAGE) && $shop['seller_verified'] == 1) { ?>
                                    <div class="seller-badges__grid">
                                        <div class="badge-item">
                                            <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/green-tick.svg" alt=""></span>
                                            <span class="badge-item__label"><?php echo Labels::getLabel('LBL_TrustSEAL_Verified', $siteLangId); ?></span>
                                        </div>
                                    </div>
                                <?php } ?>


                                <?php if (isset($seller_type) && !empty($seller_type)) {
                                    $sellerType = ShopProfile::getSellerTypeArr($siteLangId); ?>
                                    <div class="seller-badges__grid">
                                        <div class="badge-item">
                                            <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="<?php echo isset($sellerType[$shop['sprofile_seller_type']]) ? $sellerType[$shop['sprofile_seller_type']]  : ''; ?>"></span>
                                            <span class="badge-item__label"><?php echo isset($sellerType[$seller_type]) ? $sellerType[$seller_type]  : ''; ?></span>
                                        </div>
                                    </div>
                                <?php } ?>
                                    <?php if(FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)){ ?>
                                <?php if ($subscription_package_id == SellerPackages::SILVER_PACKAGE) { ?>
                                    <div class="seller-badges__grid">
                                        <div class="badge-item">
                                            <span class="badge-item__media"><img class="gray-scale" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" alt=""></span>
                                            <span class="badge-item__label"><?php echo $subscription_package; ?></span>
                                        </div>
                                    </div>
                                <?php } elseif ($subscription_package_id == SellerPackages::GOLD_PACKAGE) { ?>
                                    <div class="seller-badges__grid">
                                        <div class="badge-item">
                                            <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png"></span>
                                            <span class="badge-item__label"><?php echo $subscription_package; ?></span>
                                        </div>
                                    </div>
                                <?php } else { ?>
                                    <div class="seller-badges__grid">
                                        <div class="badge-item">
                                            <span class="badge-item__label"><?php echo $subscription_package; ?></span>
                                        </div>
                                    </div>
                                <?php }}
                                if ($shop['is_founding_member'] == 1) { ?>
                                    <div class="seller-badges__grid">
                                        <div class="badge-item">
                                            <span class="badge-item__media"> <img src="<?php echo CONF_WEBROOT_URL; ?>images/crown.png"></span>
                                            <span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?></span>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    <?php } ?>

                </div>

                <div class="shop-view__meta-r">
                    <a onclick="contactWithSeller('<?php echo $shop['shop_id']; ?>');" title="<?php echo Labels::getLabel('Lbl_Send_Message', $siteLangId); ?>" href="javascript:void(0)" class="btn btn--bordered-brand d-flex align-items-center justify-content-center">
                        <span class="site-icon site-icon--small mr-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.4">
                                <path d="M2.8,3H17.2a.8.8,0,0,1,.8.8V16.6a.8.8,0,0,1-.8.8H2.8a.8.8,0,0,1-.8-.8V3.8A.8.8,0,0,1,2.8,3Zm7.248,6.946L4.918,5.59,3.882,6.81l6.176,5.244,6.065-5.248L15.077,5.6,10.049,9.946Z" transform="translate(-2 -3)"></path>
                            </svg>
                        </span>
                        <span> <?php echo Labels::getLabel('LBL_Contact_Seller', $siteLangId); ?></span>
                    </a>
                </div>

            </div>

        </div>
    </div>


    <div class="shop-controls">
        <?php if (isset($shop_main_page) && $shop_main_page == 1 && isset($searchFrm)) { ?>
            <div class="shop-controls__small">
                <div class="shop-search">

                    <?php
                    $searchFrm->setFormTagAttribute('onSubmit', 'searchProducts(this); return(false);');
                    $searchFrm->setFormTagAttribute('class', 'form shop-search__form');
                    $shopIdFld = $searchFrm->getField('shop_id');
                    $keywordFld = $searchFrm->getField('keyword');
                    $keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_in_this_store', $siteLangId));
                    //$keywordFld->htmlAfterField = '<input name="btnSrchSubmit" value="" type="submit" class="input-submit">';									
                    echo $searchFrm->getFormTag();
                    $fld = $searchFrm->getField('keyword');
                    $fld->addFieldTagAttribute("class", "input-field nofocus"); ?>
                    <span class="shop-search__icon site-icon site-icon--search site-icon--small">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14">
                            <path d="M13.048,12.074,16,15.025,15.025,16l-2.951-2.952a6.2,6.2,0,1,1,.975-.974Zm-1.382-.511a4.822,4.822,0,1,0-.1.1l.1-.1Z" transform="translate(-2 -2)"></path>
                        </svg>
                    </span>
                    <?php echo $searchFrm->getFieldHTML('keyword');
                    echo $searchFrm->getFieldHTML('shop_id');
                    echo $searchFrm->getFieldHTML('join_price');
                    echo '</form>';
                    echo $searchFrm->getExternalJS();
                    ?>

                </div>
            </div>
        <?php } ?>
        <div class="shop-controls__large">

            <nav class="shop-menu">
                <?php
                $variables = array('template_id' => $template_id, 'shop_id' => $shop['shop_id'], 'shop_user_id' => $shop['shop_user_id'], 'collectionData' => $collectionData, 'action' => $action, 'siteLangId' => $siteLangId);
                $this->includeTemplate('shops/shop-layout-navigation.php', $variables, false);
                ?>

            </nav>

        </div>

    </div>



</div>