<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (isset($includeEditor) && $includeEditor == true) {
    $extendEditorJs = 'true';
} else {
    $extendEditorJs = 'false';
}
if (CommonHelper::isThemePreview() && isset($_SESSION['preview_theme'])) {
    $themeActive = 'true';
} else {
    $themeActive = 'false';
}
$commonHeadData = array(
    'siteLangId' => $siteLangId,
    'siteLangCode' => $siteLangCode,
    'controllerName' => $controllerName,
    'action' => $action,
    'jsVariables' => $jsVariables,
    'extendEditorJs' => $extendEditorJs,
    'themeDetail' => $themeDetail,
    'themeActive' => $themeActive,
    'currencySymbolLeft' => $currencySymbolLeft,
    'currencySymbolRight' => $currencySymbolRight,
    'isUserDashboard' => $isUserDashboard,
    'canonicalUrl' => isset($canonicalUrl) ? $canonicalUrl : '',
);
if (isset($layoutTemplate) && $layoutTemplate != '') {
    $commonHeadData['layoutTemplate'] = $layoutTemplate;
    $commonHeadData['layoutRecordId'] = $layoutRecordId;
}
if (isset($socialShareContent) && $socialShareContent != '') {
    $commonHeadData['socialShareContent'] = $socialShareContent;
}
if (isset($includeEditor) && $includeEditor == true) {
    $commonHeadData['includeEditor'] = $includeEditor;
}
$this->includeTemplate('_partial/header/commonHeadTop.php', $commonHeadData, false);
/* This is not included in common head, because, commonhead file not able to access the $this->Controller and $this->action[ */
echo $this->writeMetaTags();
/* ] */
$this->includeTemplate('_partial/header/commonHeadMiddle.php', $commonHeadData, false);
/* This is not included in common head, because, if we are adding any css/js from any controller then that file is not included[ */
echo $this->getJsCssIncludeHtml(!CONF_DEVELOPMENT_MODE);
/* ] */

$this->includeTemplate('_partial/header/commonHeadBottom.php', $commonHeadData, false);
?>

<header id="header" class="header no-print" role="site-header">
    <?php
    if (FatApp::getConfig('CONF_AUTO_RESTORE_ON', FatUtility::VAR_INT, 1) && CommonHelper::demoUrl()) {
        $this->includeTemplate('restore-system/top-header.php');
    }
    ?>
    <div class="header__secondary">
        <div class="container">
            <div id="secondary-menu-js" class="header-row header-offset">
                <div class="header-row__cell header-row__cell-1">
                    <div class="menu-secondary">
                        <?php $this->includeTemplate('_partial/headerTopNavigation.php');
                        ?>
                    </div>
                </div>
                <div class="header-row__cell header-row__cell-2">
                    <div class="menu-secondary">
                        <ul>

                            <?php $this->includeTemplate('_partial/headerLanguageArea.php'); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header__primary">
        <div class="container">
            <div class="header-row  justify-content-between">

                <div class="logo logo-supplier">
                    <?php
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_MAIN_HEADER_LOGO, 0, 0, $siteLangId, false);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                    ?>
                    <a href="<?php echo CommonHelper::generateUrl(); ?>">
                        <img <?php if ($fileData['afile_aspect_ratio'] > 0) { ?> data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?> src="<?php echo CommonHelper::generateFullFileUrl('image', 'mainHeaderLogo', array($siteLangId), CONF_WEBROOT_FRONT_URL); ?>" alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>" title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>">
                    </a>
                </div>

                <!-- div class="d-flex"><a class="seller_login_toggle" href="javascript:void(0)" data-trigger="yk-login--wrapper"><i class="fa fa-user-circle"></i></a>
                    <//?php if (!empty($seller_navigation_left)) { ?>
                        <a class="seller_nav_toggle" href="javascript:void(0)" data-trigger="short-nav"><i class="fas fa-bars"></i></a>
                    <//?php } ?>
                </div -->

                <div class="d-flex order-3">
                    <a class="seller_login_toggle" href="javascript:void(0)" data-trigger="yk-login--wrapper"><i class="fa fa-user-circle"></i></a>
                    <?php if (!empty($seller_navigation_left)) { ?>
                        <a class="seller_nav_toggle" href="javascript:void(0)" data-trigger="short-nav"><i class="fas fa-bars"></i></a>
                    <?php } ?>
                </div>


                <div class="yk-login--wrapper" id="yk-login--wrapper" data-close-on-click-outside="yk-login--wrapper">

                    <?php $this->includeTemplate('_partial/seller/sellerHeaderLoginForm.php', $loginData, false); ?>
                </div>

            </div>
        </div>
    </div>
    <div class="bottom-head">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="short-nav" id="short-nav" data-close-on-click-outside="short-nav">
                        <?php $this->includeTemplate('_partial/seller/sellerNavigationLeft.php'); ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</header>